<?php
// Get the names and values for vars sent by input.php
if (isset($_GET))
{
	foreach($_GET as $name => $value) $$name = $value;
};

if (isset($_COOKIE["CookieRoom"])) $R = urldecode($_COOKIE["CookieRoom"]);

// Fix a security hole
if (isset($L) && !is_dir("./localization/".$L)) exit();

require("./config/config.lib.php");
require("./localization/".$L."/localized.chat.php");

header("Content-Type: text/html; charset={$Charset}");

// avoid server configuration for magic quotes
if(function_exists('set_magic_quotes_runtime') && version_compare(PHP_VERSION, '5.3.0') < 0) set_magic_quotes_runtime(0);
else ini_set("magic_quotes_runtime", 0);
// Can't turn off magic quotes gpc so just redo what it did if it is on.
if (function_exists('get_magic_quotes_gpc') && @get_magic_quotes_gpc()) {
	foreach($_GET as $k=>$v)
		$_GET[$k] = stripslashes($v);
	foreach($_POST as $k=>$v)
		$_POST[$k] = stripslashes($v);
	foreach($_COOKIE as $k=>$v)
		$_COOKIE[$k] = stripslashes($v);
}

// For translations with an explicit charset (not the 'x-user-defined' one)
if (!isset($FontName)) $FontName = "";
?>
<!DOCTYPE html>
<HTML dir="<?php echo(($Align == "right") ? "RTL" : "LTR"); ?>">

<HEAD>
<TITLE><?php echo(L_IGNOR_TIT); ?></TITLE>
<LINK REL="stylesheet" HREF="<?php echo($skin.".css.php?Charset={$Charset}&medium={$FontSize}&FontName=".urlencode($FontName)); ?>" TYPE="text/css">
<SCRIPT TYPE="text/javascript" LANGUAGE="javascript1.1">
<!--
// Put the focus at the message box in the input frame
function put_focus()
{
	var clean = (document.forms['IgnForm'].Refresh.value != 1);
	with (window.opener)
	{
		if (clean) window.parent.is_ignored_popup = null;
		focus();
		if (document.forms['MsgForm']) document.forms['MsgForm'].elements['M'].focus();
	}
}
// -->
</SCRIPT>
</HEAD>

<BODY CLASS="frame" onUnload="if (window.opener && !window.opener.closed && document.forms['IgnForm'].elements['Exit'].value != 1) put_focus();">
<CENTER>
<?php
if(isset($Ign))
{
	$Ignore = explode (",", $Ign);
	for ($i = 0; $i < count($Ignore); $i++)
	{
		echo("-&nbsp;".urldecode($Ignore[$i])."<br />");
	}
}
else
{
	echo(L_IGNOR_NON);
}
?>
</CENTER>

<?php
// The form below allows to check whether the popup unloads because ignored users list
// has been modified, because the user reduced/closed it or because the user exit the
// chat
?>
<FORM ACTION="nothing" METHOD="POST" AUTOCOMPLETE="OFF" NAME="IgnForm">
	<INPUT TYPE="hidden" NAME="Refresh" VALUE="0">
	<INPUT TYPE="hidden" NAME="Exit" VALUE="0">
</FORM>
</BODY>

</HTML>