# pH7 Social Dating Builder

## ⚡️ The 2026 <span style="text-decoration:underline">Social Dating WebApp Builder</span>

### 🚀 Secure, User-Friendly & Open Source Social Dating Web App Software


[![PayPal](https://img.shields.io/badge/Donate-PayPal-lightgrey.svg)](https://www.paypal.com/cgi-bin/webscr?cmd=_s-xclick&hosted_button_id=X457W3L7DAPC6 "Help keep me off the streets! ;)") [![Build Status](https://scrutinizer-ci.com/g/pH7Software/pH7-Social-Dating-CMS/badges/build.png?b=master)](https://scrutinizer-ci.com/g/pH7Software/pH7-Social-Dating-CMS/build-status/master) [![MIT License](https://img.shields.io/badge/License-MIT-blue.svg)](https://opensource.org/licenses/MIT) [![SourceForge](https://img.shields.io/badge/Download-SourceForge-orange.svg)](https://sourceforge.net/projects/ph7socialdating/files/latest/download) [![Patreon](https://img.shields.io/badge/Subscribe-Patreon-red.svg)](https://www.patreon.com/bePatron?u=3534366 "Become a Patron Today!")

> [!Note]
> **pH7's Social Dating Solution™** is a **Professional**, **Open Source** All-Inclusive **Turnkey Dating Software**. Fully responsive design, low-resource-intensive, powerful and very secure.

---

**pH7Builder** (formerly known as **pH7CMS**) is the first Professional, Free and Open Source Social Dating Site Builder Software. By far, the first choice for creating enterprise-level Dating Apps/Services or social networking sites.

**✨ Imagine in 3 months' time, you have a well-known, successful online community with thousands of happy users without spending a dime for it! Instead, you spent money on advertising, user acquisition, and other marketing strategies... Imagine the time you have saved. The amazing business and freedom you have now created.**

With **[pH7Builder](https://sourceforge.net/projects/ph7socialdating/files/latest/download)**, *THIS IS TOTALLY POSSIBLE!* (however, you have to be motivated! Nothing comes as magic).


![Professional PHP Social Dating Builder Software](https://cloud.githubusercontent.com/assets/1325411/19419476/5475b32c-93d0-11e6-9756-8e7db8df129f.png)

### 🤗 100% Owned by YOU! ❤

**Don't let your Web app be at the mercy of others!​​​​​​​​​​​​​​​​ 🚀** 

Why should your business be at the mercy of others?

Unlike cloud or SaaS solutions, by choosing pH7Builder, you have complete control of your website, database, and your users!
You get and own all data and files hosted on your own server (the one you choose) ✌️


👉 Convinced by the software? ☕️ You could boost the software development by **[offering a coffee](https://www.buymeacoffee.com/ph7cms)**! 🚀🤗

[![Ko Fi - Offer Me A Flat White](static/img/kofi-logo.png)](https://ko-fi.com/phenry) [![Buy Me A Coffee](static/img/buymeacoffee-logo.svg)](https://www.buymeacoffee.com/ph7cms)


## 📖 Contents

- [Software Overview](#-software-overview-)
  - [Features](#-how-powerful-your-social-dating-webapp-will-be-)
- [Requirements](#-requirements)
- [Installation](#-installation)
  - [Nginx Configuration (only for nginx server)](#-nginx-configuration)
- [Translations](#-translations)
- [Resources / Documentation](#-documentation)
- [Troubleshooting](#-troubleshooting)
- [Contributing to the project](#-contributing)
- [Why pH7Builder is Eco-Friendly?](#-ph7builder-the-eco-friendly-cms-%EF%B8%8F)
- [About Me](#-the-cook)
  - [Contact Me](#-contact-suggestion--feedback)
  - [Hire Me](#-hire-me-at-your-company)
  - [Offer me a cup of tea?](#-offer-me-a-cup-of-tea-or-tea-bags-)
- [Tools Used to Develop pH7Builder](#-toolssoftware-used-to-develop-ph7builder)
- [License](#%EF%B8%8F-license)


## 👀 Software Overview 🎉

**pH7 Dating CMS** is a **scalable social community CMS** based on a powerful modular OOP and server-side rendering architecture, using the **MVC** architecture (Model-View-Controller).

It is designed with the **KISS** principle in mind, and the whole source code can be read and understood in minutes. For better flexibility, the software uses **PDO** (PHP Data Objects) abstraction which allows the choice of the database. The principle of development is **DRY** (Don't Repeat Yourself) aimed at reducing repetition of information of all kinds (no duplicate code) and **YAGNI** principle to avoid unused code/not needed functionality in the software.

This Free and Open Source **Social Dating Site Builder** aims to be low resource-intensive, powerful, stable and secure.

Based on **[pH7Framework](https://github.com/pH7Software/pH7-Social-Dating-CMS/tree/18.x/_protected/framework#ph7framework)**, a framework written specifically for this project, the CMS also comes with 40 system modules ready to be used.

*To summarize, **pH7Builder** gives you **the perfect ingredients** to create the **best online dating service** or **social networking** website on the World Wide Web!*


## 😻 How Powerful Your Social-Dating WebApp Will Be? 🚀

* Boosted Social-Dating Streams™
* Smart Intuitive Search Engine™ (SISE System)
* Advanced Search
* Friends/Mutual Friends, Visit, Messages, Instant messaging, Views, Like, Rating, Smileys, Geo Map, Avatar, Wallpaper, ...
* Related Profiles (for better user experience and faster match)
* Custom Profile (Background profile)
* Comments
* Outsmarted Moderation Tools™
* Hot or Not
* Love Calculator
* Matchmaking System
* Geo-Location System
* People Nearby
* The FASTEST Social Dating WebApp thanks to the Deep Memoization Tunnel™ 4.0
* Photo Albums
* Videos (with possibility to upload videos from v3 YouTube API, Vimeo, Metacafe and Dailymotion)
* Forums
* Nudity Filter Option for all images uploaded by users
* Dating Scammer Detector (see if profile photos aren't used by scammers)
* Full Moderation of all contents posted by your users
* Watermark Branding
* Instant Messenger
* In-built affiliate system (that encourages brand influencers/ambassadors to promote your dating platform)
* Mailing List Newsletter
* Activity Streams
* User Mentions (using the “@” symbol with the username such as [@pH-7](https://github.com/pH-7))
* Member Approval System
* Advanced Admin Panel
* Complete Membership System
* Payment Gateways Integration for PayPal, Stripe, Braintree, 2CheckOut, and [Skeerel Pay](https://skeerel.com)
* Statistics & Analytics System
* Live Notification System
* Registration delay (to avoid spam)
* File Management
* Dynamic Field Forms Management
* Profile Privacy Settings
* Banner/Advertisement Management
* Banner Ad Monetization
* User Dashboard
* Dating-Style Profile Page
* Fake Profile Generator
* CSV User Importer
* Blog Posts
* Notes
* Pages Management
* Support for Multiple Languages, Internationalization and Localization (I18N)
* European and American Time/Date formats
* Cache system for the database, pH7Tpl (our template engine), static files (HTML, CSS, JS), string content, ...
* Maintenance Mode
* Database Backup
* Report Abuse
* SEO-Friendly (Title, Headings, Content, Code, ...), Sitemap module, [hreflang](https://support.google.com/webmasters/answer/189077), possibility to translate each URL, ...
* [Schema.org markup](https://moz.com/learn/seo/schema-structured-data) on your webapp considerably increases the ranking in search engines results and enable great features such as Google Rich Snippets
* Multilingual URLs
* Check that all UGC (User-Generated Content) are Unique (to avoid spam and malicious users)
* RSS Feed
* Block easily any IPs, emails, usernames, affiliated bank accounts, etc.
* Country Blocker (block easily any countries where you don't want your website to be accessible)
* Country Restrictions for Member and Affiliate registration forms
* RESTful API for integration from an external app (iOS iPhone, Apple Watch, Android, ...), website, program, ...
* Users' SMS Verification (supporting Clickatell and Twilio SMS gateways)
* Feedback Module
* Full Homepage Customization (profiles block, slogan, SEO text, headline)
* Fully Responsive Templates
* Memberships/Groups Manager
* Publishable easily into Android/iPhone/iOS webview mobile app thanks its Mobile-Optimized Templates
* Multiple-Themes and many customization possible
* Message templates
* Multi Themes and many personalizable
* Includes top HTML5 features
* Invite Friends
* Social Bookmark (Social Media Sharing Buttons)
* Anti-Scam and Anti-Fraud Tools
* Login Attempt Protections
* Suspicious Login Detection, from foreign locations
* Powerful Anti-Spam System (and detects duplicate contents) powered by the Invisible Intelligent Spam Detection System™
* pCO8 SECURITY pH7Framework™ (offers one of the highest protection for your webapp)
* Full Security system against XSS, CSRF, SQL injection, authentication hacking, session fixation, brute-force, reverse tabnabbing phishing attacks, ... and can even prevent some DDoS attacks!
* Two-Factor Authentication (2FA). With it, your website's admins, affiliates, users won't never be hacked again or got their accounts stolen thanks to a verification token sent on the user's mobile device
* Progressive Web App (PWA) support (requires HTTPS)
* Admin Panel - Block Access with IP Restriction
* Beautiful Code: Very thoroughly commented about what's happening throughout the PHP code, beautiful indentation and very readable, even for non-programmers
* Anyone can easily contribute to pH7Builder project thanks to the [GitHub repository](https://github.com/pH7Software/pH7-Social-Dating-CMS)


**It's not a hazard that pH7Builder is considered to be the first choice for creating an enterprise level dating Web application or a social networking platform**

*Great features [like here](https://ph7builder.com/social-dating-features/) and many other unique and exclusive features are waiting for YOU. Already released in pH7Builder!*

![Build a Social Dating Web App with pH7Builder](https://cloud.githubusercontent.com/assets/1325411/19419481/657386a4-93d0-11e6-8eee-95deba2d30a0.png)


## ⚙ Requirements

* **Application Server** PHP 8.0 or newer 🚀

* **Database** MySQL/MariaDB 5.5.3 or newer.

* **Operating System** Linux/Unix (Red Hat, CentOS, Debian, FreeBSD, Mandrake, Mac OS, etc.), Windows.

* **Web Server** Apache with mod_php or with PHP in CGI, FastCGI mode (nginx, LiteSpeed and IIS should also work. You might have to change some pieces of code and change the URL rewriting to make it work).

* **URL rewriting extension module** [Apache](https://ph7builder.com/doc/en/how-to-install-rewrite-module), nginx, LiteSpeed, IIS (for Web.config, you have a [good tutorial here](https://web.archive.org/web/20190116102700/http://www.phpgenious.com/2010/04/url-rewriting-with-php-and-iis-7/)).

* **Specific Requirement** Server has to be connected to Internet.

* **Minimum Web Space** 2.0 GB

* **pH7Builder's Video Module Requirement (only if enabled)** [FFmpeg](https://ffmpeg.org)


## 🛠 Installation

  * Git Repository:
    * Clone pH7Builder from Github `git clone git@github.com:pH7Software/pH7-Social-Dating-CMS.git ph7builder`
      (use `--depth=1` flag at the end of the line if you don't need the git history)
    * [Install Composer](https://getcomposer.org/doc/00-intro.md)
    * From a command line opened in the project folder, run `composer install` to install pH7Builder's dependencies.
  * Composer:
    * [Install Composer](https://getcomposer.org/doc/00-intro.md)
    * `composer create-project ph7software/ph7builder --prefer-dist ph7builder`
  * Sourceforge:
    * Directly download the latest stable version from [Sourceforge](https://sourceforge.net/projects/ph7socialdating/).
  * Softaculous:
    * If your Web host offers Softaculous, you might be able to install [pH7Builder in one-click with Softaculous](https://www.softaculous.com/apps/socialnetworking/pH7Builder).


## 🏗 Nginx Configuration

In order to get pH7Builder working on nginx server, you need to add some custom nginx configuration.

Create `/etc/nginx/ph7builder.conf` and add the following:

```nginx
location / {
    try_files $uri $uri/ /index.php?$args;
    index index.php;
}
```

*Please note that the above code is the strict minimum and obviously you can add more rules by comparing with the [main Apache .htaccess file](https://github.com/pH7Software/pH7-Social-Dating-CMS/blob/master/.htaccess).*

Finally, in your nginx server configuration, you will have to include `ph7builder.conf` file to complete the configuration like below:

In file, e.g., *`/etc/nginx/sites-enabled/yoursite.conf`* for Ubuntu and other OS based on Debian or `/etc/nginx/conf.d/yoursite.conf` for CentOS and other OS based on Red Hat.

```nginx
server {
    # Port number. In most cases, 80 for HTTP and 443 for HTTPS
    listen 80;

    server_name www.yoursite.com;
    root /var/www/ph7builder_public_root;
    index index.php;
    client_max_body_size 50M;

    error_log /var/log/nginx/yoursite.error.log;
    access_log /var/log/nginx/yoursite.access.log;

    # Include ph7builder.conf. You can also directly add the "location" rule instead of including the conf file
    include /etc/nginx/ph7builder.conf;
}
```

For more information, please refer to the nginx documentation.
<br />

![Create Your Own Niche Dating Service in New York City](https://cloud.githubusercontent.com/assets/1325411/19419480/65738a1e-93d0-11e6-9fbe-a48fa36fc53a.png)


## 📝 Translations

You can find and add other languages on the [I18N repo](https://github.com/pH7Software/pH7-Internationalization).


## 👨‍🍳 The Cook

Designed & Coded with lots of ❤️ by **[Pierre-Henry Soria](https://ph7.me)**. A **SUPER Passionate** Belgian Software Engineer 🍫🍺

[![Pierre-Henry Soria](https://avatars0.githubusercontent.com/u/1325411?s=200)](https://pierrehenry.be "My personal website :-)")

[![@phenrysay][x-badge]](https://x.com/phenrysay) [![BlueSky][bsky-badge]](https://bsky.app/profile/pierrehenry.dev "Follow Me on BlueSky") [![pH-7][github-badge]](https://github.com/pH-7) [![PayPal][paypal-badge]](https://www.paypal.com/cgi-bin/webscr?cmd=_s-xclick&hosted_button_id=X457W3L7DAPC6)


## 🤝 Hire Me At Your Company?

Are you building a scalable social/dating Web application?

Do you think you might need a software engineer like me at your company? (who could even be willing to relocate) 👉 **[Let's chat together](https://www.linkedin.com/in/ph7enry/)**! 😊

[![LinkedIn](https://img.shields.io/badge/LinkedIn-0077B5?style=for-the-badge&logo=linkedin&logoColor=white)](https://www.linkedin.com/in/ph7enry/ "Pierre-Henry Soria LinkedIn") [![Whatsapp](https://img.shields.io/badge/WhatsApp-25D366?style=for-the-badge&logo=whatsapp&logoColor=white)](https://wa.me/61426874095?text=I%27m%20looking%20for%20a%20software%20engineer%20like%20you)


## 💲 Offer Me A Cup of Tea? (...or tea bags...) 🍵

You appreciate the project, all the years intensively spent on the core development, and don't want to let it die...?

[![Paypal](templates/system/modules/ph7cms-helper/themes/base/img/paypal-donate.en.png)](https://www.paypal.com/cgi-bin/webscr?cmd=_s-xclick&hosted_button_id=X457W3L7DAPC6 "PayPal button")
[![Patreon](templates/system/modules/ph7cms-helper/themes/base/img/support-patreon.en.png)](https://www.patreon.com/bePatron?u=3534366 "Become a Patron")


## ⚡ Official Website

[pH7Builder.com](https://ph7builder.com)


## 📚 Documentation

[pH7Builder Documentation](https://ph7builder.com/doc/)


## 🤯 Troubleshooting

- Any issues, **[search/open an issue](https://github.com/pH7Software/pH7-Social-Dating-CMS/issues)**.

- Chitchat, sharing knowledge/experience, **[discussions Board](https://github.com/pH7Software/pH7-Social-Dating-CMS/discussions)**


## 💖 Contributing

[![I Love Open Source](static/img/love-open-source-logo.png)](https://ko-fi.com/phenry) [![Ko Fi - Offer Me A Flat White](static/img/kofi-logo.png)](https://ko-fi.com/phenry)

Anyone can contribute on **[pH7Builder GitHub](https://github.com/pH7Software/pH7-Social-Dating-CMS)** repository!

Finding bugs, improving the CMS/doc or adding translations. Any contribution is welcome and highly appreciated!

Just clone the repository, make your changes and then make a push ;-)

*WARNING: Your code/modification must be of excellent quality and follow the [Code Convention](https://ph7builder.com/doc/en/code-convention) and [PSR](https://www.php-fig.org/psr/).* I manually review and validate all improvements and changes you've done.

![pH7Software GitHub. Me, at a Costa coffee shop on Feb 4th, 2017.](https://user-images.githubusercontent.com/1325411/78962138-32ffa100-7ae3-11ea-8d35-83d78f3cbc48.jpg)


## 🌲 pH7Builder; The Eco-Friendly CMS ❤️

![Eco Friendly. Love the World and Love the Nature](static/img/love-nature.svg)

[pH7Builder](https://ph7builder.com) has been designed to reduce power and CPU usage of your server in order to preserve the nature and help to save our environment.

pH7Builder's templates also use lighter colors since LCD monitors use less electricity to display them.

Finally, **please consider using green Web hosting** (which use Green Power supply).


👉 Other [10 Easy Ways to Green Your Social Community](https://mashable.com/2010/01/01/green-your-web-site/) 👈


## 💪 Calculate Carbon Footprint of Your Social Dating Service 🌍

 How is your website impacting the planet? => Check it on the Website Carbon Calculator such as [https://www.websitecarbon.com](https://www.websitecarbon.com)


## 🔨 Tools/Software Used to Develop pH7Builder

* LAMP on **Fedora/Ubuntu** (and Mac/Windows with MAMP/WampServer/XAMPP for testing purpose).

* **Geany &amp; Sublime Text** for coding the whole project. That's it! However, since pH7Builder 5.0, **PhpStorm** (and sometimes Atom) are used as well.

* **Sequel Pro**, sometimes for easy GUI database viewing.

* **GIMP** for editing the assets, etc.

* **Trimage** (and **ImageOptim** when developing on Mac) for compressing &amp; optimizing the images.

* **Poedit** for translating the Gettext files.

* **FileZilla** for FTP client.

* **Git** for the version control system.

* Sometimes, when working on Mac, **Sequel Pro** is used to lookup easily at a database.


## 🖋 Contact (Suggestions / Feedback)

Feel free to send me an email at *hello {AT} ph7builder {D0T} com*


## ⚖️ License

**pH7Builder** (also known as pH7CMS) is an open-source software generously distributed under the [MIT license](https://opensource.org/licenses/MIT).

See the `LICENSE.md` and `COPYRIGHT.md` files for further details.


---

![Beautiful Profile Dating Page](https://user-images.githubusercontent.com/1325411/35779585-68f0d5fc-09c7-11e8-91eb-bf793fcfab6e.png)

![pH7Builder allows anyone to start a modern web dating app](https://cloud.githubusercontent.com/assets/1325411/19419477/5476b45c-93d0-11e6-823d-d293f186c0f7.png)

![Admin Panel, Browse Users](https://cloud.githubusercontent.com/assets/1325411/14080251/b476e5c6-f4fb-11e5-825e-ddc992ba1055.png)


<!-- GitHub's Markdown reference links -->
[x-badge]: https://img.shields.io/badge/x-000000?style=for-the-badge&logo=x
[bsky-badge]: https://img.shields.io/badge/BlueSky-00A8E8?style=for-the-badge&logo=bluesky&logoColor=white
[github-badge]: https://img.shields.io/badge/GitHub-100000?style=for-the-badge&logo=github&logoColor=white
[paypal-badge]: https://img.shields.io/badge/PayPal-00457C?style=for-the-badge&logo=paypal&logoColor=white
