<?php
if (isset($tpl['filter']))
{
	// Nom de l'objet du filtre.
	$object_name = '';
	if (isset($tpl['filter']['tags']))
	{
		$tags = [];
		foreach ($tpl['filter']['tags'] as &$t)
		{
			$tags[] = sprintf(
				'<a class="filter_name" href="%s#content">%s</a>',
				$t['link'], $t['name']
			);
		}
		$object_name = preg_replace('`,([^,]+)$`',
			sprintf(' %s$1', __('et')), implode(', ', $tags));
	}
	else if (!empty($tpl['filter']['object_name']))
	{
		$object_name = isset($tpl['filter']['object_link'])
			? '<a class="filter_name" href="' . $tpl['filter']['object_link'] . '#content">' .
				  $tpl['filter']['object_name'] .
			  '</a>'
			: '<span class="filter_name">' . $tpl['filter']['object_name'] . '</span>';
	}

	// Filtre.
	$breadcrumb_filter = sprintf($tpl['filter']['object_text'], $object_name) . ' ';
	if (isset($tpl['filter']['cat_text']))
	{
		$breadcrumb_filter .= sprintf($tpl['filter']['cat_text'],
			'<a id="cat_name" href="' . $tpl['filter']['cat_link'] . '#content">' .
				$tpl['filter']['cat_name'] .
			'</a>');
	}

	// Nombre de fichiers.
	if (!isset($tpl['search']['invalid']))
	{
		$count = $_GET['section'] == 'item'
			? $tpl['item_position'] . '/' . $tpl['objects_count']
			: $tpl['objects_count_formated'];
		$breadcrumb_filter .= sprintf(' <span id="objects_count">[%s]</span>', $count);
	}
}
?>
<nav id="section_nav">
<?php if (isset($tpl['filter'])) : ?>
	<p class="breadcrumb_filter">
		<span><?php echo $breadcrumb_filter; ?></span>
		-
		<a href="<?php echo $tpl['filter']['exit_link']; ?>#content"><?php echo $tpl['filter']['exit_text']; ?></a>
	</p>
<?php endif; ?>

<?php if (!empty($tpl['breadcrumb'])) : ?>
	<p id="breadcrumb">
<?php foreach ($tpl['breadcrumb'] as &$i) : ?>
<?php if ($i['id'] == 1) : continue; endif; ?>
		<a<?php if (isset($i['current'])) : ?> class="current"<?php endif; ?> href="<?php echo $i['url']; ?>#content"><?php echo $i['name']; ?></a>
<?php if ($i['type'] == 'album' && $_GET['section'] == 'item') break; ?>
<?php if (!isset($i['current'])) : ?>
		<span class="sep">/</span>
<?php endif; ?>
<?php endforeach; ?>
<?php if (!isset($_GET['filter'])) : ?>
		<span id="objects_count">[<?php if ($_GET['section'] == 'item') : ?><?php echo $tpl['item_position']; ?>/<?php endif; ?><?php echo $_GET['section'] == 'item' ? $tpl['objects_count'] : $tpl['objects_count_formated']; ?>]</span>
<?php endif; ?>
	</p>
<?php endif; ?>

</nav>
