<?php
declare(strict_types = 1);

/**
 * Fabrication des flux RSS.
 *
 * @license https://www.gnu.org/licenses/gpl-3.0.html
 * @link https://www.igalerie.org/
 */

$gets = ['category', 'item', 'lang', 'tag', 'type'];
require_once(__DIR__ . '/includes/prepend.php');

// Quelques vérifications.
if (preg_match(L10N::LANG_REGEXP, $_GET['lang'] ?? '')
&& in_array($_GET['type'] ?? '', ['comments', 'items']))
{
	// Initialisation.
	$rss = new RSS($_GET['lang']);

	// Flux de catégorie.
	if (preg_match('`^\d{1,12}$`', $_GET['category'] ?? ''))
	{
		$rss->makeCategoryFeed((int) $_GET['category'], $_GET['type']);
	}

	// Flux de fichier.
	if (preg_match('`^\d{1,12}$`', $_GET['item'] ?? ''))
	{
		$rss->makeItemFeed((int) $_GET['item']);
	}

	// Flux de tag.
	if (preg_match('`^\d{1,12}$`', $_GET['tag'] ?? ''))
	{
		$rss->makeTagFeed((int) $_GET['tag']);
	}
}

die(App::httpResponse(400));
?>