<?php
declare(strict_types = 1);

class_exists('DB') || die;

require_once(__DIR__ . '/classes/AdminUsers.class.php');

template:
{
	Template::set('page',
	[
		'link' => App::getURL('users'),
		'title' => __('Utilisateurs')
	]);
	Template::set('section', 'users');
	Template::set('template', ['file' => 'users.tpl.php']);

	Template::set('profile_params', User::getProfileParams());
}

update:
{
	Admin::displayOptions('users');

	AdminUsers::actions();

	Template::set('new_user', ['fail' => !AdminUsers::addUser()]);
}

get_data:
{
	AdminUsers::getUsers();
}
?>