<?php
declare(strict_types = 1);

require_once(__DIR__ . '/Admin.class.php');

/**
 * Connexion/déconnexion à l'interface d'administration.
 *
 * @license https://www.gnu.org/licenses/gpl-3.0.html
 * @link https://www.igalerie.org/
 */
class AdminConnection extends Admin
{
	/**
	 * Authentification.
	 *
	 * @return void
	 */
	public static function login(): void
	{
		Template::set('login', $POST['login'] ?? '');

		if (!isset($_POST['login']) || !isset($_POST['password']))
		{
			return;
		}

		// Vérification des informations.
		$cause = '';
		if (!Auth::form($_POST['login'], $_POST['password'], isset($_POST['remember']), $cause))
		{
			Report::warning(L10N::getTextLoginRejected($cause));
			return;
		}

		App::redirect('dashboard');
	}

	/**
	 * Déconnexion.
	 *
	 * @return bool
	 */
	public static function logout(): bool
	{
		return isset($_POST['anticsrf']) && Auth::logout();
	}

	/**
	 * Procédure pour la réinitialisation du mot de passe.
	 *
	 * @return void
	 */
	public static function passwordForgot(): void
	{
		$forgot = [];

		if (User::passwordForgot($_POST, $forgot))
		{
			if (isset($forgot['warning']))
			{
				Report::warning($forgot['warning']);
			}
		}
		else
		{
			Report::error();
		}

		Template::set('forgot_password', $forgot);
	}
}
?>