<?php $confirm_delete = __('Supprimer les tags sélectionnés ?'); ?>
<div id="page_table" class="page_content">
	<div>
		<nav id="section_nav">
<?php include('breadcrumb.tpl.php'); ?>
		</nav>

<?php if (isset($_POST['action']) && $_POST['action'] == 'delete_confirm') : ?>
<?php include('delete_selection.tpl.php'); ?>
<?php else : ?>

		<div class="tools">
			<div><span class="icon icon_tags_add show_tool"><a data-id="new_tags" class="js<?php if (strstr($_GET['section_1'], 'add')) : ?> show<?php endif; ?>" href="<?php echo $tpl['link']('tags' . (strstr($_GET['section_1'], 'add') ? '' : '-add') . '/page/' . $_GET['page']); ?>"><?php echo __('Ajouter des tags'); ?></a></span></div>
			<span class="sep">-</span>
			<div><span class="icon icon_search show_tool"><a data-id="search" class="js<?php if (strstr($_GET['section_1'], 'search')) : ?> show<?php endif; ?>" href="<?php echo $tpl['link']('tags' . (strstr($_GET['section_1'], 'search') ? '' : '-search') . '/page/' . $_GET['page']); ?>"><?php echo __('Recherche'); ?></a></span></div>
			<span class="sep">-</span>
			<div><span class="icon icon_options show_tool"><a data-id="options" class="js<?php if (strstr($_GET['section_1'], 'display')) : ?> show<?php endif; ?>" href="<?php echo $tpl['link']('tags' . (strstr($_GET['section_1'], 'display') ? '' : '-display') . '/page/' . $_GET['page']); ?>"><?php echo __('Options d\'affichage'); ?></a></span></div>
		</div>

		<form action="<?php echo $tpl['current_url']; ?>" method="post" class="tool<?php if ($_GET['section_1'] == 'tags-add') : ?> show<?php endif; ?>" id="new_tags">
			<fieldset>
				<p class="field">
					<span class="icon icon_add"><a class="js" href="javascript:;"><?php echo __('Plus de tags'); ?></a></span>
				</p>
				<p class="field" id="new_tags_fields">
					<input<?php if ($_GET['section_1'] == 'tags-add') : ?> autofocus<?php endif; ?> name="new_tags[]" type="text" maxlength="255" size="20" class="focus" required>
					<input name="new_tags[]" type="text" maxlength="255" size="20">
					<input name="new_tags[]" type="text" maxlength="255" size="20">
					<input name="new_tags[]" type="text" maxlength="255" size="20">
				</p>
				<input name="anticsrf" type="hidden" value="<?php echo $tpl['anticsrf'](); ?>">
				<input type="submit" value="<?php echo __('Ajouter'); ?>">
			</fieldset>
		</form>

		<form action="<?php echo $tpl['current_url_pageless']; ?>" method="post" class="tool<?php if (strstr($_GET['section_1'], 'search')) : ?> show<?php endif; ?>" id="search">
			<fieldset>
				<p class="field">
					<label for="search_query"><?php echo __('Rechercher :'); ?></label>
					<input<?php if (strstr($_GET['section_1'], 'search')) : ?> autofocus<?php endif; ?> required data-help-icon="search" value="<?php echo $tpl['search']['query']; ?>" class="focus" type="text" name="search_query" id="search_query" maxlength="255" size="50" data-reset="">
				</p>
				<p class="field">
					<input<?php echo $tpl['search']['all_words'] ? ' checked' : ''; ?> type="checkbox" name="search_options[all_words]" id="search_all_words" data-reset="1">
					<label for="search_all_words"><?php echo __('Rechercher tous les mots'); ?></label>
				</p>
				<p class="field">
					<span class="icon icon_search_options showhide" rel="#adv_search"><a class="js" href="<?php echo $tpl['link']('tags-' . (strstr($_GET['section_1'], 'advanced') ? 'search' : 'search-advanced') . '/page/' . $_GET['page']); ?>"><?php echo __('Options de recherche'); ?></a></span>
				</p>
				<div id="adv_search"<?php if (strstr($_GET['section_1'], 'advanced')) : ?> class="show"<?php endif; ?>>
					<p class="field">
						<?php echo __('Rechercher dans les champs suivants :'); ?>
					</p>
					<div class="field_sublvl">
						<p class="field">
							<input<?php echo $tpl['search']['columns']['tag_name'] ? ' checked' : ''; ?> type="checkbox" name="search_options[columns][]" value="tag_name" id="search_tag_name" data-reset="1">
							<label for="search_tag_name"><?php echo __('Nom'); ?></label>
							&nbsp;
							<input<?php echo $tpl['search']['columns']['tag_url'] ? ' checked' : ''; ?> type="checkbox" name="search_options[columns][]" value="tag_url" id="search_tag_url" data-reset="1">
							<label for="search_tag_url"><?php echo __('URL'); ?></label>
						</p>
					</div>
				</div>
				<input name="anticsrf" type="hidden" value="<?php echo $tpl['anticsrf'](); ?>">
				<input name="search" type="submit" value="<?php echo __('Chercher'); ?>">
				<input class="button reset_js" type="reset" value="<?php echo __('Réinitialiser'); ?>">
			</fieldset>
		</form>

		<form action="<?php echo $tpl['current_url_pageless']; ?>" method="post" class="tool<?php if ($_GET['section_1'] == 'tags-display') : ?> show<?php endif; ?>" id="options">
			<fieldset>
				<p class="field">
					<label for="nb_per_page"><?php echo __('Nombre de tags par page :'); ?></label>
					<input<?php if ($_GET['section_1'] == 'tags-display') : ?> autofocus<?php endif; ?> required maxlength="3" size="3" value="<?php echo $tpl['options']['nb_per_page']; ?>" name="nb_per_page" id="nb_per_page" type="text" class="focus">
				</p>
				<p class="field">
					<label for="order_by_column"><?php echo __('Trier par :'); ?></label>
					<select name="order_by_column" id="order_by_column">
<?php foreach ($tpl['options']['order_by_column'] as &$i) : ?>
						<option<?php if ($i['selected']) : ?> selected<?php endif; ?> value="<?php echo $i['value']; ?>"><?php echo $i['text']; ?></option>
<?php endforeach; ?>
					</select>
					<select name="order_by_order">
<?php foreach ($tpl['options']['order_by_order'] as &$i) : ?>
						<option<?php if ($i['selected']) : ?> selected<?php endif; ?> value="<?php echo $i['value']; ?>"><?php echo $i['text']; ?></option>
<?php endforeach; ?>
					</select>
				</p>
				<input name="anticsrf" type="hidden" value="<?php echo $tpl['anticsrf'](); ?>">
				<input name="options" type="submit" value="<?php echo __('Valider'); ?>">
			</fieldset>
		</form>

<?php if ($tpl['objects_count'] > 0) : ?>

<?php include('pagination.tpl.php'); ?>

		<div class="table_form_container">
			<form class="table_form" id="tags_form" action="<?php echo $tpl['current_url']; ?>" method="post">

				<div id="obj_links_js">
<?php include('object_select.tpl.php'); ?>
				</div>

				<table class="default page">
					<tr>
						<th><?php echo __('Nom'); ?></th>
						<th><?php echo __('URL'); ?></th>
						<th><?php echo __('Fichiers liés'); ?></th>
						<th class="null"></th>
					</tr>
<?php $n = 1; foreach ($tpl['tags'] as &$i) : ?>
					<tr class="selectable_class<?php if (is_integer($n++ / 2)) : ?> even<?php endif; ?>">
						<td>
							<input required size="40" maxlength="255" name="tags[<?php echo $i['id']; ?>][name]" type="text" value="<?php echo $i['name']; ?>">
						</td>
						<td>
							<input required size="40" maxlength="255" name="tags[<?php echo $i['id']; ?>][url]" type="text" value="<?php echo $i['url']; ?>">
						</td>
						<td class="num">
							<?php if ($i['link']) : ?><a href="<?php echo $i['link']; ?>"><?php echo $i['count']; ?></a><?php else : ?>0<?php endif; ?>
						</td>
						<td class="selectable_zone"><input class="selectable" name="selected[<?php echo $i['id']; ?>]" type="checkbox"></td>
					</tr>
<?php endforeach; ?>
				</table>

				<div id="submit" class="submit_actions submit_table<?php if ($tpl['nb_pages'] > 1) : ?> submit_pages<?php endif; ?>">
					<div>
						<p id="form_save">
							<input name="save" type="submit" value="<?php echo __('Enregistrer les modifications'); ?>">
						</p>
						<p id="form_actions">
							<label for="selection_action"><?php printf(__('Action sur la sélection (%s) :'), '<span id="select_num">0</span>'); ?></label>
							<select id="selection_action" name="action">
								<optgroup label="<?php echo __('Suppression'); ?>">
									<option value="delete_confirm"><?php echo __('Supprimer'); ?></option>
								</optgroup>
							</select>
							<input name="anticsrf" type="hidden" value="<?php echo $tpl['anticsrf'](); ?>">
							<input name="selection" type="submit" value="<?php echo __('Valider'); ?>">
						</p>
					</div>
				</div>
			</form>
		</div>

		<script nonce="<?php echo CSP_NONCE; ?>" type="text/javascript">
		var confirm_delete = "<?php echo $tpl['php2js']($confirm_delete); ?>";
		</script>

<?php include('pagination.tpl.php'); ?>

<?php else : ?>
		<br>
		<div class="report_classic">
			<div class="report_msg report_info">
				<p><?php echo isset($_GET['search']) ? __('Aucun tag trouvé.') : __('Aucun tag.'); ?></p>
			</div>
		</div>
<?php endif; ?>

<?php endif; ?>

	</div>
</div>