<?php if ($tpl['file_missing']) : ?>
<br>
<div class="report_classic">
	<div class="report_msg report_error">
		<p><?php echo __('Ce fichier ne semble pas être présent dans le répertoire des albums.'); ?></p>
	</div>
</div>
<?php endif; ?>

<form class="page" action="<?php echo $tpl['current_url']; ?>" method="post">
	<fieldset>
		<legend><?php echo __('Général'); ?></legend>
		<p class="field">
			<label for="status"><?php echo __('État :'); ?></label><br>
			<select id="status" name="<?php echo $tpl['item']['id']; ?>[status]">
				<option<?php if ($tpl['item']['activated']) : ?> selected<?php endif; ?> value="1"><?php echo __('Activé'); ?></option>
				<option<?php if ($tpl['item']['deactivated']) : ?> selected<?php endif; ?> value="0"><?php echo __('Désactivé'); ?></option>
			</select>
		</p>
		<p class="field">
			<input name="reset_item_pubdt" id="reset_item_pubdt" type="checkbox">
			<label for="reset_item_pubdt"><?php echo __('Réinitialiser la date de publication'); ?></label>
		</p>
		<p class="field">
			<label for="category_parent"><?php echo __('Album :'); ?></label><br>
			<select id="category_parent" name="<?php echo $tpl['item']['id']; ?>[category_parent]">
				<?php foreach ($tpl['categories_browse'] as &$i) : ?><?php if ($i['node'] == 'content') : ?><option id="o<?php echo $i['level'] > 1 ? '' : 'v'; echo ($i['subcats'] || $i['id'] == 1) ? 's' : ''; echo $i['password'] ? 'p' : ''; echo $i['id'] == $tpl['item']['cat_id'] ? 'c' : ''; ?>:<?php echo $i['level']; ?>{<?php echo $i['id']; ?>}<?php echo $i['parents']; ?>" value="<?php echo $i['id']; ?>"<?php if ($i['type'] == 'category') : ?> disabled<?php endif; ?><?php if ($i['id'] == $tpl['item']['cat_id']) : ?> selected<?php endif; ?>><?php echo str_repeat(' ', $i['level'] * 4); ?><?php echo $i['title']; ?></option><?php endif; ?><?php endforeach; ?>

			</select>
			<a data-box-title="<?php echo __('Déplacer vers...'); ?>" data-box-list="categories" href="javascript:;" title="<?php echo __('Liste des albums'); ?>"><img width="16" height="16" src="<?php echo $tpl['admin']['style']['path']; ?>/icons/16x16/search.png"></a>
		</p>
		<p class="field">
			<label for="owner"><?php echo __('Propriétaire :'); ?></label><br>
			<select id="owner" name="<?php echo $tpl['item']['id']; ?>[owner]">
<?php foreach ($tpl['users'] as &$i) : ?>
				<option<?php if ($i['id'] == $tpl['item']['user_id']) : ?> selected<?php endif; ?> value="<?php echo $i['id']; ?>"><?php echo $i['nickname']; ?></option>
<?php endforeach; ?>
			</select>
		</p>
		<p class="field">
			<label for="hits"><?php echo __('Nombre de vues :'); ?></label><br>
			<input required name="<?php echo $tpl['item']['id']; ?>[hits]" size="12" maxlength="12" id="hits" type="text" value="<?php echo $tpl['item']['hits']; ?>">
		</p>
	</fieldset>
	<fieldset>
		<legend><?php echo __('Informations'); ?></legend>
<?php $i =& $tpl['item']; include('item_informations.tpl.php'); ?>
	</fieldset>
	<fieldset>
		<legend><?php echo __('Dates'); ?></legend>
<?php $i =& $tpl['item']; include('item_dates.tpl.php'); ?>
	</fieldset>
	<fieldset>
		<legend><?php echo __('Tags'); ?></legend>
		<p class="field">
			<label for="tags_<?php echo $i['id']; ?>"><?php echo __('Tags (séparés par une virgule) :'); ?></label>
			<a data-box-list="tags_add" href="javascript:;" title="<?php echo __('Tags de la galerie'); ?>"><img width="16" height="16" src="<?php echo $tpl['admin']['style']['path']; ?>/icons/16x16/search.png"></a>
			<textarea class="large" name="<?php echo $i['id']; ?>[tags]" rows="8" cols="50" id="tags_<?php echo $i['id']; ?>"><?php echo $i['tags']; ?></textarea>
		</p>
	</fieldset>
	<fieldset>
		<legend><?php echo __('Réglages'); ?></legend>
<?php $i =& $tpl['item']; include('item_settings.tpl.php'); ?>
	</fieldset>
	<fieldset>
		<legend><?php echo __('Vignette des catégories parentes'); ?></legend>
		<p class="field"><?php echo __('Utiliser ce fichier comme vignette pour les catégories parentes suivantes :'); ?></p>
<?php foreach ($tpl['item']['cat_parents'] as &$p) : ?>
<?php if ($p['cat_id'] > 1 && in_array($p['cat_type'], ['album', 'category'])) : ?>
		<p class="field">
			<input name="thumb[_checkboxes][]" type="hidden" value="<?php echo $p['cat_id']; ?>">
			<input<?php if ($p['thumb_id'] == $tpl['item']['id']) : ?> checked<?php endif; ?> id="thumb_<?php echo $p['cat_id']; ?>" name="thumb[<?php echo $p['cat_id']; ?>]" type="checkbox">
			<label for="thumb_<?php echo $p['cat_id']; ?>"><?php echo $p['cat_name']; ?></label>
		</p>
<?php endif; ?>
<?php endforeach; ?>
	</fieldset>
	<div id="submit">
		<div>
			<input name="anticsrf" type="hidden" value="<?php echo $tpl['anticsrf'](); ?>">
			<input name="save" type="submit" value="<?php echo __('Enregistrer'); ?>">
		</div>
	</div>
</form>

<script nonce="<?php echo CSP_NONCE; ?>" type="text/javascript">
<?php foreach ($tpl['tags'] as &$tag) { $tag = "'" . $tag . "'"; } ?>
var tags = [<?php echo implode(', ', $tpl['tags']); ?>];
var tags_flip = [];
var l10n_list_tags_empty = "<?php echo $tpl['php2js'](__('La galerie ne contient aucun tag.')); ?>";
</script>
