<?php include('users_menu.tpl.php'); ?>

<div class="tools">
	<div><span class="icon icon_group_add show_tool<?php if ($tpl['new_group']['fail']) : ?> autoclick<?php endif; ?>"><a data-id="group_add" class="js<?php if ($_GET['section_1'] == 'groups-add') : ?> show<?php endif; ?>" href="<?php echo $tpl['link']('groups' . (strstr($_GET['section_1'], 'add') ? '' : '-add')); ?>"><?php echo __('Ajouter un groupe'); ?></a></span></div>
</div>

<form action="<?php echo $tpl['current_url_pageless']; ?>" method="post" class="tool<?php if ($_GET['section_1'] == 'groups-add') : ?> show<?php endif; ?>" id="group_add">
	<fieldset>
		<p class="field<?php if ($tpl['field_error'] == 'name') : ?> field_error<?php endif; ?>">
			<label for="group_name"><?php echo __('Nom :'); ?></label>
			<input<?php if ($_GET['section_1'] == 'groups-add') : ?> autofocus<?php endif; ?> required maxlength="64" value="<?php echo $tpl['new_group']['name']; ?>" name="name" id="group_name" type="text" class="focus large">
		</p>
		<p class="field<?php if ($tpl['field_error'] == 'title') : ?> field_error<?php endif; ?>">
			<label for="group_title"><?php echo __('Titre :'); ?></label>
			<input required maxlength="128" value="<?php echo $tpl['new_group']['title']; ?>" name="title" id="group_title" type="text" class="large">
		</p>
		<p class="field">
			<label for="group_desc"><?php echo __('Description :'); ?></label>
			<textarea maxlength="500" rows="6" cols="50" name="desc" id="group_desc"><?php echo $tpl['new_group']['desc']; ?></textarea>
		</p>
		<input name="anticsrf" type="hidden" value="<?php echo $tpl['anticsrf'](); ?>">
		<input name="group_add" type="submit" value="<?php echo __('Valider'); ?>">
	</fieldset>
</form>

<table class="default" id="groups">
	<tr>
		<th class="name"><?php echo __('Nom du groupe'); ?></th>
		<th class="title"><?php echo __('Titre'); ?></th>
		<th class="type"><?php echo __('Type de compte'); ?></th>
		<th class="description"><?php echo __('Description'); ?></th>
		<th class="nb_members"><?php echo __('Nombre d\'utilisateurs'); ?></th>
	</tr>
<?php $n = 1; foreach ($tpl['groups'] as &$i) : ?>
	<tr class="selectable_class<?php if (is_integer($n++ / 2)) : ?> even<?php endif; ?>">
		<td class="name">
			<a title="<?php echo __('Modifier le groupe'); ?>" href="<?php echo $tpl['link']('group/' . $i['id']); ?>">
				<?php echo $i['name']; ?>

			</a>
		</td>
		<td class="title"><?php echo $i['title']; ?></td>
		<td class="type">
			<?php echo $i['type_text']; ?>
<?php if ($i['superadmin']) : ?>
			<img title="<?php echo __('Super-administrateur'); ?>" width="16" height="16" src="<?php echo $tpl['admin']['style']['path']; ?>/icons/16x16/crown.png">
<?php elseif ($i['admin']) : ?>
			<img title="<?php echo __('Administrateur'); ?>" width="16" height="16" src="<?php echo $tpl['admin']['style']['path']; ?>/icons/16x16/medal.png">
<?php endif; ?>
		</td>
		<td class="description"><?php echo nl2br($i['description']); ?></td>
		<td class="nb_members">
<?php if ($i['id'] == 2) : ?>
			/
<?php elseif ($i['nb_users'] < 1) : ?>
			<?php printf(__('%s utilisateur'), $i['nb_users']); ?>
<?php else : ?>
			<a href="<?php echo $tpl['link']('users/group/' . $i['id']); ?>">
				<?php printf(($i['nb_users'] > 1 ? __('%s utilisateurs') : __('%s utilisateur')), $i['nb_users']); ?>
			</a>
<?php endif; ?>
		</td>
	</tr>
<?php endforeach; ?>
</table>