<?php
/**
 * This is the template that displays the edit item form. It gets POSTed to /htsrv/item_edit.php.
 *
 * Note: don't code this URL by hand, use the template functions to generate it!
 *
 * This file is part of the b2evolution/evocms project - {@link http://b2evolution.net/}.
 * See also {@link https://github.com/b2evolution/b2evolution}.
 *
 * @license GNU GPL v2 - {@link http://b2evolution.net/about/gnu-gpl-license}
 *
 * @copyright (c)2003-2020 by Francois Planque - {@link http://fplanque.com/}.
 *
 * @package evoskins
 */
if( !defined('EVO_MAIN_INIT') ) die( 'Please, do not access this page directly.' );

global $Collection, $Blog, $Session, $inc_path;
global $action, $form_action;

/**
 * @var Plugins
 */
global $Plugins;
/**
 * @var GeneralSettings
 */
global $Settings;
/**
 * @var UserSettings
 */
global $UserSettings;

global $pagenow;

global $trackback_url;
global $bozo_start_modified, $creating;
global $edited_Item, $item_tags, $item_title, $item_content;
global $post_category, $post_extracats;
global $admin_url, $redirect_to, $form_action;


// Default params:
$params = array_merge( array(
		'disp_edit_categories' => true,
		'edit_form_params' => array(),
	), $params );

// Determine if we are creating or updating...
$creating = is_create_action( $action );

// Used to mark the required fields (in non-standard template)
$required_star = '<span class="label_field_required">*</span>';

$Form = new Form( $form_action, 'item_checkchanges', 'post' );

$Form->switch_template_parts( $params['edit_form_params'] );

// ================================ START OF EDIT FORM ================================

$form_params = array();
$iframe_name = NULL;
if( !empty( $bozo_start_modified ) )
{
	$form_params['bozo_start_modified'] = true;
}

$Form->begin_form( 'inskin', '', $form_params );

	$Form->add_crumb( 'item' );
	$Form->hidden( 'ctrl', 'items' );
	$Form->hidden( 'blog', $Blog->ID );
	if( isset( $edited_Item ) )
	{
		$copy_post_ID = param( 'cp', 'integer', 0 );
		if( $copy_post_ID > 0 )
		{	// Copy post
			$Form->hidden( 'post_ID', 0 );
		}
		else
		{	// Edit post
			$Form->hidden( 'post_ID', $edited_Item->ID );
		}
	}
	$Form->hidden( 'redirect_to', $redirect_to );

	// In case we send this to the blog for a preview :
	$Form->hidden( 'preview', 0 );
	$Form->hidden( 'more', 1 );

	// Add hidden required fields or fields that were set in the init_inskin_editing() function
	$Form->hidden( 'item_typ_ID', $edited_Item->ityp_ID );

	if( $edited_Item->get( 'urltitle' ) != '' )
	{	// post_urltitle can be defined from request param
		$Form->hidden( 'post_urltitle', $edited_Item->get( 'urltitle' ) );
	}

	if( $action != 'new' )
	{ // DO NOT ADD HIDDEN FIELDS IF THEY ARE NOT SET
		// These fields will be set only in case when switch tab from admin editing to in-skin editing
		// Fields used in "advanced" form, but not here:
		if( $edited_Item->get_type_setting( 'use_short_title' ) == 'optional' )
		{
			$Form->hidden( 'post_short_title', htmlspecialchars_decode( $edited_Item->get( 'short_title' ) ) );
		}
		$Form->hidden( 'post_comment_status', $edited_Item->get( 'comment_status' ) );
		$Form->hidden( 'post_locale', $edited_Item->get( 'locale' ) );
		$Form->hidden( 'post_locale_visibility', $edited_Item->get( 'locale_visibility' ) );
		$Form->hidden( 'post_url', $edited_Item->get( 'url' ) );
		$Form->hidden( 'post_parent_ID', $edited_Item->get( 'parent_ID' ) );
		$Form->hidden( 'post_excerpt', $edited_Item->get( 'excerpt' ) );
		$Form->hidden( 'post_excerpt_autogenerated', $edited_Item->get( 'excerpt_autogenerated' ) );
		$Form->hidden( 'titletag', $edited_Item->get( 'titletag' ) );
		$Form->hidden( 'metadesc', $edited_Item->get_setting( 'metadesc' ) );
		$Form->hidden( 'metakeywords', $edited_Item->get_setting( 'metakeywords' ) );

		if( $edited_Item->can_edit_workflow( 'status' ) )
		{	// Allow workflow status if current user can edit this property:
			$Form->hidden( 'item_st_ID', $edited_Item->pst_ID );
		}
		if( $edited_Item->can_edit_workflow( 'status' ) )
		{	// Allow workflow user if current user can edit this property:
			$Form->hidden( 'item_assigned_user_ID', $edited_Item->assigned_user_ID );
		}
		if( $edited_Item->can_edit_workflow( 'priority' ) )
		{	// Allow workflow priority if current user can edit this property:
			$Form->hidden( 'item_priority', $edited_Item->priority );
		}
		if( $edited_Item->can_edit_workflow( 'deadline' ) )
		{	// Allow workflow deadline if current user can edit this property:
			$Form->hidden( 'item_deadline', mysql2date( locale_input_datefmt(), $edited_Item->datedeadline ) );
			$Form->hidden( 'item_deadline_time', mysql2date( 'H:i', $edited_Item->datedeadline ) );
		}
		$Form->hidden( 'trackback_url', $trackback_url );
		if( check_user_perm( 'blog_edit_ts', 'edit', false, $Blog->ID ) )
		{	// If user has a permission to edit advanced properties of items:
			$Form->hidden( 'item_featured', $edited_Item->featured );
			$Form->hidden( 'expiry_delay', $edited_Item->get_setting( 'comment_expiry_delay' ) );
			$Form->hidden( 'goal_ID', $edited_Item->get_setting( 'goal_ID' ) );
		}
		if( is_pro() && $Blog->get_setting( 'track_unread_content' ) )
		{	// Update setting to mark Item as "must read" only for PRO version and when tracking of unread content is enabled for collection:
			$Form->hidden( 'item_mustread', $edited_Item->get_setting( 'mustread' ) );
		}
		$Form->hidden( 'item_hideteaser', $edited_Item->get_setting( 'hide_teaser' ) );
		$Form->hidden( 'item_switchable', $edited_Item->get_setting( 'switchable' ) );
		$Form->hidden( 'item_switchable_params', $edited_Item->get_setting( 'switchable_params' ) );

		$creator_User = $edited_Item->get_creator_User();
		$Form->hidden( 'item_owner_login', $creator_User->login );
		$Form->hidden( 'item_owner_login_displayed', 1 );
	}
	elseif( !isset( $edited_Item->status ) )
	{
		$highest_publish_status = get_highest_publish_status( 'post', $Blog->ID, false, '', $edited_Item );
		$edited_Item->set( 'status', $highest_publish_status );
	}

	if( check_user_perm( 'admin', 'restricted' ) )
	{ // These fields can be edited only by users which have an access to back-office
		if( check_user_perm( 'blog_edit_ts', 'edit', false, $Blog->ID ) )
		{ // Time stamp field values
			$Form->hidden( 'item_dateset', $edited_Item->get( 'dateset' ) );
			$Form->hidden( 'item_issue_date', mysql2localedate( $edited_Item->get( 'issue_date' ) ) );
			$Form->hidden( 'item_issue_time', substr( $edited_Item->get( 'issue_date' ), 11 ) );
		}
	}
	// Tags
	$Form->hidden( 'item_tags', $item_tags );
	$Form->hidden( 'suggest_item_tags', $UserSettings->get( 'suggest_item_tags' ) );

	if( $Blog->get_setting( 'in_skin_editing_category' ) )
	{	// If categories are allowed to update from front-office:
		$disp_edit_categories = true;
	}
	else
	{	// Don't allow to update the categories:
		$disp_edit_categories = false;
		if( $edited_Item->ID == 0 )
		{	// Force to store category Id in hidden field only for new creating items:
			$params['disp_edit_categories'] = false;
		}
	}

	if( ! $params['disp_edit_categories'] )
	{	// When categories are hidden, we store a cat_ID in the hidden input:
		if( $edited_Item->ID > 0 )
		{	// Get cat_ID from existing Item:
			$main_Chapter = $edited_Item->get_main_Chapter();
			$cat = $main_Chapter->ID;
		}
		else
		{	// Forums skin get cat_ID from $_GET:
			$cat = param( 'cat', 'integer', 0 );
		}

		if( $cat > 0 )
		{	// Store a cat_ID:
			$Form->hidden( 'post_category', $cat );
			$Form->hidden( 'cat', $cat );
			$disp_edit_categories = false;
		}
	}

?>


	<?php
	// ############################ POST CONTENTS #############################
	// Title input:
	$use_title = $edited_Item->get_type_setting( 'use_title' );
	if( $use_title != 'never' )
	{
		$Form->switch_layout( 'none' );
		echo '<table width="100%" class="compose_layout"><tr>';
		$Form->labelstart = '<th width="1%" class="label">';
		$Form->labelend = '</th>';
		$Form->inputstart = '<td>';
		$Form->inputend = '</td>';
		$Form->text_input( 'post_title', $item_title, 20, T_('Title'), '', array( 'maxlength' => 255, 'style' => 'width: 100%;', 'required' => ( $use_title == 'required' ) ) );
		echo '</tr></table>';
		$Form->switch_layout( NULL );
	}


	if( $edited_Item->get_type_setting( 'allow_attachments' ) && $edited_Item->ID > 0 )
	{ // ####################### ATTACHMENTS FIELDSETS #########################
		$LinkOwner = new LinkItem( $edited_Item );
	}

	if( $edited_Item->get_type_setting( 'use_text' ) != 'never' )
	{ // Display text
		// --------------------------- TOOLBARS ------------------------------------
		echo '<div class="edit_toolbars">';
		// CALL PLUGINS NOW:
		$admin_toolbar_params = array(
				'edit_layout' => 'expert',
				'Item' => $edited_Item,
			);
		if( isset( $LinkOwner) && $LinkOwner->is_temp() )
		{
			$admin_toolbar_params['temp_ID'] = $LinkOwner->get_ID();
		}
		$Plugins->trigger_event( 'AdminDisplayToolbar', $admin_toolbar_params );
		echo '</div>';

		// ---------------------------- TEXTAREA -------------------------------------
		$Form->switch_layout( 'none' );
		$Form->fieldstart = '<div class="edit_area">';
		$Form->fieldend = "</div>\n";
		$Form->textarea_input( 'content', $item_content, 16, NULL, array(
				'cols' => 50 ,
				'id' => 'itemform_post_content',
				'class' => 'autocomplete_usernames link_attachment_dropzone'
			) );
		$Form->switch_layout( NULL );
		?>
		<script language="JavaScript">
			<!--
			// This is for toolbar plugins
			var b2evoCanvas = document.getElementById('itemform_post_content');
			//-->
		</script>

		<?php
		echo '<div class="edit_plugin_actions">';
		// CALL PLUGINS NOW:
		$display_editor_params = array(
				'target_type'   => 'Item',
				'target_object' => $edited_Item,
				'content_id'    => 'itemform_post_content',
				'edit_layout'   => 'inskin',
			);
		if( isset( $LinkOwner) && $LinkOwner->is_temp() )
		{
			$display_editor_params['temp_ID'] = $LinkOwner->get_ID();
		}
		$Plugins->trigger_event( 'DisplayEditorButton', $display_editor_params );
		echo '</div>';
	}
	else
	{ // Hide text
		$Form->hidden( 'content', $item_content );
	}

	// =================================== INSTRUCTION ====================================
	if( $edited_Item->get_type_setting( 'front_order_instruction' ) && $edited_Item->get_type_setting( 'instruction' ) )
	{
		echo '<div class="action_messages evo_instruction"><div class="log_note">'.$edited_Item->get_type_setting( 'instruction' ).'</div></div>';
	}

	global $display_item_settings_is_defined;
	$display_item_settings_is_defined = false;
	modules_call_method( 'display_item_settings', array( 'Form' => & $Form, 'Blog' => & $Blog, 'edited_Item' => & $edited_Item ) );

	if( ! $display_item_settings_is_defined )
	{
		// ################### VISIBILITY / SHARING ###################
		// Get those statuses which are not allowed for the current User to create posts in this blog
		$exclude_statuses = array_merge( get_restricted_statuses( $Blog->ID, 'blog_post!', 'create', $edited_Item->status, '', $edited_Item ), array( 'trash' ) );
		// Get allowed visibility statuses
		$sharing_options = get_visibility_statuses( 'radio-options', $exclude_statuses );
		if( count( $sharing_options ) == 1 )
		{ // Only one visibility status is available, don't show radio but set hidden field
			$Form->hidden( 'post_status', $sharing_options[0][0] );
		}
		else
		{ // Display visibiliy options
			$Form->begin_fieldset( T_('Visibility / Sharing'), array( 'id' => 'itemform_visibility' ) );
			$Form->switch_layout( 'linespan' );
			visibility_select( $Form, $edited_Item->status );
			$Form->switch_layout( NULL );
			$Form->end_fieldset();
		}
	}

	if( $disp_edit_categories )
	{	// Display categories
		cat_select( $Form, true, false );
	}

	// ################### TEXT RENDERERS ###################
	if( $Blog->get_setting( 'in_skin_editing_renderers' ) && $edited_Item->get_type_setting( 'use_text' ) != 'never' )
	{	// If text renderers are allowed to update from front-office and text content is allowed for the item type:
		$item_renderer_checkboxes = $edited_Item->get_renderer_checkboxes();
	}
	else
	{	// Don't allow to update the text renderers:
		$item_renderer_checkboxes = false;
	}
	if( !empty( $item_renderer_checkboxes ) )
	{
		$Form->begin_fieldset( T_('Text Renderers'), array( 'id' => 'itemform_renderers' ) );
		echo $item_renderer_checkboxes;
		$Form->end_fieldset();
	}
?>

<div class="clear"></div>

<?php
// ################### LOCATIONS ###################
echo_item_location_form( $Form, $edited_Item );

if( $edited_Item->get_type_setting( 'use_coordinates' ) != 'never' )
{
	$Form->hidden( 'item_latitude', $edited_Item->get_setting( 'latitude' ) );
	$Form->hidden( 'item_longitude', $edited_Item->get_setting( 'longitude' ) );
	$Form->hidden( 'google_map_zoom', $edited_Item->get_setting( 'map_zoom' ) );
	$Form->hidden( 'google_map_type', $edited_Item->get_setting( 'map_type' ) );
}

// ################### CUSTOM FIELDS ###################
$custom_fields = $edited_Item->get_type_custom_fields();
if( count( $custom_fields ) > 0 )
{
	$Form->begin_fieldset( T_('Additional fields') );

	$Form->switch_layout( 'table' );
	$Form->labelstart = '<td class="right"><strong>';
	$Form->labelend = '</strong></td>';

	echo $Form->formstart;

	// Display inputs to edit custom fields:
	display_editable_custom_fields( $Form, $edited_Item );

	echo $Form->formend;

	$Form->switch_layout( NULL );

	$Form->end_fieldset();
}

if( $edited_Item->get_type_setting( 'allow_attachments' ) && $edited_Item->ID > 0 )
{ // ####################### ATTACHMENTS FIELDSETS #########################
	if( $LinkOwner->count_links() )
	{
		$Form->begin_fieldset( T_('Attachments') );
		if( check_user_perm( 'files', 'view' ) && check_user_perm( 'admin', 'restricted' ) )
		{
			display_attachments( $LinkOwner );
		}
		else
		{
			$Form->info( '', T_('You do not have permission to edit file attachments for this post') );
		}
		$Form->end_fieldset();
	}
}

// ####################### PLUGIN FIELDSETS #########################
$Plugins->trigger_event( 'DisplayItemFormFieldset', array( 'Form' => & $Form, 'Item' => & $edited_Item) );
?>

<div class="clear"></div>

<div class="center margin2ex">
<?php // ------------------------------- ACTIONS ----------------------------------
	echo '<div class="edit_actions">';
	echo_publish_buttons( $Form, $creating, $edited_Item, true );
	echo '</div>';
?>
</div>
<?php
// ================================== END OF EDIT FORM ==================================
$Form->end_form();


// ####################### JS BEHAVIORS #########################
echo_publishnowbutton_js();
// New category input box:
echo_onchange_newcat();
echo_autocomplete_tags();
echo_fieldset_folding_js();

$edited_Item->load_Blog();
?>