/*
 * This file is part of the TYPO3 CMS project.
 *
 * It is free software; you can redistribute it and/or modify it under
 * the terms of the GNU General Public License, either version 2
 * of the License, or any later version.
 *
 * For the full copyright and license information, please read the
 * LICENSE.txt file that was distributed with this source code.
 *
 * The TYPO3 project - inspiring people to share!
 */
import{LitElement as N,html as u,nothing as E}from"lit";import{customElement as f,property as P,query as _}from"lit/decorators.js";import{until as k}from"lit/directives/until.js";import{lll as l}from"@typo3/core/lit-helper.js";import b from"@typo3/core/ajax/ajax-request.js";import M from"@typo3/backend/storage/persistent.js";import{ModuleUtility as O}from"@typo3/backend/module.js";import D from"@typo3/backend/context-menu.js";import{PageTree as I}from"@typo3/backend/tree/page-tree.js";import{TreeNodePositionEnum as c,TreeNodeCommandEnum as r}from"@typo3/backend/tree/tree-node.js";import{TreeToolbar as x}from"@typo3/backend/tree/tree-toolbar.js";import{TreeModuleState as $}from"@typo3/backend/tree/tree-module-state.js";import y from"@typo3/backend/modal.js";import w from"@typo3/backend/severity.js";import{ModuleStateStorage as C}from"@typo3/backend/storage/module-state-storage.js";import{DataTransferTypes as g}from"@typo3/backend/enum/data-transfer-types.js";var s=function(d,e,t,n){var o=arguments.length,i=o<3?e:n===null?n=Object.getOwnPropertyDescriptor(e,t):n,a;if(typeof Reflect=="object"&&typeof Reflect.decorate=="function")i=Reflect.decorate(d,e,t,n);else for(var m=d.length-1;m>=0;m--)(a=d[m])&&(i=(o<3?a(i):o>3?a(e,t,i):a(e,t))||i);return o>3&&i&&Object.defineProperty(e,t,i),i};const S="typo3-backend-navigation-component-pagetree";let h=class extends I{constructor(){super(...arguments),this.allowNodeEdit=!0,this.allowNodeDrag=!0,this.allowNodeSorting=!0}sendChangeCommand(e){let t="",n="0";if(e.target)if(n=e.target.identifier,e.position===c.BEFORE){const o=this.getPreviousNode(e.target);n=(o.depth===e.target.depth?"-":"")+o.identifier}else e.position===c.AFTER&&(n="-"+n);if(e.command===r.NEW){const o=e;t="&data[pages]["+e.node.identifier+"][pid]="+encodeURIComponent(n)+"&data[pages]["+e.node.identifier+"][title]="+encodeURIComponent(o.title)+"&data[pages]["+e.node.identifier+"][doktype]="+encodeURIComponent(o.doktype)}else if(e.command===r.EDIT)t="&data[pages]["+e.node.identifier+"][title]="+encodeURIComponent(e.title);else if(e.command===r.DELETE){const o=C.current("web");e.node.identifier===o.identifier&&this.selectFirstNode(),t="&cmd[pages]["+e.node.identifier+"][delete]=1"}else t="cmd[pages]["+e.node.identifier+"]["+e.command+"]="+n;this.requestTreeUpdate(t).then(o=>{if(o&&o.hasErrors)this.errorNotification(o.messages);else if(e.command===r.NEW){const i=this.getParentNode(e.node);i.loaded=!1,this.loadChildren(i)}else this.refreshOrFilterTree()})}initializeDragForNode(){throw new Error("unused")}async handleNodeEdit(e,t){if(e.__loading=!0,e.identifier.startsWith("NEW")){const n=this.getPreviousNode(e),o=e.depth===n.depth?c.AFTER:c.INSIDE,i={command:r.NEW,node:e,title:t,position:o,target:n,doktype:e.doktype};await this.sendChangeCommand(i)}else{const n={command:r.EDIT,node:e,title:t};await this.sendChangeCommand(n)}e.__loading=!1}createDataTransferItemsFromNode(e){return[{type:g.treenode,data:this.getNodeTreeIdentifier(e)},{type:g.pages,data:JSON.stringify({records:[{identifier:e.identifier,tablename:"pages"}]})}]}async handleNodeAdd(e,t,n){this.updateComplete.then(()=>{this.editNode(e)})}handleNodeDelete(e){const t={node:e,command:r.DELETE};this.settings.displayDeleteConfirmation?y.confirm(TYPO3.lang["mess.delete.title"],TYPO3.lang["mess.delete"].replace("%s",t.node.name),w.warning,[{text:TYPO3.lang["labels.cancel"]||"Cancel",active:!0,btnClass:"btn-default",name:"cancel"},{text:TYPO3.lang.delete||"Delete",btnClass:"btn-warning",name:"delete"}]).addEventListener("button.clicked",o=>{o.target.name==="delete"&&this.sendChangeCommand(t),y.dismiss()}):this.sendChangeCommand(t)}handleNodeMove(e,t,n){const o={node:e,target:t,position:n,command:r.MOVE};let i="";switch(n){case c.BEFORE:i=TYPO3.lang["mess.move_before"];break;case c.AFTER:i=TYPO3.lang["mess.move_after"];break;default:i=TYPO3.lang["mess.move_into"];break}i=i.replace("%s",e.name).replace("%s",t.name);const a=y.confirm(TYPO3.lang.move_page,i,w.warning,[{text:TYPO3.lang["labels.cancel"]||"Cancel",active:!0,btnClass:"btn-default",name:"cancel"},{text:TYPO3.lang["cm.copy"]||"Copy",btnClass:"btn-warning",name:"copy"},{text:TYPO3.lang["labels.move"]||"Move",btnClass:"btn-warning",name:"move"}]);a.addEventListener("button.clicked",m=>{const T=m.target;T.name==="move"?(o.command=r.MOVE,this.sendChangeCommand(o)):T.name==="copy"&&(o.command=r.COPY,this.sendChangeCommand(o)),a.hideModal()})}requestTreeUpdate(e){return new b(top.TYPO3.settings.ajaxUrls.record_process).post(e,{headers:{"Content-Type":"application/x-www-form-urlencoded","X-Requested-With":"XMLHttpRequest"}}).then(t=>t.resolve()).catch(t=>{this.errorNotification(t),this.loadData()})}};h=s([f("typo3-backend-navigation-component-pagetree-tree")],h);let p=class extends $(N){constructor(){super(...arguments),this.mountPointPath=null,this.moduleStateType="web",this.configuration=null,this.refresh=()=>{this.tree.refreshOrFilterTree()},this.setMountPoint=e=>{this.setTemporaryMountPoint(e.detail.pageId)},this.selectFirstNode=()=>{this.tree.selectFirstNode()},this.loadContent=e=>{const t=e.detail.node;if(!t?.checked||(C.updateWithTreeIdentifier("web",t.identifier,t.__treeIdentifier),e.detail.propagate===!1))return;const n=top.TYPO3.ModuleMenu.App;let o=O.getFromName(n.getCurrentModule()).link;o+=o.includes("?")?"&":"?",top.TYPO3.Backend.ContentContainer.setUrl(o+"id="+t.identifier)},this.showContextMenu=e=>{const t=e.detail.node;t&&D.show(t.recordType,t.identifier,"tree","","",this.tree.getElementFromNode(t),e.detail.originalEvent)}}connectedCallback(){super.connectedCallback(),document.addEventListener("typo3:pagetree:refresh",this.refresh),document.addEventListener("typo3:pagetree:mountPoint",this.setMountPoint),document.addEventListener("typo3:pagetree:selectFirstNode",this.selectFirstNode)}disconnectedCallback(){document.removeEventListener("typo3:pagetree:refresh",this.refresh),document.removeEventListener("typo3:pagetree:mountPoint",this.setMountPoint),document.removeEventListener("typo3:pagetree:selectFirstNode",this.selectFirstNode),super.disconnectedCallback()}createRenderRoot(){return this}render(){return u`<div id=typo3-pagetree class=tree>${k(this.renderTree(),"")}</div>`}getConfiguration(){if(this.configuration!==null)return Promise.resolve(this.configuration);const e=top.TYPO3.settings.ajaxUrls.page_tree_configuration;return new b(e).get().then(async t=>{const n=await t.resolve("json");return this.configuration=n,this.mountPointPath=n.temporaryMountPoint||null,n})}async renderTree(){const e=await this.getConfiguration();return u`<typo3-backend-navigation-component-pagetree-toolbar id=typo3-pagetree-toolbar .tree=${this.tree}></typo3-backend-navigation-component-pagetree-toolbar><div id=typo3-pagetree-treeContainer class=navigation-tree-container>${this.renderMountPoint()}<typo3-backend-navigation-component-pagetree-tree id=typo3-pagetree-tree class=tree-wrapper .setup=${e} @tree:initialized=${()=>{this.toolbar.tree=this.tree,this.fetchActiveNodeIfMissing()}} @typo3:tree:node-selected=${this.loadContent} @typo3:tree:node-context=${this.showContextMenu} @typo3:tree:nodes-prepared=${this.selectActiveNodeInLoadedNodes}></typo3-backend-navigation-component-pagetree-tree></div>`}unsetTemporaryMountPoint(){M.unset("pageTree_temporaryMountPoint").then(()=>{this.mountPointPath=null})}renderMountPoint(){return this.mountPointPath===null?E:u`<div class=node-mount-point><div class=node-mount-point__icon><typo3-backend-icon identifier=actions-info-circle size=small></typo3-backend-icon></div><div class=node-mount-point__text>${this.mountPointPath}</div><div class="node-mount-point__icon mountpoint-close" @click=${()=>this.unsetTemporaryMountPoint()} title=${l("labels.temporaryDBmount")}><typo3-backend-icon identifier=actions-close size=small></typo3-backend-icon></div></div>`}setTemporaryMountPoint(e){new b(this.configuration.setTemporaryMountPointUrl).post("pid="+e,{headers:{"Content-Type":"application/x-www-form-urlencoded","X-Requested-With":"XMLHttpRequest"}}).then(t=>t.resolve()).then(t=>{t&&t.hasErrors?(this.tree.errorNotification(t.message),this.tree.loadData()):this.mountPointPath=t.mountPointPath}).catch(t=>{this.tree.errorNotification(t),this.tree.loadData()})}};s([P({type:String})],p.prototype,"mountPointPath",void 0),s([_(".tree-wrapper")],p.prototype,"tree",void 0),s([_("typo3-backend-navigation-component-pagetree-toolbar")],p.prototype,"toolbar",void 0),p=s([f("typo3-backend-navigation-component-pagetree")],p);let v=class extends x{constructor(){super(...arguments),this.tree=null}render(){return u`<div class=tree-toolbar><div class=tree-toolbar__menu><div class=tree-toolbar__search><label for=toolbarSearch class=visually-hidden>${l("labels.label.searchString")}</label> <input type=search id=toolbarSearch class="form-control form-control-sm search-input" placeholder=${l("tree.searchTermInfo")}></div></div><div class=tree-toolbar__submenu>${this.tree?.settings?.doktypes?.length?this.tree.settings.doktypes.map(e=>u`<div class="tree-toolbar__menuitem tree-toolbar__drag-node" title=${e.title} draggable=true data-tree-icon=${e.icon} data-node-type=${e.nodeType} aria-hidden=true @dragstart=${t=>{this.handleDragStart(t,e)}}><typo3-backend-icon identifier=${e.icon} size=small></typo3-backend-icon></div>`):""} <button type=button class="tree-toolbar__menuitem dropdown-toggle dropdown-toggle-no-chevron float-end" data-bs-toggle=dropdown aria-expanded=false aria-label=${l("labels.openPageTreeOptionsMenu")}><typo3-backend-icon identifier=actions-menu-alternative size=small></typo3-backend-icon></button><ul class="dropdown-menu dropdown-menu-end"><li><button class=dropdown-item @click=${()=>this.refreshTree()}><span class=dropdown-item-columns> <span class="dropdown-item-column dropdown-item-column-icon" aria-hidden=true><typo3-backend-icon identifier=actions-refresh size=small></typo3-backend-icon> </span> <span class="dropdown-item-column dropdown-item-column-title">${l("labels.refresh")} </span> </span></button></li><li><button class=dropdown-item @click=${e=>this.collapseAll(e)}><span class=dropdown-item-columns> <span class="dropdown-item-column dropdown-item-column-icon" aria-hidden=true><typo3-backend-icon identifier=apps-pagetree-category-collapse-all size=small></typo3-backend-icon> </span> <span class="dropdown-item-column dropdown-item-column-title">${l("labels.collapse")} </span> </span></button></li></ul></div></div>`}handleDragStart(e,t){const n={__hidden:!1,__expanded:!1,__indeterminate:!1,__loading:!1,__processed:!1,__treeDragAction:"",__treeIdentifier:"",__treeParents:[""],__parents:[""],__x:0,__y:0,deletable:!1,depth:0,editable:!0,hasChildren:!1,icon:t.icon,overlayIcon:"",identifier:"NEW"+Math.floor(Math.random()*1e9).toString(16),loaded:!1,name:"",note:"",parentIdentifier:"",prefix:"",recordType:"pages",suffix:"",tooltip:"",type:"PageTreeItem",doktype:t.nodeType,statusInformation:[],labels:[]};this.tree.draggingNode=n,this.tree.nodeDragMode=r.NEW,e.dataTransfer.clearData();const o={statusIconIdentifier:this.tree.getNodeDragStatusIcon(),tooltipIconIdentifier:t.icon,tooltipLabel:t.title};e.dataTransfer.setData(g.dragTooltip,JSON.stringify(o)),e.dataTransfer.setData(g.newTreenode,JSON.stringify(n)),e.dataTransfer.effectAllowed="move"}};s([P({type:h})],v.prototype,"tree",void 0),v=s([f("typo3-backend-navigation-component-pagetree-toolbar")],v);export{h as EditablePageTree,p as PageTreeNavigationComponent,S as navigationComponentName};
