<?php

/**
 * Soosyze Framework https://soosyze.com
 *
 * @author  Mathieu NOËL <mathieu@soosyze.com>
 * @license https://github.com/soosyze/framework/blob/master/LICENSE (MIT License)
 */
return [
    '3gp'     => 'video/3gpp',
    '3g2'     => 'video/3gpp2',
    '7z'      => 'application/x-7z-compressed',
    'aac'     => 'audio/x-aac',
    'abw'     => 'application/x-abiword',
    'ai'      => 'application/postscript',
    'aif'     => 'audio/x-aiff',
    'air'     => 'application/vnd.adobe.air-application-installer-package+zip',
    'ait'     => 'application/vnd.dvb.ait',
    'arc'     => 'application/octet-stream',
    'asc'     => 'text/plain',
    'asf'     => 'video/x-ms-asf',
    'atom'    => 'application/atom+xml',
    'avi'     => 'video/x-msvideo',
    'azw'     => 'application/vnd.amazon.ebook',
    'bm'      => 'image/bmp',
    'bmp'     => [
        'image/bmp', 'image/x-windows-bmp'
    ],
    'bin'     => 'application/octet-stream',
    'bz'      => 'application/x-bzip',
    'bz2'     => 'application/x-bzip2',
    'cer'     => 'application/pkix-cert',
    'crl'     => 'application/pkix-crl',
    'crt'     => 'application/x-x509-ca-cert',
    'csh'     => 'application/x-csh',
    'css'     => 'text/css',
    'csv'     => 'text/csv',
    'cu'      => 'application/cu-seeme',
    'deb'     => 'application/x-debian-package',
    'doc'     => 'application/msword',
    'docm'    => 'application/vnd.ms-word.document.macroenabled.12',
    'docx'    => 'application/vnd.openxmlformats-officedocument.wordprocessingml.document',
    'dotm'    => 'application/vnd.ms-word.template.macroenabled.12',
    'dotx'    => 'application/vnd.openxmlformats-officedocument.wordprocessingml.template',
    'dvi'     => 'application/x-dvi',
    'eot'     => 'application/vnd.ms-fontobject',
    'eps'     => 'application/postscript',
    'epub'    => 'application/epub+zip',
    'etx'     => 'text/x-setext',
    'flac'    => 'audio/flac',
    'flv'     => 'video/x-flv',
    'gif'     => 'image/gif',
    'gz'      => [
        'application/gzip', 'application/x-gzip'
    ],
    'gzip'    => [
        'application/x-gzip', 'multipart/x-gzip'
    ],
    'htm'     => 'text/html',
    'html'    => 'text/html',
    'ico'     => 'image/x-icon',
    'ics'     => 'text/calendar',
    'ini'     => 'text/plain',
    'iso'     => 'application/x-iso9660-image',
    'jar'     => 'application/java-archive',
    'jpe'     => [
        'image/jpeg', 'image/pjpeg', 'image/x-citrix-jpeg'
    ],
    'jpeg'    => [
        'image/jpeg', 'image/pjpeg', 'image/x-citrix-jpeg'
    ],
    'jpg'     => [
        'image/jpeg', 'image/pjpeg', 'image/x-citrix-jpeg'
    ],
    'js'      => [
        'application/x-javascript', 'application/javascript',
        'application/ecmascript', 'text/javascript'
    ],
    'json'    => 'application/json',
    'latex'   => 'application/x-latex',
    'log'     => 'text/plain',
    'm4a'     => 'audio/mp4',
    'm4v'     => 'video/mp4',
    'mid'     => 'audio/midi',
    'midi'    => 'audio/midi',
    'mov'     => 'video/quicktime',
    'mka'     => 'audio/x-matroska',
    'mkv'     => 'video/x-matroska',
    'movie'   => 'video/x-sgi-movie',
    'mp3'     => [
        'audio/mpeg', 'audio/mpeg3', 'audio/mp3'
    ],
    'mp4'     => 'video/mp4',
    'mp4a'    => 'audio/mp4',
    'mp4v'    => 'video/mp4',
    'mpe'     => 'video/mpeg',
    'mpeg'    => 'video/mpeg',
    'mpg'     => 'video/mpeg',
    'mpg4'    => 'video/mp4',
    'mpkg'    => 'application/vnd.apple.installer+xml',
    'odb'     => 'application/vnd.oasis.opendocument.database',
    'odc'     => 'application/vnd.oasis.opendocument.chart',
    'odf'     => 'application/vnd.oasis.opendocument.formula',
    'odft'    => 'application/vnd.oasis.opendocument.formula-template',
    'odg'     => 'application/vnd.oasis.opendocument.graphics',
    'odi'     => 'application/vnd.oasis.opendocument.image',
    'odm'     => 'application/vnd.oasis.opendocument.text-master',
    'odp'     => 'application/vnd.oasis.opendocument.presentation',
    'ods'     => 'application/vnd.oasis.opendocument.spreadsheet',
    'odt'     => 'application/vnd.oasis.opendocument.text',
    'oga'     => 'audio/ogg',
    'ogg'     => 'audio/ogg',
    'ogv'     => 'video/ogg',
    'ogx'     => 'application/ogg',
    'otf'     => 'font/otf',
    'otg'     => 'application/vnd.oasis.opendocument.graphics-template',
    'oth'     => 'application/vnd.oasis.opendocument.text-web',
    'oti'     => 'application/vnd.oasis.opendocument.image-template',
    'otp'     => 'application/vnd.oasis.opendocument.presentation-template',
    'ots'     => 'application/vnd.oasis.opendocument.spreadsheet-template',
    'ott'     => 'application/vnd.oasis.opendocument.text-template',
    'oxt'     => 'application/vnd.openofficeorg.extension',
    'pbm'     => 'image/x-portable-bitmap',
    'pdf'     => 'application/pdf',
    'pgm'     => 'image/x-portable-graymap',
    'png'     => [
        'image/png', 'image/x-png', 'image/x-citrix-png'
    ],
    'pnm'     => 'image/x-portable-anymap',
    'ppm'     => 'image/x-portable-pixmap',
    'ppsm'    => 'application/vnd.ms-powerpoint.slideshow.macroenabled.12',
    'ppsx'    => 'application/vnd.openxmlformats-officedocument.presentationml.slideshow',
    'ppt'     => 'application/vnd.ms-powerpoint',
    'pptm'    => 'application/vnd.ms-powerpoint.presentation.macroenabled.12',
    'pptx'    => 'application/vnd.openxmlformats-officedocument.presentationml.presentation',
    'ps'      => 'application/postscript',
    'qt'      => 'video/quicktime',
    'rar'     => 'application/x-rar-compressed',
    'ras'     => 'image/x-cmu-raster',
    'rdf'     => 'application/rdf+xml',
    'rsd'     => 'application/rsd+xml',
    'rss'     => 'application/rss+xml',
    'rtf'     => 'application/rtf',
    'sgm'     => [
        'application/sgml', 'text/sgml'
    ],
    'sgml'    => [
        'application/sgml', 'text/sgml'
    ],
    'sh'      => 'application/x-sh',
    'svg'     => 'image/svg+xml',
    'swf'     => 'application/x-shockwave-flash',
    'tar'     => 'application/x-tar',
    'tif'     => [
        'image/tiff', 'image/x-tiff'
    ],
    'tiff'    => [
        'image/tiff', 'image/x-tiff'
    ],
    'torrent' => 'application/x-bittorrent',
    'ttf'     => 'application/x-font-ttf',
    'txt'     => 'text/plain',
    'vsd'     => 'application/vnd.visio',
    'wav'     => 'audio/x-wav',
    'weba'    => 'audio/webm',
    'webm'    => 'video/webm',
    'webp'    => 'image/webp',
    'wma'     => 'audio/x-ms-wma',
    'wmv'     => 'video/x-ms-wmv',
    'woff'    => 'application/x-font-woff',
    'woff2'   => 'font/woff2',
    'wsdl'    => 'application/wsdl+xml',
    'xhtml'   => 'application/xhtml+xml',
    'xbm'     => 'image/x-xbitmap',
    'xl'      => 'application/excel',
    'xla'     => [
        'application/excel', 'application/x-excel', 'application/x-msexcel'
    ],
    'xlb'     => [
        'application/excel', 'application/vnd.ms-excel', 'application/x-excel'
    ],
    'xlc'     => [
        'application/excel', 'application/vnd.ms-excel', 'application/x-excel'
    ],
    'xld'     => [
        'application/excel', 'application/x-excel'
    ],
    'xlk'     => [
        'application/excel', 'application/x-excel'
    ],
    'xll'     => [
        'application/excel', 'application/vnd.ms-excel', 'application/x-excel'
    ],
    'xlm'     => [
        'application/excel', 'application/vnd.ms-excel', 'application/x-excel'
    ],
    'xls'     => [
        'application/excel', 'application/vnd.ms-excel', 'application/x-excel', 'application/x-msexcel'
    ],
    'xlt'     => [
        'application/excel', 'application/x-excel'
    ],
    'xlv'     => [
        'application/excel', 'application/x-excel'
    ],
    'xlw'     => [
        'application/excel', 'application/vnd.ms-excel', 'application/x-excel', 'application/x-msexcel'
    ],
    'xlsx'    => 'application/vnd.openxmlformats-officedocument.spreadsheetml.sheet',
    'xul'     => 'application/vnd.mozilla.xul+xml',
    'xml'     => [
        'application/xml', 'text/xml'
    ],
    'xpm'     => 'image/x-xpixmap',
    'xwd'     => 'image/x-xwindowdump',
    'yaml'    => 'text/yaml',
    'yml'     => 'text/yaml',
    'zip'     => [
        'application/zip', 'application/x-compressed',
        'application/x-zip-compressed', 'multipart/x-zip'
    ]
];
