<?php

declare(strict_types=1);

/**
 * Soosyze Framework https://soosyze.com
 *
 * @license https://github.com/soosyze/framework/blob/master/LICENSE (MIT License)
 */

namespace Soosyze\Components\Validator\Rules;

/**
 * {@inheritdoc}
 *
 * @author Mathieu NOËL <mathieu@soosyze.com>
 */
class ImageDimensionsHeight extends ImageDimensions
{
    /**
     * {@inheritdoc}
     */
    protected function messages(): array
    {
        $output               = parent::messages();
        $output[ 'must' ]     = 'The height of the :label image must be between :minpx and :maxpx.';
        $output[ 'not_must' ] = 'The height of the :label image must not be between :minpx and :maxpx.';

        return $output;
    }
}
