<?php
/**
 * Copyright since 2007 PrestaShop SA and Contributors
 * PrestaShop is an International Registered Trademark & Property of PrestaShop SA
 *
 * NOTICE OF LICENSE
 *
 * This source file is subject to the Open Software License (OSL 3.0)
 * that is bundled with this package in the file LICENSE.md.
 * It is also available through the world-wide-web at this URL:
 * https://opensource.org/licenses/OSL-3.0
 * If you did not receive a copy of the license and are unable to
 * obtain it through the world-wide-web, please send an email
 * to license@prestashop.com so we can send you a copy immediately.
 *
 * DISCLAIMER
 *
 * Do not edit or add to this file if you wish to upgrade PrestaShop to newer
 * versions in the future. If you wish to customize PrestaShop for your
 * needs please refer to https://devdocs.prestashop.com/ for more information.
 *
 * @author    PrestaShop SA and Contributors <contact@prestashop.com>
 * @copyright Since 2007 PrestaShop SA and Contributors
 * @license   https://opensource.org/licenses/OSL-3.0 Open Software License (OSL 3.0)
 */

declare(strict_types=1);

namespace PrestaShop\PrestaShop\Core\Form\IdentifiableObject\DataProvider;

use PrestaShop\PrestaShop\Core\CommandBus\CommandBusInterface;
use PrestaShop\PrestaShop\Core\Context\ShopContext;
use PrestaShop\PrestaShop\Core\Domain\AttributeGroup\Attribute\Query\GetAttributeForEditing;
use PrestaShop\PrestaShop\Core\Domain\AttributeGroup\Attribute\QueryResult\EditableAttribute;
use Symfony\Component\Routing\Router;

class AttributeFormDataProvider implements FormDataProviderInterface
{
    public function __construct(
        private CommandBusInterface $queryBus,
        private readonly Router $router,
        private ShopContext $shopContext,
    ) {
    }

    public function getData($id)
    {
        /** @var EditableAttribute $editableAttribute */
        $editableAttribute = $this->queryBus->handle(new GetAttributeForEditing((int) $id));
        $thumbnailTexture = [];
        $textureImage = $editableAttribute->getTextureImage();
        if ($textureImage) {
            $thumbnailTexture[] = [
                'size' => $textureImage['size'],
                'image_path' => $textureImage['path'],
                'delete_path' => $this->router->generate(
                    'admin_attributes_delete_texture_image',
                    [
                        'attributeGroupId' => $editableAttribute->getAttributeGroupId(),
                        'attributeId' => $id,
                    ]
                ),
            ];
        }

        return [
            'attribute_group' => $editableAttribute->getAttributeGroupId(),
            'name' => $editableAttribute->getLocalizedNames(),
            'color' => $editableAttribute->getColor(),
            'shop_association' => $editableAttribute->getAssociatedShopIds(),
            'texture' => $thumbnailTexture,
        ];
    }

    public function getDefaultData()
    {
        return [
            'shop_association' => $this->shopContext->getAssociatedShopIds(),
        ];
    }
}
