/*
 * Svix API
 *
 * No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)
 *
 * API version: 1.1.1
 */

// Code generated by OpenAPI Generator (https://openapi-generator.tech); DO NOT EDIT.

package openapi

import (
	"bytes"
	_context "context"
	_ioutil "io/ioutil"
	_nethttp "net/http"
	_neturl "net/url"
	"strings"
	"time"
	"reflect"
)

// Linger please
var (
	_ _context.Context
)

// MessageAttemptApiService MessageAttemptApi service
type MessageAttemptApiService service

type ApiV1MessageAttemptExpungeContentRequest struct {
	ctx _context.Context
	ApiService *MessageAttemptApiService
	appId string
	msgId string
	attemptId string
}


func (r ApiV1MessageAttemptExpungeContentRequest) Execute() (*_nethttp.Response, error) {
	return r.ApiService.V1MessageAttemptExpungeContentExecute(r)
}

/*
 * V1MessageAttemptExpungeContent Delete attempt response body
 * Deletes the given attempt's response body. Useful when an endpoint accidentally returned sensitive content.
 * @param ctx _context.Context - for authentication, logging, cancellation, deadlines, tracing, etc. Passed from http.Request or context.Background().
 * @param appId The app's ID or UID
 * @param msgId The msg's ID or UID
 * @param attemptId The attempt's ID
 * @return ApiV1MessageAttemptExpungeContentRequest
 */
func (a *MessageAttemptApiService) V1MessageAttemptExpungeContent(ctx _context.Context, appId string, msgId string, attemptId string) ApiV1MessageAttemptExpungeContentRequest {
	return ApiV1MessageAttemptExpungeContentRequest{
		ApiService: a,
		ctx: ctx,
		appId: appId,
		msgId: msgId,
		attemptId: attemptId,
	}
}

/*
 * Execute executes the request
 */
func (a *MessageAttemptApiService) V1MessageAttemptExpungeContentExecute(r ApiV1MessageAttemptExpungeContentRequest) (*_nethttp.Response, error) {
	var (
		localVarHTTPMethod   = _nethttp.MethodDelete
		localVarPostBody     interface{}
		localVarFormFileName string
		localVarFileName     string
		localVarFileBytes    []byte
	)

	localBasePath, err := a.client.cfg.ServerURLWithContext(r.ctx, "MessageAttemptApiService.V1MessageAttemptExpungeContent")
	if err != nil {
		return nil, GenericOpenAPIError{error: err.Error()}
	}

	localVarPath := localBasePath + "/api/v1/app/{app_id}/msg/{msg_id}/attempt/{attempt_id}/content"
	localVarPath = strings.Replace(localVarPath, "{"+"app_id"+"}", _neturl.PathEscape(parameterToString(r.appId, "")), -1)
	localVarPath = strings.Replace(localVarPath, "{"+"msg_id"+"}", _neturl.PathEscape(parameterToString(r.msgId, "")), -1)
	localVarPath = strings.Replace(localVarPath, "{"+"attempt_id"+"}", _neturl.PathEscape(parameterToString(r.attemptId, "")), -1)

	localVarHeaderParams := make(map[string]string)
	localVarQueryParams := _neturl.Values{}
	localVarFormParams := _neturl.Values{}
	if strlen(r.appId) < 1 {
		return nil, reportError("appId must have at least 1 elements")
	}
	if strlen(r.appId) > 256 {
		return nil, reportError("appId must have less than 256 elements")
	}
	if strlen(r.msgId) < 1 {
		return nil, reportError("msgId must have at least 1 elements")
	}
	if strlen(r.msgId) > 256 {
		return nil, reportError("msgId must have less than 256 elements")
	}

	// to determine the Content-Type header
	localVarHTTPContentTypes := []string{}

	// set Content-Type header
	localVarHTTPContentType := selectHeaderContentType(localVarHTTPContentTypes)
	if localVarHTTPContentType != "" {
		localVarHeaderParams["Content-Type"] = localVarHTTPContentType
	}

	// to determine the Accept header
	localVarHTTPHeaderAccepts := []string{"application/json"}

	// set Accept header
	localVarHTTPHeaderAccept := selectHeaderAccept(localVarHTTPHeaderAccepts)
	if localVarHTTPHeaderAccept != "" {
		localVarHeaderParams["Accept"] = localVarHTTPHeaderAccept
	}
	req, err := a.client.prepareRequest(r.ctx, localVarPath, localVarHTTPMethod, localVarPostBody, localVarHeaderParams, localVarQueryParams, localVarFormParams, localVarFormFileName, localVarFileName, localVarFileBytes)
	if err != nil {
		return nil, err
	}

	localVarHTTPResponse, err := a.client.callAPI(req)
	if err != nil || localVarHTTPResponse == nil {
		return localVarHTTPResponse, err
	}

	localVarBody, err := _ioutil.ReadAll(localVarHTTPResponse.Body)
	localVarHTTPResponse.Body.Close()
	localVarHTTPResponse.Body = _ioutil.NopCloser(bytes.NewBuffer(localVarBody))
	if err != nil {
		return localVarHTTPResponse, err
	}

	if localVarHTTPResponse.StatusCode >= 300 {
		newErr := GenericOpenAPIError{
			body:  localVarBody,
			error: localVarHTTPResponse.Status,
		}
		if localVarHTTPResponse.StatusCode == 400 {
			var v HttpErrorOut
			err = a.client.decode(&v, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
			if err != nil {
				newErr.error = err.Error()
				return localVarHTTPResponse, newErr
			}
			newErr.model = v
			return localVarHTTPResponse, newErr
		}
		if localVarHTTPResponse.StatusCode == 401 {
			var v HttpErrorOut
			err = a.client.decode(&v, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
			if err != nil {
				newErr.error = err.Error()
				return localVarHTTPResponse, newErr
			}
			newErr.model = v
			return localVarHTTPResponse, newErr
		}
		if localVarHTTPResponse.StatusCode == 403 {
			var v HttpErrorOut
			err = a.client.decode(&v, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
			if err != nil {
				newErr.error = err.Error()
				return localVarHTTPResponse, newErr
			}
			newErr.model = v
			return localVarHTTPResponse, newErr
		}
		if localVarHTTPResponse.StatusCode == 404 {
			var v HttpErrorOut
			err = a.client.decode(&v, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
			if err != nil {
				newErr.error = err.Error()
				return localVarHTTPResponse, newErr
			}
			newErr.model = v
			return localVarHTTPResponse, newErr
		}
		if localVarHTTPResponse.StatusCode == 409 {
			var v HttpErrorOut
			err = a.client.decode(&v, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
			if err != nil {
				newErr.error = err.Error()
				return localVarHTTPResponse, newErr
			}
			newErr.model = v
			return localVarHTTPResponse, newErr
		}
		if localVarHTTPResponse.StatusCode == 422 {
			var v HTTPValidationError
			err = a.client.decode(&v, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
			if err != nil {
				newErr.error = err.Error()
				return localVarHTTPResponse, newErr
			}
			newErr.model = v
			return localVarHTTPResponse, newErr
		}
		if localVarHTTPResponse.StatusCode == 429 {
			var v HttpErrorOut
			err = a.client.decode(&v, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
			if err != nil {
				newErr.error = err.Error()
				return localVarHTTPResponse, newErr
			}
			newErr.model = v
		}
		return localVarHTTPResponse, newErr
	}

	return localVarHTTPResponse, nil
}

type ApiV1MessageAttemptGetRequest struct {
	ctx _context.Context
	ApiService *MessageAttemptApiService
	appId string
	msgId string
	attemptId string
}


func (r ApiV1MessageAttemptGetRequest) Execute() (MessageAttemptOut, *_nethttp.Response, error) {
	return r.ApiService.V1MessageAttemptGetExecute(r)
}

/*
 * V1MessageAttemptGet Get Attempt
 * `msg_id`: Use a message id or a message `eventId`
 * @param ctx _context.Context - for authentication, logging, cancellation, deadlines, tracing, etc. Passed from http.Request or context.Background().
 * @param appId The app's ID or UID
 * @param msgId The msg's ID or UID
 * @param attemptId The attempt's ID
 * @return ApiV1MessageAttemptGetRequest
 */
func (a *MessageAttemptApiService) V1MessageAttemptGet(ctx _context.Context, appId string, msgId string, attemptId string) ApiV1MessageAttemptGetRequest {
	return ApiV1MessageAttemptGetRequest{
		ApiService: a,
		ctx: ctx,
		appId: appId,
		msgId: msgId,
		attemptId: attemptId,
	}
}

/*
 * Execute executes the request
 * @return MessageAttemptOut
 */
func (a *MessageAttemptApiService) V1MessageAttemptGetExecute(r ApiV1MessageAttemptGetRequest) (MessageAttemptOut, *_nethttp.Response, error) {
	var (
		localVarHTTPMethod   = _nethttp.MethodGet
		localVarPostBody     interface{}
		localVarFormFileName string
		localVarFileName     string
		localVarFileBytes    []byte
		localVarReturnValue  MessageAttemptOut
	)

	localBasePath, err := a.client.cfg.ServerURLWithContext(r.ctx, "MessageAttemptApiService.V1MessageAttemptGet")
	if err != nil {
		return localVarReturnValue, nil, GenericOpenAPIError{error: err.Error()}
	}

	localVarPath := localBasePath + "/api/v1/app/{app_id}/msg/{msg_id}/attempt/{attempt_id}"
	localVarPath = strings.Replace(localVarPath, "{"+"app_id"+"}", _neturl.PathEscape(parameterToString(r.appId, "")), -1)
	localVarPath = strings.Replace(localVarPath, "{"+"msg_id"+"}", _neturl.PathEscape(parameterToString(r.msgId, "")), -1)
	localVarPath = strings.Replace(localVarPath, "{"+"attempt_id"+"}", _neturl.PathEscape(parameterToString(r.attemptId, "")), -1)

	localVarHeaderParams := make(map[string]string)
	localVarQueryParams := _neturl.Values{}
	localVarFormParams := _neturl.Values{}
	if strlen(r.appId) < 1 {
		return localVarReturnValue, nil, reportError("appId must have at least 1 elements")
	}
	if strlen(r.appId) > 256 {
		return localVarReturnValue, nil, reportError("appId must have less than 256 elements")
	}
	if strlen(r.msgId) < 1 {
		return localVarReturnValue, nil, reportError("msgId must have at least 1 elements")
	}
	if strlen(r.msgId) > 256 {
		return localVarReturnValue, nil, reportError("msgId must have less than 256 elements")
	}

	// to determine the Content-Type header
	localVarHTTPContentTypes := []string{}

	// set Content-Type header
	localVarHTTPContentType := selectHeaderContentType(localVarHTTPContentTypes)
	if localVarHTTPContentType != "" {
		localVarHeaderParams["Content-Type"] = localVarHTTPContentType
	}

	// to determine the Accept header
	localVarHTTPHeaderAccepts := []string{"application/json"}

	// set Accept header
	localVarHTTPHeaderAccept := selectHeaderAccept(localVarHTTPHeaderAccepts)
	if localVarHTTPHeaderAccept != "" {
		localVarHeaderParams["Accept"] = localVarHTTPHeaderAccept
	}
	req, err := a.client.prepareRequest(r.ctx, localVarPath, localVarHTTPMethod, localVarPostBody, localVarHeaderParams, localVarQueryParams, localVarFormParams, localVarFormFileName, localVarFileName, localVarFileBytes)
	if err != nil {
		return localVarReturnValue, nil, err
	}

	localVarHTTPResponse, err := a.client.callAPI(req)
	if err != nil || localVarHTTPResponse == nil {
		return localVarReturnValue, localVarHTTPResponse, err
	}

	localVarBody, err := _ioutil.ReadAll(localVarHTTPResponse.Body)
	localVarHTTPResponse.Body.Close()
	localVarHTTPResponse.Body = _ioutil.NopCloser(bytes.NewBuffer(localVarBody))
	if err != nil {
		return localVarReturnValue, localVarHTTPResponse, err
	}

	if localVarHTTPResponse.StatusCode >= 300 {
		newErr := GenericOpenAPIError{
			body:  localVarBody,
			error: localVarHTTPResponse.Status,
		}
		if localVarHTTPResponse.StatusCode == 400 {
			var v HttpErrorOut
			err = a.client.decode(&v, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
			if err != nil {
				newErr.error = err.Error()
				return localVarReturnValue, localVarHTTPResponse, newErr
			}
			newErr.model = v
			return localVarReturnValue, localVarHTTPResponse, newErr
		}
		if localVarHTTPResponse.StatusCode == 401 {
			var v HttpErrorOut
			err = a.client.decode(&v, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
			if err != nil {
				newErr.error = err.Error()
				return localVarReturnValue, localVarHTTPResponse, newErr
			}
			newErr.model = v
			return localVarReturnValue, localVarHTTPResponse, newErr
		}
		if localVarHTTPResponse.StatusCode == 403 {
			var v HttpErrorOut
			err = a.client.decode(&v, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
			if err != nil {
				newErr.error = err.Error()
				return localVarReturnValue, localVarHTTPResponse, newErr
			}
			newErr.model = v
			return localVarReturnValue, localVarHTTPResponse, newErr
		}
		if localVarHTTPResponse.StatusCode == 404 {
			var v HttpErrorOut
			err = a.client.decode(&v, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
			if err != nil {
				newErr.error = err.Error()
				return localVarReturnValue, localVarHTTPResponse, newErr
			}
			newErr.model = v
			return localVarReturnValue, localVarHTTPResponse, newErr
		}
		if localVarHTTPResponse.StatusCode == 409 {
			var v HttpErrorOut
			err = a.client.decode(&v, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
			if err != nil {
				newErr.error = err.Error()
				return localVarReturnValue, localVarHTTPResponse, newErr
			}
			newErr.model = v
			return localVarReturnValue, localVarHTTPResponse, newErr
		}
		if localVarHTTPResponse.StatusCode == 422 {
			var v HTTPValidationError
			err = a.client.decode(&v, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
			if err != nil {
				newErr.error = err.Error()
				return localVarReturnValue, localVarHTTPResponse, newErr
			}
			newErr.model = v
			return localVarReturnValue, localVarHTTPResponse, newErr
		}
		if localVarHTTPResponse.StatusCode == 429 {
			var v HttpErrorOut
			err = a.client.decode(&v, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
			if err != nil {
				newErr.error = err.Error()
				return localVarReturnValue, localVarHTTPResponse, newErr
			}
			newErr.model = v
		}
		return localVarReturnValue, localVarHTTPResponse, newErr
	}

	err = a.client.decode(&localVarReturnValue, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
	if err != nil {
		newErr := GenericOpenAPIError{
			body:  localVarBody,
			error: err.Error(),
		}
		return localVarReturnValue, localVarHTTPResponse, newErr
	}

	return localVarReturnValue, localVarHTTPResponse, nil
}

type ApiV1MessageAttemptGetHeadersRequest struct {
	ctx _context.Context
	ApiService *MessageAttemptApiService
	appId string
	msgId string
	attemptId string
}


func (r ApiV1MessageAttemptGetHeadersRequest) Execute() (MessageAttemptHeadersOut, *_nethttp.Response, error) {
	return r.ApiService.V1MessageAttemptGetHeadersExecute(r)
}

/*
 * V1MessageAttemptGetHeaders Get Attempt Headers
 * Calculate and return headers used on a given message attempt
 * @param ctx _context.Context - for authentication, logging, cancellation, deadlines, tracing, etc. Passed from http.Request or context.Background().
 * @param appId The app's ID or UID
 * @param msgId The msg's ID or UID
 * @param attemptId The attempt's ID
 * @return ApiV1MessageAttemptGetHeadersRequest
 */
func (a *MessageAttemptApiService) V1MessageAttemptGetHeaders(ctx _context.Context, appId string, msgId string, attemptId string) ApiV1MessageAttemptGetHeadersRequest {
	return ApiV1MessageAttemptGetHeadersRequest{
		ApiService: a,
		ctx: ctx,
		appId: appId,
		msgId: msgId,
		attemptId: attemptId,
	}
}

/*
 * Execute executes the request
 * @return MessageAttemptHeadersOut
 */
func (a *MessageAttemptApiService) V1MessageAttemptGetHeadersExecute(r ApiV1MessageAttemptGetHeadersRequest) (MessageAttemptHeadersOut, *_nethttp.Response, error) {
	var (
		localVarHTTPMethod   = _nethttp.MethodGet
		localVarPostBody     interface{}
		localVarFormFileName string
		localVarFileName     string
		localVarFileBytes    []byte
		localVarReturnValue  MessageAttemptHeadersOut
	)

	localBasePath, err := a.client.cfg.ServerURLWithContext(r.ctx, "MessageAttemptApiService.V1MessageAttemptGetHeaders")
	if err != nil {
		return localVarReturnValue, nil, GenericOpenAPIError{error: err.Error()}
	}

	localVarPath := localBasePath + "/api/v1/app/{app_id}/msg/{msg_id}/attempt/{attempt_id}/headers"
	localVarPath = strings.Replace(localVarPath, "{"+"app_id"+"}", _neturl.PathEscape(parameterToString(r.appId, "")), -1)
	localVarPath = strings.Replace(localVarPath, "{"+"msg_id"+"}", _neturl.PathEscape(parameterToString(r.msgId, "")), -1)
	localVarPath = strings.Replace(localVarPath, "{"+"attempt_id"+"}", _neturl.PathEscape(parameterToString(r.attemptId, "")), -1)

	localVarHeaderParams := make(map[string]string)
	localVarQueryParams := _neturl.Values{}
	localVarFormParams := _neturl.Values{}
	if strlen(r.appId) < 1 {
		return localVarReturnValue, nil, reportError("appId must have at least 1 elements")
	}
	if strlen(r.appId) > 256 {
		return localVarReturnValue, nil, reportError("appId must have less than 256 elements")
	}
	if strlen(r.msgId) < 1 {
		return localVarReturnValue, nil, reportError("msgId must have at least 1 elements")
	}
	if strlen(r.msgId) > 256 {
		return localVarReturnValue, nil, reportError("msgId must have less than 256 elements")
	}

	// to determine the Content-Type header
	localVarHTTPContentTypes := []string{}

	// set Content-Type header
	localVarHTTPContentType := selectHeaderContentType(localVarHTTPContentTypes)
	if localVarHTTPContentType != "" {
		localVarHeaderParams["Content-Type"] = localVarHTTPContentType
	}

	// to determine the Accept header
	localVarHTTPHeaderAccepts := []string{"application/json"}

	// set Accept header
	localVarHTTPHeaderAccept := selectHeaderAccept(localVarHTTPHeaderAccepts)
	if localVarHTTPHeaderAccept != "" {
		localVarHeaderParams["Accept"] = localVarHTTPHeaderAccept
	}
	req, err := a.client.prepareRequest(r.ctx, localVarPath, localVarHTTPMethod, localVarPostBody, localVarHeaderParams, localVarQueryParams, localVarFormParams, localVarFormFileName, localVarFileName, localVarFileBytes)
	if err != nil {
		return localVarReturnValue, nil, err
	}

	localVarHTTPResponse, err := a.client.callAPI(req)
	if err != nil || localVarHTTPResponse == nil {
		return localVarReturnValue, localVarHTTPResponse, err
	}

	localVarBody, err := _ioutil.ReadAll(localVarHTTPResponse.Body)
	localVarHTTPResponse.Body.Close()
	localVarHTTPResponse.Body = _ioutil.NopCloser(bytes.NewBuffer(localVarBody))
	if err != nil {
		return localVarReturnValue, localVarHTTPResponse, err
	}

	if localVarHTTPResponse.StatusCode >= 300 {
		newErr := GenericOpenAPIError{
			body:  localVarBody,
			error: localVarHTTPResponse.Status,
		}
		if localVarHTTPResponse.StatusCode == 400 {
			var v HttpErrorOut
			err = a.client.decode(&v, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
			if err != nil {
				newErr.error = err.Error()
				return localVarReturnValue, localVarHTTPResponse, newErr
			}
			newErr.model = v
			return localVarReturnValue, localVarHTTPResponse, newErr
		}
		if localVarHTTPResponse.StatusCode == 401 {
			var v HttpErrorOut
			err = a.client.decode(&v, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
			if err != nil {
				newErr.error = err.Error()
				return localVarReturnValue, localVarHTTPResponse, newErr
			}
			newErr.model = v
			return localVarReturnValue, localVarHTTPResponse, newErr
		}
		if localVarHTTPResponse.StatusCode == 403 {
			var v HttpErrorOut
			err = a.client.decode(&v, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
			if err != nil {
				newErr.error = err.Error()
				return localVarReturnValue, localVarHTTPResponse, newErr
			}
			newErr.model = v
			return localVarReturnValue, localVarHTTPResponse, newErr
		}
		if localVarHTTPResponse.StatusCode == 404 {
			var v HttpErrorOut
			err = a.client.decode(&v, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
			if err != nil {
				newErr.error = err.Error()
				return localVarReturnValue, localVarHTTPResponse, newErr
			}
			newErr.model = v
			return localVarReturnValue, localVarHTTPResponse, newErr
		}
		if localVarHTTPResponse.StatusCode == 409 {
			var v HttpErrorOut
			err = a.client.decode(&v, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
			if err != nil {
				newErr.error = err.Error()
				return localVarReturnValue, localVarHTTPResponse, newErr
			}
			newErr.model = v
			return localVarReturnValue, localVarHTTPResponse, newErr
		}
		if localVarHTTPResponse.StatusCode == 422 {
			var v HTTPValidationError
			err = a.client.decode(&v, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
			if err != nil {
				newErr.error = err.Error()
				return localVarReturnValue, localVarHTTPResponse, newErr
			}
			newErr.model = v
			return localVarReturnValue, localVarHTTPResponse, newErr
		}
		if localVarHTTPResponse.StatusCode == 429 {
			var v HttpErrorOut
			err = a.client.decode(&v, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
			if err != nil {
				newErr.error = err.Error()
				return localVarReturnValue, localVarHTTPResponse, newErr
			}
			newErr.model = v
		}
		return localVarReturnValue, localVarHTTPResponse, newErr
	}

	err = a.client.decode(&localVarReturnValue, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
	if err != nil {
		newErr := GenericOpenAPIError{
			body:  localVarBody,
			error: err.Error(),
		}
		return localVarReturnValue, localVarHTTPResponse, newErr
	}

	return localVarReturnValue, localVarHTTPResponse, nil
}

type ApiV1MessageAttemptListAttemptedDestinationsRequest struct {
	ctx _context.Context
	ApiService *MessageAttemptApiService
	appId string
	msgId string
	limit *int32
	iterator *string
}

func (r ApiV1MessageAttemptListAttemptedDestinationsRequest) Limit(limit int32) ApiV1MessageAttemptListAttemptedDestinationsRequest {
	r.limit = &limit
	return r
}
func (r ApiV1MessageAttemptListAttemptedDestinationsRequest) Iterator(iterator string) ApiV1MessageAttemptListAttemptedDestinationsRequest {
	r.iterator = &iterator
	return r
}

func (r ApiV1MessageAttemptListAttemptedDestinationsRequest) Execute() (ListResponseMessageEndpointOut, *_nethttp.Response, error) {
	return r.ApiService.V1MessageAttemptListAttemptedDestinationsExecute(r)
}

/*
 * V1MessageAttemptListAttemptedDestinations List Attempted Destinations
 * List endpoints attempted by a given message. Additionally includes metadata about the latest message attempt.
By default, endpoints are listed in ascending order by ID.
 * @param ctx _context.Context - for authentication, logging, cancellation, deadlines, tracing, etc. Passed from http.Request or context.Background().
 * @param appId The app's ID or UID
 * @param msgId The msg's ID or UID
 * @return ApiV1MessageAttemptListAttemptedDestinationsRequest
 */
func (a *MessageAttemptApiService) V1MessageAttemptListAttemptedDestinations(ctx _context.Context, appId string, msgId string) ApiV1MessageAttemptListAttemptedDestinationsRequest {
	return ApiV1MessageAttemptListAttemptedDestinationsRequest{
		ApiService: a,
		ctx: ctx,
		appId: appId,
		msgId: msgId,
	}
}

/*
 * Execute executes the request
 * @return ListResponseMessageEndpointOut
 */
func (a *MessageAttemptApiService) V1MessageAttemptListAttemptedDestinationsExecute(r ApiV1MessageAttemptListAttemptedDestinationsRequest) (ListResponseMessageEndpointOut, *_nethttp.Response, error) {
	var (
		localVarHTTPMethod   = _nethttp.MethodGet
		localVarPostBody     interface{}
		localVarFormFileName string
		localVarFileName     string
		localVarFileBytes    []byte
		localVarReturnValue  ListResponseMessageEndpointOut
	)

	localBasePath, err := a.client.cfg.ServerURLWithContext(r.ctx, "MessageAttemptApiService.V1MessageAttemptListAttemptedDestinations")
	if err != nil {
		return localVarReturnValue, nil, GenericOpenAPIError{error: err.Error()}
	}

	localVarPath := localBasePath + "/api/v1/app/{app_id}/msg/{msg_id}/endpoint"
	localVarPath = strings.Replace(localVarPath, "{"+"app_id"+"}", _neturl.PathEscape(parameterToString(r.appId, "")), -1)
	localVarPath = strings.Replace(localVarPath, "{"+"msg_id"+"}", _neturl.PathEscape(parameterToString(r.msgId, "")), -1)

	localVarHeaderParams := make(map[string]string)
	localVarQueryParams := _neturl.Values{}
	localVarFormParams := _neturl.Values{}
	if strlen(r.appId) < 1 {
		return localVarReturnValue, nil, reportError("appId must have at least 1 elements")
	}
	if strlen(r.appId) > 256 {
		return localVarReturnValue, nil, reportError("appId must have less than 256 elements")
	}
	if strlen(r.msgId) < 1 {
		return localVarReturnValue, nil, reportError("msgId must have at least 1 elements")
	}
	if strlen(r.msgId) > 256 {
		return localVarReturnValue, nil, reportError("msgId must have less than 256 elements")
	}

	if r.limit != nil {
		localVarQueryParams.Add("limit", parameterToString(*r.limit, ""))
	}
	if r.iterator != nil {
		localVarQueryParams.Add("iterator", parameterToString(*r.iterator, ""))
	}
	// to determine the Content-Type header
	localVarHTTPContentTypes := []string{}

	// set Content-Type header
	localVarHTTPContentType := selectHeaderContentType(localVarHTTPContentTypes)
	if localVarHTTPContentType != "" {
		localVarHeaderParams["Content-Type"] = localVarHTTPContentType
	}

	// to determine the Accept header
	localVarHTTPHeaderAccepts := []string{"application/json"}

	// set Accept header
	localVarHTTPHeaderAccept := selectHeaderAccept(localVarHTTPHeaderAccepts)
	if localVarHTTPHeaderAccept != "" {
		localVarHeaderParams["Accept"] = localVarHTTPHeaderAccept
	}
	req, err := a.client.prepareRequest(r.ctx, localVarPath, localVarHTTPMethod, localVarPostBody, localVarHeaderParams, localVarQueryParams, localVarFormParams, localVarFormFileName, localVarFileName, localVarFileBytes)
	if err != nil {
		return localVarReturnValue, nil, err
	}

	localVarHTTPResponse, err := a.client.callAPI(req)
	if err != nil || localVarHTTPResponse == nil {
		return localVarReturnValue, localVarHTTPResponse, err
	}

	localVarBody, err := _ioutil.ReadAll(localVarHTTPResponse.Body)
	localVarHTTPResponse.Body.Close()
	localVarHTTPResponse.Body = _ioutil.NopCloser(bytes.NewBuffer(localVarBody))
	if err != nil {
		return localVarReturnValue, localVarHTTPResponse, err
	}

	if localVarHTTPResponse.StatusCode >= 300 {
		newErr := GenericOpenAPIError{
			body:  localVarBody,
			error: localVarHTTPResponse.Status,
		}
		if localVarHTTPResponse.StatusCode == 400 {
			var v HttpErrorOut
			err = a.client.decode(&v, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
			if err != nil {
				newErr.error = err.Error()
				return localVarReturnValue, localVarHTTPResponse, newErr
			}
			newErr.model = v
			return localVarReturnValue, localVarHTTPResponse, newErr
		}
		if localVarHTTPResponse.StatusCode == 401 {
			var v HttpErrorOut
			err = a.client.decode(&v, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
			if err != nil {
				newErr.error = err.Error()
				return localVarReturnValue, localVarHTTPResponse, newErr
			}
			newErr.model = v
			return localVarReturnValue, localVarHTTPResponse, newErr
		}
		if localVarHTTPResponse.StatusCode == 403 {
			var v HttpErrorOut
			err = a.client.decode(&v, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
			if err != nil {
				newErr.error = err.Error()
				return localVarReturnValue, localVarHTTPResponse, newErr
			}
			newErr.model = v
			return localVarReturnValue, localVarHTTPResponse, newErr
		}
		if localVarHTTPResponse.StatusCode == 404 {
			var v HttpErrorOut
			err = a.client.decode(&v, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
			if err != nil {
				newErr.error = err.Error()
				return localVarReturnValue, localVarHTTPResponse, newErr
			}
			newErr.model = v
			return localVarReturnValue, localVarHTTPResponse, newErr
		}
		if localVarHTTPResponse.StatusCode == 409 {
			var v HttpErrorOut
			err = a.client.decode(&v, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
			if err != nil {
				newErr.error = err.Error()
				return localVarReturnValue, localVarHTTPResponse, newErr
			}
			newErr.model = v
			return localVarReturnValue, localVarHTTPResponse, newErr
		}
		if localVarHTTPResponse.StatusCode == 422 {
			var v HTTPValidationError
			err = a.client.decode(&v, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
			if err != nil {
				newErr.error = err.Error()
				return localVarReturnValue, localVarHTTPResponse, newErr
			}
			newErr.model = v
			return localVarReturnValue, localVarHTTPResponse, newErr
		}
		if localVarHTTPResponse.StatusCode == 429 {
			var v HttpErrorOut
			err = a.client.decode(&v, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
			if err != nil {
				newErr.error = err.Error()
				return localVarReturnValue, localVarHTTPResponse, newErr
			}
			newErr.model = v
		}
		return localVarReturnValue, localVarHTTPResponse, newErr
	}

	err = a.client.decode(&localVarReturnValue, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
	if err != nil {
		newErr := GenericOpenAPIError{
			body:  localVarBody,
			error: err.Error(),
		}
		return localVarReturnValue, localVarHTTPResponse, newErr
	}

	return localVarReturnValue, localVarHTTPResponse, nil
}

type ApiV1MessageAttemptListAttemptedMessagesRequest struct {
	ctx _context.Context
	ApiService *MessageAttemptApiService
	appId string
	endpointId string
	limit *int32
	iterator *string
	channel *string
	tag *string
	status *MessageStatus
	before *time.Time
	after *time.Time
	withContent *bool
	eventTypes *[]string
}

func (r ApiV1MessageAttemptListAttemptedMessagesRequest) Limit(limit int32) ApiV1MessageAttemptListAttemptedMessagesRequest {
	r.limit = &limit
	return r
}
func (r ApiV1MessageAttemptListAttemptedMessagesRequest) Iterator(iterator string) ApiV1MessageAttemptListAttemptedMessagesRequest {
	r.iterator = &iterator
	return r
}
func (r ApiV1MessageAttemptListAttemptedMessagesRequest) Channel(channel string) ApiV1MessageAttemptListAttemptedMessagesRequest {
	r.channel = &channel
	return r
}
func (r ApiV1MessageAttemptListAttemptedMessagesRequest) Tag(tag string) ApiV1MessageAttemptListAttemptedMessagesRequest {
	r.tag = &tag
	return r
}
func (r ApiV1MessageAttemptListAttemptedMessagesRequest) Status(status MessageStatus) ApiV1MessageAttemptListAttemptedMessagesRequest {
	r.status = &status
	return r
}
func (r ApiV1MessageAttemptListAttemptedMessagesRequest) Before(before time.Time) ApiV1MessageAttemptListAttemptedMessagesRequest {
	r.before = &before
	return r
}
func (r ApiV1MessageAttemptListAttemptedMessagesRequest) After(after time.Time) ApiV1MessageAttemptListAttemptedMessagesRequest {
	r.after = &after
	return r
}
func (r ApiV1MessageAttemptListAttemptedMessagesRequest) WithContent(withContent bool) ApiV1MessageAttemptListAttemptedMessagesRequest {
	r.withContent = &withContent
	return r
}
func (r ApiV1MessageAttemptListAttemptedMessagesRequest) EventTypes(eventTypes []string) ApiV1MessageAttemptListAttemptedMessagesRequest {
	r.eventTypes = &eventTypes
	return r
}

func (r ApiV1MessageAttemptListAttemptedMessagesRequest) Execute() (ListResponseEndpointMessageOut, *_nethttp.Response, error) {
	return r.ApiService.V1MessageAttemptListAttemptedMessagesExecute(r)
}

/*
 * V1MessageAttemptListAttemptedMessages List Attempted Messages
 * List messages for a particular endpoint. Additionally includes metadata about the latest message attempt.

The `before` parameter lets you filter all items created before a certain date and is ignored if an iterator is passed.

Note that by default this endpoint is limited to retrieving 90 days' worth of data
relative to now or, if an iterator is provided, 90 days before/after the time indicated
by the iterator ID. If you require data beyond those time ranges, you will need to explicitly
set the `before` or `after` parameter as appropriate.

 * @param ctx _context.Context - for authentication, logging, cancellation, deadlines, tracing, etc. Passed from http.Request or context.Background().
 * @param appId The app's ID or UID
 * @param endpointId The ep's ID or UID
 * @return ApiV1MessageAttemptListAttemptedMessagesRequest
 */
func (a *MessageAttemptApiService) V1MessageAttemptListAttemptedMessages(ctx _context.Context, appId string, endpointId string) ApiV1MessageAttemptListAttemptedMessagesRequest {
	return ApiV1MessageAttemptListAttemptedMessagesRequest{
		ApiService: a,
		ctx: ctx,
		appId: appId,
		endpointId: endpointId,
	}
}

/*
 * Execute executes the request
 * @return ListResponseEndpointMessageOut
 */
func (a *MessageAttemptApiService) V1MessageAttemptListAttemptedMessagesExecute(r ApiV1MessageAttemptListAttemptedMessagesRequest) (ListResponseEndpointMessageOut, *_nethttp.Response, error) {
	var (
		localVarHTTPMethod   = _nethttp.MethodGet
		localVarPostBody     interface{}
		localVarFormFileName string
		localVarFileName     string
		localVarFileBytes    []byte
		localVarReturnValue  ListResponseEndpointMessageOut
	)

	localBasePath, err := a.client.cfg.ServerURLWithContext(r.ctx, "MessageAttemptApiService.V1MessageAttemptListAttemptedMessages")
	if err != nil {
		return localVarReturnValue, nil, GenericOpenAPIError{error: err.Error()}
	}

	localVarPath := localBasePath + "/api/v1/app/{app_id}/endpoint/{endpoint_id}/msg"
	localVarPath = strings.Replace(localVarPath, "{"+"app_id"+"}", _neturl.PathEscape(parameterToString(r.appId, "")), -1)
	localVarPath = strings.Replace(localVarPath, "{"+"endpoint_id"+"}", _neturl.PathEscape(parameterToString(r.endpointId, "")), -1)

	localVarHeaderParams := make(map[string]string)
	localVarQueryParams := _neturl.Values{}
	localVarFormParams := _neturl.Values{}
	if strlen(r.appId) < 1 {
		return localVarReturnValue, nil, reportError("appId must have at least 1 elements")
	}
	if strlen(r.appId) > 256 {
		return localVarReturnValue, nil, reportError("appId must have less than 256 elements")
	}
	if strlen(r.endpointId) < 1 {
		return localVarReturnValue, nil, reportError("endpointId must have at least 1 elements")
	}
	if strlen(r.endpointId) > 256 {
		return localVarReturnValue, nil, reportError("endpointId must have less than 256 elements")
	}

	if r.limit != nil {
		localVarQueryParams.Add("limit", parameterToString(*r.limit, ""))
	}
	if r.iterator != nil {
		localVarQueryParams.Add("iterator", parameterToString(*r.iterator, ""))
	}
	if r.channel != nil {
		localVarQueryParams.Add("channel", parameterToString(*r.channel, ""))
	}
	if r.tag != nil {
		localVarQueryParams.Add("tag", parameterToString(*r.tag, ""))
	}
	if r.status != nil {
		localVarQueryParams.Add("status", parameterToString(*r.status, ""))
	}
	if r.before != nil {
		localVarQueryParams.Add("before", parameterToString(*r.before, ""))
	}
	if r.after != nil {
		localVarQueryParams.Add("after", parameterToString(*r.after, ""))
	}
	if r.withContent != nil {
		localVarQueryParams.Add("with_content", parameterToString(*r.withContent, ""))
	}
	if r.eventTypes != nil {
		t := *r.eventTypes
		if reflect.TypeOf(t).Kind() == reflect.Slice {
			s := reflect.ValueOf(t)
			for i := 0; i < s.Len(); i++ {
				localVarQueryParams.Add("event_types", parameterToString(s.Index(i), "multi"))
			}
		} else {
			localVarQueryParams.Add("event_types", parameterToString(t, "multi"))
		}
	}
	// to determine the Content-Type header
	localVarHTTPContentTypes := []string{}

	// set Content-Type header
	localVarHTTPContentType := selectHeaderContentType(localVarHTTPContentTypes)
	if localVarHTTPContentType != "" {
		localVarHeaderParams["Content-Type"] = localVarHTTPContentType
	}

	// to determine the Accept header
	localVarHTTPHeaderAccepts := []string{"application/json"}

	// set Accept header
	localVarHTTPHeaderAccept := selectHeaderAccept(localVarHTTPHeaderAccepts)
	if localVarHTTPHeaderAccept != "" {
		localVarHeaderParams["Accept"] = localVarHTTPHeaderAccept
	}
	req, err := a.client.prepareRequest(r.ctx, localVarPath, localVarHTTPMethod, localVarPostBody, localVarHeaderParams, localVarQueryParams, localVarFormParams, localVarFormFileName, localVarFileName, localVarFileBytes)
	if err != nil {
		return localVarReturnValue, nil, err
	}

	localVarHTTPResponse, err := a.client.callAPI(req)
	if err != nil || localVarHTTPResponse == nil {
		return localVarReturnValue, localVarHTTPResponse, err
	}

	localVarBody, err := _ioutil.ReadAll(localVarHTTPResponse.Body)
	localVarHTTPResponse.Body.Close()
	localVarHTTPResponse.Body = _ioutil.NopCloser(bytes.NewBuffer(localVarBody))
	if err != nil {
		return localVarReturnValue, localVarHTTPResponse, err
	}

	if localVarHTTPResponse.StatusCode >= 300 {
		newErr := GenericOpenAPIError{
			body:  localVarBody,
			error: localVarHTTPResponse.Status,
		}
		if localVarHTTPResponse.StatusCode == 400 {
			var v HttpErrorOut
			err = a.client.decode(&v, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
			if err != nil {
				newErr.error = err.Error()
				return localVarReturnValue, localVarHTTPResponse, newErr
			}
			newErr.model = v
			return localVarReturnValue, localVarHTTPResponse, newErr
		}
		if localVarHTTPResponse.StatusCode == 401 {
			var v HttpErrorOut
			err = a.client.decode(&v, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
			if err != nil {
				newErr.error = err.Error()
				return localVarReturnValue, localVarHTTPResponse, newErr
			}
			newErr.model = v
			return localVarReturnValue, localVarHTTPResponse, newErr
		}
		if localVarHTTPResponse.StatusCode == 403 {
			var v HttpErrorOut
			err = a.client.decode(&v, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
			if err != nil {
				newErr.error = err.Error()
				return localVarReturnValue, localVarHTTPResponse, newErr
			}
			newErr.model = v
			return localVarReturnValue, localVarHTTPResponse, newErr
		}
		if localVarHTTPResponse.StatusCode == 404 {
			var v HttpErrorOut
			err = a.client.decode(&v, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
			if err != nil {
				newErr.error = err.Error()
				return localVarReturnValue, localVarHTTPResponse, newErr
			}
			newErr.model = v
			return localVarReturnValue, localVarHTTPResponse, newErr
		}
		if localVarHTTPResponse.StatusCode == 409 {
			var v HttpErrorOut
			err = a.client.decode(&v, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
			if err != nil {
				newErr.error = err.Error()
				return localVarReturnValue, localVarHTTPResponse, newErr
			}
			newErr.model = v
			return localVarReturnValue, localVarHTTPResponse, newErr
		}
		if localVarHTTPResponse.StatusCode == 422 {
			var v HTTPValidationError
			err = a.client.decode(&v, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
			if err != nil {
				newErr.error = err.Error()
				return localVarReturnValue, localVarHTTPResponse, newErr
			}
			newErr.model = v
			return localVarReturnValue, localVarHTTPResponse, newErr
		}
		if localVarHTTPResponse.StatusCode == 429 {
			var v HttpErrorOut
			err = a.client.decode(&v, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
			if err != nil {
				newErr.error = err.Error()
				return localVarReturnValue, localVarHTTPResponse, newErr
			}
			newErr.model = v
		}
		return localVarReturnValue, localVarHTTPResponse, newErr
	}

	err = a.client.decode(&localVarReturnValue, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
	if err != nil {
		newErr := GenericOpenAPIError{
			body:  localVarBody,
			error: err.Error(),
		}
		return localVarReturnValue, localVarHTTPResponse, newErr
	}

	return localVarReturnValue, localVarHTTPResponse, nil
}

type ApiV1MessageAttemptListByEndpointRequest struct {
	ctx _context.Context
	ApiService *MessageAttemptApiService
	appId string
	endpointId string
	limit *int32
	iterator *string
	status *MessageStatus
	statusCodeClass *StatusCodeClass
	channel *string
	tag *string
	before *time.Time
	after *time.Time
	withContent *bool
	withMsg *bool
	eventTypes *[]string
}

func (r ApiV1MessageAttemptListByEndpointRequest) Limit(limit int32) ApiV1MessageAttemptListByEndpointRequest {
	r.limit = &limit
	return r
}
func (r ApiV1MessageAttemptListByEndpointRequest) Iterator(iterator string) ApiV1MessageAttemptListByEndpointRequest {
	r.iterator = &iterator
	return r
}
func (r ApiV1MessageAttemptListByEndpointRequest) Status(status MessageStatus) ApiV1MessageAttemptListByEndpointRequest {
	r.status = &status
	return r
}
func (r ApiV1MessageAttemptListByEndpointRequest) StatusCodeClass(statusCodeClass StatusCodeClass) ApiV1MessageAttemptListByEndpointRequest {
	r.statusCodeClass = &statusCodeClass
	return r
}
func (r ApiV1MessageAttemptListByEndpointRequest) Channel(channel string) ApiV1MessageAttemptListByEndpointRequest {
	r.channel = &channel
	return r
}
func (r ApiV1MessageAttemptListByEndpointRequest) Tag(tag string) ApiV1MessageAttemptListByEndpointRequest {
	r.tag = &tag
	return r
}
func (r ApiV1MessageAttemptListByEndpointRequest) Before(before time.Time) ApiV1MessageAttemptListByEndpointRequest {
	r.before = &before
	return r
}
func (r ApiV1MessageAttemptListByEndpointRequest) After(after time.Time) ApiV1MessageAttemptListByEndpointRequest {
	r.after = &after
	return r
}
func (r ApiV1MessageAttemptListByEndpointRequest) WithContent(withContent bool) ApiV1MessageAttemptListByEndpointRequest {
	r.withContent = &withContent
	return r
}
func (r ApiV1MessageAttemptListByEndpointRequest) WithMsg(withMsg bool) ApiV1MessageAttemptListByEndpointRequest {
	r.withMsg = &withMsg
	return r
}
func (r ApiV1MessageAttemptListByEndpointRequest) EventTypes(eventTypes []string) ApiV1MessageAttemptListByEndpointRequest {
	r.eventTypes = &eventTypes
	return r
}

func (r ApiV1MessageAttemptListByEndpointRequest) Execute() (ListResponseMessageAttemptOut, *_nethttp.Response, error) {
	return r.ApiService.V1MessageAttemptListByEndpointExecute(r)
}

/*
 * V1MessageAttemptListByEndpoint List Attempts By Endpoint
 * List attempts by endpoint id

Note that by default this endpoint is limited to retrieving 90 days' worth of data
relative to now or, if an iterator is provided, 90 days before/after the time indicated
by the iterator ID. If you require data beyond those time ranges, you will need to explicitly
set the `before` or `after` parameter as appropriate.

 * @param ctx _context.Context - for authentication, logging, cancellation, deadlines, tracing, etc. Passed from http.Request or context.Background().
 * @param appId The app's ID or UID
 * @param endpointId The ep's ID or UID
 * @return ApiV1MessageAttemptListByEndpointRequest
 */
func (a *MessageAttemptApiService) V1MessageAttemptListByEndpoint(ctx _context.Context, appId string, endpointId string) ApiV1MessageAttemptListByEndpointRequest {
	return ApiV1MessageAttemptListByEndpointRequest{
		ApiService: a,
		ctx: ctx,
		appId: appId,
		endpointId: endpointId,
	}
}

/*
 * Execute executes the request
 * @return ListResponseMessageAttemptOut
 */
func (a *MessageAttemptApiService) V1MessageAttemptListByEndpointExecute(r ApiV1MessageAttemptListByEndpointRequest) (ListResponseMessageAttemptOut, *_nethttp.Response, error) {
	var (
		localVarHTTPMethod   = _nethttp.MethodGet
		localVarPostBody     interface{}
		localVarFormFileName string
		localVarFileName     string
		localVarFileBytes    []byte
		localVarReturnValue  ListResponseMessageAttemptOut
	)

	localBasePath, err := a.client.cfg.ServerURLWithContext(r.ctx, "MessageAttemptApiService.V1MessageAttemptListByEndpoint")
	if err != nil {
		return localVarReturnValue, nil, GenericOpenAPIError{error: err.Error()}
	}

	localVarPath := localBasePath + "/api/v1/app/{app_id}/attempt/endpoint/{endpoint_id}"
	localVarPath = strings.Replace(localVarPath, "{"+"app_id"+"}", _neturl.PathEscape(parameterToString(r.appId, "")), -1)
	localVarPath = strings.Replace(localVarPath, "{"+"endpoint_id"+"}", _neturl.PathEscape(parameterToString(r.endpointId, "")), -1)

	localVarHeaderParams := make(map[string]string)
	localVarQueryParams := _neturl.Values{}
	localVarFormParams := _neturl.Values{}
	if strlen(r.appId) < 1 {
		return localVarReturnValue, nil, reportError("appId must have at least 1 elements")
	}
	if strlen(r.appId) > 256 {
		return localVarReturnValue, nil, reportError("appId must have less than 256 elements")
	}
	if strlen(r.endpointId) < 1 {
		return localVarReturnValue, nil, reportError("endpointId must have at least 1 elements")
	}
	if strlen(r.endpointId) > 256 {
		return localVarReturnValue, nil, reportError("endpointId must have less than 256 elements")
	}

	if r.limit != nil {
		localVarQueryParams.Add("limit", parameterToString(*r.limit, ""))
	}
	if r.iterator != nil {
		localVarQueryParams.Add("iterator", parameterToString(*r.iterator, ""))
	}
	if r.status != nil {
		localVarQueryParams.Add("status", parameterToString(*r.status, ""))
	}
	if r.statusCodeClass != nil {
		localVarQueryParams.Add("status_code_class", parameterToString(*r.statusCodeClass, ""))
	}
	if r.channel != nil {
		localVarQueryParams.Add("channel", parameterToString(*r.channel, ""))
	}
	if r.tag != nil {
		localVarQueryParams.Add("tag", parameterToString(*r.tag, ""))
	}
	if r.before != nil {
		localVarQueryParams.Add("before", parameterToString(*r.before, ""))
	}
	if r.after != nil {
		localVarQueryParams.Add("after", parameterToString(*r.after, ""))
	}
	if r.withContent != nil {
		localVarQueryParams.Add("with_content", parameterToString(*r.withContent, ""))
	}
	if r.withMsg != nil {
		localVarQueryParams.Add("with_msg", parameterToString(*r.withMsg, ""))
	}
	if r.eventTypes != nil {
		t := *r.eventTypes
		if reflect.TypeOf(t).Kind() == reflect.Slice {
			s := reflect.ValueOf(t)
			for i := 0; i < s.Len(); i++ {
				localVarQueryParams.Add("event_types", parameterToString(s.Index(i), "multi"))
			}
		} else {
			localVarQueryParams.Add("event_types", parameterToString(t, "multi"))
		}
	}
	// to determine the Content-Type header
	localVarHTTPContentTypes := []string{}

	// set Content-Type header
	localVarHTTPContentType := selectHeaderContentType(localVarHTTPContentTypes)
	if localVarHTTPContentType != "" {
		localVarHeaderParams["Content-Type"] = localVarHTTPContentType
	}

	// to determine the Accept header
	localVarHTTPHeaderAccepts := []string{"application/json"}

	// set Accept header
	localVarHTTPHeaderAccept := selectHeaderAccept(localVarHTTPHeaderAccepts)
	if localVarHTTPHeaderAccept != "" {
		localVarHeaderParams["Accept"] = localVarHTTPHeaderAccept
	}
	req, err := a.client.prepareRequest(r.ctx, localVarPath, localVarHTTPMethod, localVarPostBody, localVarHeaderParams, localVarQueryParams, localVarFormParams, localVarFormFileName, localVarFileName, localVarFileBytes)
	if err != nil {
		return localVarReturnValue, nil, err
	}

	localVarHTTPResponse, err := a.client.callAPI(req)
	if err != nil || localVarHTTPResponse == nil {
		return localVarReturnValue, localVarHTTPResponse, err
	}

	localVarBody, err := _ioutil.ReadAll(localVarHTTPResponse.Body)
	localVarHTTPResponse.Body.Close()
	localVarHTTPResponse.Body = _ioutil.NopCloser(bytes.NewBuffer(localVarBody))
	if err != nil {
		return localVarReturnValue, localVarHTTPResponse, err
	}

	if localVarHTTPResponse.StatusCode >= 300 {
		newErr := GenericOpenAPIError{
			body:  localVarBody,
			error: localVarHTTPResponse.Status,
		}
		if localVarHTTPResponse.StatusCode == 400 {
			var v HttpErrorOut
			err = a.client.decode(&v, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
			if err != nil {
				newErr.error = err.Error()
				return localVarReturnValue, localVarHTTPResponse, newErr
			}
			newErr.model = v
			return localVarReturnValue, localVarHTTPResponse, newErr
		}
		if localVarHTTPResponse.StatusCode == 401 {
			var v HttpErrorOut
			err = a.client.decode(&v, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
			if err != nil {
				newErr.error = err.Error()
				return localVarReturnValue, localVarHTTPResponse, newErr
			}
			newErr.model = v
			return localVarReturnValue, localVarHTTPResponse, newErr
		}
		if localVarHTTPResponse.StatusCode == 403 {
			var v HttpErrorOut
			err = a.client.decode(&v, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
			if err != nil {
				newErr.error = err.Error()
				return localVarReturnValue, localVarHTTPResponse, newErr
			}
			newErr.model = v
			return localVarReturnValue, localVarHTTPResponse, newErr
		}
		if localVarHTTPResponse.StatusCode == 404 {
			var v HttpErrorOut
			err = a.client.decode(&v, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
			if err != nil {
				newErr.error = err.Error()
				return localVarReturnValue, localVarHTTPResponse, newErr
			}
			newErr.model = v
			return localVarReturnValue, localVarHTTPResponse, newErr
		}
		if localVarHTTPResponse.StatusCode == 409 {
			var v HttpErrorOut
			err = a.client.decode(&v, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
			if err != nil {
				newErr.error = err.Error()
				return localVarReturnValue, localVarHTTPResponse, newErr
			}
			newErr.model = v
			return localVarReturnValue, localVarHTTPResponse, newErr
		}
		if localVarHTTPResponse.StatusCode == 422 {
			var v HTTPValidationError
			err = a.client.decode(&v, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
			if err != nil {
				newErr.error = err.Error()
				return localVarReturnValue, localVarHTTPResponse, newErr
			}
			newErr.model = v
			return localVarReturnValue, localVarHTTPResponse, newErr
		}
		if localVarHTTPResponse.StatusCode == 429 {
			var v HttpErrorOut
			err = a.client.decode(&v, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
			if err != nil {
				newErr.error = err.Error()
				return localVarReturnValue, localVarHTTPResponse, newErr
			}
			newErr.model = v
		}
		return localVarReturnValue, localVarHTTPResponse, newErr
	}

	err = a.client.decode(&localVarReturnValue, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
	if err != nil {
		newErr := GenericOpenAPIError{
			body:  localVarBody,
			error: err.Error(),
		}
		return localVarReturnValue, localVarHTTPResponse, newErr
	}

	return localVarReturnValue, localVarHTTPResponse, nil
}

type ApiV1MessageAttemptListByEndpointDeprecatedRequest struct {
	ctx _context.Context
	ApiService *MessageAttemptApiService
	appId string
	msgId string
	endpointId string
	limit *int32
	iterator *string
	channel *string
	tag *string
	status *MessageStatus
	before *time.Time
	after *time.Time
	eventTypes *[]string
}

func (r ApiV1MessageAttemptListByEndpointDeprecatedRequest) Limit(limit int32) ApiV1MessageAttemptListByEndpointDeprecatedRequest {
	r.limit = &limit
	return r
}
func (r ApiV1MessageAttemptListByEndpointDeprecatedRequest) Iterator(iterator string) ApiV1MessageAttemptListByEndpointDeprecatedRequest {
	r.iterator = &iterator
	return r
}
func (r ApiV1MessageAttemptListByEndpointDeprecatedRequest) Channel(channel string) ApiV1MessageAttemptListByEndpointDeprecatedRequest {
	r.channel = &channel
	return r
}
func (r ApiV1MessageAttemptListByEndpointDeprecatedRequest) Tag(tag string) ApiV1MessageAttemptListByEndpointDeprecatedRequest {
	r.tag = &tag
	return r
}
func (r ApiV1MessageAttemptListByEndpointDeprecatedRequest) Status(status MessageStatus) ApiV1MessageAttemptListByEndpointDeprecatedRequest {
	r.status = &status
	return r
}
func (r ApiV1MessageAttemptListByEndpointDeprecatedRequest) Before(before time.Time) ApiV1MessageAttemptListByEndpointDeprecatedRequest {
	r.before = &before
	return r
}
func (r ApiV1MessageAttemptListByEndpointDeprecatedRequest) After(after time.Time) ApiV1MessageAttemptListByEndpointDeprecatedRequest {
	r.after = &after
	return r
}
func (r ApiV1MessageAttemptListByEndpointDeprecatedRequest) EventTypes(eventTypes []string) ApiV1MessageAttemptListByEndpointDeprecatedRequest {
	r.eventTypes = &eventTypes
	return r
}

func (r ApiV1MessageAttemptListByEndpointDeprecatedRequest) Execute() (ListResponseMessageAttemptEndpointOut, *_nethttp.Response, error) {
	return r.ApiService.V1MessageAttemptListByEndpointDeprecatedExecute(r)
}

/*
 * V1MessageAttemptListByEndpointDeprecated List Attempts For Endpoint
 * DEPRECATED: please use list_attempts with endpoint_id as a query parameter instead.

List the message attempts for a particular endpoint.

Returning the endpoint.

The `before` parameter lets you filter all items created before a certain date and is ignored if an iterator is passed.

Note that by default this endpoint is limited to retrieving 90 days' worth of data
relative to now or, if an iterator is provided, 90 days before/after the time indicated
by the iterator ID. If you require data beyond those time ranges, you will need to explicitly
set the `before` or `after` parameter as appropriate.

 * @param ctx _context.Context - for authentication, logging, cancellation, deadlines, tracing, etc. Passed from http.Request or context.Background().
 * @param appId The app's ID or UID
 * @param msgId The msg's ID or UID
 * @param endpointId The ep's ID or UID
 * @return ApiV1MessageAttemptListByEndpointDeprecatedRequest
 */
func (a *MessageAttemptApiService) V1MessageAttemptListByEndpointDeprecated(ctx _context.Context, appId string, msgId string, endpointId string) ApiV1MessageAttemptListByEndpointDeprecatedRequest {
	return ApiV1MessageAttemptListByEndpointDeprecatedRequest{
		ApiService: a,
		ctx: ctx,
		appId: appId,
		msgId: msgId,
		endpointId: endpointId,
	}
}

/*
 * Execute executes the request
 * @return ListResponseMessageAttemptEndpointOut
 */
func (a *MessageAttemptApiService) V1MessageAttemptListByEndpointDeprecatedExecute(r ApiV1MessageAttemptListByEndpointDeprecatedRequest) (ListResponseMessageAttemptEndpointOut, *_nethttp.Response, error) {
	var (
		localVarHTTPMethod   = _nethttp.MethodGet
		localVarPostBody     interface{}
		localVarFormFileName string
		localVarFileName     string
		localVarFileBytes    []byte
		localVarReturnValue  ListResponseMessageAttemptEndpointOut
	)

	localBasePath, err := a.client.cfg.ServerURLWithContext(r.ctx, "MessageAttemptApiService.V1MessageAttemptListByEndpointDeprecated")
	if err != nil {
		return localVarReturnValue, nil, GenericOpenAPIError{error: err.Error()}
	}

	localVarPath := localBasePath + "/api/v1/app/{app_id}/msg/{msg_id}/endpoint/{endpoint_id}/attempt"
	localVarPath = strings.Replace(localVarPath, "{"+"app_id"+"}", _neturl.PathEscape(parameterToString(r.appId, "")), -1)
	localVarPath = strings.Replace(localVarPath, "{"+"msg_id"+"}", _neturl.PathEscape(parameterToString(r.msgId, "")), -1)
	localVarPath = strings.Replace(localVarPath, "{"+"endpoint_id"+"}", _neturl.PathEscape(parameterToString(r.endpointId, "")), -1)

	localVarHeaderParams := make(map[string]string)
	localVarQueryParams := _neturl.Values{}
	localVarFormParams := _neturl.Values{}
	if strlen(r.appId) < 1 {
		return localVarReturnValue, nil, reportError("appId must have at least 1 elements")
	}
	if strlen(r.appId) > 256 {
		return localVarReturnValue, nil, reportError("appId must have less than 256 elements")
	}
	if strlen(r.msgId) < 1 {
		return localVarReturnValue, nil, reportError("msgId must have at least 1 elements")
	}
	if strlen(r.msgId) > 256 {
		return localVarReturnValue, nil, reportError("msgId must have less than 256 elements")
	}
	if strlen(r.endpointId) < 1 {
		return localVarReturnValue, nil, reportError("endpointId must have at least 1 elements")
	}
	if strlen(r.endpointId) > 256 {
		return localVarReturnValue, nil, reportError("endpointId must have less than 256 elements")
	}

	if r.limit != nil {
		localVarQueryParams.Add("limit", parameterToString(*r.limit, ""))
	}
	if r.iterator != nil {
		localVarQueryParams.Add("iterator", parameterToString(*r.iterator, ""))
	}
	if r.channel != nil {
		localVarQueryParams.Add("channel", parameterToString(*r.channel, ""))
	}
	if r.tag != nil {
		localVarQueryParams.Add("tag", parameterToString(*r.tag, ""))
	}
	if r.status != nil {
		localVarQueryParams.Add("status", parameterToString(*r.status, ""))
	}
	if r.before != nil {
		localVarQueryParams.Add("before", parameterToString(*r.before, ""))
	}
	if r.after != nil {
		localVarQueryParams.Add("after", parameterToString(*r.after, ""))
	}
	if r.eventTypes != nil {
		t := *r.eventTypes
		if reflect.TypeOf(t).Kind() == reflect.Slice {
			s := reflect.ValueOf(t)
			for i := 0; i < s.Len(); i++ {
				localVarQueryParams.Add("event_types", parameterToString(s.Index(i), "multi"))
			}
		} else {
			localVarQueryParams.Add("event_types", parameterToString(t, "multi"))
		}
	}
	// to determine the Content-Type header
	localVarHTTPContentTypes := []string{}

	// set Content-Type header
	localVarHTTPContentType := selectHeaderContentType(localVarHTTPContentTypes)
	if localVarHTTPContentType != "" {
		localVarHeaderParams["Content-Type"] = localVarHTTPContentType
	}

	// to determine the Accept header
	localVarHTTPHeaderAccepts := []string{"application/json"}

	// set Accept header
	localVarHTTPHeaderAccept := selectHeaderAccept(localVarHTTPHeaderAccepts)
	if localVarHTTPHeaderAccept != "" {
		localVarHeaderParams["Accept"] = localVarHTTPHeaderAccept
	}
	req, err := a.client.prepareRequest(r.ctx, localVarPath, localVarHTTPMethod, localVarPostBody, localVarHeaderParams, localVarQueryParams, localVarFormParams, localVarFormFileName, localVarFileName, localVarFileBytes)
	if err != nil {
		return localVarReturnValue, nil, err
	}

	localVarHTTPResponse, err := a.client.callAPI(req)
	if err != nil || localVarHTTPResponse == nil {
		return localVarReturnValue, localVarHTTPResponse, err
	}

	localVarBody, err := _ioutil.ReadAll(localVarHTTPResponse.Body)
	localVarHTTPResponse.Body.Close()
	localVarHTTPResponse.Body = _ioutil.NopCloser(bytes.NewBuffer(localVarBody))
	if err != nil {
		return localVarReturnValue, localVarHTTPResponse, err
	}

	if localVarHTTPResponse.StatusCode >= 300 {
		newErr := GenericOpenAPIError{
			body:  localVarBody,
			error: localVarHTTPResponse.Status,
		}
		if localVarHTTPResponse.StatusCode == 400 {
			var v HttpErrorOut
			err = a.client.decode(&v, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
			if err != nil {
				newErr.error = err.Error()
				return localVarReturnValue, localVarHTTPResponse, newErr
			}
			newErr.model = v
			return localVarReturnValue, localVarHTTPResponse, newErr
		}
		if localVarHTTPResponse.StatusCode == 401 {
			var v HttpErrorOut
			err = a.client.decode(&v, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
			if err != nil {
				newErr.error = err.Error()
				return localVarReturnValue, localVarHTTPResponse, newErr
			}
			newErr.model = v
			return localVarReturnValue, localVarHTTPResponse, newErr
		}
		if localVarHTTPResponse.StatusCode == 403 {
			var v HttpErrorOut
			err = a.client.decode(&v, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
			if err != nil {
				newErr.error = err.Error()
				return localVarReturnValue, localVarHTTPResponse, newErr
			}
			newErr.model = v
			return localVarReturnValue, localVarHTTPResponse, newErr
		}
		if localVarHTTPResponse.StatusCode == 404 {
			var v HttpErrorOut
			err = a.client.decode(&v, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
			if err != nil {
				newErr.error = err.Error()
				return localVarReturnValue, localVarHTTPResponse, newErr
			}
			newErr.model = v
			return localVarReturnValue, localVarHTTPResponse, newErr
		}
		if localVarHTTPResponse.StatusCode == 409 {
			var v HttpErrorOut
			err = a.client.decode(&v, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
			if err != nil {
				newErr.error = err.Error()
				return localVarReturnValue, localVarHTTPResponse, newErr
			}
			newErr.model = v
			return localVarReturnValue, localVarHTTPResponse, newErr
		}
		if localVarHTTPResponse.StatusCode == 422 {
			var v HTTPValidationError
			err = a.client.decode(&v, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
			if err != nil {
				newErr.error = err.Error()
				return localVarReturnValue, localVarHTTPResponse, newErr
			}
			newErr.model = v
			return localVarReturnValue, localVarHTTPResponse, newErr
		}
		if localVarHTTPResponse.StatusCode == 429 {
			var v HttpErrorOut
			err = a.client.decode(&v, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
			if err != nil {
				newErr.error = err.Error()
				return localVarReturnValue, localVarHTTPResponse, newErr
			}
			newErr.model = v
		}
		return localVarReturnValue, localVarHTTPResponse, newErr
	}

	err = a.client.decode(&localVarReturnValue, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
	if err != nil {
		newErr := GenericOpenAPIError{
			body:  localVarBody,
			error: err.Error(),
		}
		return localVarReturnValue, localVarHTTPResponse, newErr
	}

	return localVarReturnValue, localVarHTTPResponse, nil
}

type ApiV1MessageAttemptListByMsgRequest struct {
	ctx _context.Context
	ApiService *MessageAttemptApiService
	appId string
	msgId string
	limit *int32
	iterator *string
	status *MessageStatus
	statusCodeClass *StatusCodeClass
	channel *string
	tag *string
	endpointId *string
	before *time.Time
	after *time.Time
	withContent *bool
	eventTypes *[]string
}

func (r ApiV1MessageAttemptListByMsgRequest) Limit(limit int32) ApiV1MessageAttemptListByMsgRequest {
	r.limit = &limit
	return r
}
func (r ApiV1MessageAttemptListByMsgRequest) Iterator(iterator string) ApiV1MessageAttemptListByMsgRequest {
	r.iterator = &iterator
	return r
}
func (r ApiV1MessageAttemptListByMsgRequest) Status(status MessageStatus) ApiV1MessageAttemptListByMsgRequest {
	r.status = &status
	return r
}
func (r ApiV1MessageAttemptListByMsgRequest) StatusCodeClass(statusCodeClass StatusCodeClass) ApiV1MessageAttemptListByMsgRequest {
	r.statusCodeClass = &statusCodeClass
	return r
}
func (r ApiV1MessageAttemptListByMsgRequest) Channel(channel string) ApiV1MessageAttemptListByMsgRequest {
	r.channel = &channel
	return r
}
func (r ApiV1MessageAttemptListByMsgRequest) Tag(tag string) ApiV1MessageAttemptListByMsgRequest {
	r.tag = &tag
	return r
}
func (r ApiV1MessageAttemptListByMsgRequest) EndpointId(endpointId string) ApiV1MessageAttemptListByMsgRequest {
	r.endpointId = &endpointId
	return r
}
func (r ApiV1MessageAttemptListByMsgRequest) Before(before time.Time) ApiV1MessageAttemptListByMsgRequest {
	r.before = &before
	return r
}
func (r ApiV1MessageAttemptListByMsgRequest) After(after time.Time) ApiV1MessageAttemptListByMsgRequest {
	r.after = &after
	return r
}
func (r ApiV1MessageAttemptListByMsgRequest) WithContent(withContent bool) ApiV1MessageAttemptListByMsgRequest {
	r.withContent = &withContent
	return r
}
func (r ApiV1MessageAttemptListByMsgRequest) EventTypes(eventTypes []string) ApiV1MessageAttemptListByMsgRequest {
	r.eventTypes = &eventTypes
	return r
}

func (r ApiV1MessageAttemptListByMsgRequest) Execute() (ListResponseMessageAttemptOut, *_nethttp.Response, error) {
	return r.ApiService.V1MessageAttemptListByMsgExecute(r)
}

/*
 * V1MessageAttemptListByMsg List Attempts By Msg
 * List attempts by message id

Note that by default this endpoint is limited to retrieving 90 days' worth of data
relative to now or, if an iterator is provided, 90 days before/after the time indicated
by the iterator ID. If you require data beyond those time ranges, you will need to explicitly
set the `before` or `after` parameter as appropriate.

 * @param ctx _context.Context - for authentication, logging, cancellation, deadlines, tracing, etc. Passed from http.Request or context.Background().
 * @param appId The app's ID or UID
 * @param msgId The msg's ID or UID
 * @return ApiV1MessageAttemptListByMsgRequest
 */
func (a *MessageAttemptApiService) V1MessageAttemptListByMsg(ctx _context.Context, appId string, msgId string) ApiV1MessageAttemptListByMsgRequest {
	return ApiV1MessageAttemptListByMsgRequest{
		ApiService: a,
		ctx: ctx,
		appId: appId,
		msgId: msgId,
	}
}

/*
 * Execute executes the request
 * @return ListResponseMessageAttemptOut
 */
func (a *MessageAttemptApiService) V1MessageAttemptListByMsgExecute(r ApiV1MessageAttemptListByMsgRequest) (ListResponseMessageAttemptOut, *_nethttp.Response, error) {
	var (
		localVarHTTPMethod   = _nethttp.MethodGet
		localVarPostBody     interface{}
		localVarFormFileName string
		localVarFileName     string
		localVarFileBytes    []byte
		localVarReturnValue  ListResponseMessageAttemptOut
	)

	localBasePath, err := a.client.cfg.ServerURLWithContext(r.ctx, "MessageAttemptApiService.V1MessageAttemptListByMsg")
	if err != nil {
		return localVarReturnValue, nil, GenericOpenAPIError{error: err.Error()}
	}

	localVarPath := localBasePath + "/api/v1/app/{app_id}/attempt/msg/{msg_id}"
	localVarPath = strings.Replace(localVarPath, "{"+"app_id"+"}", _neturl.PathEscape(parameterToString(r.appId, "")), -1)
	localVarPath = strings.Replace(localVarPath, "{"+"msg_id"+"}", _neturl.PathEscape(parameterToString(r.msgId, "")), -1)

	localVarHeaderParams := make(map[string]string)
	localVarQueryParams := _neturl.Values{}
	localVarFormParams := _neturl.Values{}
	if strlen(r.appId) < 1 {
		return localVarReturnValue, nil, reportError("appId must have at least 1 elements")
	}
	if strlen(r.appId) > 256 {
		return localVarReturnValue, nil, reportError("appId must have less than 256 elements")
	}
	if strlen(r.msgId) < 1 {
		return localVarReturnValue, nil, reportError("msgId must have at least 1 elements")
	}
	if strlen(r.msgId) > 256 {
		return localVarReturnValue, nil, reportError("msgId must have less than 256 elements")
	}

	if r.limit != nil {
		localVarQueryParams.Add("limit", parameterToString(*r.limit, ""))
	}
	if r.iterator != nil {
		localVarQueryParams.Add("iterator", parameterToString(*r.iterator, ""))
	}
	if r.status != nil {
		localVarQueryParams.Add("status", parameterToString(*r.status, ""))
	}
	if r.statusCodeClass != nil {
		localVarQueryParams.Add("status_code_class", parameterToString(*r.statusCodeClass, ""))
	}
	if r.channel != nil {
		localVarQueryParams.Add("channel", parameterToString(*r.channel, ""))
	}
	if r.tag != nil {
		localVarQueryParams.Add("tag", parameterToString(*r.tag, ""))
	}
	if r.endpointId != nil {
		localVarQueryParams.Add("endpoint_id", parameterToString(*r.endpointId, ""))
	}
	if r.before != nil {
		localVarQueryParams.Add("before", parameterToString(*r.before, ""))
	}
	if r.after != nil {
		localVarQueryParams.Add("after", parameterToString(*r.after, ""))
	}
	if r.withContent != nil {
		localVarQueryParams.Add("with_content", parameterToString(*r.withContent, ""))
	}
	if r.eventTypes != nil {
		t := *r.eventTypes
		if reflect.TypeOf(t).Kind() == reflect.Slice {
			s := reflect.ValueOf(t)
			for i := 0; i < s.Len(); i++ {
				localVarQueryParams.Add("event_types", parameterToString(s.Index(i), "multi"))
			}
		} else {
			localVarQueryParams.Add("event_types", parameterToString(t, "multi"))
		}
	}
	// to determine the Content-Type header
	localVarHTTPContentTypes := []string{}

	// set Content-Type header
	localVarHTTPContentType := selectHeaderContentType(localVarHTTPContentTypes)
	if localVarHTTPContentType != "" {
		localVarHeaderParams["Content-Type"] = localVarHTTPContentType
	}

	// to determine the Accept header
	localVarHTTPHeaderAccepts := []string{"application/json"}

	// set Accept header
	localVarHTTPHeaderAccept := selectHeaderAccept(localVarHTTPHeaderAccepts)
	if localVarHTTPHeaderAccept != "" {
		localVarHeaderParams["Accept"] = localVarHTTPHeaderAccept
	}
	req, err := a.client.prepareRequest(r.ctx, localVarPath, localVarHTTPMethod, localVarPostBody, localVarHeaderParams, localVarQueryParams, localVarFormParams, localVarFormFileName, localVarFileName, localVarFileBytes)
	if err != nil {
		return localVarReturnValue, nil, err
	}

	localVarHTTPResponse, err := a.client.callAPI(req)
	if err != nil || localVarHTTPResponse == nil {
		return localVarReturnValue, localVarHTTPResponse, err
	}

	localVarBody, err := _ioutil.ReadAll(localVarHTTPResponse.Body)
	localVarHTTPResponse.Body.Close()
	localVarHTTPResponse.Body = _ioutil.NopCloser(bytes.NewBuffer(localVarBody))
	if err != nil {
		return localVarReturnValue, localVarHTTPResponse, err
	}

	if localVarHTTPResponse.StatusCode >= 300 {
		newErr := GenericOpenAPIError{
			body:  localVarBody,
			error: localVarHTTPResponse.Status,
		}
		if localVarHTTPResponse.StatusCode == 400 {
			var v HttpErrorOut
			err = a.client.decode(&v, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
			if err != nil {
				newErr.error = err.Error()
				return localVarReturnValue, localVarHTTPResponse, newErr
			}
			newErr.model = v
			return localVarReturnValue, localVarHTTPResponse, newErr
		}
		if localVarHTTPResponse.StatusCode == 401 {
			var v HttpErrorOut
			err = a.client.decode(&v, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
			if err != nil {
				newErr.error = err.Error()
				return localVarReturnValue, localVarHTTPResponse, newErr
			}
			newErr.model = v
			return localVarReturnValue, localVarHTTPResponse, newErr
		}
		if localVarHTTPResponse.StatusCode == 403 {
			var v HttpErrorOut
			err = a.client.decode(&v, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
			if err != nil {
				newErr.error = err.Error()
				return localVarReturnValue, localVarHTTPResponse, newErr
			}
			newErr.model = v
			return localVarReturnValue, localVarHTTPResponse, newErr
		}
		if localVarHTTPResponse.StatusCode == 404 {
			var v HttpErrorOut
			err = a.client.decode(&v, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
			if err != nil {
				newErr.error = err.Error()
				return localVarReturnValue, localVarHTTPResponse, newErr
			}
			newErr.model = v
			return localVarReturnValue, localVarHTTPResponse, newErr
		}
		if localVarHTTPResponse.StatusCode == 409 {
			var v HttpErrorOut
			err = a.client.decode(&v, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
			if err != nil {
				newErr.error = err.Error()
				return localVarReturnValue, localVarHTTPResponse, newErr
			}
			newErr.model = v
			return localVarReturnValue, localVarHTTPResponse, newErr
		}
		if localVarHTTPResponse.StatusCode == 422 {
			var v HTTPValidationError
			err = a.client.decode(&v, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
			if err != nil {
				newErr.error = err.Error()
				return localVarReturnValue, localVarHTTPResponse, newErr
			}
			newErr.model = v
			return localVarReturnValue, localVarHTTPResponse, newErr
		}
		if localVarHTTPResponse.StatusCode == 429 {
			var v HttpErrorOut
			err = a.client.decode(&v, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
			if err != nil {
				newErr.error = err.Error()
				return localVarReturnValue, localVarHTTPResponse, newErr
			}
			newErr.model = v
		}
		return localVarReturnValue, localVarHTTPResponse, newErr
	}

	err = a.client.decode(&localVarReturnValue, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
	if err != nil {
		newErr := GenericOpenAPIError{
			body:  localVarBody,
			error: err.Error(),
		}
		return localVarReturnValue, localVarHTTPResponse, newErr
	}

	return localVarReturnValue, localVarHTTPResponse, nil
}

type ApiV1MessageAttemptListByMsgDeprecatedRequest struct {
	ctx _context.Context
	ApiService *MessageAttemptApiService
	appId string
	msgId string
	limit *int32
	iterator *string
	endpointId *string
	channel *string
	tag *string
	status *MessageStatus
	before *time.Time
	after *time.Time
	statusCodeClass *StatusCodeClass
	eventTypes *[]string
}

func (r ApiV1MessageAttemptListByMsgDeprecatedRequest) Limit(limit int32) ApiV1MessageAttemptListByMsgDeprecatedRequest {
	r.limit = &limit
	return r
}
func (r ApiV1MessageAttemptListByMsgDeprecatedRequest) Iterator(iterator string) ApiV1MessageAttemptListByMsgDeprecatedRequest {
	r.iterator = &iterator
	return r
}
func (r ApiV1MessageAttemptListByMsgDeprecatedRequest) EndpointId(endpointId string) ApiV1MessageAttemptListByMsgDeprecatedRequest {
	r.endpointId = &endpointId
	return r
}
func (r ApiV1MessageAttemptListByMsgDeprecatedRequest) Channel(channel string) ApiV1MessageAttemptListByMsgDeprecatedRequest {
	r.channel = &channel
	return r
}
func (r ApiV1MessageAttemptListByMsgDeprecatedRequest) Tag(tag string) ApiV1MessageAttemptListByMsgDeprecatedRequest {
	r.tag = &tag
	return r
}
func (r ApiV1MessageAttemptListByMsgDeprecatedRequest) Status(status MessageStatus) ApiV1MessageAttemptListByMsgDeprecatedRequest {
	r.status = &status
	return r
}
func (r ApiV1MessageAttemptListByMsgDeprecatedRequest) Before(before time.Time) ApiV1MessageAttemptListByMsgDeprecatedRequest {
	r.before = &before
	return r
}
func (r ApiV1MessageAttemptListByMsgDeprecatedRequest) After(after time.Time) ApiV1MessageAttemptListByMsgDeprecatedRequest {
	r.after = &after
	return r
}
func (r ApiV1MessageAttemptListByMsgDeprecatedRequest) StatusCodeClass(statusCodeClass StatusCodeClass) ApiV1MessageAttemptListByMsgDeprecatedRequest {
	r.statusCodeClass = &statusCodeClass
	return r
}
func (r ApiV1MessageAttemptListByMsgDeprecatedRequest) EventTypes(eventTypes []string) ApiV1MessageAttemptListByMsgDeprecatedRequest {
	r.eventTypes = &eventTypes
	return r
}

func (r ApiV1MessageAttemptListByMsgDeprecatedRequest) Execute() (ListResponseMessageAttemptOut, *_nethttp.Response, error) {
	return r.ApiService.V1MessageAttemptListByMsgDeprecatedExecute(r)
}

/*
 * V1MessageAttemptListByMsgDeprecated List Attempts
 * Deprecated: Please use "List Attempts by Endpoint" and "List Attempts by Msg" instead.

Note that by default this endpoint is limited to retrieving 90 days' worth of data
relative to now or, if an iterator is provided, 90 days before/after the time indicated
by the iterator ID. If you require data beyond those time ranges, you will need to explicitly
set the `before` or `after` parameter as appropriate.

`msg_id`: Use a message id or a message `eventId`
 * @param ctx _context.Context - for authentication, logging, cancellation, deadlines, tracing, etc. Passed from http.Request or context.Background().
 * @param appId The app's ID or UID
 * @param msgId The msg's ID or UID
 * @return ApiV1MessageAttemptListByMsgDeprecatedRequest
 */
func (a *MessageAttemptApiService) V1MessageAttemptListByMsgDeprecated(ctx _context.Context, appId string, msgId string) ApiV1MessageAttemptListByMsgDeprecatedRequest {
	return ApiV1MessageAttemptListByMsgDeprecatedRequest{
		ApiService: a,
		ctx: ctx,
		appId: appId,
		msgId: msgId,
	}
}

/*
 * Execute executes the request
 * @return ListResponseMessageAttemptOut
 */
func (a *MessageAttemptApiService) V1MessageAttemptListByMsgDeprecatedExecute(r ApiV1MessageAttemptListByMsgDeprecatedRequest) (ListResponseMessageAttemptOut, *_nethttp.Response, error) {
	var (
		localVarHTTPMethod   = _nethttp.MethodGet
		localVarPostBody     interface{}
		localVarFormFileName string
		localVarFileName     string
		localVarFileBytes    []byte
		localVarReturnValue  ListResponseMessageAttemptOut
	)

	localBasePath, err := a.client.cfg.ServerURLWithContext(r.ctx, "MessageAttemptApiService.V1MessageAttemptListByMsgDeprecated")
	if err != nil {
		return localVarReturnValue, nil, GenericOpenAPIError{error: err.Error()}
	}

	localVarPath := localBasePath + "/api/v1/app/{app_id}/msg/{msg_id}/attempt"
	localVarPath = strings.Replace(localVarPath, "{"+"app_id"+"}", _neturl.PathEscape(parameterToString(r.appId, "")), -1)
	localVarPath = strings.Replace(localVarPath, "{"+"msg_id"+"}", _neturl.PathEscape(parameterToString(r.msgId, "")), -1)

	localVarHeaderParams := make(map[string]string)
	localVarQueryParams := _neturl.Values{}
	localVarFormParams := _neturl.Values{}
	if strlen(r.appId) < 1 {
		return localVarReturnValue, nil, reportError("appId must have at least 1 elements")
	}
	if strlen(r.appId) > 256 {
		return localVarReturnValue, nil, reportError("appId must have less than 256 elements")
	}
	if strlen(r.msgId) < 1 {
		return localVarReturnValue, nil, reportError("msgId must have at least 1 elements")
	}
	if strlen(r.msgId) > 256 {
		return localVarReturnValue, nil, reportError("msgId must have less than 256 elements")
	}

	if r.limit != nil {
		localVarQueryParams.Add("limit", parameterToString(*r.limit, ""))
	}
	if r.iterator != nil {
		localVarQueryParams.Add("iterator", parameterToString(*r.iterator, ""))
	}
	if r.endpointId != nil {
		localVarQueryParams.Add("endpoint_id", parameterToString(*r.endpointId, ""))
	}
	if r.channel != nil {
		localVarQueryParams.Add("channel", parameterToString(*r.channel, ""))
	}
	if r.tag != nil {
		localVarQueryParams.Add("tag", parameterToString(*r.tag, ""))
	}
	if r.status != nil {
		localVarQueryParams.Add("status", parameterToString(*r.status, ""))
	}
	if r.before != nil {
		localVarQueryParams.Add("before", parameterToString(*r.before, ""))
	}
	if r.after != nil {
		localVarQueryParams.Add("after", parameterToString(*r.after, ""))
	}
	if r.statusCodeClass != nil {
		localVarQueryParams.Add("status_code_class", parameterToString(*r.statusCodeClass, ""))
	}
	if r.eventTypes != nil {
		t := *r.eventTypes
		if reflect.TypeOf(t).Kind() == reflect.Slice {
			s := reflect.ValueOf(t)
			for i := 0; i < s.Len(); i++ {
				localVarQueryParams.Add("event_types", parameterToString(s.Index(i), "multi"))
			}
		} else {
			localVarQueryParams.Add("event_types", parameterToString(t, "multi"))
		}
	}
	// to determine the Content-Type header
	localVarHTTPContentTypes := []string{}

	// set Content-Type header
	localVarHTTPContentType := selectHeaderContentType(localVarHTTPContentTypes)
	if localVarHTTPContentType != "" {
		localVarHeaderParams["Content-Type"] = localVarHTTPContentType
	}

	// to determine the Accept header
	localVarHTTPHeaderAccepts := []string{"application/json"}

	// set Accept header
	localVarHTTPHeaderAccept := selectHeaderAccept(localVarHTTPHeaderAccepts)
	if localVarHTTPHeaderAccept != "" {
		localVarHeaderParams["Accept"] = localVarHTTPHeaderAccept
	}
	req, err := a.client.prepareRequest(r.ctx, localVarPath, localVarHTTPMethod, localVarPostBody, localVarHeaderParams, localVarQueryParams, localVarFormParams, localVarFormFileName, localVarFileName, localVarFileBytes)
	if err != nil {
		return localVarReturnValue, nil, err
	}

	localVarHTTPResponse, err := a.client.callAPI(req)
	if err != nil || localVarHTTPResponse == nil {
		return localVarReturnValue, localVarHTTPResponse, err
	}

	localVarBody, err := _ioutil.ReadAll(localVarHTTPResponse.Body)
	localVarHTTPResponse.Body.Close()
	localVarHTTPResponse.Body = _ioutil.NopCloser(bytes.NewBuffer(localVarBody))
	if err != nil {
		return localVarReturnValue, localVarHTTPResponse, err
	}

	if localVarHTTPResponse.StatusCode >= 300 {
		newErr := GenericOpenAPIError{
			body:  localVarBody,
			error: localVarHTTPResponse.Status,
		}
		if localVarHTTPResponse.StatusCode == 400 {
			var v HttpErrorOut
			err = a.client.decode(&v, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
			if err != nil {
				newErr.error = err.Error()
				return localVarReturnValue, localVarHTTPResponse, newErr
			}
			newErr.model = v
			return localVarReturnValue, localVarHTTPResponse, newErr
		}
		if localVarHTTPResponse.StatusCode == 401 {
			var v HttpErrorOut
			err = a.client.decode(&v, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
			if err != nil {
				newErr.error = err.Error()
				return localVarReturnValue, localVarHTTPResponse, newErr
			}
			newErr.model = v
			return localVarReturnValue, localVarHTTPResponse, newErr
		}
		if localVarHTTPResponse.StatusCode == 403 {
			var v HttpErrorOut
			err = a.client.decode(&v, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
			if err != nil {
				newErr.error = err.Error()
				return localVarReturnValue, localVarHTTPResponse, newErr
			}
			newErr.model = v
			return localVarReturnValue, localVarHTTPResponse, newErr
		}
		if localVarHTTPResponse.StatusCode == 404 {
			var v HttpErrorOut
			err = a.client.decode(&v, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
			if err != nil {
				newErr.error = err.Error()
				return localVarReturnValue, localVarHTTPResponse, newErr
			}
			newErr.model = v
			return localVarReturnValue, localVarHTTPResponse, newErr
		}
		if localVarHTTPResponse.StatusCode == 409 {
			var v HttpErrorOut
			err = a.client.decode(&v, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
			if err != nil {
				newErr.error = err.Error()
				return localVarReturnValue, localVarHTTPResponse, newErr
			}
			newErr.model = v
			return localVarReturnValue, localVarHTTPResponse, newErr
		}
		if localVarHTTPResponse.StatusCode == 422 {
			var v HTTPValidationError
			err = a.client.decode(&v, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
			if err != nil {
				newErr.error = err.Error()
				return localVarReturnValue, localVarHTTPResponse, newErr
			}
			newErr.model = v
			return localVarReturnValue, localVarHTTPResponse, newErr
		}
		if localVarHTTPResponse.StatusCode == 429 {
			var v HttpErrorOut
			err = a.client.decode(&v, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
			if err != nil {
				newErr.error = err.Error()
				return localVarReturnValue, localVarHTTPResponse, newErr
			}
			newErr.model = v
		}
		return localVarReturnValue, localVarHTTPResponse, newErr
	}

	err = a.client.decode(&localVarReturnValue, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
	if err != nil {
		newErr := GenericOpenAPIError{
			body:  localVarBody,
			error: err.Error(),
		}
		return localVarReturnValue, localVarHTTPResponse, newErr
	}

	return localVarReturnValue, localVarHTTPResponse, nil
}

type ApiV1MessageAttemptResendRequest struct {
	ctx _context.Context
	ApiService *MessageAttemptApiService
	appId string
	msgId string
	endpointId string
	idempotencyKey *string
}

func (r ApiV1MessageAttemptResendRequest) IdempotencyKey(idempotencyKey string) ApiV1MessageAttemptResendRequest {
	r.idempotencyKey = &idempotencyKey
	return r
}

func (r ApiV1MessageAttemptResendRequest) Execute() (*_nethttp.Response, error) {
	return r.ApiService.V1MessageAttemptResendExecute(r)
}

/*
 * V1MessageAttemptResend Resend Webhook
 * Resend a message to the specified endpoint.
 * @param ctx _context.Context - for authentication, logging, cancellation, deadlines, tracing, etc. Passed from http.Request or context.Background().
 * @param appId The app's ID or UID
 * @param msgId The msg's ID or UID
 * @param endpointId The ep's ID or UID
 * @return ApiV1MessageAttemptResendRequest
 */
func (a *MessageAttemptApiService) V1MessageAttemptResend(ctx _context.Context, appId string, msgId string, endpointId string) ApiV1MessageAttemptResendRequest {
	return ApiV1MessageAttemptResendRequest{
		ApiService: a,
		ctx: ctx,
		appId: appId,
		msgId: msgId,
		endpointId: endpointId,
	}
}

/*
 * Execute executes the request
 */
func (a *MessageAttemptApiService) V1MessageAttemptResendExecute(r ApiV1MessageAttemptResendRequest) (*_nethttp.Response, error) {
	var (
		localVarHTTPMethod   = _nethttp.MethodPost
		localVarPostBody     interface{}
		localVarFormFileName string
		localVarFileName     string
		localVarFileBytes    []byte
	)

	localBasePath, err := a.client.cfg.ServerURLWithContext(r.ctx, "MessageAttemptApiService.V1MessageAttemptResend")
	if err != nil {
		return nil, GenericOpenAPIError{error: err.Error()}
	}

	localVarPath := localBasePath + "/api/v1/app/{app_id}/msg/{msg_id}/endpoint/{endpoint_id}/resend"
	localVarPath = strings.Replace(localVarPath, "{"+"app_id"+"}", _neturl.PathEscape(parameterToString(r.appId, "")), -1)
	localVarPath = strings.Replace(localVarPath, "{"+"msg_id"+"}", _neturl.PathEscape(parameterToString(r.msgId, "")), -1)
	localVarPath = strings.Replace(localVarPath, "{"+"endpoint_id"+"}", _neturl.PathEscape(parameterToString(r.endpointId, "")), -1)

	localVarHeaderParams := make(map[string]string)
	localVarQueryParams := _neturl.Values{}
	localVarFormParams := _neturl.Values{}
	if strlen(r.appId) < 1 {
		return nil, reportError("appId must have at least 1 elements")
	}
	if strlen(r.appId) > 256 {
		return nil, reportError("appId must have less than 256 elements")
	}
	if strlen(r.msgId) < 1 {
		return nil, reportError("msgId must have at least 1 elements")
	}
	if strlen(r.msgId) > 256 {
		return nil, reportError("msgId must have less than 256 elements")
	}
	if strlen(r.endpointId) < 1 {
		return nil, reportError("endpointId must have at least 1 elements")
	}
	if strlen(r.endpointId) > 256 {
		return nil, reportError("endpointId must have less than 256 elements")
	}

	// to determine the Content-Type header
	localVarHTTPContentTypes := []string{}

	// set Content-Type header
	localVarHTTPContentType := selectHeaderContentType(localVarHTTPContentTypes)
	if localVarHTTPContentType != "" {
		localVarHeaderParams["Content-Type"] = localVarHTTPContentType
	}

	// to determine the Accept header
	localVarHTTPHeaderAccepts := []string{"application/json"}

	// set Accept header
	localVarHTTPHeaderAccept := selectHeaderAccept(localVarHTTPHeaderAccepts)
	if localVarHTTPHeaderAccept != "" {
		localVarHeaderParams["Accept"] = localVarHTTPHeaderAccept
	}
	if r.idempotencyKey != nil {
		localVarHeaderParams["idempotency-key"] = parameterToString(*r.idempotencyKey, "")
	}
	req, err := a.client.prepareRequest(r.ctx, localVarPath, localVarHTTPMethod, localVarPostBody, localVarHeaderParams, localVarQueryParams, localVarFormParams, localVarFormFileName, localVarFileName, localVarFileBytes)
	if err != nil {
		return nil, err
	}

	localVarHTTPResponse, err := a.client.callAPI(req)
	if err != nil || localVarHTTPResponse == nil {
		return localVarHTTPResponse, err
	}

	localVarBody, err := _ioutil.ReadAll(localVarHTTPResponse.Body)
	localVarHTTPResponse.Body.Close()
	localVarHTTPResponse.Body = _ioutil.NopCloser(bytes.NewBuffer(localVarBody))
	if err != nil {
		return localVarHTTPResponse, err
	}

	if localVarHTTPResponse.StatusCode >= 300 {
		newErr := GenericOpenAPIError{
			body:  localVarBody,
			error: localVarHTTPResponse.Status,
		}
		if localVarHTTPResponse.StatusCode == 400 {
			var v HttpErrorOut
			err = a.client.decode(&v, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
			if err != nil {
				newErr.error = err.Error()
				return localVarHTTPResponse, newErr
			}
			newErr.model = v
			return localVarHTTPResponse, newErr
		}
		if localVarHTTPResponse.StatusCode == 401 {
			var v HttpErrorOut
			err = a.client.decode(&v, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
			if err != nil {
				newErr.error = err.Error()
				return localVarHTTPResponse, newErr
			}
			newErr.model = v
			return localVarHTTPResponse, newErr
		}
		if localVarHTTPResponse.StatusCode == 403 {
			var v HttpErrorOut
			err = a.client.decode(&v, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
			if err != nil {
				newErr.error = err.Error()
				return localVarHTTPResponse, newErr
			}
			newErr.model = v
			return localVarHTTPResponse, newErr
		}
		if localVarHTTPResponse.StatusCode == 404 {
			var v HttpErrorOut
			err = a.client.decode(&v, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
			if err != nil {
				newErr.error = err.Error()
				return localVarHTTPResponse, newErr
			}
			newErr.model = v
			return localVarHTTPResponse, newErr
		}
		if localVarHTTPResponse.StatusCode == 409 {
			var v HttpErrorOut
			err = a.client.decode(&v, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
			if err != nil {
				newErr.error = err.Error()
				return localVarHTTPResponse, newErr
			}
			newErr.model = v
			return localVarHTTPResponse, newErr
		}
		if localVarHTTPResponse.StatusCode == 422 {
			var v HTTPValidationError
			err = a.client.decode(&v, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
			if err != nil {
				newErr.error = err.Error()
				return localVarHTTPResponse, newErr
			}
			newErr.model = v
			return localVarHTTPResponse, newErr
		}
		if localVarHTTPResponse.StatusCode == 429 {
			var v HttpErrorOut
			err = a.client.decode(&v, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
			if err != nil {
				newErr.error = err.Error()
				return localVarHTTPResponse, newErr
			}
			newErr.model = v
		}
		return localVarHTTPResponse, newErr
	}

	return localVarHTTPResponse, nil
}
