<?php
/**
 * @copyright   &copy; 2005-2024 PHPBoost
 * @license     https://www.gnu.org/licenses/gpl-3.0.html GNU/GPL-3.0
 * @author      Julien BRISWALTER <j1.seth@phpboost.com>
 * @version     PHPBoost 6.0 - last update: 2021 12 01
 * @since       PHPBoost 4.0 - 2013 12 17
 * @contributor Julien BRISWALTER <j1.seth@phpboost.com>
 * @contributor Arnaud GENET <elenwii@phpboost.com>
 * @contributor Sebastien LARTIGUE <babsolune@phpboost.com>
*/

####################################################
#                    French                        #
####################################################

// Typogrphy
$lang['sandbox.typography']         = 'Typographie';
$lang['sandbox.component.titles']   = 'Titres';
$lang['sandbox.component.title']    = 'Titre';
$lang['sandbox.component.items']    = 'Éléments';
$lang['sandbox.component.item']     = 'Élément';

$lang['sandbox.sizes']                   = 'Tailles';
$lang['sandbox.component.item.smallest'] = 'Élément en très petit';
$lang['sandbox.component.item.smaller']  = 'Élément en plus petit';
$lang['sandbox.component.item.small']    = 'Élément en petit';
$lang['sandbox.component.item.big']      = 'Élément en grand';
$lang['sandbox.component.item.bigger']   = 'Élément en plus grand';
$lang['sandbox.component.item.biggest']  = 'Élément très grand';

$lang['sandbox.component.styles']              = 'Styles';
$lang['sandbox.component.item.bold']           = 'Élément en gras';
$lang['sandbox.component.item.italic']         = 'Élément en italique';
$lang['sandbox.component.item.underline']      = 'Élément souligné';
$lang['sandbox.component.item.strike']         = 'Élément barré';
$lang['sandbox.component.link']                = 'Lien hypertext';
$lang['sandbox.component.item.ellipsis']       = 'Élément tronqué';
$lang['sandbox.component.item.left']           = 'Élément aligné à gauche';
$lang['sandbox.component.item.center']         = 'Élément aligné au centre';
$lang['sandbox.component.item.right']          = 'Élément aligné à droite';
$lang['sandbox.component.item.float.left']     = 'Élément flottant à gauche';
$lang['sandbox.component.item.float.right']    = 'Élément flottant à droite';
$lang['sandbox.component.item.stretch.center'] = 'répartis';
$lang['sandbox.component.item.stretch.right']  = 'sur la largeur';
$lang['sandbox.component.item.pinned']         = 'Élément épinglé';
$lang['sandbox.component.item.stack.index']    = 'indexé';

$lang['sandbox.component.color']             = 'Couleurs';
$lang['sandbox.component.color.text']        = 'Couleur de texte';
$lang['sandbox.component.color.bgc']         = 'Couleur de fond transparente';
$lang['sandbox.component.color.bgc.full']    = 'Couleur de fond pleine';
$lang['sandbox.component.color.description'] = '
    <p>Pour la démo, les classes de couleurs sont montrées avec la classe <code class="language-css">.pinned</code> mais fonctionnent avec toute balise html.</p>
    <p>La couleur des bordures est prise en compte seulement si l\'élément en possède.</p>
';

// Media
$lang['sandbox.media']                   = 'Media';
$lang['sandbox.component.image']         = 'Images';
$lang['sandbox.component.caption.image'] = 'Image avec légende';
$lang['sandbox.component.lightbox']      = 'Lightbox';
$lang['sandbox.component.youtube']       = 'Youtube';
$lang['sandbox.component.movie']         = 'Vidéo';
$lang['sandbox.component.audio']         = 'Audio';

// Lists
$lang['sandbox.component.lists'] = 'Listes';

$lang['sandbox.component.progress.bar'] = 'Barre de progression';

$lang['sandbox.component.explorer'] = 'Explorateur';
$lang['sandbox.component.root']     = 'Racine';
$lang['sandbox.component.tree']     = 'Arborescence';
$lang['sandbox.component.cat']      = 'Catégorie';
$lang['sandbox.component.file']     = 'Fichier';

$lang['sandbox.component.notation']                 = 'Notation';
$lang['sandbox.component.notation.possible.values'] = 'Valeurs possibles';
$lang['sandbox.component.notation.example']         = 'Exemple pour une note de 2.4 sur 5';

$lang['sandbox.component.link.icon'] = 'Item avec icône';
$lang['sandbox.component.link.img']  = 'Item avec image';
$lang['sandbox.component.link']      = 'Item de Liste';
$lang['sandbox.component.panel']     = 'Panneau';
// Modal
$lang['sandbox.component.modal'] = 'Modal';

// Pagination
$lang['sandbox.component.pagination']      = 'Pagination';
$lang['sandbox.component.pagination.prev'] = 'Vers la première page';
$lang['sandbox.component.pagination.page'] = 'Vers la page';
$lang['sandbox.component.pagination.this'] = 'Page courrante';
$lang['sandbox.component.pagination.next'] = 'Vers la dernière page';

// Blockquote
$lang['sandbox.component.quote']    = 'Citation';
$lang['sandbox.component.code']     = 'Code';
$lang['sandbox.component.code.php'] = 'Code PHP';
$lang['sandbox.component.hidden']   = 'Élément caché';

// Tables
$lang['sandbox.component.table']                      = 'Tableaux';
$lang['sandbox.component.table.description']          = 'Description';
$lang['sandbox.component.table.description.content']  = 'Description du tableau';
$lang['sandbox.component.table.name']                 = 'Nom';
$lang['sandbox.component.table.caption']              = 'Description du tableau';
$lang['sandbox.component.table.caption.no.header']    = 'Ceci est un tableau sans entête';
$lang['sandbox.component.table.author']               = 'Auteur';
$lang['sandbox.component.table.test']                 = 'Test';
$lang['sandbox.component.table.header']               = 'Entête';
$lang['sandbox.component.table.sort.up']              = 'Croissant';
$lang['sandbox.component.table.sort.down']            = 'Décroissant';
$lang['sandbox.component.table.responsive.header']    = 'Tableau responsive avec entête';
$lang['sandbox.component.table.responsive.no.header'] = 'Tableau responsive sans entête';

// Message helper
$lang['sandbox.component.alert.messages']          = 'Messages d\'alerte';
$lang['sandbox.component.message.success']         = 'Ceci est un message de succès';
$lang['sandbox.component.message.notice']          = 'Ceci est un message d\'information';
$lang['sandbox.component.message.warning']         = 'Ceci est un message d\'avertissement';
$lang['sandbox.component.message.error']           = 'Ceci est un message d\'erreur';
$lang['sandbox.component.message.question']        = 'Ceci est une question:<br /> est-ce que l\'affichage sur deux lignes fonctionne correctement ?';
$lang['sandbox.component.message.member']          = 'Ceci est un message dont l\'affichage est limité aux membres';
$lang['sandbox.component.message.modo']            = 'Ceci est un message dont l\'affichage est limité aux modérateurs';
$lang['sandbox.component.message.admin']           = 'Ceci est un message dont l\'affichage est limité aux administrateurs';
$lang['sandbox.component.message.float.unlimited'] = 'Ceci est un message flottant sans limite de temps';
$lang['sandbox.component.message.float.limited']   = 'Ceci est un message flottant avec une limite de temps';
$lang['sandbox.component.message.float.display']   = 'Afficher les messages éphémères';

// Tooltips
$lang['sandbox.component.tooltip']        = 'Tooltip';
$lang['sandbox.component.tooltip.custom'] = 'Tooltip personnalisé';
$lang['sandbox.component.tooltip.clue'] = '
    Un "tooltip" est une description indexée à un élément qui est cachée par défaut et qui apparait au survol de l\'élément (les exemples suivants sont montrés avec la classe <code class="language-css">.pinned</code>). <br />
    Par défaut, dans PHPBoost le tooltip s\'applique à toute balise possédant un attribut <code class="language-html">aria-label</code>.
';
$lang['sandbox.component.tooltip.eg.basic'] = 'Au survol, la description déclarée dans l\'attribut aria-label apparait.';
$lang['sandbox.component.tooltip.label.basic'] = '
    Ce plugin supporte les balises html sans attribut dans la description.
    <br /><br />saut de ligne<br /><br />
    paragraphe<p>Lorem ipsum dolor sit amet, consectetur adipisicing elit. Similique, enim.</p>
    <i>Texte en italique</i>
    <br />etc
';
$lang['sandbox.component.tooltip.options'] = '
    Au survol, la description déclarée dans l\'attribut aria-label est remplacée par un texte alternatif
    et des options ont été ajoutées.
';
$lang['sandbox.component.tooltip.eg.options']  = 'Au survol un texte alternatif avec des options apparait à la place du contenu de l\'aria-label';
$lang['sandbox.component.tooltip.alt.options'] = 'Texte alternatif avec des options';
$lang['sandbox.component.tooltip.options'] = '
    Options: <br />
    <code class="language-markup">data-tooltip</code> pour ajouter un texte alternatif <br />
    <code class="language-markup">data-tooltip-pos</code> pour forcer la position du tooltip (top|right|bottom|left) <br />
    <code class="language-markup">data-tooltip-class</code> pour ajouter des class de personnalisation ("display-none" pour ne pas afficher le tooltip mais laisser le aria-label)<br />
';
?>
