<?php
/**
 * @copyright   &copy; 2005-2024 PHPBoost
 * @license     https://www.gnu.org/licenses/gpl-3.0.html GNU/GPL-3.0
 * @author      Julien BRISWALTER <j1.seth@phpboost.com>
 * @version     PHPBoost 6.0 - last update: 2021 12 01
 * @since       PHPBoost 4.0 - 2013 12 17
 * @contributor Julien BRISWALTER <j1.seth@phpboost.com>
 * @contributor Arnaud GENET <elenwii@phpboost.com>
 * @contributor Sebastien LARTIGUE <babsolune@phpboost.com>
*/

####################################################
#                    English                       #
####################################################

// Typogrphie
$lang['sandbox.typography']         = 'Typography';
$lang['sandbox.component.titles']   = 'Titles';
$lang['sandbox.component.title']    = 'Title';
$lang['sandbox.component.items']    = 'Elements';
$lang['sandbox.component.item']     = 'Element';

$lang['sandbox.sizes']                   = 'Text Sizes';
$lang['sandbox.component.item.smallest'] = 'Smallest text';
$lang['sandbox.component.item.smaller']  = 'Smaller text';
$lang['sandbox.component.item.small']    = 'Small text';
$lang['sandbox.component.item.big']      = 'Big text';
$lang['sandbox.component.item.bigger']   = 'Bigger text';
$lang['sandbox.component.item.biggest']  = 'Biggest text';

$lang['sandbox.component.styles']              = 'Styles';
$lang['sandbox.component.item.bold']           = 'Bold text';
$lang['sandbox.component.item.italic']         = 'Italic text';
$lang['sandbox.component.item.underline']      = 'Underline text';
$lang['sandbox.component.item.strike']         = 'Strike text';
$lang['sandbox.component.link']                = 'Hypertext link';
$lang['sandbox.component.item.ellipsis']       = 'Ellipsis element';
$lang['sandbox.component.item.left']           = 'Left aligned element';
$lang['sandbox.component.item.center']         = 'Center aligned element';
$lang['sandbox.component.item.right']          = 'Right aligned element';
$lang['sandbox.component.item.float.left']     = 'Floating left element';
$lang['sandbox.component.item.float.right']    = 'Floating right element';
$lang['sandbox.component.item.stretch.center'] = 'justify';
$lang['sandbox.component.item.stretch.right']  = 'on width';
$lang['sandbox.component.item.pinned']         = 'Pinned element';
$lang['sandbox.component.item.stack.index']    = 'Element with index';

$lang['sandbox.component.color']             = 'Colors';
$lang['sandbox.component.color.text']        = 'Text color';
$lang['sandbox.component.color.bgc']         = 'Transparent background color';
$lang['sandbox.component.color.bgc.full']    = 'Plain background color';
$lang['sandbox.component.color.description'] = '
    <p>For the demo, color classes are shown with the <code class="language-css">.pinned</code> class and can match to any html tag .</p>
    <p>Borders are colored only if the element has some.</p>
';

// Media
$lang['sandbox.media']                   = 'Media';
$lang['sandbox.component.image']         = 'Pictures';
$lang['sandbox.component.caption.image'] = 'Picture with caption';
$lang['sandbox.component.lightbox']      = 'Lightbox';
$lang['sandbox.component.youtube']       = 'Youtube';
$lang['sandbox.component.movie']         = 'Video';
$lang['sandbox.component.audio']         = 'Audio';

// Lists
$lang['sandbox.component.lists'] = 'Lists';

$lang['sandbox.component.progress.bar'] = 'Progress bar';

$lang['sandbox.component.explorer'] = 'Explorer';
$lang['sandbox.component.root']     = 'Root';
$lang['sandbox.component.tree']     = 'Tree';
$lang['sandbox.component.cat']      = 'Category';
$lang['sandbox.component.file']     = 'File';

$lang['sandbox.component.notation']                 = 'Notation';
$lang['sandbox.component.notation.possible.values'] = 'Possible values';
$lang['sandbox.component.notation.example']         = 'Example for a rating of 2.4 on 5';

$lang['sandbox.component.link.icon'] = 'Item with icon';
$lang['sandbox.component.link.img']  = 'Item with picture';
$lang['sandbox.component.link']      = 'Item de Liste';
$lang['sandbox.component.panel']     = 'Panel';
// Modal
$lang['sandbox.component.modal'] = 'Modal';

//Pagination
$lang['sandbox.component.pagination']      = 'Pagination';
$lang['sandbox.component.pagination.prev'] = 'Vers la première page';
$lang['sandbox.component.pagination.page'] = 'Vers la page';
$lang['sandbox.component.pagination.this'] = 'Page courrante';
$lang['sandbox.component.pagination.next'] = 'Vers la dernière page';

//Blockquote
$lang['sandbox.component.quote']    = 'Quote';
$lang['sandbox.component.code']     = 'Code';
$lang['sandbox.component.code.php'] = 'PHP code';
$lang['sandbox.component.hidden']   = 'Hidden text';

//Tables
$lang['sandbox.component.table']                      = 'Tables';
$lang['sandbox.component.table.description']          = 'Description';
$lang['sandbox.component.table.description.content']  = 'Table description';
$lang['sandbox.component.table.name']                 = 'Name';
$lang['sandbox.component.table.caption']              = 'This is a table';
$lang['sandbox.component.table.caption.no.header']    = 'This is a table with no header';
$lang['sandbox.component.table.author']               = 'Author';
$lang['sandbox.component.table.test']                 = 'Test';
$lang['sandbox.component.table.header']               = 'Header';
$lang['sandbox.component.table.sort.up']              = 'Sort up';
$lang['sandbox.component.table.sort.down']            = 'Sort down';
$lang['sandbox.component.table.responsive.header']    = 'Responsive table with header';
$lang['sandbox.component.table.responsive.no.header'] = 'Responsive table without header';

$lang['sandbox.component.alert.messages']          = 'Alert messages';
$lang['sandbox.component.message.success']         = 'This is a success message';
$lang['sandbox.component.message.notice']          = 'This is a notice message';
$lang['sandbox.component.message.warning']         = 'This is a warning message';
$lang['sandbox.component.message.error']           = 'This is a error message';
$lang['sandbox.component.message.question']        = 'This is a question:<br /> is the two-lines display working correctly?';
$lang['sandbox.component.message.member']          = 'This is a message limited to members';
$lang['sandbox.component.message.modo']            = 'This is a message limited to moderators';
$lang['sandbox.component.message.admin']           = 'This is a message limited to administrators';
$lang['sandbox.component.message.float.unlimited'] = 'This is a floating message without time limit';
$lang['sandbox.component.message.float.limited']   = 'This is a floating message with time limit';
$lang['sandbox.component.message.float.display']   = 'Display floating messages';

// Tooltips
$lang['sandbox.component.tooltip']        = 'Tooltip';
$lang['sandbox.component.tooltip.custom'] = 'Customized tooltip';
$lang['sandbox.component.tooltip.clue'] = '
    A tooltip is a description indexed to an element witch is hidden by deault and been revealed on hover the element (The following examples are shown with the <code class="language-css">.pinned</code> class). <br />
    By default in PHPBoost the tooltips are applied to all elements with <code class="language-html">aria-label</code> attribute.
';
$lang['sandbox.component.tooltip.eg.basic']    = 'On hover, the description setted in the aria-label is revealed.';
$lang['sandbox.component.tooltip.label.basic'] = '
    This plugin allows html tag without attributes.
    <br /><br />line break<br /><br />
    paragraphe<p>Lorem ipsum dolor sit amet, consectetur adipisicing elit. Similique, enim.</p>
    <i>Italics</i>
    <br />etc
';
$lang['sandbox.component.tooltip.options'] = '
    On hover the aria-label description is replaced by aternative text and options have been added.
';
$lang['sandbox.component.tooltip.eg.options']  = 'On hover, alternative text with options is shown instead of aria-label description';
$lang['sandbox.component.tooltip.alt.options'] = 'Alternatif text with options';
$lang['sandbox.component.tooltip.options'] = '
    Options: <br />
    <code class="language-markup">data-tooltip</code> to add alternative text <br />
    <code class="language-markup">data-tooltip-pos</code> to force position of the tooltip (top|right|bottom|left) <br />
    <code class="language-markup">data-tooltip-class</code> to add custom classes ("display-none" to keep aria-label but hide the tooltip)<br />
';
?>
