<?php
/**
 * @copyright   &copy; 2005-2024 PHPBoost
 * @license     https://www.gnu.org/licenses/gpl-3.0.html GNU/GPL-3.0
 * @author      Kevin MASSY <reidlos@phpboost.com>
 * @version     PHPBoost 6.0 - last update: 2024 03 13
 * @since       PHPBoost 3.0 - 2012 04 12
 * @contributor Julien BRISWALTER <j1.seth@phpboost.com>
 * @contributor Arnaud GENET <elenwii@phpboost.com>
 * @contributor mipel <mipel@phpboost.com>
 * @contributor xela <xela@phpboost.com>
 * @contributor Sebastien LARTIGUE <babsolune@phpboost.com>
*/

####################################################
#                     French                       #
####################################################

// Common
$lang['addon.multiple.select']     = 'Gestion multiple';
$lang['addon.multiple.install']    = 'Installer la sélection';
$lang['addon.multiple.uninstall']  = 'Désinstaller la sélection';
$lang['addon.multiple.enable']     = 'Activer la sélection';
$lang['addon.multiple.disable']    = 'Désactiver la sélection';
$lang['addon.multiple.upgrade']    = 'Mettre à jour la sélection';
$lang['addon.install']             = 'Installer';
$lang['addon.uninstall']           = 'Désinstaller';
$lang['addon.compatible']          = 'Compatible';
$lang['addon.not.compatible']      = 'Incompatible';
$lang['addon.compatibility']       = 'Compatibilité';
$lang['addon.authorizations']      = 'Autorisations';
$lang['addon.authorizations.save'] = 'Sauvegarder les autorisations';
$lang['addon.upload.clue']         = 'L\'archive uploadée doit être au format <span class="text-strong">zip ou gzip</span> et ne doit pas dépasser <span class="text-strong">:max_size</span>. En cas de dépassement, déposez le dossier extrait de l\'archive :addon de votre site sur votre FTP.';

// Langs
$lang['addon.langs.directory']       = 'dans le dossier <span class ="text-strong pinned question">lang</span>';
$lang['addon.langs']                 = 'Langues';
$lang['addon.langs.management']      = 'Gestion des langues';
$lang['addon.langs.add']             = 'Ajouter une langue';
$lang['addon.langs.delete']          = 'Suppression d\'une langue';
$lang['addon.langs.delete.multiple'] = 'Suppression des langues sélectionnées';
$lang['addon.langs.installed']       = 'Langues installées';
$lang['addon.langs.available']       = 'Langues disponibles';
$lang['addon.langs.default']         = 'Langue par défaut';
$lang['addon.langs.default.auth']    = 'La langue par défaut est visible par tout le monde';
$lang['addon.langs.select.all']      = 'Selectionner toutes les langues';
    // Warnings
$lang['addon.langs.warning.delete']  = 'Une langue doit être activée, désactivée ou supprimée uniquement depuis cette page.<br />En aucun cas il ne faut intervenir sur le FTP et/ou dans la base de données.';
$lang['addon.langs.warning.install'] = 'Les langues ajoutées sont automatiquement activées. Pensez à les désactiver si besoin.';
$lang['addon.langs.not.lang']        = 'Ce dossier n\'est pas un dossier de langue.';
    // Upload
$lang['addon.langs.upload']      = 'Uploader une langue';
    // Drop
$lang['addon.langs.drop']          = 'Supprimer tous les fichiers de la langue';
$lang['addon.langs.drop.multiple'] = 'Supprimer tous les fichiers des langues';
$lang['addon.langs.default.clue']  = 'La langue par défaut ne peut pas être désinstallée, désactivée ou réservée';

// Modules
$lang['addon.modules.directory']       = 'à la <span class ="text-strong pinned question">racine</span>';
$lang['addon.modules']                 = 'Modules';
$lang['addon.modules.management']      = 'Gestion des modules';
$lang['addon.modules.add']             = 'Ajouter un module';
$lang['addon.modules.update']          = 'Mettre à jour un module';
$lang['addon.modules.delete']          = 'Suppression d\'un module';
$lang['addon.modules.delete.multiple'] = 'Suppression de modules';
$lang['addon.modules.installed']       = 'Modules installés';
$lang['addon.modules.available']       = 'Modules disponibles';
$lang['addon.modules.select.all']      = 'Sélectionner tous les modules';
$lang['addon.modules.no.icon']         = 'Aucune icône';
    // Warnings
$lang['addon.modules.warning.delete']  = 'Un module doit être activé, désactivé ou supprimé uniquement depuis cette page. <br />En aucun cas il ne faut intervenir sur le FTP et/ou dans la base de données.';
$lang['addon.modules.warning.install'] = 'Les modules ajoutés sont automatiquement activés. Pensez à les désactiver si besoin.';
$lang['addon.modules.warning.update']  = 'Les modules mis à jour sont automatiquement activés. Pensez à les désactiver si besoin.';
$lang['addon.modules.not.module']      = 'Ce dossier n\'est pas un dossier de module.';
    // Upload
$lang['addon.modules.upload']      = 'Uploader un module';
    // Module
$lang['addon.modules.php.version']   = 'Version PHP';
$lang['addon.modules.documentation'] = 'Documentation';
    // Messages helper
$lang['addon.modules.already.installed'] = 'Ce module est déjà installé';
$lang['addon.modules.not.upgradable']    = 'Ce module ne peut pas être mis à jour';
$lang['addon.modules.not.installed']     = 'Ce module n\'est pas installé !';
$lang['addon.modules.available.updates'] = 'Mises à jour disponibles';
$lang['addon.modules.config.conflict']   = 'Conflit avec la configuration du module, installation impossible!';
$lang['addon.modules.not.compatible']    = 'Ce module n\'est pas compatible avec la version actuelle de PHPBoost vérifiez la disponibilité d\'une nouvelle version sur <a class="offload" href="https://www.phpboost.com/download">le site de PHPBoost</a>.';
    // Drop
$lang['addon.modules.drop']          = 'Supprimer tous les fichiers du module';
$lang['addon.modules.drop.multiple'] = 'Supprimer tous les fichiers des modules';
    // Upgrade
$lang['addon.modules.upgrade']     = 'Mettre à jour';
$lang['addon.modules.upgrade.all'] = 'Mettre à jour les modules sélectionnés';

// Themes
$lang['addon.themes.directory']       = 'dans le dossier <span class ="text-strong pinned question">templates</span>';
$lang['addon.themes']                 = 'Thèmes';
$lang['addon.themes.management']      = 'Gestion des thèmes';
$lang['addon.themes.add']             = 'Ajouter un thème';
$lang['addon.themes.delete']          = 'Suppression d\'un thème';
$lang['addon.themes.delete.multiple'] = 'Suppression des thèmes sélectionnés';
$lang['addon.themes.installed']       = 'Thèmes installés';
$lang['addon.themes.available']       = 'Thèmes disponibles';
$lang['addon.themes.default']         = 'Thème par défaut';
$lang['addon.themes.default.clue']    = 'Le thème par défaut ne peut pas être désinstallé, désactivé ou réservé';
$lang['addon.themes.default.auth']    = 'Le thème par défaut est visible par tout le monde';
$lang['addon.themes.select.all']      = 'Sélectionner tous les thèmes';
    // Theme
$lang['addon.themes.html.version']      = 'Version HTML';
$lang['addon.themes.css.version']       = 'Version CSS';
$lang['addon.themes.main.color']        = 'Couleurs dominantes';
$lang['addon.themes.variable.width']    = 'Extensible';
$lang['addon.themes.width']             = 'Largeur';
$lang['addon.themes.parent.theme']      = 'Thème parent';
$lang['addon.themes.bot.informed']      = 'Non précisé';
$lang['addon.themes.view.real.preview'] = 'Voir en taille réelle';
    // Warnings
$lang['addon.themes.warning.delete']             = 'Un thème doit être activé, désactivé ou supprimé uniquement depuis cette page.<br />En aucun cas il ne faut intervenir sur le FTP et/ou dans la base de données.';
$lang['addon.themes.warning.install']            = 'Les thèmes ajoutés sont automatiquement activés. Pensez à les désactiver si besoin.';
$lang['addon.themes.warning.default']            = 'Le thème par défaut ne peut pas être désinstallé';
$lang['addon.themes.warning.version']            = 'La version PHPBoost de ce thème n\'est pas compatible avec la version PHPBoost du site';
$lang['addon.themes.parent.theme.not.installed'] = 'Le thème parent (<b>:id_parent</b>) de ce thème n\'est pas installé, veuillez l\'installer avant de pouvoir installer celui-ci';
$lang['addon.themes.default.parent.theme']       = 'Le thème <b>:name</b> est le parent du thème par défaut du site (<b>:default_theme</b>), il ne peut pas être désinstallé';
$lang['addon.themes.warning.childs.list']        = 'Les thèmes <b>:themes_names</b>, enfants du thème <b>:name</b> vont également être désinstallés';
$lang['addon.themes.warning.child']              = 'Le thème <b>:theme_name</b>, enfant du thème <b>:name</b> va également être désinstallé';
$lang['addon.themes.not.theme']                  = 'Ce dossier n\'est pas un dossier de thème.';
    // Upload
$lang['addon.themes.upload'] = 'Uploader un thème';
    // Drop
$lang['addon.themes.drop']          = 'Supprimer tous les fichiers du thème';
$lang['addon.themes.drop.multiple'] = 'Supprimer tous les fichiers des thèmes';
?>
