<?php
/**
 * @package     PHPBoost
 * @subpackage  Stats
 * @copyright   &copy; 2005-2024 PHPBoost
 * @license     https://www.gnu.org/licenses/gpl-3.0.html GNU/GPL-3.0
 * @author      Kevin MASSY <reidlos@phpboost.com>
 * @version     PHPBoost 6.0 - last update: 2024 06 22
 * @since       PHPBoost 3.0 - 2011 09 27
 * @contributor Julien BRISWALTER <j1.seth@phpboost.com>
 * @contributor Sebastien LARTIGUE <babsolune@phpboost.com>
*/

class Countries
{
	private static $countries = array();
	private static $pictures_path = '/images/stats/countries/';
	private static $pictures_extension = '.png';
	private static $countries_identifier = array(
		'ad', 'ae', 'af', 'ag', 'ai', 'al', 'am', 'an', 'ao', 'aq', 'ar', 'as', 'at', 'au', 'aw', 'az',
        'ba', 'bb', 'bd', 'be', 'bf', 'bg', 'bh', 'bi', 'bj', 'bm', 'bn', 'bo', 'br', 'bs', 'bt', 'bv', 'bw', 'by', 'bz',
        'ca', 'cc', 'cd', 'cf', 'cg', 'ch', 'ci', 'ck', 'cl', 'cm', 'cn', 'co', 'cr', 'cu', 'cv', 'cx', 'cy', 'cz',
        'de', 'dj', 'dk', 'dm', 'do', 'dz',
        'ec', 'ee', 'eg', 'eh', 'er', 'es', 'et',
        'fe', 'fi', 'fj', 'fk', 'fm', 'fo', 'fr', 'fs', 'fw',
        'ga', 'gd', 'ge', 'gf', 'gg', 'gh', 'gi', 'gl', 'gm', 'gn', 'gp', 'gq', 'gr', 'gs', 'gt', 'gu', 'gw', 'gy',
        'hk', 'hm', 'hn', 'hr', 'ht', 'hu',
        'id', 'ie', 'il', 'im', 'in', 'io', 'iq', 'ir', 'is', 'it',
        'je', 'jm', 'jo', 'jp',
        'ke', 'kg', 'kh', 'ki', 'km', 'kn', 'kp', 'kr', 'kw', 'ky', 'kz',
        'la', 'lb', 'lc', 'li', 'lk', 'lr', 'ls', 'lt', 'lu', 'lv', 'ly',
        'ma', 'mc', 'md', 'mg', 'mh', 'mk', 'ml', 'mm', 'mn', 'mo', 'mp', 'mq', 'mr', 'ms', 'mt', 'mu', 'mv', 'mw', 'mx', 'my', 'mz',
        'na', 'nc', 'ne', 'nf', 'ng', 'ni', 'nl', 'no', 'np', 'nr', 'nu', 'nz',
        'om',
		'pa', 'pe', 'pf', 'pg', 'ph', 'pk', 'pl', 'pm', 'pn', 'pr', 'ps', 'pt', 'pw', 'py',
        'qa',
        're', 'ro', 'ru', 'rs', 'rw',
        'sa', 'sb', 'sc', 'sd', 'se', 'sg', 'sh', 'si', 'sj', 'sk', 'sl', 'sm', 'sn', 'so', 'sr', 'st', 'sv', 'sy', 'sz',
        'tc', 'td', 'tf', 'tg', 'th', 'tj', 'tk', 'tm', 'tn', 'to', 'tp', 'tr', 'tt', 'tv', 'tw', 'tz',
        'ua', 'ug', 'uk', 'gb', 'um', 'us', 'uy', 'uz',
        'va', 'vc', 've', 'vg', 'vi', 'vn', 'vu',
        'wf', 'ws',
        'ye', 'yt',
        'za', 'zm', 'zw',
        'other'
	);

	public static function __static()
	{
		if (empty(self::$countries))
		{
			self::build_countries();
		}
	}

	public static function get_countries()
	{
        usort(self::$countries, function($a, $b) {
            return strcmp($a["name"], $b["name"]);
        });
		return self::$countries;
	}

	public static function get_country($identifier)
	{
		if (self::is_available($identifier))
		{
			return self::$countries[$identifier];
		}
		throw new Exception($identifier . ' not available');
	}

	public static function is_available($identifier)
	{
		return in_array($identifier, self::$countries_identifier);
	}

	private static function build_countries()
	{
		$lang = LangLoader::get_all_langs();
		foreach (self::$countries_identifier as $country_identifier)
		{
			self::$countries[$country_identifier] = array(
				'name' => $lang[$country_identifier],
				'picture' => self::$pictures_path . $country_identifier . self::$pictures_extension
			);
		}
	}
}
?>
