<?php
/**
 *
 * @package    mahara
 * @subpackage core
 * @author     Catalyst IT Limited <mahara@catalyst.net.nz>
 * @license    https://www.gnu.org/licenses/gpl-3.0.html GNU GPL version 3 or later
 * @copyright  For copyright information on Mahara, please see the README file distributed with this software.
 *
 */

/**
 * CONFIGURATION DEFAULTS
 *
 * Do Not Edit This File!
 *
 * If you see a setting in here you'd like to change, copy it to your
 * config.php and change it there.
 *
 * This file sets defaults that are useful for most people.
 */

$cfg = new stdClass();

/**
 * @global int $cfg->directorypermissions what permissions to use for files and directories in
 * dataroot. The default allows only the web server user to read the data. If
 * you're on shared hosting and might want to download the contents of your
 * dataroot later (e.g. for backup purposes), set this to 0755. Otherwise,
 * leave it as is!
 */
//$cfg->directorypermissions = 0700;

/**
 * @global bool $cfg->insecuredataroot whether to enforce checking that files being served have
 * come from dataroot. You would only want to turn this on if you were running
 * more than one Mahara against the same dataroot. If you are doing that, make
 * sure you create separate dataroots for each installation, but symlink the
 * artefact directory from all of them to one of them, and turn on
 * 'insecuredataroot' on all the ones you created symlinks for.
 *
 * If you don't know what you're doing/didn't understand the paragraph above,
 * then leave this setting alone!
 */
//$cfg->insecuredataroot = false;

/**
 * @global string $cfg->noreplyaddress system mail address. emails out come from this address.
 * if not specified, will default to noreply@ automatically detected host.
 * if that doesn't work or you want something else, then specify it here.
 */
// $cfg->noreplyaddress = 'noreply@myhost.com';

/**
 * Logging configuration
 * @global int $cfg->log_dbg_targets Where to log debugging messages
 * @global int $cfg->log_info_targets Where to log informational messages
 * @global int $cfg->log_warn_targets Where to log warnings
 * @global int $cfg->log_environ_targets Where to log environment errors
 * For each log level, you can specify where the messages are displayed.
 *
 * LOG_TARGET_SCREEN makes the error messages go to the screen - useful
 * when debugging but not on a live site!
 * LOG_TARGET_ADMIN sends error messages to the screen but only when
 * browsing in the admin section
 * LOG_TARGET_ERRORLOG makes the error messages go to the log as specified
 * by the apache ErrorLog directive. It's probably useful to have this on
 * for all log levels.
 * LOG_TARGET_FILE allows you to specify a file that messages will be logged
 * to. It's best to pick a path in dataroot, but note that logfiles tend to get
 * very large over time - so it's advisable to implement some kind of logrotate
 * if you want to leave this on all the time. The other option is to just turn
 * this on when you are getting some kind of error or want to see the logging,
 * and know that you're not going to let the logfile get large.
 *
 * You can combine the targets with bitwise operations,
 * e.g. LOG_TARGET_SCREEN | LOG_TARGET_ERRORLOG
 *
 * This configuration is suitable for people running Mahara for the first
 * time. You will immediately see environment errors, and so can correct
 * them. You will be able to see other debugging information in your error
 * logs. Once your site is up and running you might want to remove the
 * environment level logging completely, and just log everything else to
 * the error log.
 */
$cfg->log_dbg_targets     = LOG_TARGET_ERRORLOG;
$cfg->log_info_targets    = LOG_TARGET_ERRORLOG;
$cfg->log_warn_targets    = LOG_TARGET_ERRORLOG;
$cfg->log_environ_targets = LOG_TARGET_SCREEN | LOG_TARGET_ERRORLOG;
/**
 * This configuration is suitable for developers. You will see all errors
 * and they will also be in the logs.
 */
//$cfg->log_dbg_targets     = LOG_TARGET_SCREEN | LOG_TARGET_ERRORLOG;
//$cfg->log_info_targets    = LOG_TARGET_SCREEN | LOG_TARGET_ERRORLOG;
//$cfg->log_warn_targets    = LOG_TARGET_SCREEN | LOG_TARGET_ERRORLOG;
//$cfg->log_environ_targets = LOG_TARGET_SCREEN | LOG_TARGET_ERRORLOG;

/**
 * @global string $cfg->log_file: If you use LOG_TARGET_FILE, this is the file that errors will be logged to.
 * By default, it will write to the file 'error.log' under dataroot. If you
 * change this in config.php, make sure you use a folder which is writable by
 * the webserver.
 */
// $cfg->log_file = '/path/to/dataroot/error.log';

/**
 * @global int $cfg->log_backtrace_levels The log levels that will generate backtraces. Useful for development,
 * but probably only warnings are useful on a live site.
 */
$cfg->log_backtrace_levels = LOG_LEVEL_WARN | LOG_LEVEL_ENVIRON;


/**
 * @global boolean $cfg->log_backtrace_print_args Whether or not to print the values of function & method
 * arguments when printing a backtrace. This can be useful for debugging, but it is a mild security risk,
 * because function parameters may include sensitive data such as passwords and private keys. (Though
 * arguments whose names suggest that they contain passwords, will still be blanked out even if this
 * feature is enabled.)
 *
 * A NULL value here tells Mahara to hide argument values when $cfg->productionmode is enabled, and to
 * show them otherwise. A TRUE or FALSE tells Mahara to always show/hide argument values in backtraces
 * regardless of the value of $cfg->productionmode.
 */
$cfg->log_backtrace_print_args = null;

/**
 * @global int $cfg->error_reporting What level of errors to print to the Mahara logs. Gets passed directly
 * to the PHP function "error_reporting()".
 *
 * NOTE: There are some limitations in this method, because it doesn't get called until several scripts
 * have already been compiled: init.php, config.php, config-defaults.php, errors.php, and the file directly
 * invoked in the URL. So, compile-time errors in those files (which includes most strict errors) will be
 * unaffected by this setting.
 */
$cfg->error_reporting = E_ALL & ~E_STRICT;

/**
 * @global bool $cfg->sendemail Whether to send e-mail. If set to false, Mahara will not send any e-mail at
 * all. This is useful for when setting up development versions of Mahara where
 * you don't want to accidentally send email to users from this particular
 * Mahara installation.
 */
$cfg->sendemail = true;
/**
 * @global string $cfg->sendallemailto You can use sendallemailto to have all e-mails from this instance of Mahara
 * sent to one particular address instead of where they're aimed for. Leave
 * sendemail = true if you want to use this setting.
 */
// $cfg->sendallemailto = 'you@example.com';

/**
 * @global string $cfg->emaillog Log basic details of emails sent out by Mahara.  Must be writable by the
 * webserver user.  This will get big.
 */
// $cfg->emaillog = '/path/to/dataroot/email.log';

/**
 * @global bool $cfg->perftolog capture performance information and print it
 * @global bool $cfg->perftofoot needs a call to mahara_performance_info (smarty callback) - see default theme's footer.tpl
 * if neither are set, performance info won't be captured.
 */
// $cfg->perftolog = true;
// $cfg->perftofoot = true;

/**
 * Mail handling
 *
 * Unless you have a specific reason for having mail settings in the config file,
 * please use Configure Site -> Site options -> Email interface.
 *
 * @global string $cfg->smpthosts If you want mahara to use SMTP servers to send mail, enter one or more here
 * blank means mahara will use the default PHP method.
 */
// $cfg->smtphosts = 'smtp1.example.com;smtp2.example.com';
/**
 * @global int $cfg->smtpport If smtp server uses port number different from 25 (e.g. for secure connections,
 * port 465 is usually used with ssl, port 587 is usually used with tls),
 * specify it below. Alternatively you may specify the port in smtphosts
 * definition above using format [hostname:port] (e.g. 'smtp1.example.com:465').
 */
// $cfg->smtpport = 25;
/**
 * @global string $cfg->smtpuser If you have specified an smtp server above, and the server requires
 * authentication, enter user credentials here:
 * @global string $cfg->smptpass Password to match the user in $cfg->smtpuser
 */
// $cfg->smtpuser = '';
// $cfg->smtppass = '';
/**
 * @global string $cfg->smtpsecure If smtp server requires secure connection, specify the protocol type below.
 * Valid options are '', 'ssl' or 'tls'. Setting it to '' or leaving the line
 * commented means that secure connection will not be used.
 */
// $cfg->smtpsecure = '';

/**
 * @global bool $cfg->smtpverifypeer indicates if peer verification is required
 * when sending email to an external mail host. Normally this setting should be
 * true, but it may be necessary to set to false if the external mail server
 * has a certificate with a common name that does not match the server name.
 *
 * This setting should only be changed if you both require it and understand
 * the potential security implications.
 */
$cfg->smtpverifypeer = true;

/**
 * @global bool $cfg->smtpallowselfsigned indicates if accepting a self signed
 * certificate is allowed when sending mail to an external mail host. Normally
 * this setting should be false, but the external mail host must be used and it
 * has a self signed cert this will allow that.
 *
 * This setting should only be changed if you both require it and understand
 * the potential security implications.
 */
$cfg->smtpallowselfsigned = false;

/**
 * Variable Envelope Return Path Handling
 * @global bool $cfg->bounces_handle If you want mahara to keep track of email addresses which generate a
 * bounce, set bounces_handle to true.
 * If set to true, $cfg->bouncedomain *must* be set.
 */
$cfg->bounces_handle  = false;
/**
 * @global int $cfg->bounces_min Rather than disable an email address on the first bounce message,
 * require bounces_min bounces.
 */
$cfg->bounces_min     = 5;
/**
 * @global number $cfg->bounces_ratio Require at least (bounces_ratio*100)% of sent mail to be bounced back
 * before disabling mail for that user.
 * e.g. If using the default bounces_ratio of 0.20 and 20 mails are sent to
 * a user, at least 4 must be returned before email is disabled.
 * (Set this to 0 to ignore bounces_ratio and rely solely on bounces_min)
 */
$cfg->bounces_ratio   = 0.20;
/**
 * @global string $cfg->bounceprefix Identity of the Mahara instance
 * If you have several Mahara, Moodle, or other VERP processors on the same
 * bounce domain, you need to keep track of which processor belongs to
 * which domain.
 */
$cfg->bounceprefix    = 'AAA-';
/**
 * @global string $cfg->bouncedomain The domainpart of the generated VERP domain. e.g.
 * <localpart>@$cfg->bouncedomain
 * This must be set for VERP handling to take effect
 */
//$cfg->bouncedomain    = '';

/**
 * @global number $cfg->bounces_resetdays number of days before resetting the
 * emailsent and emailbounced values for each email
 */
 $cfg->bounces_resetdays = 30;

/**
 * @global string $cfg->imapserver The imap server to check for bounced emails
 * @global int $cfg->imapport The port for the imap server
 */
//$cfg->imapserver  = 'localhost';
//$cfg->imapport    = 143;
/**
 * @global string $cfg->imapuser The imap username to authenticate
 * @global string $cfg->imappass The imap password to authenticate
 */
//$cfg->imapuser    = '';
//$cfg->imappass    = '';
/**
 * @global string $cfg->imapflags Any flags to pass to imap_open, can have multiple
 * See https://www.php.net/manual/en/function.imap-open.php
 */
//$cfg->imapflags   = '';
/**
 * @global string $cfg->imapmailbox Which mailbox to poll, defaults to INBOX
 */
//$cfg->imapmailbox = 'INBOX.someotherbox';
/**
 * You can even set the library to check pop mail boxes
 */
//$cfg->imapflags   = '/pop3';
//$cfg->imapport    = 110;

/**
 * maximum allowed size of uploaded images
 * @global int $cfg->imagemaxwidth
 * @global int $cfg->imagemaxheight
 * NOTE: the scalable resize might result in images with one dimesion larger than one of these sizes, but not both
 */
$cfg->imagemaxwidth = 1170;
$cfg->imagemaxheight = 1170;
/**
 * @global int $cfg->maximageresizememory Maximum allowed memory usage for thumbnail generation (approximate)
 */
$cfg->maximageresizememory = 104857600;

/**
 * @global $cfg->pathtoclam The path to the ClamAV executable (clamscan or clamdscan); disabled by default
 */
$cfg->pathtoclam = '';

/**
 * @global mixed $cfg->pathtomagicdb Set this value to specify where the PHP fileinfo "magic" DB is.
 *
 * If this value is NULL, Mahara will attempt to use PHP's internal magic db, or to
 * autolocate your system's magic DB.
 */
$cfg->pathtomagicdb = NULL;

/**
 * @global string $cfg->unziptempdir some shared hosts have restrictions on where unzip can be used
 * dataroot is often not allowed; but /tmp is. This path should end with a "/"
 * Note that if there is more than one mahara on this host using this setting
 * you must change this to something unique, eg /tmp/mahara1/ and /tmp/mahara2/
 */
// $cfg->unziptempdir = '/tmp/mahara/';
/**
 * @global string $cfg->sessionpath The directory to store session files in. Defaults to $cfg->dataroot.'sessions'.
 * This path should NOT end with a "/"
 *
 * If your dataroot is stored on a slow volume (such as NFS) you may want to change this to a local directory.
 * Although if you're using a web server cluster, be aware that session files need to be stored in a location shared
 * by all servers, or you need to use persistence to send each user to only one server per session.
 */
// $cfg->sessionpath = '/tmp/mahara-sessions';

/**
 * @global int $cfg->accesstimeupdatefrequency How often Mahara should update the last
 * access time for users. Setting this lower means the field will be updated more
 * regularly, but means a database write will be required for more requests.
 * Setting it to zero means the access time will be updated every request
 */
$cfg->accesstimeupdatefrequency = 300;

/**
 * @global int $cfg->accessidletimeout How long since their last request before a user is considered to be logged
 * out. Note that it makes no sense for this to be less than the
 * accesstimeupdatefrequency.
 */
$cfg->accessidletimeout = 600;

/**
 * @global int $cfg->leapovermnetlogelevel if importing Leap2A over an xmlrpc mnet connection,
 * set this to something higher than 0 to log import information
 * see the constants in import/leap/lib.php
 */
$cfg->leapovermnetloglevel = 0;

/**
 * @global string $cfg->remoteavatarbaseurl base URL of avatar server (with the trailing slash)
 * This should normally be set to https://www.gravatar.com/avatar/
 */
//$cfg->remoteavatarbaseurl = 'https://www.gravatar.com/avatar/';

/**
 * Options for width/height of wysiwyg editor in block configuration
 * forms.  Workaround for current lack of tinymce fullscreen button.
 *
 * @global bool $cfg->blockeditormaxwidth Make the block config form expand to the full width of browser window
 * whenever it contains a tinymce (also increases editor height in
 * textbox blocktype):
 */
//$cfg->blockeditormaxwidth = true;

/**
 * @global int $cfg->blockeditorheight Set a fixed height in pixels for the tinymce editor (currently only
 * affects the textbox blocktype):
 */
// $cfg->blockeditorheight = 550;

/**
 * @global boolean $cfg->tinymcespellcheck Activate the TinyMCE spellcheck plugin. Not usually necessary
 * in modern browsers, which have their own built-in spellchecker. Requires the PHP "enchant" or "pspell"
 * module to be installed.
 */
//$cfg->tinymcespellcheckerengine = 'enchant';
//$cfg->tinymcespellcheckerengine = 'pspell';

/**
 * @global bool $cfg->sslproxy This needs to be true when forcing https with an ssl proxy such as nginx.
 */
$cfg->sslproxy = false;

/**
 * @global string $cfg->cacertinfo The name of a file holding one or more certificates to verify the peer
 * when Mahara does HTTPS requests using the PHP Curl library.
 */
// $cfg->cacertinfo = null;

/**
 * External login page
 * @global string $cfg->externallogin Use this config option when you want users to be redirected to another
 * login page, for example a moodle instance that has mnet to this mahara
 * You can use the following placeholders:
 * {wwwroot} - Expands out to the wwwroot of this moodle
 * {shorturlencoded} - Expands to the relative script path of the current page (and is urlencoded)
 *
 * A point to note about the example below. Moodle doesn't strip the trailing slash from wwwroot
 * Bug MDL-30042 fixes this, if this patch isn't applied, just hard code the login url you want instead
 *
 * Another point to note is if you need some system to render the local login page when accessing a restricted page
 * rather than automatically redirect to externallogin you can override this by adding a 'override=1' to the URL of the page you are
 * trying to access.
 */
// $cfg->externallogin = 'http://moodle.example.com/auth/mnet/jump.php?hostwwwroot={wwwroot}&wantsurl={shorturlencoded}';

/**
 * @global bool $cfg->renamecopies If true, new copies of views & collections will have "Copy of" prepended to the title,
 * and if a page already exists with that title, a number will be appended to the end of the title.
 *
 * If false, "Copy of" will NOT be prepended, but a number may still be appended to the end of the title.
 */
$cfg->renamecopies = false;

/**
 * Favicon display
 * @global string $cfg->favicondisplay string used to get the favicon image src from a given domain.
 * Used to display the sites whose iframe embed code is allowed by htmlpurifier.
 * Either assume that favicon.ico exists at the root of the domain, or use a service.
 */
// $cfg->favicondisplay = 'http://%s/favicon.ico';
// $cfg->favicondisplay = 'http://www.grabicon.com/%s';
// $cfg->favicondisplay = 'http://www.getfavicon.org/?url=%s';
$cfg->favicondisplay = 'http://www.google.com/s2/favicons?domain=%s';

/**
 * @global bool $cfg->productionmode If false, a message is shown at the top of the screen saying that the
 * site is not in production mode; and a number of other parameters are overridden with sensible defaults
 * for a dev site. (See init.php for the full effect).
 *
 * Because productionmode=false overrides a lot of settings with sensible dev mode defaults, if you want to
 * fine-tune your settings on your dev site, you'll paradoxically need to set productionmode=true.
 */
$cfg->productionmode = true;

/**
 * @global bool $cfg->sitethemeprefs If true, users can change their preferred theme for browsing the site.  The user's theme preference
 * will override any site, institution, or page theme.
 * (Even with this setting disabled, users in multiple institutions can choose which of their
 * institutions' themes they wish to use)
 */
// $cfg->sitethemeprefs = true;

/**
 * Clean url configuration
 * @global bool $cfg->cleanurls Set "true" to activate clean URLS in Mahara
 * Do not turn this on until you have the correct rewrite rules in place on your webserver, or none of
 * your links will work.
 * See https://wiki.mahara.org/wiki/System_Administrator%27s_Guide/Clean_URL_Configuration
 */
// $cfg->cleanurls = true;

/**
 * Strings to use when generating user and group urls, i.e. the 'user' and 'group' portion of clean urls
 * such as http://mahara.example.com/user/bob and http://mahara.example.com/group/bobs-group.  These
 * must match the output of the rewrite rules you have enabled in your webserver.  These strings will
 * also be used as prefixes whenever a valid clean url cannot be automatically generated.
 * @global string $cfg->cleanurluserdefault
 * @global string $cfg->cleangroupdefault
 * @global string $cfg->cleanurlviewdefault
 */
$cfg->cleanurluserdefault = 'user';
$cfg->cleanurlgroupdefault = 'group';
$cfg->cleanurlviewdefault = 'page';

/**
 * @global string $cfg->cleanurlcharset Character encoding for clean urls.  ASCII or UTF-8.
 */
$cfg->cleanurlcharset = 'ASCII';

/**
 * @global string $cfg->cleanurlinvalidcharacters A PCRE pattern defining sequences of characters to be removed and replaced by '-' when automatically
 * generating names for use in clean urls.  For example, if the pattern is /[^a-zA-Z0-9]+/, and a clean
 * url is being generated for a user with the username 'nigel.mcnie', the '.', which appears in the
 * invalidcharacters list is replaced, to give a url like http://mahara.example.com/user/nigel-mcnie
 */
$cfg->cleanurlinvalidcharacters = '/[^a-zA-Z0-9]+/';

/**
 * @global string $cfg>cleanurlvalidate A pattern to validate user-editable fields for use in clean urls.  If a user enters a string that
 * doesn't match this, it's an error.
 */
$cfg->cleanurlvalidate = '/^[a-z0-9-]*$/';

/**
 * @global bool $cfg->cleanurlusereditable Setting this to false will remove the "Change profile URL" option from the settings page.
 */
$cfg->cleanurlusereditable = true;

/**
 * @global bool $cfg->cleanurlusersubdomains generate subdomain-style profile urls like http://bob.mahara.example.com
 * Warning: Enabling this option on your site is likely to cause users with open sessions to be logged out on all profile pages.
 * See https://wiki.mahara.org/wiki/System_Administrator%27s_Guide/Clean_URL_Configuration#User_Subdomains
 */
// $cfg->cleanurlusersubdomains = true;

/**
 * @global bool $cfg->nocache Turn on caching of HTTP requests
 */
// $cfg->nocache = true;

/**
 * Settings used by the "elasticsearch" search plugin.
 * See the helpfiles on the plugin's configuration page for details.
 * @global string $cfg->plugin_search_elasticsearch_host
 * @global int $cfg->plugin_search_elasticsearch_port
 * @global int $cfg->plugin_search_elasticsearch_scheme
 * @global string $cfg->plugin_search_elasticsearch_username
 * @global string $cfg->plugin_search_elasticsearch_password
 * @global string $cfg->plugin_search_elasticsearch_indexingusername
 * @global string $cfg->plugin_search_elasticsearch_indexingpassword
 * @global string $cfg->plugin_search_elasticsearch_indexname
 * @global string $cfg->plugin_search_elasticsearch_bypassindexname
 * @global string $cfg->plugin_search_elasticsearch_analyzer
 * @global string $cfg->plugin_search_elasticsearch_types
 * @global string $cfg->plugin_search_elasticsearch_ignoressl
 */
// $cfg->plugin_search_elasticsearch_host = '127.0.0.1';
// $cfg->plugin_search_elasticsearch_port = 9200;
// $cfg->plugin_search_elasticsearch_scheme = 'https';
// $cfg->plugin_search_elasticsearch_username = '';
// $cfg->plugin_search_elasticsearch_password = '';
// $cfg->plugin_search_elasticsearch_indexingusername = '';
// $cfg->plugin_search_elasticsearch_indexingpassword = '';
// $cfg->plugin_search_elasticsearch_indexname = 'mahara';
// $cfg->plugin_search_elasticsearch_bypassindexname = null;
// $cfg->plugin_search_elasticsearch_analyzer = 'mahara_analyzer';
// $cfg->plugin_search_elasticsearch_types = 'usr,interaction_instance,interaction_forum_post,group,view,artefact,block_instance,collection';
// When scheme is set to https but the mahara site is not in production mode this flag will
// allow system to ignore checking SSL certificate. Useful if testing with a site using a self-signed certificate
// $cfg->plugin_search_elasticsearch_ignoressl = false;
/**
 * @global int $cfg->plugin_search_elasticsearch_requestlimit How many items to send per elasticsearch bulk request
 * The main side effect of raising this, is that it increases the size of the POST request you send to your
 * elasticsearch server. If you're using a proxy in front of elasticsearch, a very large request is likely to exceed
 * its default POST request size limit.
 */
$cfg->plugin_search_elasticsearch_requestlimit = '100';

/**
 * @global int $cfg->plugin_search_elasticsearch_redolimit If there are records in the queue that have failed on
 * being sent in a previous bulk attempt, how many of them should we retry sending individually during each cron
 * run. The idea here is that if there is one "bad" record in a bulk request which causes the whole request to fail,
 * you want to retry the records in that batch individually so that the rest of them can be sent.
 *
 * We count retried records against the (optional) cron limit. So if cronlimit is 1000 and redolimit is 200, then
 * we'll do 800 new records and at the end retry 200 individual records.
 *
 * A reasonable starting value for this is your cronlimit divided by your requestlimit. (i.e. 50000/100 = 500).
 */
$cfg->plugin_search_elasticsearch_redolimit = '500';

/**
 * The maximum number of comment indentation levels to show
 * (Same for the comment block & for bottom of page, so it's best if it's small)
 */
// $cfg->plugin_artefact_comment_maxindent = 5;

/**
 * Additional HTML: Use these settings to put snippets of HTML at the top of every page on the site.
 * This is useful for e.g. Google Analytics. If you need to enter a multi-line snippet, it may be best
 * to use a PHP nowdoc: http://www.php.net/manual/en/language.types.string.php#language.types.string.syntax.nowdoc
 */
// $cfg->additionalhtmlhead = <<<'HTML'
// <script>
//   var _gaq = _gaq || [];
//   _gaq.push(['_setAccount', 'UA-XXXXX-X']);
//   _gaq.push(['_trackPageview']);
//   (function() {
//     var ga = document.createElement('script'); ga.type = 'application/javascript'; ga.async = true;
//     ga.src = ('https:' == document.location.protocol ? 'https://ssl' : 'http://www') + '.google-analytics.com/ga.js';
//     var s = document.getElementsByTagName('script')[0]; s.parentNode.insertBefore(ga, s);
//   })();
// </script>
// HTML;
/**
 * @global string $cfg->additionalhtmlhead Added as the last item before the closing </head> tag
 */
$cfg->additionalhtmlhead = '';
/**
 * @global string $cfg->additionalhtmltopofbody Added immediately after the opening <body> tag
 */
$cfg->additionalhtmltopofbody = '';
/**
 * @global string $cfg->additionalhtmlfooter Added as the last item before the closing </body> tag
 */
$cfg->additionalhtmlfooter = '';

/**
 * @global string $cfg->auth_ldap_debug_sync_cron Whether to display extended debugging messages in
 * the auth/ldap user & group synchronization cron task.
 */
// $cfg->auth_ldap_debug_sync_cron = false;

/**
 * @global bool $cfg->usersuniquebyusername When turned on, this setting means that it doesn't matter
 * which other application the user SSOs from, the same username string from a remote SSO will be given
 * the same account in Mahara.
 *
 * This setting is one that has security implications unless only turned on by people who know what they're doing. In
 * particular, every system linked to Mahara should be making sure that same username == same person.  This happens for
 * example if two Moodles are using the same LDAP server for authentication.
 *
 * If this setting is on, it must NOT be possible to self register on the site for ANY institution - otherwise users
 * could simply pick usernames of people's accounts they wished to steal.
 */
$cfg->usersuniquebyusername = false;

/**
 * @global bool $cfg->skins Activates the experimental "page skins" feature, which allows users to customize the CSS
 * on individual pages.
 */
// $cfg->skins = false;

/**
 * @global string $cfg->opensslcnf Allows manual setting of path to openssl.cnf file for ssl key generation if not
 * being automatically detected. Needed for extra-site networking.
 */
// $cfg->opensslcnf = '';

/**
 * global string $cfg->dbprefix If set, Mahara will add this prefix to all of its database table names.
 * This setting is generally only necessary if you are running Mahara in the same database as another
 * web application (a situation most commonly encountered in shared hosting).
 *
 * Due to database name length limits, the dbprefix MUST be no longer than 19 characters.
 */
$cfg->dbprefix = '';

/**
 * @global bool $cfg->publicsearchallowed Activates the display of the search box for logged-out users
 */
$cfg->publicsearchallowed = false;

/**
 * @global boolean $cfg->probationenabled Determines whether or not to use the new-user probation system.
 * If enabled, this will prevent newly self-registered users from taking certain actions that would be
 * useful for creating spam content. Users will leave probation once non-probationary users take actions
 * that indicate they trust the probationary user.
 */
$cfg->probationenabled = false;

/**
 * @global integer $cfg->probationstartingpoints If new user probation is enabled, this setting determines how
 * many probation points new users will start with.
 */
$cfg->probationstartingpoints = 2;

/**
 * @global integer $cfg->emailcontact If Mahara's anti-spam settings are enabled, this email address will be
 * shown as a contact address to anonymous users when their message is identified as a possible spam message.
 * This can help reduce user frustration in the event of a false positive.
 */
$cfg->emailcontact = '';

/**
 * @global string $cfg->cookieprefix Prefix to use on the names of any cookies issued by Mahara. This may
 * be useful in some unusual hosting situations, for instance if you are running another web application
 * that issues cookies with the same domain and path as Mahara.
 */
// $cfg->cookieprefix = '';

/**
 * @global bool $cfg->showloginsideblock
 * Whether to show the login sideblock
 */
$cfg->showloginsideblock = true;

/**
 * @global string $cfg->ajaxifyblocks Whether or not to use AJAX to load the content of blocktypes.
 * If the network connection to your users is quite slow, then disabling this may improve the user
 * experience.
 */
$cfg->ajaxifyblocks = true;

/**
 * @global string $cfg->mathjaxpath Determines the path to CDN or server-local installation of MathJax.js.
 * If MathJax is enabled, use to configure path to MathJax.
 */
$cfg->mathjaxpath = '//cdnjs.cloudflare.com/ajax/libs/mathjax/2.7.1/MathJax.js?config=TeX-AMS-MML_HTMLorMML&delayStartupUntil=configured';

/**
 * @global string $cfg->mathjaxconfig Determines MathJax configuration options.
 * The default MathJax configuration should be appropriate for most users, but MathJax is highly configurable
 * and any of the standard MathJax configuration options can be added here.
 */
$cfg->mathjaxconfig = '
MathJax.Hub.Config({
  TeX:{extensions: ["mhchem.js"]}
});
MathJax.Hub.Configured();
';

/**
 * @global string $cfg->maxuploadsize The maximum upload size in bytes
 * This allow to limit the upload size
 * The real maximum upload size will be calculated on
 *  - PHP settings: post_max_size and upload_max_filesize
 *  - this setting $cfg->maxuploadsize if set
 */
//$cfg->maxuploadsize = 16777216;

/**
 * @global string $cfg->urlsecret A secret you need to add to the lib/cron.php or admin/upgrade.php
 * URL to run it through the browser rather than the commandline to prevent unauthorised users triggering
 * the cron or an upgrade, eg http://example.com/lib/cron.php?urlsecret=mysupersecret. If you do not wish
 * to have a url secret set $cfg->urlsecret = null.
 */
$cfg->urlsecret = 'mysupersecret';

/**
 * @global string $cfg->passwordsaltalt1 A previous password salt used on the site.
 * When changing the salt (or disabling it), you will need to set the current salt as an alternate salt
 * There are up to 20 alternate salts (e.g. $cfg->passwordsaltalt2, $cfg->passwordsaltalt3, etc)
 */
$cfg->passwordsaltalt1 = 'old salt value';

/**
 * @global array $cfg->openbadgedisplayer_source The open badge sources
 * The default sources are openbadgepassport.com and Badgr
 */
$cfg->openbadgedisplayer_source = '{"passport":"https://openbadgepassport.com/","badgr":"https://api.badgr.io/"}';

/**
 * @global string $cfg->memcacheservers
 * A comma separated list of memcache servers to store user sessions for SimpleSAMLphp.
 * localhost:11211 will be used by default.
 */
// $cfg->memcacheservers = 'hostname1:port1,hostname2:port2,hostname3:port3';

/**
 * @global string $cfg->sessionhandler
 * An alternative session handler for Mahara if you do not wish to use files.
 * Specify the name of the session handler. Will be used for SAML session handling unless $cfg->ssphpsessionhandler set
 */
$cfg->sessionhandler = 'file';
//$cfg->sessionhandler = 'memcached'; // also set the $cfg->memcacheservers setting if using this one
//$cfg->sessionhandler = 'redis'; // also set the $cfg->redis* settings if using this one

/**
 * @global string $cfg->ssphpsessionhandler
 * An alternative session handler for SimpleSAMLphp if you do not wish to use memcache.
 * Specify the name of the session handler.
 */
// $cfg->ssphpsessionhandler = 'memcached'; // also set the $cfg->memcacheservers setting if using this one
// $cfg->ssphpsessionhandler = 'redis'; // also set the $cfg->redis* setting if using this one
// $cfg->ssphpsessionhandler = 'sql'; // also set the $cfg->ssphpsql* settings if using this one

/**
 * Redis session handling
 */
// If accessing a redis sentinel server
//$cfg->redissentinelservers = "localhost:26379";  // A comma separated string of hosts:ports
//$cfg->redismastergroup = 'mymaster';
//$cfg->redisprefix = 'mahara';
// Otherwise use direct redis connection
//$cfg->redisserver = "localhost:26379";  // A string of a single host:port

/**
 * SQL session store configs for SimpleSAMLphp
 * Specify the SQL database connection string, credentials and table prefix
 */
/*
 $cfg->ssphpsqldsn = "mysql:host=localhost;dbname=simplesamlphp";
 $cfg->ssphpsqlusername = null;
 $cfg->ssphpsqlpassword = null;
 $cfg->ssphpsqlprefix = 'ssphp';
*/

/**
 * @global array $cfg->saml_custommappingfile
 * A list of paths to custom attribute mapping files for SimpleSAMLphp IDP and SP
 */
/*
 $cfg->saml_custommappingfile = '{
    "idp" : ["' . $CFG->docroot . 'auth/saml/extlib/simplesamlphp/attributemap/name2oid.php"],
    "sp" : ["' . $cfg->dataroot . '/customattributemap/customname2oid.php"]
 }';
*/

/**
 * Log SAML attributes
 * To help diagnose authentication issues between Mahara and the IdP it is useful to see what attributes are being sent
 * so we log what was sent to the usr_login_saml table when this flag is set to true.
 * Note: This should be switched off once problems are diagnosed / fixed and the table cleared
 */
$cfg->saml_log_attributes = false;

/**
 * @global array $cfg->externalfilesystem
 * A configuration data for an external file system
 */
/*
 $cfg->externalfilesystem = '{
    "includefilepath" : "module/objectfs/classes/s3_file_system.php",
    "class" : "s3_file_system",
 }';
*/

/**
 * @global string $cfg->dwoocachedir
 * The location of the dwoo cache directory
 */
//$cfg->customdwoocachedir = '/var/cache/appcache/testing';

/**
 * Uncomment the following line if you wish to lock down access for members of institutions
 * so that they are separated entirely and disallow contact between members of one institution
 * with members of another institution.
 *
 * Users can only be in one institution at one point in time. Being a member of multiple
 * institutions is not allowed. Only institution staff, institution admins, site staff and
 * site admins can create groups. No friends allowed.
 */
//$cfg->isolatedinstitutions = true;

/**
 * Uncomment the following line if you do not wish to allow friends and friend related
 * activities on your install of Mahara. No friends allowed - this is a site-wide setting.
 */
//$cfg->friendsnotallowed = true;

/**
 * Restrict the site to only allow the upload of certain file types.
 * Set as a comma separated string of valid file extensions
 */
//$cfg->validfiletypes = 'doc,docx,gif,jpeg,jpg,m4a,mp3,mp4,pdf,png'; // for example

/**
 * Allow the creation of a user with minimum details from SAML
 * With modern privacy laws some IdPs will not include identifying things like firstname/lastname,
 * email address in their minimum packet of info about an authenticated user.
 * Mahara expect these to exist to create a new user.
 * To get passed this, by allowing just a unique identifier/username, we set the following flag
 */
// $cfg->saml_create_minimum_user=true;

/**
 * Allow SAML to create an institution when creating a new user if the institution they need
 * to belong to doesn't yet exist. The IdP can pass an institution display name through
 * and be mapped via the SAML instance setting 'samlfieldfororganisationname'.
 * To make a new institution you need to define what institution to fetch an existing SAML
 * instance from to be used as the default 'template' SAML settings.
 * The 'saml_create_institution_default' can also be used as a 'parent' auth to update the
 * role* values for all the other SAML configs that have the same 'institutionidpentityid' value
 */
//$cfg->saml_create_institution=true;
//$cfg->saml_create_institution_default = 'mahara';

/**
 * Allow the export option called PDF export
 * This option exports portfolios as pdf files
 *
 * Note: This is an experimental feature requiring the install of a Chrome / Chromium browser on
 * your server to ustilise the print to PDF commandline option - Use with caution.
 */
//$cfg->usepdfexport = true;

/**
 * Allow the site to not set the HTTP Strict Transport Security header
 * This is useful if the server or a downstream program sets this header already
 */
//$cfg->hstsoverride = true;

/**
 * Allow emails sent to people that are using external authentication to contain authid parameter
 * so that on following the link the person gets redirected to login at their external site first if needed
 */
//$cfg->emailexternalredirect = true;

/**
*  Restrict the number of access list rules (rows) when sharing personal portfolios to this number of rows.
*  Note: This is an experimental feature. For the time being, setting this number to a low one, in particular
*  a single digit number, is only recommended for new sites. When you do that on an existing site, the access
*  permissions will not be changed and an existing portfolio shared with 30 people, will still be shared with these
*  30 people even though the config value says '5'. The portfolio owner will not be able to remove access for
*  anybody individually but the first row. When the form is saved, the change is applied and all other access
*  rules but the first visible one are removed. It just needs that 'Save'
*/
//$cfg->accesslistmaximum = 100;

/**
 * ===================================================================
 * Configuration values in Admin menu > Configure site > Site options
 * ===================================================================
 */

/**
 * Site settings :: Site name
 *
 * Choose a name for your Mahara instance. It appears in certain places around
 * the site, e.g. in the title bar of the browser and in emails sent from the
 * site. Therefore, it should not be too long.
 *
 * @var string $cfg->sitename
 */
//$cfg->sitename = '';

/**
 * Site settings :: Language
 *
 * Set the default language for your site. If you have multiple language packs
 * installed, you see a drop-down menu. Otherwise, the standard language,
 * English, is displayed. The directory name of the selected language pack is
 * the value that should be used here.
 *
 * @see get_languages()
 * @var string $cfg->lang
 */
//$cfg->lang = 'en.utf8';

/**
 * Site settings :: Theme
 *
 * Mahara comes with a number of themes that you can use. If you have
 * institutions set up, they can choose their own theme. You can search for
 * community-contributed themes on the Mahara wiki. The value used is the
 * directory name of the theme.
 *
 * @see get_all_themes()
 * @var string $cfg->theme
 */
//$cfg->theme = 'raw';

/**
 * Site settings :: Country
 *
 * The country selected is the default for country selections throughout your
 * Mahara installation. The value should be the ISO 3166 two character shortcode.
 *
 * @see getoptions_country()
 * @var string $cfg->country
 */
//$cfg->country = 'nz';

/**
 * Site settings :: Time zone
 *
 * the time zone in which you want to have time stamps displayed around the
 * site. If you do not select one, one will be chosen according to the country
 * if you entered one. This may not be accurate if a country has more than one
 * time zone. The value should be an IANA time zone.
 *
 * @see getoptions_timezone()
 * @var string $cfg->timezone
 */
//$cfg->timezone = 'Pacific/Auckland';

/**
 * Site settings :: Show homepage / dashboard information
 *
 * If set to ‘true’, information about Mahara and how it is used is displayed on
 * the homepage for logged-out and on the dashboard for registered people.
 * Account holders can disable this for their own dashboard.
 *
 * @var boolean $cfg->homepageinfo
 */
// $cfg->homepageinfo = true;

/**
 * Site settings :: Custom landing page
 *
 * Set to 'true' if you want people to arrive at a different page than the
 * dashboard after having logged in. The select menu where you
 * can choose the appropriate page becomes visible.
 *
 * @var boolean $cfg->homepageredirect
 */
//$cfg->homepageredirect = false;

/**
 * Site settings :: Custom landing page URL
 *
 * The internal URL to a page. The page needs to be accessible to all
 * registered people. Only used if $cfg->homepageredirect is 'true'.
 *
 * @var boolean $cfg->homepageredirecturl
 */
//$cfg->homepageredirecturl = '/view/view.php?id=7';

/**
 * Site settings :: Registration agreement
 *
 * If set to 'true', administrators cannot make the 'Confirm registration' setting
 * optional when configuring an institution. This prevents institution
 * administrators from disabling this setting. New accounts can only be created with
 * administrator approval.
 *
 * @var boolean $cfg->registerterms
 */
//$cfg->registerterms = false;

/**
 * Site settings :: Require reason for masquerading
 *
 * If set to 'true', administrators will be required to enter a reason for
 * masquerading as another person. This will be logged, and if the setting
 * 'Notify people of masquerading' is enabled, included in the notification
 * to the account holder about the masquerading. This setting needs logging
 * to be turned on.
 *
 * @var boolean $cfg->masqueradingreasonrequired
 */
//$cfg->masqueradingreasonrequired = false;

/**
 * Site settings :: Notify people of masquerading
 *
 * If set to 'true', account holders will be notified when an administrator
 * masqueraded as them. The notification will include who, when and - if
 * enabled under 'Require reason for masquerading' - why. This setting needs
 * logging to be turned on.
 *
 * @var boolean $cfg->masqueradingnotified
 */
//$cfg->masqueradingnotified = false;

/**
 * Site settings :: Anonymous comments
 *
 * If set to 'true', logged-out people and people without a login can
 * leave comments on public pages or pages they can access via a secret URL.
 *
 * @var boolean $cfg->anonymouscomments
 */
//$cfg->anonymouscomments = false;

/**
 * Site settings :: Access to site files
 *
 * If set to 'true', registered people will have access to site files in
 * subfolders of the folder 'public'. By default, only files directly in the
 * folder 'public' are accessible to them.
 *
 * @var boolean $cfg->sitefilesaccess
 */
//$cfg->sitefilesaccess = false;

/**
 * Site settings :: License metadata
 *
 * If set to 'true', authors can choose under which license they want to make
 * their content available. They can set a default license in their account
 * settings and then decide for each artefact individually as well. An
 * institution administrator can set the default license in the institution
 * settings.
 *
 * @var boolean $cfg->licensemetadata
 */
//$cfg->licensemetadata = false;

/**
 * Site settings :: Custom licenses
 *
 * If set to 'true', authors can enter any URL as license for their content. If
 * not allowed, they will be limited to the licenses configured by the site
 * administrator.
 *
 * @var boolean $cfg->licenseallowcustom
 */
//$cfg->licenseallowcustom = false;

/**
 * Site settings :: Enable MathJax
 *
 * If set to 'true', mathematics and science equations can be displayed nicely in
 * Mahara pages. For more information on how to configure it, see above.
 *
 * @var boolean $cfg->mathjax
 */
//$cfg->mathjax = false;

/**
 * Site settings :: Sitemap
 *
 * If set to 'true', sitemap files from publicly accessible pages, groups, and
 * forum topics are generated that can be sent to another service.
 *
 * @var boolean $cfg->generatesitemap
 */
//$cfg->generatesitemap = 1;

/**
 * Institution settings :: People allowed multiple institutions
 *
 * If set to 'true', account holders can be members of several institutions at
 * the same time. Thus, a person who belongs to two or more institutions only
 * needs one account. You cannot allow multiple institutions when 'Strict
 * privacy' is turned on, and when the site has isolated institutions.
 *
 * @var boolean $cfg->usersallowedmultipleinstitutions
 */
//$cfg->usersallowedmultipleinstitutions = true;

/**
 * Institution settings :: Warning time for institution expiry
 *
 * If set to 'true', a notification will be sent to the site and institution
 * administrators this amount of time before an institution is due to expire
 * and be suspended. This value is a number of minutes. If the value is set
 * to 0, this triggers the 'no end date' (in the UI) and institutions won't
 * expire.
 *
 * @var int $cfg->institutionexpirynotification
 */
//$cfg->institutionexpirynotification = 60 * 60 * 24 * 7;

/**
 * Institution settings :: Auto-suspend expired institutions
 *
 * If set to 'true', this option will allow Mahara to automatically suspend an
 * institution that has expired automatically. This means that members of that
 * institution will not be able to log in until the institution has been
 * unsuspended.
 *
 * @var boolean $cfg->institutionautosuspend
 */
//$cfg->institutionautosuspend = false;

/**
 * Institution settings :: Review accounts before self-deletion
 *
 * If set to 'true', every institution is forced to approve or deny the deletion
 * of accounts if people attempt to delete their account. If set to 'false', it
 * is up to each institution to activate this setting.
 *
 * This setting gives institutions in a formal learning setting the possibility
 * to prevent accidental account deletion by people before portfolios are
 * archived if required.
 *
 * @var boolean $cfg->defaultreviewselfdeletion
 */
//$cfg->defaultreviewselfdeletion = false;

/**
 * Institution settings :: Access reports for staff
 *
 * If set to 'true', site and institution staff will have access to people
 * reports. The following reports are available to them:
 *  - Masquerading sessions (if logging of these is turned on)
 *  - Portfolio access
 *  - Account details
 *
 * @var boolean $cfg->staffreports
 */
//$cfg->staffreports = false;

/**
 * Institution settings :: All reports for institution staff
 *
 * If set to 'true', institution staff will have access to all reports in their
 * institutions. This is normally restricted to administrators and site staff.
 *
 * @var boolean $cfg->staffstats
 */
//$cfg->staffstats = false;

/**
 * Account settings :: Authors can choose page themes
 *
 * If set to 'true', authors can select a theme for their portfolio page. The
 * page is displayed with this theme to other people. Thus, the institution
 * or site theme can be overwritten.
 *
 * @var boolean $cfg->userscanchooseviewthemes
 */
//$cfg->userscanchooseviewthemes = false;

/**
 * Account settings :: Display remote avatars
 *
 * If set to 'true', account holders' default profile pictures will be their
 * Gravatar pictures (remote avatar). They will need an account with Gravatar
 * for this to work.
 *
 * If you use your own avatar server to provide profile pictures for your
 * account holders, you can use that instead of Gravatar for the default
 * profile pictures. In order to do so, you need to add the remote avatar
 * base URL to your config.php via the $cfg->remoteavatarbaseurl var.
 *
 * @var boolean $cfg->remoteavatars
 */
//$cfg->remoteavatars = false;

/**
 * Account settings :: People can hide real names
 *
 * If set to 'true', people who have set a display name may choose to be
 * searchable only by their display name and will not be found in searches by
 * their real name. In the administration section of the site, people are
 * always searchable by their real names. An administrator (site and
 * institution) always sees the display name, first and last name, and username.
 *
 * @var boolean $cfg->userscanhiderealnames
 */
//$cfg->userscanhiderealnames = false;

/**
 * Account settings :: Never display usernames
 *
 * If set to 'true', ordinary account holders cannot search for others using
 * their username in the search. They will also not be able to see the
 * username of any other person on the site.
 *
 * These restrictions do not apply to staff and administrators. Additionally,
 * Clean URLs (if activated) for profile pages will be generated using display
 * names (if provided) or real names, rather than usernames.
 *
 * @var boolean $cfg->nousernames
 */
//$cfg->nousernames = false;

/**
 * Account settings :: Allow anonymous pages
 *
 * If set to 'true', account holders can hide their name as the author of a page
 * from others. Administrators and staff can still view authorship information
 * by clicking on the 'Author's name hidden' link that will reveal the real
 * name.
 *
 * The name is also anonymised in blocks that are on the page and would
 * normally display the author's name.
 *
 * @var boolean $cfg->allowanonymouspages
 */
//$cfg->allowanonymouspages = false;

/**
 * Account settings :: Export to queue
 *
 * If set to 'true', the export queue will handle the exporting of personal
 * portfolios for better server load management. The person exporting a
 * portfolio will receive an email when the export is ready for download.
 *
 * @var boolean $cfg->exporttoqueue
 */
//$cfg->exporttoqueue = false;

/**
 * Account settings :: Multiple journals
 *
 * If set to 'true', all account holders will have multiple journals by default.
 * They can still change that setting in their personal account settings.
 *
 * @var boolean $cfg->defaultmultipleblogs
 */
//$cfg->defaultmultipleblogs = false;

/**
 * Account settings :: HTML editor
 *
 * Choose whether the HTML editor is used by default or not. If set to
 * 'Person-decides', account holders will be allowed to choose whether to use the
 * HTML editor in their personal settings or not. Otherwise the specified
 * setting will be used site-wide.
 *
 * Options are;
 *  - an empty string : Person decides
 *  - disable : no one has it
 *  - enabled : everyone has it
 *
 * @var string $cfg->wysiwyg
 */
//$cfg->wysiwyg = "";

/**
 * Account settings :: Session lifetime
 *
 * For security reasons, after a specified period of inactivity, a person will
 * be logged out automatically. The field this relates to is
 * 'sessionlifetime', and it is measured in minutes. However, the database entry for
 * 'session_timeout' is in seconds.
 *
 * The default value is 86400 seconds (24 hours).
 *
 * @var int $cfg->session_timeout
 */
//$cfg->session_timeout = 60 * 60 * 24;

/**
 * Account settings :: Default registration expiry lifetime
 *
 * As site administrator you can decide when pending registrations that require
 * approval expire. This time is specified in minutes, or 0 for 'No end date'.
 * The value should round to 'days' at a minimum. If the latter option is
 * chosen, pending registrations will not expire by default.
 *
 * The default value is 2 weeks.
 *
 * @var int $cfg->defaultregistrationexpirylifetime
 */
//$cfg->defaultregistrationexpirylifetime = 60 * 24 * 7 * 2;

/**
 * Account settings :: Default account lifetime
 *
 * If set to 'true', accounts will expire after this amount of time from when they were
 * created. When an account is expired, the account holder cannot log in. This
 * time is specified in minutes, or 0 for 'No end date'. The value should round
 * to 'days' at a minimum. If the latter option is chosen, accounts will not
 * expire by default.
 *
 * @var int $cfg->defaultaccountlifetime
 */
//$cfg->defaultaccountlifetime = 0;

/**
 * Account settings :: Default account inactivity time
 *
 * How long an account will remain active without the person logging in. This
 * time is specified in minutes, or 0 for 'No end date'. The value should round
 * to 'days' at a minimum.
 *
 * @var int $cfg->defaultaccountinactiveexpire
 */
//$cfg->defaultaccountinactiveexpire = 0;

/**
 * Account settings :: Warning time for inactivity / expiry
 *
 * The time before accounts expire or become inactive, at which a warning
 * message will be sent to the primary email address of the account holder.
 *
 * This time is specified in minutes, or 0 for 'No end date'. The value should
 * round to 'days' at a minimum.
 *
 * @var int $cfg->defaultaccountinactivewarn
 */
//$cfg->defaultaccountinactivewarn = 60 * 24 * 7;

/**
 * Access settings :: Allow public portfolios
 *
 * If set to 'true', people can create portfolios that are accessible to the
 * public rather than only to registered people.
 *
 * @var boolean $cfg->allowpublicviews
 */
//$cfg->allowpublicviews = true;

/**
 * Access settings :: Allow public profiles
 *
 * If set to 'true', people can set their profile pages to be accessible to the
 * public rather than only to registered people.
 *
 * @var boolean $cfg->allowpublicprofiles
 */
//$cfg->allowpublicprofiles = true;

/**
 * Access settings :: Profile access for all registered people
 *
 * If set to 'true', profile pages will be viewable by all registered people.
 *
 * @var boolean $cfg->loggedinprofileviewaccess
 */
//$cfg->loggedinprofileviewaccess = true;

/**
 * Group settings :: Create groups
 *
 * Decide who will be able to create new groups.
 *
 * Valid values:
 *  - admins : Administrators only
 *  - staff  : Administrators and staff only
 *  - all    : Everyone
 *
 * @var string $cfg->creategroups
 */
//$cfg->creategroups = 'all';

/**
 * Group settings :: Create public groups
 *
 * Decide who will be able to create groups that are viewable by the general
 * public.
 *
 * Valid values:
 *  - siteadmins : Site administrators only
 *  - admins     : Administrators only
 *  - staff      : Administrators and staff only
 *  - all        : Everyone
 *
 * @var string $cfg->createpublicgroups
 */
//$cfg->createpublicgroups = 'all';

/**
 * Group settings :: Allow group categories
 *
 * If set to 'true', allow site administrators to create categories that can be
 * assigned to groups.
 *
 * @var boolean $cfg->allowgroupcategories
 */
//$cfg->allowgroupcategories = false;

/**
 * Group settings :: See own groups only
 *
 * If set to 'true', allow people to see only groups that they own or that they
 * are members of. They can also only search for others who are in these
 * groups. This setting requires that isolated institutions are turned on in
 * the config.php file.
 *
 * @see $cfg->isolatedinstitutions
 * @var boolean $cfg->owngroupsonly
 */
//$cfg->owngroupsonly = false;

/**
 * Side block settings :: Tag cloud
 *
 * If set to 'true', people can see a sidebar in a few places on the site with
 * a list of their most frequently used tags.
 *
 * @var boolean $cfg->showtagssideblock
 */
//$cfg->showtagssideblock = true;

/**
 * Side block settings :: Maximum tags in cloud
 *
 * The default number of tags to display in tag clouds.
 *
 * @var int $cfg->tagssideblockmaxtags
 */
//$cfg->tagssideblockmaxtags = 20;

/**
 * Side block settings :: Show who is online
 *
 * If set to 'true', people can see a sidebar with a list of everyone who has
 * been online over the past ten minutes.
 *
 * @var bool $cfg->showonlineuserssideblock
 */
//$cfg->showonlineuserssideblock = true;

/**
 * Side block settings :: Limit for "People online"
 *
 * The maximum number of people to display in the sidebar "People online".
 *
 * @var int $cfg->onlineuserssideblockmaxusers
 */
//$cfg->onlineuserssideblockmaxusers = 10;

/**
 * Side block settings :: Show profile completion
 *
 * If set to 'true', a progress bar with tips about what to complete in the
 * personal profile will be displayed in a side block. Account holders can
 * disable it in their account settings.
 *
 * @var boolean $cfg->showprogressbar
 */
//$cfg->showprogressbar = false;

/**
 * Side block settings :: Portfolio search
 *
 * If set to 'true', the 'Search my portfolio' side block is displayed in the
 * 'Portfolios' and 'Files' areas of the site. However, it has not
 * been working for most people for a long time.
 *
 * @var boolean $cfg->showselfsearchsideblock
 */
//$cfg->showselfsearchsideblock = false;

/**
 * Search settings :: Search plugin
 *
 * The search plugin to use.
 *
 * @see get_search_plugins()
 * @var string $cfg->searchplugin
 */
//$cfg->searchplugin = 'internal';

/**
 * Search settings :: Show people in public search
 *
 * If set to 'true', this will allow names to appear in public search results.
 * This needs to have 'publicsearchallowed' set to true and be using a search
 * plugin that allows public search, e.g. Elasticsearch. Changing this setting
 * will require search re-indexing.
 *
 * @var boolean $cfg->searchuserspublic
 */
//$cfg->searchuserspublic = false;

/**
 * Security settings :: Password policy
 *
 * The password policy for people whose account is set to use the built-in
 * internal authentication method. The password policy does not affect accounts
 * using external authentication, e.g. SSO or LDAP.
 *
 * The string is created from a number (minimum characters) and a string
 * representing the complexity. These values are concatenated with an
 * underscore.
 *
 * The password to be from 8 to 20 (inclusive) characters. The complexity has to be one of
 * the following:
 *  - ul   : Upper and lower case letters
 *  - uln  : Upper and lower case letters, numbers
 *  - ulns : Upper and lower case letters, numbers, symbols
 *
 * @var string $cfg->passwordpolicy
 */
//$cfg->passwordpolicy = '8_ulns';

/**
 * Security setting :: Virus checking
 *
 * If set to 'true', all uploaded files are checked for viruses using ClamAV. You
 * have to have ClamAV installed on your server.
 *
 * @var boolean $cfg->viruschecking
 */
//$cfg->viruschecking = false;

/**
 * Security setting :: Anti-spam
 *
 * The type of anti-spam measures used on publicly visible forms.
 *
 * @see available_spam_traps()
 * @var string $cfg->antispam
 */
//$cfg->antispam = 'advanced';

/**
 * Security setting :: Spamhaus URL deny list
 *
 * If set to 'true', URLs are checked against the Spamhaus DNSBL.
 *
 * @var boolean $cfg->spamhaus
 */
//$cfg->spamhaus = false;

/**
 * Security setting :: SURBL URL deny list
 *
 * If set to 'true', URLs are checked against the SURBL DNSBL.
 *
 * @var boolean $cfg->surbl
 */
//$cfg->surbl = false;

/**
 * Security setting :: Disable external resources in HTML
 *
 * If set to 'true', authors will be prevented from embedding external resources
 * such as images from remote sites into their forum posts and other HTML
 * content. YouTube videos and other media can also not be embedded. It is
 * however a good thing to do from a security standpoint since it does
 * neutralise a few clever phishing attacks. See the HTML Purifier
 * documentation for more details.
 *
 * @var boolean $cfg->disableexternalresources
 */
//$cfg->disableexternalresources = false;

/**
 * Security setting :: reCAPTCHA on account registration / 'Contact us' forms
 *
 * If set to 'true', people who register themselves on the site and who use the
 * ‘Contact us’ form when not logged in are required to fill in the reCAPTCHA
 * form. This is for spam protection.
 *
 * @var boolean $cfg->recaptchaonregisterform
 */
//$cfg->recaptchaonregisterform = false;

/**
 * Security setting :: reCAPTCHA site key
 *
 * The site key for your site's reCAPTCHA account.
 *
 * @var string $cfg->recaptchapublickey
 */
//$cfg->recaptchapublickey = '';

/**
 * Security setting :: reCAPTCHA secret key
 *
 * The secret key for your site's reCAPTCHA account.
 *
 * @var string $cfg->recaptchaprivatekey
 */
//$cfg->recaptchaprivatekey = '';

/**
 * Security setting :: HSTS override
 *
 * If your web server already sets the HTTP Strict Transport Security (HSTS)
 * header, then deactivate it here for Mahara. This prevents it from being set
 * twice and causing an error when you check your site for the proper
 * configuration, e.g. via an SSL check tool.
 *
 * @var boolean $cfg->hstsoverride
 */
//$cfg->hstsoverride = false;

/**
 * Proxy settings :: Proxy address
 *
 * If your site uses a proxy server to access the Internet, specify it
 * in hostname:portnumber notation.
 *
 * @var string $cfg->proxyaddress
 */
//$cfg->proxyaddress = '';

/**
 * Proxy settings :: Proxy authentication model
 *
 * Enter your proxy's authentication model if needed:
 *  - [empty string] : None
 *  - basic          : Basic [NCSA]
 *
 * @var string $cfg->proxyauthmodel
 */
//$cfg->proxyauthmodel = '';

/**
 * Proxy settings :: Proxy credentials
 *
 * Enter the credentials required for your proxy to authenticate your web
 * server in username:password format.
 *
 * @var string $cfg->proxyauthcredentials
 */
//$cfg->proxyauthcredentials = '';

/**
 * Email settings :: SMTP host
 *
 * If you want to force Mahara to use a specific SMTP server instead of the
 * system one, enter its hostname here, e.g. smtp.example.com. It is possible
 * to specify more than one host by separating them with semicolons,
 * e.g. smtp1.example.com;smtp2.example.com, but keep in mind that all other
 * settings, e.g. authentication credentials and port numbers, will apply to
 * all listed servers. It is not possible to specify different credentials for
 * each server in this list. This feature is useful when SMTP host
 * authentication is not required or you list different frontends for the same
 * mail server in which case other settings will work.
 *
 * @var string $cfg->smtphosts
 */
//$cfg->smtphosts = '';

/**
 * Email settings :: SMTP port
 *
 * If your SMTP server uses a port number different from 25, you may specify
 * it here. When encryption is enabled, the default ports are 465 for SSL and
 * 587 for TLS. You only need to specify a port number if it is different from
 * these. Check the correct settings with your mail service provider.
 *
 * @var int $cfg->smtpport
 */
//$cfg->smtpport = '';

/**
 * Email settings :: User
 *
 * If your SMTP server requires authentication, enter the username here.
 *
 * @var string $cfg->smtpuser
 */
//$cfg->smtpuser = '';

/**
 * Email settings :: Password
 *
 * If your SMTP server requires authentication, enter the password here.
 *
 * @var string $cfg->smtppass
 */
//$cfg->smtppass = '';

/**
 * Email settings :: SMTP encryption
 *
 * If your SMTP server supports encryption, enable it here using one of these
 * values:
 *  - [empty string] : None
 *  - ssl            : SSL
 *  - tls            : TLS
 *
 * @var string $cfg->smtpsecure
 */
//$cfg->smtpsecure = '';

/**
 * Email settings :: System mail address
 *
 * This email address is the address that emails are sent from when Mahara
 * sends email.
 *
 * @var string $cfg->noreplyaddress
 */
//$cfg->noreplyaddress = '';

/**
 * Logging settings :: Log events
 *
 * Decide which events you wish to log in the database. Events are generated
 * every time a person does something significant on the site, such as editing
 * a page. This log is kept in the event_log table in the database.
 *
 * Valid values:
 *  - none       : Nothing is logged in the database.
 *  - masquerade : Only masquerading sessions are logged. This setting needs to be
 *                 turned on if you wish to report on administrator masquerading of
 *                 account holders.
 *  - all        : All events that can be logged in the database are logged.
 *
 * @var string $cfg->eventloglevel
 */
//$cfg->eventloglevel = 'none';

/**
 * Logging settings :: Event log expiry
 *
 * Decide for how long you wish to keep your database log. If you selected to
 * log all events, the table can grow quite quickly especially on an active
 * site. This is value is a number of minutes. If the value is set to 0 this
 * triggers the 'No end date' (in the UI) and the event log is not deleted by
 * default.
 *
 * @var int $cfg->eventlogexpiry
 */
//$cfg->eventlogexpiry = 0;

/**
 * Logging settings :: Event log reporting
 *
 * If set to 'true', you can report over a number of activities on the site in
 * the ‘Reports’ section that require events to be logged.
 *
 * @var boolean $cfg->eventlogenhancedsearch
 */
//$cfg->eventlogenhancedsearch = false;
