<?php
/**
 *
 * @package    mahara
 * @subpackage lang
 * @author     Catalyst IT Limited <mahara@catalyst.net.nz>
 * @license    https://www.gnu.org/licenses/gpl-3.0.html GNU GPL version 3 or later
 * @copyright  For copyright information on Mahara, please see the README file distributed with this software.
 *
 */

defined('INTERNAL') || die();

// General form strings
$string['active'] = 'Active';
$string['add']     = 'Add';
$string['addspecific'] = 'Add "%s"';
$string['addone']  = 'Add one';
$string['cancel']  = 'Cancel';
$string['configure'] = 'Configure';
$string['configurespecific'] = 'Configure "%s"';
$string['copy'] = 'Copy';
$string['copytoclipboard']  = 'Copy secret URL to the clipboard';
$string['delete']  = 'Delete';
$string['deletespecific'] = 'Delete "%s"';
$string['deletespecificfrom'] = 'Delete "%s" with URL "%s"';
$string['deleteitem']  = 'Delete';
$string['deleted']  = 'deleted';
$string['moveitemup']  = 'Move up';
$string['moveitemdown']  = 'Move down';
$string['edit']    = 'Edit';
$string['editspecificfrom'] = 'Edit "%s" with URL "%s"';
$string['editspecific']    = 'Edit "%s"';
$string['managespecific'] = 'Manage "%s"';
$string['connectspecific']    = 'Connect "%s"';
$string['editing'] = 'Editing';
$string['settingsspecific'] = 'Settings for "%s"';
$string['enabledspecific']    = '"%s" is enabled';
$string['disabledspecific']    = '"%s" is disabled';
$string['move']    = 'Move';
$string['save']    = 'Save';
$string['submit']  = 'Submit';
$string['update']  = 'Update';
$string['change']  = 'Change';
$string['send']    = 'Send';
$string['go']      = 'Go';
$string['continue'] = 'Continue';
$string['configfor'] = 'Configuration for';
$string['infofor'] = 'Information for';
$string['default'] = 'Default';
$string['upload']  = 'Upload';
$string['complete']  = 'Complete';
$string['Failed']  = 'Failed';
$string['loading'] = 'Loading ...';
$string['showtags'] = 'Show my tags';
$string['errorprocessingform'] = 'There was an error with submitting this form. Please check the marked fields and try again.';
$string['description'] = 'Description';
$string['orientation'] = 'Orientation';
$string['remove']  = 'Remove';
$string['Close'] = 'Close';
$string['Help'] = 'Help';
$string['helpfor'] = 'Help for "%s"';
$string['closehelp'] = 'Close help';
$string['applychanges'] = 'Apply changes';
$string['general'] = 'General';
$string['units'] = 'Units';
$string['status'] = 'Status';
$string['toggletoolbarson'] = 'Toggle toolbars on. Show full list of buttons';
$string['toggletoolbarsoff'] = 'Toggle toolbars off. Show basic buttons';
$string['defaulthint'] = 'Type in a search term';
$string['imagexofy'] = 'Image {x} of {y}';
$string['clickformore'] = '(Press \'enter\' to display more information)';
$string['goto'] = 'Go to \'%s\'';
$string['gotomore'] = 'Read more...';
// generic switch state strings.
$string['on'] = 'On';
$string['off'] = 'Off';
$string['yes'] = 'Yes';
$string['no'] = 'No';
$string['true'] = 'True';
$string['false'] = 'False';
$string['enabled'] = 'Enabled';
$string['disabled'] = 'Disabled';
// Objectionable strings.
$string['complaint'] = 'Complaint';
$string['notifyadministrator'] = 'Notify administrator';
$string['notifyadministratorconfirm'] = 'Are you sure you wish to report this page as containing objectionable material?';
$string['notifyadministratorreview'] = 'Are you sure you are ready for the administrator to review this page again?';
$string['notobjectionable'] = 'Not objectionable';
$string['reportobjectionablematerial'] = 'Report objectionable material';
$string['objectionablematerialreported'] = 'Objectionable material reported';
$string['objectionablematerialreportedowner'] = 'Someone reported your page to contain objectionable content. Please review your page and make adjustments where needed.';
$string['objectionablematerialreportedreply'] = 'Click the "Review objectionable content" button to let your administrator know that you\'ve made changes or to ask for clarification.';
$string['objectionablematerialreportreplied'] = 'An administrator reviewed the page again and still finds it to contain objectionable content. Please check your notification for more information. You can then make changes and send a message to the administrator by clicking the "Review objectionable content" button or ask for clarification.';
$string['objectionreviewsent'] = 'Objection review has been sent to page owner. Click on "Still objectionable" if you want to adjust and send another review.';
$string['lastobjection'] = 'Last objection';
$string['objectionnotreviewed'] = 'Objection not yet reviewed';
$string['objectionnotreviewedreply'] = 'Reply to un-reviewed objection:

%s';
$string['lastobjectionartefact'] = 'Last objection for "%s"';
$string['replyingtoobjection'] = 'Replying to objection:
"%s"

%s';
$string['reportsent'] = 'Your report has been sent.';
$string['reviewrequestsent'] = 'Your review request has been sent.';
$string['stillobjectionable'] = 'Still objectionable';
$string['objectionreview'] = 'Review objectionable material';
$string['objectionreviewonview'] = 'Replying to objectionable material can only be done via the page';
$string['reviewcomplaint'] = 'Review of complaint';
$string['reviewcomplaintdesc'] = 'Enter a message that you would like to send along to give more details to the author on what they should change. If you leave the field empty, the original complaint will be sent instead.';
$string['reviewnotification'] = 'The administrator was notified to review the portfolio and check if objectionable material still exists.';
$string['reviewnotificationdesc'] = 'Please review if objectionable material still exists.';
$string['removeaccess'] = 'Remove access';
$string['removeaccessdesc'] = 'Revoke access to this page (and collection if the page is in one) immediately until the objectionable material has been removed.';
// responsive design strings
$string['tabs'] = 'Tabs';
$string['tab'] = 'tab';
$string['selected'] = 'selected';
$string['admin'] = 'Admin';
$string['menu'] = 'Menu';
$string['adminmenu'] = 'Administration menu';
$string['usermenu1'] = 'Account menu';
// nav tool tips
$string['profilepage'] = "Profile page";
$string['mainmenu'] = "Main menu";
$string['showmainmenu'] = "Show main menu";
$string['showadminmenu'] = "Show administration menu";
$string['showusermenu1'] = "Show account menu";
$string['showsearch'] = "Show search";
$string['showmenu'] = "Show menu for %s";

$string['at'] = 'at';
$string['From'] = 'From';
$string['To'] = 'To';
$string['ascending'] = 'Ascending';
$string['descending'] = 'Descending';
$string['sortorder'] = 'Sort order of files';
$string['All'] = 'All';
$string['Allinstitutions'] = 'All institutions';
$string['none']   = 'None';
$string['samepage'] = 'Same page';
$string['selectall']   = 'Select all';
$string['selectnone']   = 'Select none';

$string['enable'] = 'Enable';
$string['disable'] = 'Disable';
$string['show'] = 'Show';
$string['hide'] = 'Hide';
$string['pluginenabled'] = 'The plugin is now visible.';
$string['plugindisabled'] = 'The plugin has been hidden.';
$string['plugindisableduser'] = 'The %s plugin has been disabled. Please check with your administrator to have this feature enabled.';
$string['pluginnotenabled'] = 'Plugin is hidden. You must make the %s plugin visible first.';
$string['pluginexplainaddremove'] = 'Plugins in Mahara are always installed and can be accessed if people know the URLs and would otherwise have access. Rather than enabling and disabling the functionality, plugins are hidden or made visible by clicking on the \'Hide\' or \'Show\' links beside the plugins below.';
$string['pluginexplainartefactblocktypes'] = 'When hiding an \'artefact\' type plugin, Mahara also stops the display of the blocks related to it.';
$string['pluginbrokenanddisabledtitle1'] = 'The broken plugin "%s" was disabled.';
$string['pluginbrokenanddisabled'] = 'Someone attempted to load the %s plugin, but it could not be loaded.
To prevent further errors, the plugin has been disabled.

The error message generated by the plugin was:
----------------------------------------------------------------------------

    %s

----------------------------------------------------------------------------

To re-enable the plugin, please visit the page "Extensions" of your site.
';

$string['next']      = 'Next';
$string['nextpage']  = 'Next page';
$string['previous']  = 'Previous';
$string['prevpage']  = 'Previous page';
$string['first']     = 'First';
$string['firstpage'] = 'First page';
$string['last']      = 'Last';
$string['lastpage']  = 'Last page';
$string['maxitemsperpage1']  = 'Results per page:';
$string['showmore'] = 'Show more';

$string['accept'] = 'Accept';
$string['memberofinstitutions'] = 'Member of %s';
$string['staffofinstitutions'] = 'Staff of %s';
$string['supportadminofinstitutions'] = 'Support administrator of %s';
$string['adminofinstitutions'] = 'Administrator of %s';
$string['reject'] = 'Reject';
$string['sendrequest'] = 'Send request';
$string['reason'] = 'Reason';
$string['select'] = 'Select';

// Tags
$string['tags'] = 'Tags';
$string['tagsdesc'] = 'Search for/enter tags for this item.';
$string['tagsdescprofile'] = 'Search for/enter tags for this item. Items tagged with \'profile\' are displayed in your sidebar.';
$string['tagsdescblock'] = 'Search for/enter tags for this block.';
$string['viewtags'] = 'Page tags';
$string['youhavenottaggedanythingyet'] = 'You have not tagged anything yet';
$string['mytags'] = 'My tags';
$string['Tag'] = 'Tag';
$string['itemstaggedwith'] = 'Items tagged with "%s"';
$string['nitems'] = array(
    '%s item',
    '%s items',
);
$string['searchresultsfor'] = 'Search results for';
$string['alltags'] = 'All tags';
$string['sortalpha'] = 'Sort tags alphabetically';
$string['sortfreq'] = 'Sort tags by frequency';
$string['sortresultsby'] = 'Sort results by:';
$string['sortedby'] = 'sorted by:';
$string['sortby'] = 'Sort by:';
$string['adminfirst'] = 'Admin first';
$string['nameatoz'] = 'Name A to Z';
$string['nameztoa'] = 'Name Z to A';
$string['firstjoined'] = 'First joined';
$string['lastjoined'] = 'Last joined';
$string['date'] = 'Date';
$string['earliest'] = 'Earliest';
$string['latest'] = 'Latest';
$string['dateformatguide1'] = 'Use the format %s';
$string['dateofbirthformatguide1'] = 'Use the format %s';
$string['datetimeformatguide1'] = 'Use the format %s';
$string['filterresultsby'] = 'Filter results by:';
$string['tagfilter_all'] = 'All';
$string['tagfilter_file'] = 'Files';
$string['tagfilter_image'] = 'Images';
$string['tagfilter_text'] = 'Text';
$string['tagfilter_view'] = 'Pages';
$string['tagfilter_collection'] = 'Collections';
$string['tagfilter_blog'] = 'Journal';
$string['tagfilter_blogpost'] = 'Journal entry';
$string['tagfilter_plan'] = 'Plan';
$string['tagfilter_task'] = 'Plan task';
$string['tagfilter_external'] = 'External';
$string['tagfilter_resume'] = 'Résumé';
$string['edittags'] = 'Edit tags';
$string['selectatagtoedit'] = 'Select a tag to edit';
$string['edittag'] = 'Edit <a href="%s">%s</a>';
$string['editthistag'] = 'Edit this tag';
$string['edittagdescription'] = 'All items in your portfolio tagged "%s" will be updated';
$string['deletetag'] = 'Delete <a href="%s">%s</a>';
$string['confirmdeletetag'] = 'Do you really want to delete this tag from all items in your portfolio?';
$string['deletetagdescription'] = 'Remove this tag from all items in your portfolio';
$string['tagupdatedsuccessfully'] = 'Tag updated successfully';
$string['tagdeletedsuccessfully'] = 'Tag deleted successfully';
$string['relatedtags'] = 'Tagged content of %s';
$string['relatedtagsinview'] = 'Tagged content of %s in portfolio "%s"';
$string['norelatedtaggeditemstoview'] = 'There is nothing you can view with tag "%s" owned by "%s".';
$string['norelatedtaggeditemstoviewfiltered'] = 'There is no %s you can view with tag "%s" owned by "%s".';

$string['selfsearch'] = 'Search my portfolio';
$string['resultsperpage'] = 'Results per page';

// Institution tags
$string['allowinstitutiontags'] = 'Institution tags';
$string['allowinstitutiontagsdescription'] = 'Administrators can define a set of tags that institution members can use.';
$string['cantlistinstitutiontags'] = 'You are not allowed to list institution tags.';
$string['createtag'] = 'Create tag';
$string['deleteinstitutiontag'] = 'Delete institution tag';
$string['deleteinstitutiontagspecific'] = 'Delete institution tag "%s"';
$string['editinstitutiontag'] = 'Edit institution tag';
$string['error:duplicatetag'] = 'Institutional tag already exists.';
$string['error:emptytag'] = 'Institutional tag cannot be empty.';
$string['institutiontagcantbesaved'] = 'Institution tag can\'t be saved.';
$string['institutiontag'] = 'Institution tag';
$string['institutiontagdesc'] = 'You can add one tag at a time';
$string['institutiontagdeleted'] = 'Institution tag deleted successfully.';
$string['institutiontagdeletefail'] = 'Failed to delete institution tag.';
$string['institutiontags'] = 'Institution tags';
$string['institutiontagsdescription'] = 'The institution tags are predefined by the institution and available for use by all institution members. You can create as many tags as you like.';
$string['institutiontagsaved'] = 'Institution tag saved.';
$string['notags'] = 'No tags for this institution.';
$string['tag'] = 'Tag';
$string['timesused'] = 'Times used';
$string['usedtagscantbedeleted'] = 'Used tags can\'t be deleted';

// License metadata
$string['license'] = 'License';
$string['licenseother'] = 'Other license (enter URL)';
$string['licenseotherurl'] = 'Enter URL';
$string['licensedesc'] = 'The license for this content.';
$string['licensenone1'] = 'All rights reserved';
$string['licensenonedetailed1'] = '© %s, all rights reserved';
$string['licensingadvanced'] = 'Advanced licensing';
$string['licensor'] = 'Licensor';
$string['licensordesc'] = 'The original licensor for this content.';
$string['licensorurl'] = 'Original URL';
$string['licensorurldesc'] = 'The original URL for this content.';
$string['licensemandatoryerror'] = 'The license field is mandatory.';
$string['licensenocustomerror'] = 'This is not a permitted license on this site.';

// Quota strings
$string['quota'] = 'Quota';
$string['quotausage'] = 'You have used <span id="quota_used">%s</span> of your <span id="quota_total">%s</span> quota.';
$string['quotausagegroup'] = 'This group has used <span id="quota_used">%s</span> of its <span id="quota_total">%s</span> quota.';
$string['groupquota'] = 'Group quota';

$string['updatefailed'] = 'Update failed';

// profile sideblock strings
$string['invitedgroup'] = 'group invitation';
$string['invitedgroups'] = 'group invitations';
$string['logout'] = 'Logout';
$string['pendingfriend'] = 'pending friend';
$string['pendingfriends'] = 'pending friends';
$string['profile'] = 'profile';
$string['views'] = 'Pages';

// Progress bar sideblock strings
$string['profilecompleteness'] = 'Profile completion';
$string['profilecompletenesspreview'] = 'Profile completion preview';
$string['profilecompletenesstips'] = 'Profile completion tips';
$string['progressbargenerictask'] = array(
    0 => 'Add one: %2$s',
    1 => 'Add %d: %s'
);
$string['profilecompletionforwhichinstitution'] = 'for';
$string['noprogressitems'] = 'No profile completion items for this institution.';

// Online users sideblock strings
$string['peopleonline'] = 'People online';
$string['lastminutes'] = 'Last %s minutes';
$string['allpeopleonline'] = 'Show people online';
$string['nopeopleonlinefound'] = 'No people online found';

// Links and resources sideblock
$string['linksandresources'] = 'Links and resources';

// auth
$string['accesstotallydenied_institutionsuspended'] = 'Your institution %s has been suspended. Until it is unsuspended, you will not be able to log in to %s.
Please contact your institution for help.';
$string['accesstotallydenied_institutionexpired'] = 'Your institution %s has expired. Until it is unexpired, you will not be able to log in to %s.
Please contact your institution for help.';
$string['accesstotallydenied_institutioninactive'] = 'The authentication method for institution "%s" is inactive. Until it is made active, you will not be able to log in to %s.
Please contact your institution administrator for help.';
$string['accessforbiddentoadminsection'] = 'You are forbidden from accessing the administration section.';
$string['accountdeleted'] = 'Sorry, your account has been deleted. You can <a href="%scontact.php">contact the site administrator</a>.';
$string['accountexpired'] = 'Sorry, your account has expired. You can <a href="%scontact.php">contact the site administrator</a> to have it reactivated.';
$string['accountcreated'] = '%s: New account';
$string['accountcreatedtext'] = 'Dear %s,

A new account has been created for you on %s. Your details are as follows:

Username: %s
Password: %s

Visit %s to get started!

Regards, %s site administrator';
$string['accountcreatedchangepasswordtext'] = 'Dear %s,

A new account has been created for you on %s. Your details are as follows:

Username: %s
Password: %s

Once you log in for the first time, you will be asked to change your password.

Visit %s to get started!

Regards, %s site administrator';
$string['accountcreatedhtml'] = '<p>Dear %s</p>

<p>A new account has been created for you on <a href="%s">%s</a>. Your details are as follows:</p>

<ul>
    <li><strong>Username:</strong> %s</li>
    <li><strong>Password:</strong> %s</li>
</ul>

<p>Visit <a href="%s">%s</a> to get started!</p>

<p>Regards, %s site administrator</p>
';
$string['accountcreatedchangepasswordhtml'] = '<p>Dear %s</p>

<p>A new account has been created for you on <a href="%s">%s</a>. Your details are as follows:</p>

<ul>
    <li><strong>Username:</strong> %s</li>
    <li><strong>Password:</strong> %s</li>
</ul>

<p>Once you log in for the first time, you will be asked to change your password.</p>

<p>Visit <a href="%s">%s</a> to get started!</p>

<p>Regards, %s site administrator</p>
';
$string['accountexpirywarning'] = 'Account expiry warning';
$string['accountexpirywarningtext1'] = 'Dear %s,

Your account on %s will expire on %s.

If you wish to keep your portfolio content after your account expires, we recommend you export your portfolio via %s.

If you wish to extend your account access or have any questions regarding the above, please feel free to contact us:

%s

Regards,
%s site administrator';
$string['accountexpirywarninghtml1'] = '<p>Dear %s,</p>

<p>Your account on %s will expire on %s.</p>

<p>If you wish to keep your portfolio content after your account expires, we recommend you export your portfolio via the <a href="%s">export tool</a>.</p>

<p>If you wish to extend your account access or have any questions regarding the above, please feel free to <a href="%s">contact us</a>.</p>

<p>Regards,<br>
%s site administrator</p>';
$string['institutionmembershipexpirywarning'] = 'Institution membership expiry warning';
$string['institutionmembershipexpirywarningtext1'] = 'Dear %s,

Your membership of %s on %s will expire on %s.

If you wish to extend your membership or have any questions regarding the above, please feel free to contact us:

%s

Regards,
%s site administrator';
$string['institutionmembershipexpirywarninghtml1'] = '<p>Dear %s,</p>

<p>Your membership of %s on %s will expire on %s.</p>

<p>If you wish to extend your membership or have any questions regarding the above, please feel free to <a href="%s">contact us</a>.</p>

<p>Regards,<br>
%s site administrator</p>';
$string['institutionexpirywarning'] = 'Institution expiry warning';
$string['institutionexpirywarningtext_institution1'] = 'Dear %s,

%s\'s membership of %s will expire on %s.

If you wish to extend your institution\'s membership or have any questions regarding the above, please feel free to contact us:

%s

Regards,
%s site administrator';
$string['institutionexpirywarninghtml_institution1'] = '<p>Dear %s,</p>

<p>%s\'s membership of %s will expire on %s.</p>

<p>If you wish to extend your institution\'s membership or have any questions regarding the above, please feel free to <a href="%s">contact us</a>.</p>

<p>Regards,<br>
%s site administrator</p>';
$string['institutionexpirywarningtext_site1'] = 'Dear %s,

The institution \'%s\' will expire on %s.

You may wish to contact them to extend their membership of %s.

Regards,
%s site administrator';
$string['institutionexpirywarninghtml_site1'] = '<p>Dear %s,</p>

<p>The institution \'%s\' will expire on %s.</p>

<p>You may wish to contact them to extend their membership of %s.</p>

<p>Regards,<br>
%s site administrator</p>';
$string['accountinactive'] = 'Sorry, your account is currently inactive.';
$string['accountinactivewarning'] = 'Account inactivity warning';
$string['accountinactivewarningtext1'] = 'Dear %s,

Your account on %s will become inactive on %s.

Once inactive, you will not be able to log in until an administrator re-enables your account.

You can prevent your account from becoming inactive by logging in.

Regards,
%s site administrator';
$string['accountinactivewarninghtml1'] = '<p>Dear %s,</p>

<p>Your account on %s will become inactive on %s.</p>

<p>Once inactive, you will not be able to log in until an administrator re-enables your account.</p>

<p>You can prevent your account from becoming inactive by logging in.</p>

<p>Regards,<br>
%s site administrator</p>';
$string['accountsuspended'] = 'Your account has been suspended as of %s.
The reason for your suspension is: %s';
$string['youraccounthasbeensuspended'] = 'Your account has been suspended.';
$string['youraccounthasbeenunsuspended'] = 'Your account has been unsuspended.';
$string['changepasswordinfo'] = 'You are required to change your password before you can proceed.';
$string['chooseinstitution'] = 'Choose your institution';
$string['chooseusernamepassword'] = 'Choose your username and password';
$string['chooseusernamepasswordinfo'] = 'You need a username and password to log in to %s. Please choose them now.';
$string['confirmpassword'] = 'Confirm password';
$string['deleteaccount1'] = 'Delete account';
$string['senddeletenotification'] = 'Send request';
$string['javascriptnotenabled'] = 'Your browser does not have JavaScript enabled. This site requires JavaScript to be enabled before you can log in.';
$string['cookiesnotenabled'] = 'Your browser does not have cookies enabled or is blocking cookies. This site requires cookies to be enabled before you can log in.';
$string['institution'] = 'Institution';
$string['institutionnotfound'] = 'Institution "%s" not found';
$string['institutioncontacts'] = '\'%s\' contacts';
$string['institutionlink'] = '<a href="%s">%s</a>';
$string['link'] = '<a href="%s">%s</a>';
$string['loggedoutok'] = 'You have been logged out successfully';
$string['login'] = 'Login';
$string['loginfailed'] = 'You have not provided the correct credentials to log in. Please check your username and password are correct.';
$string['loginto'] = 'Log in to %s';
$string['orloginvia'] = 'Or log in via:';
$string['newpassword'] = 'New password';
$string['nosessionreload'] = 'Reload the page to log in';
$string['oldpassword'] = 'Current password';
$string['password'] = 'Password';
$string['passwordstrength1'] = 'Very weak';
$string['passwordstrength2'] = 'Weak';
$string['passwordstrength3'] = 'Strong';
$string['passwordstrength4'] = 'Very strong';
$string['passworddescription'] = '';
$string['passworddescriptionbase'] = 'The minimum length of the password is %s characters.';
$string['passworddescription1.ul'] = 'It must contain upper case letters [A-Z] and lower case letters [a-z].';
$string['passworddescription1.uln'] = 'It must contain upper case letters [A-Z], lower case letters [a-z], and numbers [0-9].';
$string['passworddescription1.ulns'] = 'It must contain upper case letters [A-Z], lower case letters [a-z], numbers [0-9], and symbols [e.g. ! . @ # $ & * - _ ].';
$string['passwordhelp'] = 'The password you use to access the system';
$string['passwordnotchanged'] = 'You did not change your password. Please choose a new password.';
$string['passwordsaved'] = 'Your new password has been saved';
$string['passwordsdonotmatch'] = 'The passwords do not match.';
$string['passwordtooeasy'] = 'Your password is too easy. Please choose a stronger password.';
$string['register'] = 'Register';
$string['reloadtoview'] = 'Reload the page to view';
$string['sessiontimedout'] = 'Your session has timed out. Please enter your login details to continue.';
$string['sessiontimedoutpublic'] = 'Your session has timed out. You may <a href="%s">log in</a> to continue browsing.';
$string['sessiontimedoutreload'] = 'Your session has timed out. Reload the page to log in again.';
$string['username'] = 'Username';
$string['preferredname'] = 'Display name';
$string['preferrednamedisplay'] = 'Displayed name';
$string['usernamedescription'] = ' ';
$string['usernamehelp'] = 'The username you have been given to access this system.';
$string['youaremasqueradingas'] = 'You are masquerading as %s.';
$string['yournewpassword1'] = 'Your new password. The password must be at least %s characters long. Passwords are case sensitive and must be different from your username. %s<br/>
For good security, consider using a passphrase. A passphrase is a sentence rather than a single word. Consider using a favourite quote or listing two (or more) of your favourite things separated by spaces.';
$string['yournewpasswordagain'] = 'Your new password again';
$string['invalidsesskey'] = 'Invalid session key';
$string['cannotremovedefaultemail'] = 'You cannot remove your primary email address.';
$string['emailtoolong'] = 'Email addresses cannot be longer than 255 characters.';
$string['emailinvalid'] = 'Email address invalid.';
$string['mustspecifyoldpassword'] = 'You must specify your current password.';
$string['mustspecifycurrentpassword'] = 'You must specify your current password to change your username.';
$string['Site'] = 'Site';
$string['maildisabled'] = 'Email disabled';

// Misc. register stuff that could be used elsewhere
$string['profileicon'] = 'Profile image';
$string['bulkselect'] = 'Select people for editing / reports';
$string['emailaddress'] = 'Email address';
$string['emailaddressdescription'] = ' ';
$string['firstname'] = 'First name';
$string['firstnameall'] = 'All first names';
$string['firstnamedescription'] = ' ';
$string['lastname'] = 'Last name';
$string['lastnameall'] = 'All last names';
$string['lastnamedescription'] = ' ';
$string['studentid'] = 'ID number';
$string['displayname'] = 'Display name';
$string['fullname'] = 'Full name';
$string['registerwelcome'] = 'Welcome! To use this site you must register first.';
$string['registeragreeterms'] = 'You must also agree to the <a href="terms.php">terms and conditions</a>.';
$string['registerprivacy1'] = 'The data we collect here will be stored according to our privacy statement.';
$string['registerstep3fieldsoptional'] = '<h1>Choose an optional profile picture</h1><p>You have now successfully registered with %s. You may now choose an optional profile picture to be displayed as your avatar.</p>';
$string['registerstep3fieldsmandatory'] = '<h1>Fill out mandatory profile fields</h1><p>The following fields are required. You must fill them out before your registration is complete.</p>';
$string['registeringdisallowed'] = 'Sorry, you cannot register for this system at this time.';
$string['membershipexpiry'] = 'Membership expires';
$string['institutionfull'] = 'The institution you have chosen is not accepting any more registrations.';
$string['registrationnotallowed'] = 'The institution you have chosen does not allow self-registration.';
$string['registrationcomplete'] = 'Thank you for registering at %s';
$string['language'] = 'Language';
$string['itemdeleted'] = 'Item deleted';
$string['itemupdated'] = 'Item updated';
$string['approvalrequired'] = 'Approval required';
$string['authentication'] = 'Authentication';

// Forgot password
$string['cantchangepassword'] = 'Sorry, you are unable to change your password through this interface - please use your institution\'s interface instead.';
$string['forgotusernamepassword'] = 'Forgotten your username or password?';
$string['forgotusernamepasswordtextprimaryemail'] = '<p>If you have forgotten your username or password, enter the primary email address listed in your profile and we will send you a message you can use to give yourself a new password.</p>
<p>If you know your username and have forgotten your password, you can also enter your username instead.</p>';
$string['lostusernamepassword'] = 'Lost username / password';
$string['emailaddressorusername'] = 'Email address or username';
$string['pwchangerequestsentfullinfo'] = 'You should receive an email shortly with a link that you can use to change the password for your account.<br>If you do not receive an email, either the details you entered are incorrect or you normally use external authentication to access the site.';
$string['forgotusernamepasswordemailsubject'] = 'Username / password details for %s';
$string['forgotusernamepasswordemailmessagetext'] = 'Dear %s,

A username / password request has been made for your account on %s.

Your username is %s.

If you wish to reset your password, please follow the link below:

%s

If you did not request a password reset, please ignore this email.

If you have any questions regarding the above, please feel free to contact us:

%s

Regards, %s site administrator';
$string['forgotusernamepasswordemailmessagehtml'] = '<p>Dear %s,</p>

<p>A username / password request has been made for your account on %s.</p>

<p>Your username is <strong>%s</strong>.</p>

<p>If you wish to reset your password, please follow the link below:</p>

<p><a href="%s">%s</a></p>

<p>If you did not request a password reset, please ignore this email.</p>

<p>If you have any questions regarding the above, please feel free to <a href="%s">contact us</a>.</p>

<p>Regards, %s site administrator</p>';
$string['forgotpassemailsendunsuccessful'] = 'Sorry, it appears that the email could not be sent successfully. This is our fault. Please try again shortly.';
$string['forgotpassemailsentanyway1'] = 'An email was sent to the address stored for this person, but the address may not be correct or the recipient server is returning messages. Please contact the %s administrator to reset your password if you do not receive the email.';
$string['forgotpasswordenternew'] = 'Please enter your new password to continue.';
$string['nosuchpasswordrequest'] = 'No such password request';
$string['passwordresetexpired'] = 'The password reset key has expired';
$string['passwordchangedok'] = 'Your password was successfully changed.';

// Reset password when moving from external to internal auth.
$string['noinstitutionsetpassemailsubject'] = '%s: Membership of %s';
$string['noinstitutionsetpassemailmessagetext'] = 'Dear %s,

You are no longer a member of %s.
You may continue to use %s with your current username %s, but you must set a new password for your account.

Please follow the link below to continue the reset process.

%sforgotpass.php?key=%s

If you have any questions regarding the above, please feel free to contact
us.

%scontact.php

Regards, %s site administrator

%sforgotpass.php?key=%s';
$string['noinstitutionsetpassemailmessagehtml'] = '<p>Dear %s,</p>

<p>You are no longer a member of %s.</p>
<p>You may continue to use %s with your current username %s, but you must set a new password for your account.</p>

<p>Please follow the link below to continue the reset process.</p>

<p><a href="%sforgotpass.php?key=%s">%sforgotpass.php?key=%s</a></p>

<p>If you have any questions regarding the above, please feel free to <a href="%scontact.php">contact us</a>.</p>

<p>Regards, %s site administrator</p>

<p><a href="%sforgotpass.php?key=%s">%sforgotpass.php?key=%s</a></p>';

// Send information about username and how to reset password
// when moving from external to internal auth with a password already set
$string['noinstitutionoldpassemailsubject'] = '%s: Membership of %s';
$string['noinstitutionoldpassemailmessagetext'] = 'Dear %s,

You are no longer a member of %s.
You may continue to use %s with your current username %s, and the password that you have already set for your account.

If you have forgotten your password, you can reset it by going to the following page and entering in your username.

%sforgotpass.php

If you have any questions regarding the above, please feel free to contact
us.

%scontact.php

Regards, %s site administrator

%sforgotpass.php';
$string['noinstitutionoldpassemailmessagehtml'] = '<p>Dear %s,</p>

<p>You are no longer a member of %s.</p>
<p>You may continue to use %s with your current username %s and the password that you have already set for your account.</p>

<p>If you have forgotten your password, you can reset it by going to the following page and entering in your username.</p>

<p><a href="%sforgotpass.php">%sforgotpass.php</a></p>

<p>If you have any questions regarding the above, please feel free to <a href="%scontact.php">contact us</a>.</p>

<p>Regards, %s site administrator</p>

<p><a href="%sforgotpass.php">%sforgotpass.php</a></p>';
$string['debugemail'] = 'NOTICE: This email was intended for %s <%s> but has been sent to you as per the "sendallemailto" configuration setting.';
$string['divertingemailto'] = 'Diverting email to %s';


// Expiry times
$string['noenddate'] = 'No end date';
$string['day']       = 'day';
$string['days']      = 'days';
$string['weeks']     = 'weeks';
$string['month']    = 'month';
$string['months']    = 'months';
$string['years']     = 'years';
$string['year']     = 'year';

// Datepicker options
$string['datepicker_today'] = "Go to today";
$string['datepicker_clear'] = "Clear selection";
$string['datepicker_close'] = "Close the picker";
$string['datepicker_selectMonth'] = "Select month";
$string['datepicker_prevMonth'] = "Previous month";
$string['datepicker_nextMonth'] = "Next month";
$string['datepicker_selectYear'] = "Select year";
$string['datepicker_prevYear'] = "Previous year";
$string['datepicker_nextYear'] = "Next year";
$string['datepicker_selectDecade'] = "Select decade";
$string['datepicker_prevDecade'] = "Previous decade";
$string['datepicker_nextDecade'] = "Next decade";
$string['datepicker_prevCentury'] = "Previous century";
$string['datepicker_nextCentury'] = "Next century";
$string['datepicker_pickHour'] = "Pick hour";
$string['datepicker_incrementHour'] = "Increment hour";
$string['datepicker_decrementHour'] = "Decrement hour";
$string['datepicker_pickMinute'] = "Pick minute";
$string['datepicker_incrementMinute'] = "Increment minute";
$string['datepicker_decrementMinute'] = "Decrement minute";
$string['datepicker_pickSecond'] = "Pick second";
$string['datepicker_incrementSecond'] = "Increment second";
$string['datepicker_decrementSecond'] = "Decrement second";
$string['datepicker_togglePeriod'] = "Toggle period";
$string['datepicker_selectTime'] = "Select time";

$string['timelapsestringhour'] = array(
    0 => '%2$s hour %s min ago',
    1 => '%2$s hour %s mins ago'
);
$string['timelapsestringhours'] = array(
    0 => '%2$s hours %s min ago',
    1 => '%2$s hours %s mins ago'
);
$string['timelapsestringminute'] = array(
    0 => '%s min ago',
    1 => '%s mins ago'
);
$string['timelapsestringseconds'] = array(
    0 => '%s sec ago',
    1 => '%s secs ago',
);

// Site content pages
$string['sitecontentnotfound'] = '%s text not available';

// Contact us form
$string['name']                     = 'Name';
$string['email']                    = 'Email';
$string['emails']                    = 'Emails';
$string['subject']                  = 'Subject';
$string['message']                  = 'Message';
$string['messagesent']              = 'Your message has been sent';
$string['nosendernamefound']        = 'No sender name was submitted';
$string['emailnotsent']             = 'Failed to send contact email. Error message: "%s"';

// mahara.js
$string['namedfieldempty'] = 'The required field "%s" is empty';
$string['duplicatenamedfield'] = 'The value entered already exists';
$string['processing']     = 'Processing';
$string['unknownerror']       = 'An unknown error occurred (0x20f91a0)';

// menu
$string['skipmenu']     = 'Skip to main content';
$string['dropdownmenu'] = 'menu';
$string['overview']     = 'Overview';
$string['home']         = 'Home';
$string['Content']      = 'Content';
$string['myportfolio']  = 'Portfolio';
$string['Create']       = 'Create';
$string['Engage']       = 'Engage';
$string['Manage']       = 'Manage';
$string['settings']     = 'Settings';
$string['people']       = 'People';
$string['myfriends']          = 'My friends';
$string['findpeople']        = 'Find people';
$string['groups']             = 'Groups';
$string['mygroups']           = 'My groups';
$string['returntosite']       = 'Return to site';
$string['administration'] = 'Administration';
$string['siteinformation']    = 'Site information';
$string['institutioninformation'] = 'Institution information';

$string['unreadmessages'] = 'unread messages';
$string['unreadmessage'] = 'unread message';

$string['siteclosed'] = 'The site is temporarily closed for a database upgrade. Site administrators may log in.';
$string['siteclosedlogindisabled'] = 'The site is temporarily closed for a database upgrade. <a href="%s">Perform the upgrade now.</a>';

// footer
$string['termsandconditions'] = 'Terms and conditions';
$string['privacystatement']   = 'Privacy statement';
$string['about']              = 'About';
$string['contactus']          = 'Contact us';
$string['legal']              = 'Legal';
$string['externalmanual']     = 'External manual';

// my account
$string['account'] =  'Settings';
$string['accountprefs'] = 'Preferences';
$string['preferences'] = 'Preferences';
$string['activityprefs'] = 'Activity preferences';
$string['changepassword'] = 'Change password';
$string['notifications'] = 'Notifications';
$string['inbox'] = 'Inbox';
$string['unread'] = '%s unread';
$string['gotoinbox'] = 'Go to inbox';
$string['institutionmembership'] = 'Institution membership';
$string['institutionmembershipdescription'] = 'If you are a member of any institutions, they will be listed here. You may also request membership of institutions and accept or decline pending membership invitations.';
$string['youareamemberof'] = 'You are a member of %s';
$string['leaveinstitution'] = 'Leave institution';
$string['reallyleaveinstitution'] = 'Are you sure you want to leave this institution?';
$string['cancelrequest'] = 'Cancel request';
$string['confirminvitation'] = 'Confirm invitation';
$string['joininstitution'] = 'Join institution';
$string['decline'] = 'Decline';
$string['requestmembershipofaninstitution'] = 'Request membership of an institution';
$string['optionalinstitutionid'] = 'Institution ID';
$string['institutionmemberconfirmsubject'] = 'Institution membership confirmation';
$string['institutionmemberconfirmmessage'] = 'You have been added as a member of %s.';
$string['institutionmemberrejectsubject'] = 'Institution membership request declined';
$string['institutionmemberrejectmessage'] = 'Your request for membership of %s was declined.';
$string['noinstitutionstafffound'] = 'No institution staff were found.';
$string['noinstitutionadminfound'] = 'No institution administrators were found.';
$string['Memberships'] = 'Memberships';
$string['Requests'] = 'Requests';
$string['Invitations'] = 'Invitations';
$string['institutionmembershipfullsubject'] = 'Institution membership quota reached';
$string['institutionmembershipfullmessagetext'] = 'Hello %s,

The maximum number of accounts for %s on %s has been reached.

Please clean up existing accounts or ask to have the maximum number of allowed accounts increased for this institution. Any site administrator can increase the limit.

Regards,
The %s Team';

$string['institutionmemberrefusedprivacy'] = 'Hello %s,

%s, with the username %s, has refused the %s. Their account was suspended.
%s %s

Please contact them via email at %s if you wish to discuss the refusal.

Regards,
The %s Team';
$string['thereasonis'] = 'The reason is:';
$string['config'] = 'Configuration';

$string['sendmessage'] = 'Send message';
$string['spamtrap'] = 'Spam trap';
$string['formerror'] = 'There was an error processing your submission. Please try again.';
$string['formerroremail'] = 'Contact us at %s if you continue to have problems.';
$string['denylisteddomaininurl'] = 'A URL in this field contains the deny listed domain %s.';
$string['newuserscantpostlinksorimages1'] = 'Sorry, anonymous or newly registered people aren\'t allowed to post links. Please reword your post to remove any links or URLs and try again.';

$string['notinstallable'] = 'Not installable';
$string['pluginnotinstallable'] = "Plugin %s %s is not installable: ";
$string['installedplugins'] = 'Installed plugins';
$string['notinstalledplugins'] = '<span class="error">Not installed plugins</span>';
$string['plugintype'] = 'Plugin type';

$string['settingssaved'] = 'Settings saved';
$string['settingssavefailed'] = 'Failed to save settings';

$string['width'] = 'Width';
$string['height'] = 'Height';
$string['widthshort'] = 'w';
$string['heightshort'] = 'h';
$string['filter'] = 'Filter';
$string['expand'] = 'Expand';
$string['expandspecific'] = 'Expand %s';
$string['collapse'] = 'Collapse';
$string['collapsespecific'] = 'Collapse %s';
$string['more...'] = 'More...';
$string['moreoptions'] = 'More options';
$string['moreoptionsfor'] = 'More options for "%s"';
$string['submittedinfo'] = 'Submission information';
$string['submittedinfofor'] = 'Submission information for "%s"';
$string['releasedinfo'] = 'Release options';
$string['releasedinfofor'] = 'Release options for "%s"';
$string['details'] = 'details';
$string['Details'] = 'Details';
$string['nohelpfound'] = 'There was no help found for this item.';
$string['nohelpfoundpage'] = 'There was no help found for this page.';
$string['couldnotgethelp'] = 'An error occurred trying to retrieve the help page.';
$string['profileimagetext'] = "%s's profile picture";
$string['profileimagetexttemplate'] = "Profile picture will go here";
$string['profileimagetextanonymous'] = "anonymous profile picture";
$string['primaryemailinvalid'] = 'Your primary email address is invalid.';
$string['addemail'] = 'Add email address';
$string['connectedapps'] = 'Connected apps';
$string['acccountappsdescription'] = 'Here you can administer any applications that require token access.';
$string['acccountaddappsdescription'] = 'Currently, there are no plugins active that allow token administration.';
$string['acccountchooseappsdescription'] = 'To administer your application tokens, please select the application from the "Connected apps" bar.';

// Search
$string['search'] = 'Search';
$string['searchtype'] = 'Search type';
$string['searchusers1'] = 'Search for people';
$string['Query'] = 'Search';
$string['query'] = 'Search';
$string['querydescription'] = 'The words to be searched for';
$string['result'] = 'result';
$string['results'] = 'results';
$string['nresults'] = array(
    '%s result',
    '%s results'
);
$string['Results'] = 'Results';
$string['noresultsfound'] = 'No results found';
$string['users'] = 'People';
$string['searchwithin'] = 'Search within';

// artefact
$string['artefact'] = 'artefact';
$string['Artefact'] = 'Artefact';
$string['Artefacts'] = 'Artefacts';
$string['artefactnotfound'] = 'Artefact with id %s not found';
$string['artefactnotrendered'] = 'Artefact not rendered';
$string['nodeletepermission'] = 'You do not have permission to delete this artefact.';
$string['noeditpermission'] = 'You do not have permission to edit this artefact.';
$string['cantbedeleted'] = 'This artefact cannot be deleted because it and/or its sub artefacts are in submitted pages.';
$string['cantbedeletedbeingusedascoverimage'] = 'This artefact cannot be deleted because it is being used as cover image in an existing portfolio.';
$string['Permissions'] = 'Permissions';
$string['republish'] = 'Publish';
$string['view'] = 'Page';
$string['artefactnotpublishable'] = 'Artefact %s is not publishable in page %s';
$string['nopublishpermissiononartefact'] = 'You do not have permission to publish %s.';
$string['nopathfound'] = 'No path found for this artefact.';
$string['cantmoveitem'] = 'Cannot move this artefact.';

$string['belongingto'] = 'Belonging to';
$string['attachment'] = 'Attachment';
$string['editaccess'] = 'Share';

// Upload manager
$string['clammovedfile'] = 'The file has been moved to a quarantine directory.';
$string['clamdeletedfile'] = 'The file has been deleted.';
$string['clamdeletedfilefailed'] = 'The file could not be deleted.';
$string['clambroken'] = 'Your administrator has enabled virus checking for file uploads but has misconfigured something. Your file upload was NOT successful. Your administrator was notified so they can fix it. Maybe try uploading this file later.';
$string['clamemailsubject'] = '%s :: ClamAV notification';
$string['clamlost'] = 'ClamAV is configured to run on file upload, but the path supplied to ClamAV, %s, is invalid.';
$string['clamnotset'] = 'You have activated virus checking, but have not set a "Path to ClamAV" value. Virus checking will not take effect until you configure the path to ClamAV by adding a $cfg->pathtoclam value to your config.php file.';
$string['clamfailed'] = 'ClamAV has failed to run. The return error message was %s. Here is the output from ClamAV:';
$string['clamunknownerror'] = 'There was an unknown error with ClamAV.';
$string['image'] = 'Image';
$string['imageformattingoptions'] = 'Image formatting options';
$string['filenotimage'] = 'The file you uploaded is not a valid image. It must be a PNG, JPEG or GIF file.';
$string['uploadedfiletoobig1'] = 'The file exceeded the maximum upload file size of %s. Please upload a smaller file.';
$string['notphpuploadedfile'] = 'The file was lost in the upload process. This should not happen. Please contact your administrator for more information.';
$string['virusfounduser'] = 'The file you have uploaded, %s, has been scanned by a virus checker and found to be infected! Your file upload was NOT successful.';
$string['fileunknowntype'] = 'The type of your uploaded file could not be determined. Your file may be corrupted, or it could be a configuration problem. Please contact your administrator.';
$string['virusrepeatsubject'] = 'Warning: %s is a repeat virus uploader.';
$string['virusrepeatmessage'] = '%s has uploaded multiple files which have been scanned by a virus checker and found to be infected.';
$string['exportfiletoobig'] = 'The file about to be generated will be too big. Please clear some disk space.';
$string['phpuploaderror'] = 'An error occurred during file upload: %s (Error code %s).';
$string['phpuploaderror_1'] = 'The uploaded file exceeds the upload_max_filesize directive in php.ini.';
$string['phpuploaderror_2'] = 'The uploaded file exceeds the max_file_size directive that was specified in the HTML form.';
$string['phpuploaderror_3'] = 'The uploaded file was only partially uploaded.';
$string['phpuploaderror_4'] = 'No file was uploaded.';
$string['phpuploaderror_6'] = 'Missing a temporary folder.';
$string['phpuploaderror_7'] = 'Failed to write file to disk. Check that your filesystem has enough space to write to the Mahara dataroot and/or the PHP \'upload_tmp_dir\' directories.';
$string['phpuploaderror_8'] = 'File upload stopped by extension.';
$string['adminphpuploaderror'] = 'A file upload error was probably caused by your server configuration.';
$string['noinputnamesupplied'] = 'No input name is provided.';
$string['cannotrenametempfile'] = 'Can not rename the temporary file.';
$string['failedmovingfiletodataroot'] = 'Can not move uploaded file to dataroot.';

$string['youraccounthasbeensuspendedtext2'] = 'Your account at %s has been suspended by %s.'; // @todo: more info?
$string['youraccounthasbeensuspendedtextcron'] = 'Your account at %s has been suspended.';
$string['youraccounthasbeensuspendedreasontext'] = "Your account at %s has been suspended by %s. Reason:\n\n%s";
$string['youraccounthasbeensuspendedreasontextcron'] = "Your account at %s has been suspended. Reason:\n\n%s";
$string['youraccounthasbeenunsuspendedtext2'] = 'Your account at %s has been unsuspended. You may once again log in and use the site.'; // can't provide a login link because we don't know how they log in - it might be by xmlrpc
$string['youraccounthasbeensuspendedtext3'] = 'Your account on %s has been suspended because you refused to consent to the %s.';

// size of stuff
$string['sizemb'] = 'MB';
$string['sizekb'] = 'KB';
$string['sizegb'] = 'GB';
$string['sizeb'] = 'B';
$string['bytes'] = 'bytes';

// countries

$string['country.af'] = 'Afghanistan';
$string['country.ax'] = 'Åland Islands';
$string['country.al'] = 'Albania';
$string['country.dz'] = 'Algeria';
$string['country.as'] = 'American Samoa';
$string['country.ad'] = 'Andorra';
$string['country.ao'] = 'Angola';
$string['country.ai'] = 'Anguilla';
$string['country.aq'] = 'Antarctica';
$string['country.ag'] = 'Antigua and Barbuda';
$string['country.ar'] = 'Argentina';
$string['country.am'] = 'Armenia';
$string['country.aw'] = 'Aruba';
$string['country.au'] = 'Australia';
$string['country.at'] = 'Austria';
$string['country.az'] = 'Azerbaijan';
$string['country.bs'] = 'Bahamas';
$string['country.bh'] = 'Bahrain';
$string['country.bd'] = 'Bangladesh';
$string['country.bb'] = 'Barbados';
$string['country.by'] = 'Belarus';
$string['country.be'] = 'Belgium';
$string['country.bz'] = 'Belize';
$string['country.bj'] = 'Benin';
$string['country.bm'] = 'Bermuda';
$string['country.bt'] = 'Bhutan';
$string['country.bo'] = 'Bolivia (Plurinational State of)';
$string['country.bq'] = 'Bonaire';
$string['country.ba'] = 'Bosnia and Herzegovina';
$string['country.bw'] = 'Botswana';
$string['country.bv'] = 'Bouvet Island';
$string['country.br'] = 'Brazil';
$string['country.io'] = 'British Indian Ocean Territory';
$string['country.bn'] = 'Brunei Darussalam';
$string['country.bg'] = 'Bulgaria';
$string['country.bf'] = 'Burkina Faso';
$string['country.bi'] = 'Burundi';
$string['country.kh'] = 'Cambodia';
$string['country.cm'] = 'Cameroon';
$string['country.ca'] = 'Canada';
$string['country.cv'] = 'Cape Verde';
$string['country.ky'] = 'Cayman Islands';
$string['country.cf'] = 'Central African Republic';
$string['country.td'] = 'Chad';
$string['country.cl'] = 'Chile';
$string['country.cn'] = 'China';
$string['country.cx'] = 'Christmas Island';
$string['country.cc'] = 'Cocos (Keeling) Islands';
$string['country.co'] = 'Colombia';
$string['country.km'] = 'Comoros';
$string['country.cg'] = 'Congo';
$string['country.cd'] = 'Congo, The Democratic Republic of The';
$string['country.ck'] = 'Cook Islands';
$string['country.cr'] = 'Costa Rica';
$string['country.ci'] = 'Cote D\'ivoire';
$string['country.hr'] = 'Croatia';
$string['country.cu'] = 'Cuba';
$string['country.cw'] = 'Curacao';
$string['country.cy'] = 'Cyprus';
$string['country.cz'] = 'Czech Republic';
$string['country.dk'] = 'Denmark';
$string['country.dj'] = 'Djibouti';
$string['country.dm'] = 'Dominica';
$string['country.do'] = 'Dominican Republic';
$string['country.ec'] = 'Ecuador';
$string['country.eg'] = 'Egypt';
$string['country.sv'] = 'El Salvador';
$string['country.gq'] = 'Equatorial Guinea';
$string['country.er'] = 'Eritrea';
$string['country.ee'] = 'Estonia';
$string['country.et'] = 'Ethiopia';
$string['country.fk'] = 'Falkland Islands (Malvinas)';
$string['country.fo'] = 'Faroe Islands';
$string['country.fj'] = 'Fiji';
$string['country.fi'] = 'Finland';
$string['country.fr'] = 'France';
$string['country.gf'] = 'French Guiana';
$string['country.pf'] = 'French Polynesia';
$string['country.tf'] = 'French Southern Territories';
$string['country.ga'] = 'Gabon';
$string['country.gm'] = 'Gambia';
$string['country.ge'] = 'Georgia';
$string['country.de'] = 'Germany';
$string['country.gh'] = 'Ghana';
$string['country.gi'] = 'Gibraltar';
$string['country.gr'] = 'Greece';
$string['country.gl'] = 'Greenland';
$string['country.gd'] = 'Grenada';
$string['country.gp'] = 'Guadeloupe';
$string['country.gu'] = 'Guam';
$string['country.gt'] = 'Guatemala';
$string['country.gg'] = 'Guernsey';
$string['country.gn'] = 'Guinea';
$string['country.gw'] = 'Guinea-bissau';
$string['country.gy'] = 'Guyana';
$string['country.ht'] = 'Haiti';
$string['country.hm'] = 'Heard Island and McDonald Islands';
$string['country.va'] = 'Holy See';
$string['country.hn'] = 'Honduras';
$string['country.hk'] = 'Hong Kong';
$string['country.hu'] = 'Hungary';
$string['country.is'] = 'Iceland';
$string['country.in'] = 'India';
$string['country.id'] = 'Indonesia';
$string['country.ir'] = 'Iran, Islamic Republic of';
$string['country.iq'] = 'Iraq';
$string['country.ie'] = 'Ireland';
$string['country.im'] = 'Isle of Man';
$string['country.il'] = 'Israel';
$string['country.it'] = 'Italy';
$string['country.jm'] = 'Jamaica';
$string['country.jp'] = 'Japan';
$string['country.je'] = 'Jersey';
$string['country.jo'] = 'Jordan';
$string['country.kz'] = 'Kazakhstan';
$string['country.ke'] = 'Kenya';
$string['country.ki'] = 'Kiribati';
$string['country.kp'] = 'Korea, Democratic People\'s Republic of';
$string['country.kr'] = 'Korea, Republic of';
$string['country.xk'] = 'Kosovo';
$string['country.kw'] = 'Kuwait';
$string['country.kg'] = 'Kyrgyzstan';
$string['country.la'] = 'Lao People\'s Democratic Republic';
$string['country.lv'] = 'Latvia';
$string['country.lb'] = 'Lebanon';
$string['country.ls'] = 'Lesotho';
$string['country.lr'] = 'Liberia';
$string['country.ly'] = 'Libya';
$string['country.li'] = 'Liechtenstein';
$string['country.lt'] = 'Lithuania';
$string['country.lu'] = 'Luxembourg';
$string['country.mo'] = 'Macao';
$string['country.mk'] = 'North Macedonia';
$string['country.mg'] = 'Madagascar';
$string['country.mw'] = 'Malawi';
$string['country.my'] = 'Malaysia';
$string['country.mv'] = 'Maldives';
$string['country.ml'] = 'Mali';
$string['country.mt'] = 'Malta';
$string['country.mh'] = 'Marshall Islands';
$string['country.mq'] = 'Martinique';
$string['country.mr'] = 'Mauritania';
$string['country.mu'] = 'Mauritius';
$string['country.yt'] = 'Mayotte';
$string['country.mx'] = 'Mexico';
$string['country.fm'] = 'Micronesia, Federated States of';
$string['country.md'] = 'Moldova, Republic of';
$string['country.me'] = 'Montenegro';
$string['country.mc'] = 'Monaco';
$string['country.mn'] = 'Mongolia';
$string['country.ms'] = 'Montserrat';
$string['country.ma'] = 'Morocco';
$string['country.mz'] = 'Mozambique';
$string['country.mm'] = 'Myanmar';
$string['country.na'] = 'Namibia';
$string['country.nr'] = 'Nauru';
$string['country.np'] = 'Nepal';
$string['country.nl'] = 'Netherlands';
$string['country.nc'] = 'New Caledonia';
$string['country.nz'] = 'New Zealand';
$string['country.ni'] = 'Nicaragua';
$string['country.ne'] = 'Niger';
$string['country.ng'] = 'Nigeria';
$string['country.nu'] = 'Niue';
$string['country.nf'] = 'Norfolk Island';
$string['country.mp'] = 'Northern Mariana Islands';
$string['country.no'] = 'Norway';
$string['country.om'] = 'Oman';
$string['country.pk'] = 'Pakistan';
$string['country.pw'] = 'Palau';
$string['country.ps'] = 'Palestine, State of';
$string['country.pa'] = 'Panama';
$string['country.pg'] = 'Papua New Guinea';
$string['country.py'] = 'Paraguay';
$string['country.pe'] = 'Peru';
$string['country.ph'] = 'Philippines';
$string['country.pn'] = 'Pitcairn';
$string['country.pl'] = 'Poland';
$string['country.pt'] = 'Portugal';
$string['country.pr'] = 'Puerto Rico';
$string['country.qa'] = 'Qatar';
$string['country.re'] = 'Reunion';
$string['country.ro'] = 'Romania';
$string['country.ru'] = 'Russian Federation';
$string['country.rw'] = 'Rwanda';
$string['country.bl'] = 'Saint Barthelemy';
$string['country.sh'] = 'Saint Helena, Ascension and Tristan da Cunha';
$string['country.kn'] = 'Saint Kitts and Nevis';
$string['country.lc'] = 'Saint Lucia';
$string['country.mf'] = 'Saint Martin (French part)';
$string['country.pm'] = 'Saint Pierre and Miquelon';
$string['country.vc'] = 'Saint Vincent and The Grenadines';
$string['country.ws'] = 'Samoa';
$string['country.sm'] = 'San Marino';
$string['country.st'] = 'Sao Tome and Principe';
$string['country.sa'] = 'Saudi Arabia';
$string['country.sn'] = 'Senegal';
$string['country.rs'] = 'Serbia';
$string['country.sc'] = 'Seychelles';
$string['country.sl'] = 'Sierra Leone';
$string['country.sg'] = 'Singapore';
$string['country.sx'] = 'Sint Maarten (Dutch part)';
$string['country.sk'] = 'Slovakia';
$string['country.si'] = 'Slovenia';
$string['country.sb'] = 'Solomon Islands';
$string['country.so'] = 'Somalia';
$string['country.za'] = 'South Africa';
$string['country.gs'] = 'South Georgia and The South Sandwich Islands';
$string['country.ss'] = 'South Sudan';
$string['country.es'] = 'Spain';
$string['country.lk'] = 'Sri Lanka';
$string['country.sd'] = 'Sudan';
$string['country.sr'] = 'Suriname';
$string['country.sj'] = 'Svalbard and Jan Mayen';
$string['country.sz'] = 'Swaziland';
$string['country.se'] = 'Sweden';
$string['country.ch'] = 'Switzerland';
$string['country.sy'] = 'Syrian Arab Republic';
$string['country.tw'] = 'Taiwan, Province of China';
$string['country.tj'] = 'Tajikistan';
$string['country.tz'] = 'Tanzania, United Republic of';
$string['country.th'] = 'Thailand';
$string['country.tl'] = 'Timor-leste';
$string['country.tg'] = 'Togo';
$string['country.tk'] = 'Tokelau';
$string['country.to'] = 'Tonga';
$string['country.tt'] = 'Trinidad and Tobago';
$string['country.tn'] = 'Tunisia';
$string['country.tr'] = 'Turkey';
$string['country.tm'] = 'Turkmenistan';
$string['country.tc'] = 'Turks and Caicos Islands';
$string['country.tv'] = 'Tuvalu';
$string['country.ug'] = 'Uganda';
$string['country.ua'] = 'Ukraine';
$string['country.ae'] = 'United Arab Emirates';
$string['country.gb'] = 'United Kingdom';
$string['country.us'] = 'United States';
$string['country.um'] = 'United States Minor Outlying Islands';
$string['country.uy'] = 'Uruguay';
$string['country.uz'] = 'Uzbekistan';
$string['country.vu'] = 'Vanuatu';
$string['country.ve'] = 'Venezuela (Bolivarian Republic of)';
$string['country.vn'] = 'Viet Nam';
$string['country.vg'] = 'Virgin Islands, British';
$string['country.vi'] = 'Virgin Islands, U.S.';
$string['country.wf'] = 'Wallis and Futuna';
$string['country.eh'] = 'Western Sahara';
$string['country.ye'] = 'Yemen';
$string['country.zm'] = 'Zambia';
$string['country.zw'] = 'Zimbabwe';

$string['nocountryselected'] = 'No country selected';
$string['countryisodisclaimer'] = 'Country names are displayed as defined in ISO 3166, published by the International Organization for Standardization (ISO).';
$string['countryisocustomise'] = 'To adjust any country names for your site, please edit the "mahara.php" language file in each translation or <a href="https://wiki.mahara.org/wiki/Developer_Area/Language_strings#Custom_lang_strings_in_.2Flocal">create strings in the local directory</a>.';
// general stuff that doesn't really fit anywhere else
$string['system'] = 'System';
$string['done'] = 'Done';
$string['back'] = 'Back';
$string['backto'] = 'Back to %s';
$string['alphabet'] = 'A,B,C,D,E,F,G,H,I,J,K,L,M,N,O,P,Q,R,S,T,U,V,W,X,Y,Z';
$string['Created'] = 'Created';
$string['Updated'] = 'Updated';
$string['Total'] = 'Total';
$string['Visits'] = 'Visits';
$string['after'] = 'after';
$string['before'] = 'before';
$string['Visibility'] = 'Visibility';
$string['nusers'] = array(
    '1 person',
    '%s persons',
);
$string['hidden'] = 'hidden';
$string['lastupdate'] = 'Last update';
$string['lastupdateorcomment'] = 'Last update or comment';
$string['Title'] = 'Title';
$string['anonymoususer'] = '(Author\'s name hidden)';
$string['removefooterlinksupgradewarning'] = 'Your site uses custom links for the terms and conditions or the privacy statement. The following links "%s" have now been removed. You will need to add their content directly to the site\'s "Administration menu" → "Configure site" → "Legal" section.';

// import related strings (maybe separated later)
$string['importedfrom'] = 'Imported from %s';
$string['incomingfolderdesc'] = 'Files imported from other networked hosts';
$string['remotehost'] = 'Remote host %s';

$string['Copyof'] = 'Copy of %s';

// Profile views
$string['allowpublicaccess'] = 'Allow public access';
$string['viewmyprofilepage']  = 'View profile page';
$string['editmyprofilepage']  = 'Edit profile page';
$string['usersprofile'] = "%s's profile";
$string['profiledescription'] = 'Your profile page is what others see when they click on your name or profile picture.';

// Dashboard views
$string['mydashboard'] = 'My dashboard';
$string['editdashboard'] = 'Edit dashboard';
$string['usersdashboard'] = "%s's dashboard";
$string['dashboarddescription1'] = 'Your dashboard page is what you see on the homepage when you are logged in. Only you have access to it.';
$string['topicsimfollowing'] = "Topics I am following";
$string['inboxblocktitle'] = 'Inbox';
$string['mymessages'] = 'My messages';

$string['pleasedonotreplytothismessage'] = "Please do not reply to this message.";
$string['deleteduser1'] = 'Account deleted';

$string['theme'] = 'Theme';
$string['choosetheme'] = 'Choose theme...';
$string['missingparent'] = 'Theme "%s" has missing parent theme "%s".';

// Homepage info block
$string['Hide2'] = 'Hide information box';
$string['create'] = 'Create';
$string['createsubtitle'] = 'Develop your portfolio';
$string['share'] = 'Share';
$string['sharesubtitle'] = 'Control your privacy';
$string['engage'] = 'Engage';
$string['engagesubtitle'] = 'Find people and join groups';
$string['howtodisable'] = 'You have hidden the information box. You can control its visibility in <a
href="%s">Settings</a>.';

// Blocktype
$string['setblocktitle'] = 'Set a block title';
$string['blockinstanceownerchange'] = 'Edit this block to choose content to display.';
$string['blockinstanceconfigownerauto'] = 'This block will be automatically populated with data once it is copied as a personal portfolio page.';
$string['blockinstanceconfigownerchange'] = 'This block will need to be edited / configured once it is copied as a personal portfolio page for content to show up.';

// Download
$string['filenotfound'] = 'File not found';
$string['filenotfoundmaybeexpired'] = 'File not found. Your export file only exists for 24 hours after it was created. You will need to export your content again.';

$string['betweenxandy'] = 'Between %s and %s';

// Clean URLs
$string['cleanurlallowedcharacters'] = 'Only lowercase letters from a-z, numbers and - are allowed.';

// Registration statistics
$string['content'] = 'Content';
$string['modified'] = 'Modified';
$string['historical'] = 'Historical data';
$string['institutions'] = 'Institutions';
$string['logins'] = 'Logins';
$string['members'] = 'Members';
$string['blocks'] = 'Blocks';
$string['artefacts'] = 'Artefacts';
$string['posts'] = 'Posts';
$string['facebookdescription'] = 'Mahara is an open source ePortfolio and social networking web application.
It provides people with tools to create and maintain a digital portfolio of their learning and social networking features to allow them to interact with each other.';

// Form change checker
$string['wanttoleavewithoutsaving?'] = 'You have made changes - do you want to leave the page without saving them?';

// Image browser
$string['attachedimage'] = 'Attached image';
$string['imagebrowsertitle'] = 'Insert or select an image';
$string['imagebrowserdescription'] = 'Paste the URL of an external image, or use the image browser below to select or upload your own image.';
$string['url'] = 'Image URL';
$string['style'] = 'Style (CSS)';
$string['dimensions'] = 'Dimensions';
$string['constrain'] = 'Constrain';
$string['vspace'] = 'Vertical space';
$string['hspace'] = 'Horizontal space';
$string['border'] = 'Border width';
$string['showcaption'] = 'Show caption';
$string['alignment'] = 'Alignment';

//Select2 strings
$string['errorLoading'] = "The results could not be loaded.";
$string['inputTooLong'] = "Too many characters";
$string['inputTooShort'] = "Enter search query";
$string['loadingMore'] = "Loading more results...";
$string['maximumSelected'] = "Maximum items selected";
$string['noResults'] = "No results found";
$string['searching'] = "Searching...";

// Style guide
$string['styleguide_title'] = 'Style guide';
$string['styleguide_description'] = 'This style guide describes all the different types of components used by Mahara. They are in one place so you can easily check if you have styled everything when you are developing a new theme or plugin. Apply a different theme to your site to see what the individual components look like.';

// Miscellaneous (please keep these alphabetized)
$string['cli_incorrect_value'] = 'Incorrect value, please retry.';
$string['progresspagedescription'] = 'Portfolio completion page for a collection.';
$string['activitypagedescription'] = 'Activity page for an outcomes collection in groups.';
$string['scroll_to_top'] = 'Back to top';
$string['tabgroup'] = 'Group';
$string['tabinstitution'] = 'Institution';
$string['version.'] = 'v.'; // version shortname, used when duplicating pages and collections
$string['viewartefact'] = 'View ';

//Accessing an outdated url that will now redirect with session message
$string['viewartefactdatavuamodal'] = 'The data for %s artefact "%s" cannot be viewed this way anymore. Please go to page "%s" to view it.';
$string['chooselanguage'] = 'Choose language';

$string['currentinstitutionmembership'] = 'Current institution';
$string['selfmigration'] = 'Move account';
$string['migrateaccounttoinstitution'] = 'Move account to another institution';
$string['migrateinstitutiondescription'] = '<div class="lead">You can choose a new institution to move to.</div><p>You will be required to verify your login details and redirected back to %s. You will receive an email to confirm your account move. Please check your emails for the confirmation message to finalise your account move.</p>';
$string['migrateemailsubject'] = '%s account move confirmation';
$string['migrateemailtext'] = 'Hello %s,

You want to move your account on %s from institution "%s" to institution "%s". Please confirm this action by clicking the link

%s

This link is valid for 30 minutes.

Regards,
The %s Team';
$string['migrateemailtext_html'] = '<p>Hello %s,</p>
<p>You want to move your account on %s from institution "%s" to institution "%s". Please <a href="%s">confirm your account move</a>.</p>
<p>This link is valid for 30 minutes.</p>
<p>Regards,<br>
The %s Team</p>';
$string['migrateemailtextexistinguser'] = 'Hello %s,

You want to move your account on %s from institution "%s" to institution "%s".

You cannot do so because there is another account with the same username and email credentials.

To sort out this problem, please contact the administrator of institution "%s":

%s

Regards,
The %s Team';
$string['migrateemailtextexistinguser_html'] = '<p>Hello %s,</p>
<p>You want to move your account on %s from institution "%s" to institution "%s".</p>
<p>You cannot do so because there is another account with the same username and email credentials.</p>
<p>To sort out this problem, please <a href="%s">contact the administrator</a> of institution "%s".</p>
<p>Regards,<br>
The %s Team</p>';
$string['migrateaccountconfirm'] = 'Confirm your account move to another institution on %s.';
$string['migrateaccountconfirminfo'] = 'Your account will be moved from "%s" to "%s" and you will not be able to log in with your old credentials to your account anymore. If you do use your old login again, a new account will be created.';
$string['nomigrateoptions'] = 'There are no migration options to choose from.';
$string['invalidkeytoken'] = 'Something went wrong. Either the link in the confirmation email has expired or another confirmation email has been sent. Please check for the latest confirmation email or request a new one.';
$string['migratecancelled'] = 'Your account move has been cancelled';
$string['migratesuccess'] = 'Your account move to institution "%s" was successful. Please log in with your login details for that institution. Remember, if you log into your former institution, a new empty account will be created and you will have two accounts.';
$string['restartmigration'] = 'Please begin the account moving process again on <a href="%s">choose institution</a> page';
$string['confirmmigration'] = 'Move account';
$string['migrationcancelled'] = 'Your account move was cancelled.';
$string['cannotcompletemigrationwithuser'] = 'You need to be logged in with the credentials for your current institution, not the credentials of the institution to which you want to move. Then follow link in the email again.';
$string['migrateinstitutionpagelink'] = 'Go to the <a href="%s">Move account</a> page to change your institution and how you log into %s.';
$string['institutionmaxusersexceededrequest'] = 'This institution is full. You cannot join it at this point. The institution administrator has been informed. Please try again later. If the problem persists, <a href="%s">contact the institution administrator</a>.';
$string['postformresponse'] = 'A confirmation email has been sent to your primary email address. Please follow the link in that email to confirm the move to your new institution.';
$string['selfmigrate'] = 'Move account to another institution';
$string['institutionmembershipfullmessagetextuser'] = 'Hello %s,

%s wants to move to institution "%s" on %s but the maximum number of institution members has been reached.

Please either remove unused accounts or ask a site administrator to increase the number of accounts for this institution.

Once you have made the changes, please let %s know that they can try again by clicking the following link

%s

Regards,
The %s Team';
$string['institutionfilledreplysubject'] = 'Account move is possible again';
$string['institutionfilledreplymessage'] = 'Hello %s,

Thank you for your patience. You can move your account to institution "%s" now by following this link

%s

Regards,
The %s Team';
$string['institutionmembershipdescription'] = 'You can see your institution membership status and any actions you can perform that relate to institution membership.';
$string['institutionmembershiprequestsdescription'] = 'You have requested to join the following institutions.';
$string['institutionmembershipinvitedescription'] = 'An administrator has invited you to join the following institutions.';
$string['institutionmembershipjoindescription'] = 'You can send a request to join an institution. The "Institution ID" field is for setting the student ID for this institution.';

// Account updating via CSV upload
$string['accountupdated'] = '%s: Account updated';
$string['accountupdatedheading'] = 'Dear %s,

Your account has been updated on %s. Your username may have changed in the process. It is:

%s
';
$string['accountupdatedheadinghtml'] = '<p>Dear %s,</p>
<p>Your account has been updated on %s. Your username may have changed in the process. It is:</p>

<p>%s </p>
';
$string['accountupdatednewinstitution'] = '
You have been added to the institution %s.
';
$string['accountupdatednewinstitutionhtml'] = '
<p>You have been <strong>added</strong> to the institution %s.</p>
';
$string['accountupdatedremovedinstitutions'] = '
You have been removed from the following institution(s): %s
';
$string['accountupdatedremovedinstitutionshtml'] = '
<p>You have been <strong>removed</strong> from the following institution(s): <br /> %s</p>
';
$string['accountupdatedpasswordreset'] = '
Please change your password using the following link:

%s

Note: This link will expire in one day at %s.
';
$string['accountupdatedpasswordresethtml'] = '
<p>Please <a href="%s">change your password</a>.</p>

<p><strong>Note</strong>: This link will expire in one day at %s.</p>
';
$string['accountupdateresetpasslink'] = '%sforgotpass.php?key=%s';
$string['accountupdatefooter'] = '
Regards,
%s administrator';
$string['accountupdatefooterhtml'] = '
<p>Regards,<br />
%s administrator</p>';
