<?php
/**
 * Duplicate a group and its artefacts.
 *
 * New group will use same name with '.v' + unique number appended
 * @package    mahara
 * @subpackage core
 * @author     Catalyst IT Limited <mahara@catalyst.net.nz>
 * @license    https://www.gnu.org/licenses/gpl-3.0.html GNU GPL version 3 or later
 * @copyright  For copyright information on Mahara, please see the README file distributed with this software.
 *
 */

define('INTERNAL', 1);

define('SECTION_PLUGINTYPE', 'core');
define('SECTION_PLUGINNAME', 'group');
define('SECTION_PAGE', 'copy');

require(dirname(dirname(__FILE__)) . '/init.php');
require_once(get_config('libroot') . 'view.php');
require_once(get_config('libroot') . 'group.php');

$groupid = param_integer('id');
$return = param_alphanum('return', null);

// Check the group exists
if (!get_group_by_id($groupid, true)) {
    throw new GroupNotFoundException(get_string('groupnotfound', 'group', $groupid));
}

// Check for group role of the user doing the copying
$userid = $USER->get('id');
$role = group_user_access($groupid, $userid);
if (!($USER->get('admin') || $role == 'admin')) {
    throw new AccessDeniedException();
}
// Check the site setting for create groups - as copying is essentially creating a group
$cancopy = group_can_create_groups();
if (!$cancopy) {
    throw new AccessDeniedException();
}

group_copy($groupid, $return);
