<?php
/**
 * Provides a UI to edit which Pages will appear in the Collection.
 *
 * @package    mahara
 * @subpackage core
 * @author     Catalyst IT Limited <mahara@catalyst.net.nz>
 * @license    https://www.gnu.org/licenses/gpl-3.0.html GNU GPL version 3 or later
 * @copyright  For copyright information on Mahara, please see the README file distributed with this software.
 *
 */

define('INTERNAL', 1);

define('SECTION_PLUGINTYPE', 'core');
define('SECTION_PLUGINNAME', 'collection');
define('SECTION_PAGE', 'views');

require(dirname(dirname(__FILE__)) . '/init.php');
require_once('collection.php');
require_once('view.php');

$id = param_integer('id');

// view addition/displayorder values
$view = param_integer('view',0);
$direction = param_variable('direction','');

$collection = new Collection($id);
if (!$USER->can_edit_collection($collection)) {
    throw new AccessDeniedException(get_string('canteditcollection', 'collection'));
}
if ($collection->get('outcomeportfolio')) {
    throw new AccessDeniedException(get_string('canteditcollection', 'collection'));
}
$sesskey = $USER->get('sesskey');
$inlinejs = '';
if ($accesschanged = $SESSION->get('pageaccesschanged')) {
    $alertstr = get_string('viewsaddedaccesschanged', 'collection');
    foreach ($accesschanged as $viewid) {
        $changedview = new View($viewid);
        $alertstr .= " " . json_encode($changedview->get('title')) . ",";
    }
    $alertstr = substr($alertstr, 0, -1) . '.';
    $alertstr = get_string('viewsaddedtocollection1', 'collection', $SESSION->get('pagesadded')) . ' ' . $alertstr;
    $hassecreturl = $SESSION->get('hassecreturl');
    $alertstr .= ($hassecreturl) ? ' ' . get_string('viewaddedsecreturl', 'collection') : '';
    $closestr = get_string('Close', 'mahara');
    $inlinejs = <<<EOF
jQuery(function($) {
    var message = $('<div id="changestatusline" class="alert alert-dismissible alert-warning" role="alert"><button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="$closestr"><span aria-hidden="true">&times;</span></button><p>$alertstr</p></div>');
    $('#messages').append(message);
});
EOF;
    $SESSION->set('pageaccesschanged', false);
    $SESSION->set('pagesadded', false);
    $SESSION->set('hassecreturl', false);
}
$owner = $collection->get('owner');
$groupid = $collection->get('group');
$institutionname = $collection->get('institution');
$urlparams = array();
if (!empty($groupid)) {
    define('MENUITEM', 'engage/index');
    define('MENUITEM_SUBPAGE', 'views');
    define('GROUP', $groupid);
    $group = group_current_group();
    define('TITLE', $group->name . ' - ' . get_string('editviews', 'collection'));
    $baseurl = get_config('wwwroot') . 'view/groupviews.php';
    $urlparams['group'] = $groupid;
}
else if (!empty($institutionname)) {
    if ($institutionname == 'mahara') {
        define('ADMIN', 1);
        define('MENUITEM', 'configsite/views');
        $baseurl = get_config('wwwroot') . 'admin/site/views.php';
    }
    else {
        define('INSTITUTIONALADMIN', 1);
        define('MENUITEM', 'manageinstitutions/institutionviews');
        $baseurl = get_config('wwwroot') . 'view/institutionviews.php';
    }
    define('TITLE', get_string('editviews', 'collection'));
    $urlparams['institution'] = $institutionname;
}
else {
    define('MENUITEM', 'create/views');
    define('TITLE', get_string('editviews', 'collection'));
    $baseurl = get_config('wwwroot') . 'view/index.php';
}
define('SUBSECTIONHEADING', $collection->get('name'));

if ($urlparams) {
    $baseurl .= '?' . http_build_query($urlparams);
}
$accessurl = get_config('wwwroot') . 'view/accessurl.php?collection=' . $id;

if ($collection->is_submitted()) {
    $submitinfo = $collection->submitted_to();
    throw new AccessDeniedException(get_string('canteditsubmitted', 'collection', $submitinfo->name));
}

if ($view AND !empty($direction)) {
    $collection->set_viewdisplayorder($view,$direction);
    redirect('/collection/views.php?id='.$id);
}

$views = $collection->views();

if ($views) {
    foreach ($views['views'] as &$v) {
        $v->remove = pieform(array(
            'renderer' => 'div',
            'class' => 'form-as-button float-end',
            'name' => 'removeview_' . $v->view,
            'successcallback' => 'removeview_submit',
            'elements' => array(
                'view' => array(
                    'type' => 'hidden',
                    'value' => $v->view,
                ),
                'submit' => array(
                    'type' => 'button',
                    'usebuttontag' => true,
                    'class' => 'btn-link btn-sm',
                    'confirm' => get_string('viewconfirmremove', 'collection'),
                    'value' => '<span class="icon icon-times text-danger" role="presentation" aria-hidden="true"><span class="visually-hidden">' . get_string('remove') . '</span></span>',
                ),
            ),
        ));
    }
}

$elements = array();
$viewsform = null;
if ($available = Collection::available_views($owner, $groupid, $institutionname)) {
    $checkboxes = array();
    foreach ($available as $a) {
        $checkboxes['view_'.$a->id] = array(
            'class'     => 'btn drag-default-button',
            'isformgroup' => false,
            'type'      => 'checkbox',
            'title'     => $a->title,
        );
    };

    $elements['draggable-group'] = array(
        'class' => 'btn-group btn-group-vertical fullwidth ',
        'type' => 'fieldset',
        'renderelementsonly' => true,
        'elements' => $checkboxes
    );

    $elements['submit'] = array(
        'class' => 'btn-secondary float-end add-pages',
        'type' => 'button',
        'usebuttontag' => true,
        'value' => '<span class="icon icon-plus left" role="presentation" aria-hidden="true"></span>' . get_string('addviews','collection'),
        'goto' => get_config('wwwroot') . 'collection/views.php?id='.$id,
    );

    $viewsform = pieform(array(
        'name' => 'addviews',
        'class' => 'btn-draggable fullwidth',
        'renderer' => 'div',
        'plugintype' => 'core',
        'pluginname' => 'collection',
        'autofocus' => false,
        'method'   => 'post',
        'elements' => $elements,
    ));
}

$smarty = smarty(array('jquery','js/jquery/jquery-ui/js/jquery-ui.min.js','js/jquery/jquery-ui/js/jquery-ui.touch-punch.min.js', 'manage-collection-pages'));


$smarty->assign('id', $id);
$smarty->assign('INLINEJAVASCRIPT', $inlinejs);
$smarty->assign('accessurl', $accessurl);
$smarty->assign('baseurl', $baseurl);
$smarty->assign('displayurl', get_config('wwwroot') . 'collection/views.php?id=' . $id);
$smarty->assign('removeurl', get_config('wwwroot') . 'collection/deleteview.php?id=' . $id);
$smarty->assign('views', $views);
$smarty->assign('viewsform', $viewsform);
$smarty->display('collection/views.tpl');

/**
 * Callback to validate the Add Views Pieform.
 *
 * @param Pieform $form
 * @param array $values
 */
function addviews_validate(Pieform $form, $values) {
    // Check if a view was selected. Each view was marked with a
    // key of view_<id> in order to identify the correct items
    // from the form values.
    $chosen = array();
    foreach ($values as $key => $value) {
        if (substr($key, 0, 5) === 'view_' AND $value == true) {
            $chosen[] = substr($key, 5);
        }
    }
    if (empty($chosen)) {
        $form->set_error(null, get_string('needtoselectaview', 'collection'));
        return;
    }
}

/**
 * Callback to handle the submission of the Add Views Pieform.
 *
 * @param Pieform $form
 * @param array $values
 */
function addviews_submit(Pieform $form, $values) {
    global $SESSION, $collection;

    // Check if the existing view permissions are different from the views
    // being added.
    $viewids = get_column('collection_view', 'view', 'collection', $collection->get('id'));
    $firstviewaccess = array();
    if (count($viewids)) {
        $firstview = new View($viewids[0]);
        $firstviewaccess = $firstview->get_access();
    }

    $chosen = array();
    foreach ($values as $key => $value) {
        if (substr($key, 0, 5) === 'view_' AND $value == true) {
            $chosen[] = substr($key, 5);
        }
    }
    // New view permissions.
    $collectiondifferent = false;
    $different = false;
    $differentarray = array();

    // If the collection has been set to be auto copy and it doesn't have any
    // views yet, make sure the new views are shared with the institution.
    $institution = $collection->get('institution');
    if (isset($institution) && $institution && empty($viewids) && $collection->get('autocopytemplate')) {
        $time = db_format_timestamp(time());
        ensure_record_exists(
            'view_access',
            (object) array('view' => $chosen[0], 'institution' => $institution),
            (object) array('view' => $chosen[0], 'institution' => $institution, 'ctime' => $time),
            'id'
        );
    }

    foreach ($chosen as $viewid) {
        $view = new View($viewid);
        $viewaccess = $view->get_access();

        if (!empty($firstviewaccess) && empty($viewaccess)) {
            // Adding the collection access rules to the added pages.
            $different = true;
            $differentarray[] = $viewid;
        }
        else if (!empty($firstviewaccess)) {
            $merged = combine_arrays($firstviewaccess, $viewaccess);
            if ($merged != $firstviewaccess) {
                // Adding the new access rules to both collection and added
                // pages.
                $different = true;
                $collectiondifferent = true;
                $differentarray[] = $viewid;
            }
            else if ($merged != $viewaccess) {
                // Adding collection access rules to the added pages.
                $different = true;
                $differentarray[] = $viewid;
            }
        }
        else if (empty($firstviewaccess) && !empty($viewaccess)) {
            // Adding the page's access rules to the collection pages.
            $different = true;
            $collectiondifferent = true;
        }
    }
    $count = $collection->add_views($values);
    if ($collection->get('template')) {
        // Added views should be set to template too.
        $collection->set_views_as_template();
    }
    // Check if the collection has a secret url token for any of the existing
    // views.
    $hassecreturl = false;
    $views_all = array_merge($differentarray, $viewids);
    if (!empty($views_all)) {
        if (record_exists_select("view_access", "view IN (" . join(',', array_merge($differentarray, $viewids)) . ") AND (token IS NOT NULL AND token !='')")) {
            $hassecreturl = true;
        }
    }

    if ($collectiondifferent) {
        $differentarray = array_merge($differentarray, $viewids);
    }
    if ($different) {
        $SESSION->set('pageaccesschanged', $differentarray);
        $SESSION->set('pagesadded', $count);
        $SESSION->set('hassecreturl', $hassecreturl);
    }
    else {
        $SESSION->add_ok_msg(get_string('viewsaddedtocollection1', 'collection', $count));
        if ($hassecreturl) {
            $SESSION->add_error_msg(get_string('viewaddedsecreturl', 'collection'));
        }
    }
    redirect('/collection/views.php?id=' . $collection->get('id'));
}

/**
 * Callback for the remove view form.
 *
 * @param Pieform $form
 * @param array $values
 */
function removeview_submit(Pieform $form, $values) {
    global $SESSION, $collection;
    $collection->remove_view((int)$values['view']);
    $SESSION->add_ok_msg(get_string('viewremovedsuccessfully','collection'));
    redirect('/collection/views.php?id=' . $collection->get('id'));
}
