<?php
/**
 *
 * @package    mahara
 * @subpackage admin
 * @author     Catalyst IT Limited <mahara@catalyst.net.nz>
 * @license    https://www.gnu.org/licenses/gpl-3.0.html GNU GPL version 3 or later
 * @copyright  For copyright information on Mahara, please see the README file distributed with this software.
 *
 */

define('INTERNAL', 1);
define('ADMIN', 1);
define('MENUITEM', 'configextensions/pluginadmin');
require(dirname(dirname(dirname(__FILE__))) . '/init.php');
define('TITLE', get_string('pluginadmin', 'admin'));

$plugintype = param_alpha('plugintype');
$pluginname = param_variable('pluginname');

define('SECTION_PLUGINTYPE', $plugintype);
define('SECTION_PLUGINNAME', $pluginname);
define('SECTION_PAGE', 'pluginconfig');

safe_require($plugintype, $pluginname);
$enable  = param_integer('enable', 0);
$disable = param_integer('disable', 0);


$classname = generate_class_name($plugintype, $pluginname);
if ($disable && !$classname::can_be_disabled()) {
    throw new UserException("Plugin $plugintype $pluginname cannot be disabled");
}

if ($enable || $disable) {
    require_once(get_config('libroot') . 'upgrade.php');
    clear_menu_cache();
    activate_plugin_form($plugintype, get_record($plugintype . '_installed', 'name', $pluginname));
}

if ($plugintype == 'artefact') {
    $type = param_alpha('type');
    $classname = generate_artefact_class_name($type);
}
else {
    $type = '';
    $classname = generate_class_name($plugintype, $pluginname);
}

if (!$classname::has_config()) {
    throw new InvalidArgumentException("$classname doesn't have config options available");
}

$form = $classname::get_config_options();
if (method_exists($classname, 'get_config_options_css')) {
    $formcss = $classname::get_config_options_css();
}
else {
    $formcss = array();
}

if (!array_key_exists('class', $form)) {
    $form['class'] = 'card card-body';
}
$form['plugintype'] = $plugintype;
$form['pluginname'] = $pluginname;
$form['name'] = 'pluginconfig';
$form['pluginconfigform'] = true;
$form['jsform'] = true;
$form['successcallback'] = 'pluginconfig_submit';
$form['validatecallback'] = 'pluginconfig_validate';
$form['elements']['plugintype']  = array(
    'type' => 'hidden',
    'value' => $plugintype
);
$form['elements']['pluginname'] = array(
    'type' => 'hidden',
    'value' => $pluginname
);
$form['elements']['type'] = array(
    'type' => 'hidden',
    'value' => $type
);
$form['elements']['save'] = array(
    'type'  => 'submit',
    'class' => 'btn-primary',
    'value' => get_string('save'),
);

$form = pieform($form);

$javascript = [];
// // If the current search class can tweak the javascript being loaded, do that
// // now.
if (method_exists($classname, 'tweak_settingsform_js')) {
    $classname::tweak_settingsform_js($javascript);
}

$smarty = smarty($javascript, $formcss);
$smarty->assign('form', $form);
$smarty->assign('plugintype', $plugintype);
$smarty->assign('pluginname', $pluginname);
$smarty->assign('type', $type);
$heading = get_string('pluginadmin', 'admin') . ': ' . $plugintype . ': ' . $pluginname;
if ($type) {
    $heading .= ': ' . $type;
}
$smarty->assign('PAGEHEADING', $heading);
$smarty->display('admin/extensions/pluginconfig.tpl');


function pluginconfig_submit(Pieform $form, $values) {
    $success = false;
    global $plugintype, $pluginname, $classname;

    try {
        $classname::save_config_options($form, $values);
        $success = true;
    }
    catch (Exception $e) {
        $success = false;
    }

    if ($success) {
        clear_menu_cache();
        $form->json_reply(PIEFORM_OK, get_string('settingssaved'));
    }
    else {
        $error_message = [];
        $error_message[] = get_string('settingssavefailed');
        if (!empty($e->getMessage())) {
            $msg = json_decode($e->getMessage());
            if (property_exists($msg, 'error')
                && property_exists($msg->error, 'root_cause')
                && !empty($msg->error->root_cause)) {
                foreach ($msg->error->root_cause as $root_cause) {
                    $error_message[] = $root_cause->reason;
                }
            }
        }

        $form->json_reply(PIEFORM_ERR, array('message' => implode('<br>', $error_message)));
    }
}

function pluginconfig_validate(PieForm $form, $values) {
    global $plugintype, $pluginname, $classname;
    if (is_callable($classname . '::validate_config_options')) {
        $classname::validate_config_options($form, $values);
    }
}
