/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.server.browserlaunchers;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import org.apache.commons.logging.Log;
import org.apache.tools.ant.taskdefs.condition.Os;
import org.mortbay.log.LogFactory;
import org.openqa.selenium.server.ApplicationRegistry;
import org.openqa.selenium.server.BrowserConfigurationOptions;
import org.openqa.selenium.server.RemoteControlConfiguration;
import org.openqa.selenium.server.browserlaunchers.AbstractBrowserLauncher;
import org.openqa.selenium.server.browserlaunchers.AsyncExecute;
import org.openqa.selenium.server.browserlaunchers.BrowserInstallation;
import org.openqa.selenium.server.browserlaunchers.InvalidBrowserExecutableException;
import org.openqa.selenium.server.browserlaunchers.LauncherUtils;
import org.openqa.selenium.server.browserlaunchers.MacProxyManager;
import org.openqa.selenium.server.browserlaunchers.WindowsProxyManager;
import org.openqa.selenium.server.browserlaunchers.WindowsUtils;
import org.openqa.selenium.server.browserlaunchers.locators.SafariLocator;

public class SafariCustomProfileLauncher
extends AbstractBrowserLauncher {
    private static final Log LOGGER = LogFactory.getLog(SafariCustomProfileLauncher.class);
    private static final String REDIRECT_TO_GO_TO_SELENIUM = "redirect_to_go_to_selenium.htm";
    protected File customProfileDir;
    protected String[] cmdarray;
    private boolean closed = false;
    protected BrowserInstallation browserInstallation;
    protected Process process;
    protected WindowsProxyManager wpm;
    protected MacProxyManager mpm;
    private File backedUpCookieFile;
    private File originalCookieFile;
    private String originalCookieFilePath;
    protected static AsyncExecute exe = new AsyncExecute();

    protected BrowserInstallation locateSafari(String browserLaunchLocation) {
        return ApplicationRegistry.instance().browserInstallationCache().locateBrowserInstallation("safari", browserLaunchLocation, new SafariLocator());
    }

    public SafariCustomProfileLauncher(BrowserConfigurationOptions browserOptions, RemoteControlConfiguration configuration, String sessionId, String browserLaunchLocation) {
        super(sessionId, configuration, browserOptions);
        this.browserInstallation = this.locateSafari(browserLaunchLocation);
        if (this.browserInstallation == null) {
            LOGGER.error("The specified path to the browser executable is invalid.");
            throw new InvalidBrowserExecutableException("The specified path to the browser executable is invalid.");
        }
        if (configuration.shouldOverrideSystemProxy()) {
            this.createSystemProxyManager(sessionId);
        }
        exe.setLibraryPath(this.browserInstallation.libraryPath());
        this.customProfileDir = LauncherUtils.createCustomProfileDir(sessionId);
    }

    protected void launch(String url) {
        try {
            if (!this.browserConfigurationOptions.is("honorSystemProxy")) {
                this.setupSystemProxy();
            }
            if (this.browserConfigurationOptions.is("ensureCleanSession")) {
                this.ensureCleanSession();
            }
            this.launchSafari(url);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    protected void launchSafari(String url) throws IOException {
        this.cmdarray = new String[]{this.browserInstallation.launcherFilePath()};
        if (Os.isFamily("mac")) {
            String redirectHtmlFileName = this.makeRedirectionHtml(this.customProfileDir, url);
            LOGGER.info("Launching Safari to visit '" + url + "' via '" + redirectHtmlFileName + "'...");
            this.cmdarray = new String[]{this.browserInstallation.launcherFilePath(), redirectHtmlFileName};
        } else {
            LOGGER.info("Launching Safari ...");
            this.cmdarray = new String[]{this.browserInstallation.launcherFilePath(), "-url", url};
        }
        exe.setCommandline(this.cmdarray);
        this.process = exe.asyncSpawn();
    }

    public void close() {
        if (this.closed) {
            return;
        }
        if (!this.browserConfigurationOptions.is("honorSystemProxy")) {
            this.restoreSystemProxy();
        }
        if (this.process == null) {
            return;
        }
        LOGGER.info("Killing Safari...");
        int exitValue = AsyncExecute.killProcess(this.process);
        if (exitValue == 0) {
            LOGGER.warn("Safari seems to have ended on its own (did we kill the real browser???)");
        }
        this.closed = true;
        if (this.backedUpCookieFile != null && this.backedUpCookieFile.exists()) {
            File sessionCookieFile = new File(this.originalCookieFilePath);
            boolean success = sessionCookieFile.delete();
            if (success) {
                LOGGER.info("Session's cookie file deleted.");
            } else {
                LOGGER.info("Session's cookie *not* deleted.");
            }
            LOGGER.info("Trying to restore originalCookieFile...");
            this.originalCookieFile = new File(this.originalCookieFilePath);
            LauncherUtils.copySingleFile(this.backedUpCookieFile, this.originalCookieFile);
        }
    }

    protected void ensureCleanSession() {
        if (Os.isFamily("mac")) {
            String user = System.getenv("USER");
            File cacheDir = new File("/Users/" + user + "/Library/Caches/Safari");
            this.originalCookieFilePath = "/Users/" + user + "/Library/Cookies" + "/Cookies.plist";
            this.originalCookieFile = new File(this.originalCookieFilePath);
            LauncherUtils.deleteTryTryAgain(cacheDir, 6);
        } else {
            File cacheFile;
            this.originalCookieFilePath = System.getenv("APPDATA") + "/Apple Computer/Safari/Cookies/Cookies.plist";
            this.originalCookieFile = new File(this.originalCookieFilePath);
            String localAppData = System.getenv("LOCALAPPDATA");
            if (localAppData == null) {
                localAppData = System.getenv("USERPROFILE") + "/Local Settings/Application Data";
            }
            if ((cacheFile = new File(localAppData + "/Apple Computer/Safari/Cache.db")).exists()) {
                cacheFile.delete();
            }
        }
        LOGGER.info("originalCookieFilePath: " + this.originalCookieFilePath);
        String backedUpCookieFilePath = this.customProfileDir.toString() + "/Cookies.plist";
        this.backedUpCookieFile = new File(backedUpCookieFilePath);
        LOGGER.info("backedUpCookieFilePath: " + backedUpCookieFilePath);
        if (this.originalCookieFile.exists()) {
            LauncherUtils.copySingleFile(this.originalCookieFile, this.backedUpCookieFile);
            this.originalCookieFile.delete();
        }
    }

    protected String makeRedirectionHtml(File parentDir, String url) {
        File f = new File(parentDir, REDIRECT_TO_GO_TO_SELENIUM);
        PrintStream out = null;
        FileOutputStream fileOutputStream = null;
        try {
            fileOutputStream = new FileOutputStream(f);
            out = new PrintStream(fileOutputStream);
            out.println("<script language=\"JavaScript\">\n    location = \"" + url + "\"\n" + "</script>\n");
        }
        catch (FileNotFoundException e) {
            throw new RuntimeException("troublemaking redirection HTML: " + e);
        }
        finally {
            if (null != out) {
                out.close();
            }
            if (null != fileOutputStream) {
                try {
                    fileOutputStream.close();
                }
                catch (IOException e) {
                    LOGGER.warn("Ignoring exception while closing HTML redirection stream", e);
                }
            }
        }
        return f.getAbsolutePath();
    }

    public Process getProcess() {
        return this.process;
    }

    private void setupSystemProxy() throws IOException {
        if (WindowsUtils.thisIsWindows()) {
            this.wpm.backupRegistrySettings();
            this.changeRegistrySettings();
        } else {
            this.mpm.backupNetworkSettings();
            this.mpm.changeNetworkSettings();
        }
    }

    private void restoreSystemProxy() {
        if (WindowsUtils.thisIsWindows()) {
            this.wpm.restoreRegistrySettings(this.browserConfigurationOptions.is("ensureCleanSession"));
        } else {
            this.mpm.restoreNetworkSettings();
        }
    }

    protected void changeRegistrySettings() throws IOException {
        this.wpm.changeRegistrySettings(this.browserConfigurationOptions.is("ensureCleanSession"), this.browserConfigurationOptions.is("avoidProxy"));
    }

    private void createSystemProxyManager(String sessionId) {
        if (WindowsUtils.thisIsWindows()) {
            this.wpm = new WindowsProxyManager(true, sessionId, this.getPort(), this.getPort());
        } else {
            this.mpm = new MacProxyManager(sessionId, this.getPort());
        }
    }
}

