/**
 * MAGIX CMS
 * @copyright MAGIX CMS Copyright (c) 2018,
 * http://www.magix-cms.com, magix-cms.com http://www.magix-cjquery.com
 * @license Dual licensed under the MIT or GPL Version 3 licenses.
 * @version 3.0
 * @author Salvatore Di Salvo <www.disalvo-infographiste.be>
 * @author Gérits Aurélien <aurelien@magix-cms.com>
 */
"use strict";function hide(selector,context=document){forEach(selector,(e=>e.classList.add("hidden","hide")),context)}function show(selector,context=document){forEach(selector,(e=>e.classList.remove("hidden","hide")),context)}class GlobalForm{constructor(options){if(typeof Notifier==="undefined")throw new Error("Notifier is required by GlobalForm to run properly");if(typeof SimpleRequest==="undefined")throw new Error("SimpleRequest is required by GlobalForm to run properly");this.forms={selector:".validate_form"};this.message={selector:".mc-message"};if(typeof options==="object")this.set(options);this.notifier=new Notifier;this.loader=null}set(options){let instance=this;for(let key in options){if(options.hasOwnProperty(key))instance[key]=options[key]}}initAlert(m,timeout,sub){let instance=this;sub=typeof sub!=="undefined"?sub:false;timeout=typeof timeout!=="undefined"?timeout:false;if(sub)instance.notifier.set({cssClass:instance.message.selector+"-"+sub});instance.notifier.notify(m);if(typeof timeout==="number")window.setTimeout((()=>instance.notifier.close()),timeout)}redirect(loc,timeout,action,id){timeout=typeof timeout!=="undefined"?timeout:2800;action=typeof action==="string"?action:null;id=typeof id!=="undefined"?id:null;setTimeout((()=>{window.location.href=loc+(action!==null?"&action="+action:"")+(Number.isInteger(id)?"&edit="+id:"")}),timeout)}createLoader(){let loader=document.createElement("div");loader.classList.add("loader");let spinner=document.createElement("i");spinner.classList.add("fa","fa-spinner","fa-pulse","fa-fw");let text=document.createElement("span");text.innerText="Chargement en cours...";text.classList.add("sr-only");loader.append(spinner,text);this.loader=loader}displayLoader(f,closeForm){let instance=this;hide('[type="submit"]',f);closeForm=typeof closeForm!=="undefined"?closeForm:true;if(closeForm)f.classList.add("hidden","hide");let box=f.querySelector(instance.message.selector);if(instance.loader===null)instance.createLoader();box.append(instance.loader);box.classList.add("text-center")}removeLoader(f,closeForm){let instance=this;closeForm=typeof closeForm!=="undefined"?closeForm:true;if(closeForm)f.classList.remove("hidden","hide");let box=f.querySelector(instance.message.selector);box.classList.remove("text-center");box.innerHTML="";show('[type="submit"]',f)}successHandler(f){let instance=this;let options={url:f.getAttribute("action"),method:"post",form:f,resetForm:true,beforeSend:()=>{instance.displayLoader(f)},success:response=>{instance.removeLoader(f);let d=response.data;if(typeof d==="string"){instance.initAlert(d,4e3)}else if(d.debug!==undefined&&d.debug!==""){instance.initAlert(d.debug)}else if(d.notify!==undefined&&d.notify!==""){instance.initAlert(d.notify,4e3)}},complete:()=>{if(f.NF instanceof NiceForms)f.NF.reset()}};let Request=new SimpleRequest;Request.post(options.url,MagicForm.getFormDataFromData({},f),options)}initValidation(){let instance=this;forEach(instance.forms.selector,(form=>{let validator=new Validator(form,{event:"submit",eventHandler:(f,e)=>{let caller=f.dataset.caller;if(caller==="submit"){f.submit()}else{e.preventDefault();instance.successHandler(f);return false}}});validator.listen()}))}onloadRecaptcha(){forEach(this.forms.selector,(form=>{forEach(".hiddenRecaptcha",(rc=>{if(typeof rc!=="undefined"){$(rc).rules("add",{required:()=>grecaptcha.getResponse()===""});if(form.validator!==undefined){form.validator.addRule({presence:true})}}}),form)}))}initialize(){this.initValidation()}}const globalForm=new GlobalForm;var onloadCallback=()=>globalForm.onloadRecaptcha();window.addEventListener("DOMContentLoaded",(()=>globalForm.initialize()));