<?php
class frontend_db_module {
	/**
	 * @var debug_logger $logger
	 */
	protected debug_logger $logger;
	
    /**
	 * @param array $config
	 * @param array $params
	 * @return array|bool
	 */
	public function fetchData(array $config, array $params = []) {
		if ($config['context'] === 'all') {
			switch ($config['type']) {
				case 'bonds':
					$query = 'SELECT * FROM mc_plugins_module WHERE plugin_name = :plugin OR module_name = :module';
					break;
				case 'mod':
					$query = 'SELECT * FROM mc_plugins_module WHERE plugin_name = :id AND active = 1';
					break;
				default:
					return false;
			}

			try {
				return component_routing_db::layer()->fetchAll($query, $params);
			}
			catch (Exception $e) {
				if(!isset($this->logger)) $this->logger = new debug_logger(MP_LOG_DIR);
				$this->logger->log('statement','db',$e->getMessage(),$this->logger::LOG_MONTH);
			}
		}
		elseif($config['context'] === 'one') {
			switch ($config['type']) {
				case 'mod':
					$query = 'SELECT * FROM mc_plugins_module WHERE module_name = :mname AND plugin_name = :pname';
					break;
				case 'register':
					$query = 'SELECT * FROM mc_plugins WHERE name = :id';
					break;
				default:
					return false;
			}

			try {
				return component_routing_db::layer()->fetch($query, $params);
			}
			catch (Exception $e) {
				if(!isset($this->logger)) $this->logger = new debug_logger(MP_LOG_DIR);
				$this->logger->log('statement','db',$e->getMessage(),$this->logger::LOG_MONTH);
			}
		}
		return false;
    }

	/**
	 * @param array $config
	 * @param array $params
	 * @return bool|string
	 */
	public function insert(array $config, array $params = []) {
		switch ($config['type']) {
			case 'mod':
				$query = "INSERT INTO `mc_plugins_module` (plugin_name,module_name,active) VALUES (:pname,:mname,:active)";
				break;
			default:
				return false;
		}

		try {
			component_routing_db::layer()->insert($query,$params);
			return true;
		}
		catch (Exception $e) {
			return 'Exception reçue : '.$e->getMessage();
		}
    }

	/**
	 * @param array $config
	 * @param array $params
	 * @return bool|string
	 */
	public function update(array $config, array $params = []) {
		switch ($config['type']) {
			case 'mod':
				$query = 'UPDATE mc_plugins_module SET active = :active WHERE module_name = :mname AND plugin_name = :pname';
				break;
			default:
				return false;
		}

		try {
			component_routing_db::layer()->update($query,$params);
			return true;
		}
		catch (Exception $e) {
			return 'Exception reçue : '.$e->getMessage();
		}
    }

	/**
	 * @param array $config
	 * @param array $params
	 * @return bool|string
	 */
	public function delete(array $config, array $params = []) {
		switch ($config['type']) {
			case 'mod':
				$query = 'DELETE FROM mc_plugins_module WHERE module_name = :mname AND plugin_name = :pname';
				break;
			default:
				return false;
		}

		try {
			component_routing_db::layer()->delete($query,$params);
			return true;
		}
		catch (Exception $e) {
			return 'Exception reçue : '.$e->getMessage();
		}
    }
}