# System Styles

The templates folder of ILIAS contains the ILIAS System Styles. System Styles
are defined by the set of icons, fonts, html templates and CSS/SCSS files that
define the visual appearance of ILIAS. They differ from Content Styles, which
enable to manipulate the classes defining the appearance of user generated
content.

## Custom Styles

System Styles may be customized by creating custom System Styles. Custom styles have
to be placed in the `./public/Customizing/skin` directory to be active. One may have
multiple substyles which may be active for different branches of the repository.

### Tools

The ILIAS default system style called Delos is written in SCSS, which has to be
compiled using the SASS pre-processor to a CSS file that the browser can read.

For any larger scale styling project, we recommend that you consider using SASS as
well. This way, you can build on and modify all the work that has been done by the
community to style the many views and components used in ILIAS.

You may want to use the same version of SASS that is referenced in the NPM
package.json and automatically installed to `node_modules/` when using `npm install`.
This specific SASS version can be executed like this from the ILIAS root:
`node_modules/.bin/sass`

Alternatively, you can install the latest version of SASS globally with
`npm install sass -g`.

You can find a starting point for a custom System Style based on the default Delos
system style here: [Delos Repository](https://github.com/ILIAS-eLearning/delos)

At the point of writing, it does require modification to be recognized as a custom
System Style as outlined later in this document.

### Access available Styles through Frontend

1. Navigate to "Administration -> Layout and Styles" of you ILIAS Installation.
2. In a table you see all available System Styles. 
3. You may assign users to styles via Actions Dropdown
4. You may set Sub Styles for certain sections of the repository via Actions Dropdown

### How-To 

#### Step 1: Create skin directory

To create a new skin, first add a new subdirectory to directory
`./public/Customizing/skin`, e.g. `./public/Customizing/skin/myskin/`.

#### Step 2: Create template.xml File

One file that must exist in every skin is the file template.xml. E.g.
`./public/Customizing/skin/myskin/template.xml`:

```
<?xml version = "1.0" encoding = "UTF-8"?>
<template xmlns = "http://www.w3.org" version = "1" name = "MySkin">
        <style name = "MyStyle" id = "mystyle" image_directory = "images"/>
</template>
```

Every skin can contain multiple styles. This example defines one style called
MyStyle.

This skin/style combination will be listed as MySkin/MyStyle in the
ILIAS Style and Layout administration. The style's files are now expected
to be located in `./public/Customizing/skin/myskin/mystyle/`:

The ILIAS administration is the place where you can activate/deactivate styles,
and where you can assign users from one skin to another.

#### Step 3.1: Create main CSS File

The `id` attribute of the style tag defines the name of the corresponding style
sheet (CSS) file, in our example `./public/Customizing/skin/myskin/mystyle/mystyle.css`.

The easiest (but not recommended) ways to get a working skin quickly are to
* copy and rename the default CSS file located at `templates/default/delos.css`
  to `./public/Customizing/skin/myskin/mystyle/mystyle.css`
* or create `./public/Customizing/skin/myskin/mystyle/` and import delos in the
  top line of your css like so: `@import url("../../../../assets/css/delos.css");`

If your CSS file contains references to (background) images, these images must
be present at their defined locations. If you copied the default CSS file, the
image paths will not be correct anymore. You can either copy them to your skin
directory, change the CSS definitions or provide your own image files.

#### Step 3.2: Better Alternative

To have a working directory for your skin, you can also copy the complete folder
templates/default of your ilias installation to a new folder below
`./public/Customizing/skin/myskin` within that directory, edit the file
`template.xml` to have an unique Style Name and id. This is needed to identify the
new skin in ILIAS' administration. Compile `delos.scss` or copy/rename the
standard `delos.css` file to `./public/Customizing/skin/myskin/mystyle/mystyle.css`.
Take care: the main CSS-File must reflect the style id in its name (see above).

However, best use the stand alone skin [delos](https://github.com/ILIAS-eLearning/delos)
git repo, which is always an up-to-date copy of the delos skin from the main repo.
Clone it into your `./public/Customizing/skin/myskin` folder, make your changes and
merge important fixes and updates to delos into your skin.

With this approach, you should not modify the css file, but work entirely in the scss files.

#### Step 3.3 Sass

Do not forget to re-compile the scss-file after each change. Switch to the root of your style 
and execute:

```
./node_modules/.bin/sass delos.scss mystyle.css
```

or

```
./node_modules/.bin/sass  --style=compressed delos.scss mystyle.css
```

for a minified CSS version.

#### Step 4: Add Icons (Optional)

If you want to replace the default icons coming with ILIAS, you can add new
representations of them to your skin. They must be stored in a subdirectory
named like the `image_directory` attribute of the style tag in the
`template.xml` file.

E.g. if you want to replace the default icon for categories
`public/assets/images/standard/icon_cat.sfg`, and your template file defines
`image_directory = "images"` as in the example above, the new version must be
stored as `./public/Customizing/skin/myskin/mystyle/images/icon_cat.svg`.

#### Step 5: Change Layout (Optional)

The layout is specified in HTML template files. Some standard default template
files can be found in directory `templates/default`. Other template files are
stored within subdirectories of the Modules or Services directories. Most ILIAS
screens use more than one template file. Some template files are reused in many
ILIAS screens (e.g. the template file that defines the layout of the main menu).

To replace a template file for your skin, you have to create a new one in your
skin directory. Please note, that your skin should only contain template files
that are modified. You do not need to copy all default template files to your
new skin. 

Since ILIAS 5.3 we move aim to move most of the UI towards the UI Components. They
are located in src/UI. To overwrite those you need to add the respective tpl files 
in your skins folder. 

Examples:
* `components` related template files must be stored in a similar
subdirectory structure (omit the `templates` subdirectory). E.g. to replace the
template file `components/ILIAS/XYZ/templates/tpl.xyz.html` create a new
version at `./public/Customizing/skin/myskin/components/ILIAS/XYZ/tpl.xyz.html`. A template of a UI Component located in 
`src/UI/templates/default/XYZ/tpl.xyz.html` can be customized by creating a 
`./public/Customizing/skin/myskin/UI/XYZ/tpl.xyz.html` file.

The following list contains some standard template files, that are often changed in
skins:

- Standard Layout: components/ILIAS/UI/templates/default/Layout/tpl.standardpage.html, the frame of the DOM for the complete ILIAS page. 
Also checkout the according scss variable under section Layout (UI Layout Page).
- Meta Bar: components/ILIAS/UI/templates/default/MainControls/tpl.metabar.html, the Bar on the top holding Notification, Search User Avatar, etc.
Also checkout the according metabar scss variables.
- Main Bar: components/ILIAS/UI/templates/default/MainControls/tpl.mainbar.html, the Bar on the left holding triggers for opening the slates for
accessing Repository, Dasbhoard etc. Content.
Also checkout the according mainbar scss variables.
- Slate: components/ILIAS/UI/templates/default/MainControls/Slate/tpl.slate.html, the Slates triggered by opening items of the Main Bar.
Also checkout the according slate scss variables.
- Breadcrumbs: components/ILIAS/UI/templates/default/Breadcrumbs/tpl.breadcrumbs.html, Breadcrumbs working as locator on the top of the page.
Also checkout the breadcrumb scss variables.

* Startup Screens (Login, Registration, ...): `components/ILIAS/Init/templates/default/tpl .startup_screen.html`


#### Step 6: Change the ILIAS Icon

The main ILIAS icon is stored in the images Directory as `logo/HeaderIcon.svg`. You
can replace this easyly by your own Icon in svg format. As long as your Icon is
close to a square, this may be all that is needed. Probably you want to change
the file favicon `.ico` in ILIAS' root directory too. For non-square Icons you
may refer to:

[Installation and Maintenance » Change the ILIAS
icon](http://www.ilias.de/docu/goto_docu_pg_68691_367.html)

### Migration

There might be changes you need to consider if updating to a new ILIAS version.

Note that this changelog was introduced for ILIAS 5.3. If migrating to a lower
version you might find helpful information by consulting:

[Installation and Maintenance » Prepare for a new
skin](https://www.ilias.de/docu/goto_docu_pg_68693_367.html)

#### ILIAS 10
- **Important**: The location of the skin was moved to `./public/Customizing/skin`
- System style Management through GUI has been abandoned, see: https://docu.ilias.de/go/wiki/wpage_1_1357
- Sass is no shipped with NPM, see: https://github.com/ILIAS-eLearning/ILIAS/pull/8115

#### ILIAS 9
A proposal for better structuring the System Styles has been provided and accepted by the JF in 2021, 
see: https://github.com/ILIAS-eLearning/ILIAS/blob/trunk/src/UI/docu/sass-guidelines.md

With ILIAS 9 the SCSS as been restructered according to the ITCSS structure suggested by this proposal, 
and the depencency to less from Bootstrap has mostly been removed. However, the change from less to SCSS
and the abandonment from Bootstrap means, that System Styles from 8 and lower are NOT compatible with ILIAS 9.
They can not be imported, be used, or compiled. 

However, note, that most of the css should still work. Also less and scss are not that far appart. Best read
through our [SCSS Coding Guidelines](./Guidelines_SCSS-Coding.md) to get started.

#### ILIAS 7

The `icon-font-path` for glyphs has been renamend to `il-icon-font-path`
and the location has changed due to a move from the bootstrap
library to the new location for external libraries. The new location is:
`"../../../../node_modules/bootstrap/fonts/"`. If a 5.2 style is
imported, the variable `icon-font-path` must be adapted accordingly.

In March 2022, we moved the general Test & Assessment CSS (ta.css and
ta_split.css) to `less/Modules/Test/delos.less` (like other CSS for modules)
to start refactoring this module's style code. As part of this change,
the override mechanism that fetches a custom style for just the T&A has been
removed. Please use the standard skin setup described in this document to style
the Test & Assessment like the rest of your custom skin.

#### ILIAS 6

Major parts of the UI of ILIAS 6 have changed. It is therefore recommended, to create a new skin
for ILIAS think an manually move changes that are still needed from oder versions to the new skin.

Also, most importantly the following components have been introduced:

- [Standard Layout](https://test6.ilias.de/goto_test6_stys_21_LayoutPageStandardStandard_default_delos.html?), 
template directory: src/UI/templates/default/Layout, the frame of the DOM for the complete ILIAS page. 
Also checkout the according scss variable under section Layout (UI Layout Page).
- [Meta Bar](https://test6.ilias.de/goto_test6_stys_21_MainControlsMetaBarMetaBar_default_delos.html?) 
template directory: src/UI/templates/default/MainControls, the Bar on the top holding Notification, Search User Avatar, etc.
Also checkout the according metabar scss variables.
- [Main Bar](https://test6.ilias.de/goto_test6_stys_21_MainControlsMainBarMainBar_default_delos.html?) 
template directory: src/UI/templates/default/MainControls, the Bar on the left holding triggers for opening the slates for
accessing Repository, Dasbhoard etc. Content.
Also checkout the according mainbar scss variables.
- [Slate](https://test6.ilias.de/goto_test6_stys_21_MainControlsSlateFactorySlate_default_delos.html?) 
template directory: src/UI/templates/default/MainControls/Slate, the Slates triggered by opening items of the Main Bar.
Also checkout the according slate scss variables.
- [Breadcrumbs](https://test6.ilias.de/goto_test6_stys_21_BreadcrumbsBreadcrumbsBreadcrumbs_default_delos.html?)
template directory: src/UI/templates/default/Breadcrumbs, Breadcrumbs working as locator on the top of the page.
Also checkout the breadcrumb scss variables.

See above section on information on how to customize those components.

#### ILIAS 5.3

The `icon-font-path` for glyphs has changed due to a move from the bootstrap
library to the new location for external libraries. The new location is:
`"../../../../libs/bower/bower_components/bootstrap/fonts/"`. If a 5.2 style is
imported, the variable `icon-font-path` must be adapted accordingly.

## Coding Guidelines

If you want to change and contribute ILIAS style code, please refer to the most recent [SCSS Coding Guidelines](./Guidelines_SCSS-Coding.md)
