<?php
/*
 +-----------------------------------------------------------------------------+
 | ILIAS open source                                                           |
 +-----------------------------------------------------------------------------+
 | Copyright (c) 1998-2001 ILIAS open source, University of Cologne            |
 |                                                                             |
 | This program is free software; you can redistribute it and/or               |
 | modify it under the terms of the GNU General Public License                 |
 | as published by the Free Software Foundation; either version 2              |
 | of the License, or (at your option) any later version.                      |
 |                                                                             |
 | This program is distributed in the hope that it will be useful,             |
 | but WITHOUT ANY WARRANTY; without even the implied warranty of              |
 | MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the               |
 | GNU General Public License for more details.                                |
 |                                                                             |
 | You should have received a copy of the GNU General Public License           |
 | along with this program; if not, write to the Free Software                 |
 | Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA. |
 +-----------------------------------------------------------------------------+
*/

/**
 * factory classs for structure objects
 * @author  Roland Kuestermann (rku@aifb.uni-karlsruhe.de)
 * @version $Id: class.ilSoapStructureReader.php,v 1.5 2006/05/23 23:09:06 hschottm Exp $
 * @package ilias
 */
class ilSoapStructureObjectFactory
{
    public function getInstanceForObject(ilObject $object): ?ilSoapStructureObject
    {
        $classname = $this->_getClassnameForType($object->getType());
        if ($classname !== null) {
            switch ($object->getType()) {
                case "lm":
                case "glo":
                    return new $classname(
                        $object->getId(),
                        $object->getType(),
                        $object->getTitle(),
                        $object->getLongDescription(),
                        $object->getRefId()
                    );
            }
        }

        return null;
    }

    public function getInstance(
        int $objId,
        string $type,
        string $title,
        string $description,
        int $parentRefId
    ): ?ilSoapStructureObject {
        $classname = $this->_getClassnameForType($type);
        if ($classname === null) {
            return null;
        }

        return new $classname($objId, $type, $title, $description, $parentRefId);
    }

    public function _getClassnameForType(string $type): ?string
    {
        switch ($type) {
            case "glo":
            case "lm":
                return "ilSoapRepositoryStructureObject";
            case "st":
                return "ilSoapLMChapterStructureObject";
            case "pg":
                return "ilSoapLMPageStructureObject";
            case "git":
                return "ilSoapGLOTermStructureObject";
            case "term":
                return "ilSoapGLOTermDefinitionStructureObject";
        }

        return null;
    }
}
