<?php

declare(strict_types=1);

namespace ILIAS\UI\examples\Item\Group;

/**
 * ---
 * description: >
 *   Example for rendering a group item.
 *
 * expected output: >
 *   ILIAS shows a group with two items: "Item Title" and "Item Title 2". The group's heading is "Subtitle 1". Both items
 *   have got an action menu.
 * ---
 */
function base()
{
    global $DIC;
    $f = $DIC->ui()->factory();
    $renderer = $DIC->ui()->renderer();
    $actions = $f->dropdown()->standard(array(
        $f->button()->shy("ILIAS", "https://www.ilias.de"),
        $f->button()->shy("GitHub", "https://www.github.com")
    ));
    $list_item1 = $f->item()->standard("Item Title")
        ->withActions($actions)
        ->withProperties(array(
            "Origin" => "Course Title 1",
            "Last Update" => "24.11.2011",
            "Location" => "Room 123, Main Street 44, 3012 Bern"))
        ->withDescription("Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua.");

    $list_item2 = $f->item()->standard("Item 2 Title")
        ->withActions($actions)
        ->withDescription("Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua.");

    $group = $f->item()->group("Subtitle 1", array(
        $list_item1,
        $list_item2
    ));

    return $renderer->render($group);
}
