<?php

declare(strict_types=1);

namespace ILIAS\UI\examples\Chart\ProgressMeter\Mini;

/**
 * ---
 * description: >
 *   Example for rendering a mini Progress Meter when no score is given
 *
 *
 * expected output: >
 *   ILIAS shows a base progress meter with a red dot. The dot displays that no progress was reached until now.
 * ---
 */
function no_score_yet()
{
    //Loading factories
    global $DIC;
    $f = $DIC->ui()->factory();
    $renderer = $DIC->ui()->renderer();

    //Generating and rendering the mini progressmeter
    $progressmeter = $f->chart()->progressMeter()->mini(100, 0);

    // render
    return $renderer->render($progressmeter);
}
