<?php

/**
 * This file is part of ILIAS, a powerful learning management system
 * published by ILIAS open source e-Learning e.V.
 *
 * ILIAS is licensed with the GPL-3.0,
 * see https://www.gnu.org/licenses/gpl-3.0.en.html
 * You should have received a copy of said license along with the
 * source code, too.
 *
 * If this is not the case or you just want to try ILIAS, you'll find
 * us at:
 * https://www.ilias.de
 * https://github.com/ILIAS-eLearning
 *
 *********************************************************************/

declare(strict_types=1);

namespace ILIAS\News;

use ILIAS\News\Dashboard\DashboardSessionRepository;
use ILIAS\News\Persistence\NewsCache;
use ILIAS\News\Persistence\NewsRepository;

/**
 * Notes internal repo service
 * @author Alexander Killing <killing@leifos.de>
 */
class InternalRepoService
{
    protected NewsCache $cache;

    public function __construct(protected InternalDataService $data, protected \ilDBInterface $db)
    {
        $this->cache = new NewsCache();
    }

    public function cache(): NewsCache
    {
        return $this->cache;
    }

    public function news(): NewsRepository
    {
        return new NewsRepository($this->db, $this->data->factory());
    }

    public function dashboard(): DashboardSessionRepository
    {
        return new DashboardSessionRepository();
    }
}
