<?php

/**
 * This file is part of ILIAS, a powerful learning management system
 * published by ILIAS open source e-Learning e.V.
 *
 * ILIAS is licensed with the GPL-3.0,
 * see https://www.gnu.org/licenses/gpl-3.0.en.html
 * You should have received a copy of said license along with the
 * source code, too.
 *
 * If this is not the case or you just want to try ILIAS, you'll find
 * us at:
 * https://www.ilias.de
 * https://github.com/ILIAS-eLearning
 *
 *********************************************************************/

declare(strict_types=1);

/**
 * Class ilMailMimeSenderSystem
 * @author Michael Jansen <mjansen@databay.de>
 */
abstract class ilMailMimeSenderUser implements ilMailMimeSender
{
    public function __construct(
        protected ilSetting $settings,
        protected ilObjUser $user,
        protected ilMustacheFactory $mustache_factory
    ) {
    }

    public function hasReplyToAddress(): bool
    {
        return true;
    }

    public function getReplyToAddress(): string
    {
        if (
            (bool) $this->settings->get('use_global_reply_to_addr', '0') &&
            is_string($this->settings->get('global_reply_to_addr', '')) &&
            $this->settings->get('global_reply_to_addr', '') !== ''
        ) {
            return $this->settings->get('global_reply_to_addr', '');
        }

        return $this->user->getEmail();
    }

    public function getReplyToName(): string
    {
        return $this->user->getFullname();
    }

    public function hasEnvelopFromAddress(): bool
    {
        return $this->settings->get('mail_system_usr_env_from_addr', '') !== '' && $this->settings->get(
            'mail_system_usr_env_from_addr',
            ''
        ) !== null;
    }

    public function getEnvelopFromAddress(): string
    {
        return $this->settings->get('mail_system_usr_env_from_addr', '');
    }

    public function getFromAddress(): string
    {
        return $this->settings->get('mail_system_usr_from_addr', '');
    }

    public function getFromName(): string
    {
        $from = $this->settings->get('mail_system_usr_from_name', '');
        if ($from === '') {
            return $this->user->getFullname();
        }

        $placeholders = [
            'FULLNAME' => $this->user->getFullname(),
            'FIRSTNAME' => $this->user->getFirstname(),
            'LASTNAME' => $this->user->getLastname(),
        ];

        $template = $from;
        $interpolated = $this->mustache_factory->getBasicEngine()->render($template, $placeholders);

        if ($template !== $interpolated) {
            return $interpolated;
        }

        return $template;
    }
}
