<?php

/**
 * This file is part of ILIAS, a powerful learning management system
 * published by ILIAS open source e-Learning e.V.
 *
 * ILIAS is licensed with the GPL-3.0,
 * see https://www.gnu.org/licenses/gpl-3.0.en.html
 * You should have received a copy of said license along with the
 * source code, too.
 *
 * If this is not the case or you just want to try ILIAS, you'll find
 * us at:
 * https://www.ilias.de
 * https://github.com/ILIAS-eLearning
 *
 *********************************************************************/

declare(strict_types=1);

/**
 * Concrete class for sanitizing html of forum posts
 * @author Michael Jansen <mjansen@databay.de>
 */
class ilHtmlForumPostPurifier extends ilHtmlPurifierAbstractLibWrapper
{
    protected function getPurifierConfigInstance(): HTMLPurifier_Config
    {
        $config = HTMLPurifier_Config::createDefault();
        $config->set('HTML.DefinitionID', 'ilias forum post');
        $config->set('HTML.DefinitionRev', 2);
        $config->set('Cache.SerializerPath', ilHtmlPurifierAbstractLibWrapper::_getCacheDirectory());
        $config->set('HTML.Doctype', 'XHTML 1.0 Strict');

        $tags = ilObjAdvancedEditing::_getUsedHTMLTags('frm_post');
        $tags = $this->makeElementListTinyMceCompliant($tags);
        $config->set('HTML.AllowedElements', $this->removeUnsupportedElements($tags));
        $config->set('HTML.ForbiddenAttributes', 'div@style');

        if (($def = $config->maybeGetRawHTMLDefinition()) !== null) {
            $def->addAttribute('img', 'data-id', 'Number');
            $def->addAttribute('a', 'target', 'Enum#_blank,_self,_target,_top');
        }

        return $config;
    }
}
