<?php

/**
 * This file is part of ILIAS, a powerful learning management system
 * published by ILIAS open source e-Learning e.V.
 *
 * ILIAS is licensed with the GPL-3.0,
 * see https://www.gnu.org/licenses/gpl-3.0.en.html
 * You should have received a copy of said license along with the
 * source code, too.
 *
 * If this is not the case or you just want to try ILIAS, you'll find
 * us at:
 * https://www.ilias.de
 * https://github.com/ILIAS-eLearning
 *
 *********************************************************************/

declare(strict_types=1);

class ilDclMobFieldRepresentation extends ilDclFileFieldRepresentation
{
    public function addFilterInputFieldToTable(ilTable2GUI $table)
    {
        $input = $table->addFilterItemByMetaType(
            "filter_" . $this->getField()->getId(),
            ilTable2GUI::FILTER_TEXT,
            false,
            $this->getField()->getId()
        );
        $input->setSubmitFormOnEnter(true);

        $this->setupFilterInputField($input);

        return $this->getFilterInputFieldValue($input);
    }

    public function passThroughFilter(ilDclBaseRecordModel $record, $filter): bool
    {
        $value = $record->getRecordFieldValue($this->getField()->getId());

        $m_obj = new ilObjMediaObject($value);
        $file_name = $m_obj->getTitle();
        if (!$filter || strpos(strtolower($file_name), strtolower($filter)) !== false) {
            return true;
        }

        return false;
    }

    protected function buildFieldCreationInput(ilObjDataCollection $dcl, string $mode = 'create'): ilRadioOption
    {
        $opt = new ilRadioOption(
            $this->lng->txt('dcl_' . $this->getField()->getDatatype()->getTitle()),
            (string) $this->getField()->getDatatypeId()
        );
        $opt->setInfo($this->lng->txt('dcl_' . $this->getField()->getDatatype()->getTitle() . '_desc'));

        $opt->setInfo(sprintf($opt->getInfo(), implode(", ", $this->getField()->getSupportedExtensions())));

        $prop_page_details = new ilDclCheckboxInputGUI(
            $this->lng->txt('dcl_link_detail_page'),
            'prop_' . ilDclBaseFieldModel::PROP_LINK_DETAIL_PAGE_MOB
        );
        $prop_page_details->setInfo($this->lng->txt('dcl_link_detail_page_desc'));

        $opt->addSubItem($prop_page_details);

        return $opt;
    }
}
