<?php

/**
 * This file is part of ILIAS, a powerful learning management system
 * published by ILIAS open source e-Learning e.V.
 *
 * ILIAS is licensed with the GPL-3.0,
 * see https://www.gnu.org/licenses/gpl-3.0.en.html
 * You should have received a copy of said license along with the
 * source code, too.
 *
 * If this is not the case or you just want to try ILIAS, you'll find
 * us at:
 * https://www.ilias.de
 * https://github.com/ILIAS-eLearning
 *
 *********************************************************************/

namespace ILIAS\Component\Tests\Dependencies\Scenario5;

use ILIAS\Component\Component;
use ILIAS\Component\EntryPoint;

class ComponentAEntryPoint implements EntryPoint
{
    public function getComponent(): Component
    {
    }
    public function getName(): string
    {
        return "just a name";
    }
    public function enter(): int
    {
    }
}

class ComponentA implements Component
{
    public function init(
        array | \ArrayAccess &$define,
        array | \ArrayAccess &$implement,
        array | \ArrayAccess &$use,
        array | \ArrayAccess &$contribute,
        array | \ArrayAccess &$seek,
        array | \ArrayAccess &$provide,
        array | \ArrayAccess &$pull,
        array | \ArrayAccess &$internal,
    ): void {
        $contribute[EntryPoint::class] = fn() => new ComponentAEntryPoint();
    }
}
