<?php

/**
 * @package Dotclear
 *
 * @copyright Olivier Meunier & Association Dotclear
 * @copyright AGPL-3.0
 */
declare(strict_types=1);

namespace Dotclear\Schema\Status;

use Dotclear\Helper\Stack\Status;
use Dotclear\Helper\Stack\Statuses;

/**
 * @brief       User statuses handler.
 *
 * @since       2.33
 */
class User extends Statuses
{
    /**
     * Enabled user
     *
     * @var int
     */
    public const ENABLED = 1;

    /**
     * Disabled user
     *
     * @var int
     */
    public const DISABLED = 0;

    public function __construct()
    {
        // Translated names (singular, plural), for xgettext -> .pot
        __('Enabled (1)', 'Enabled (>1)');
        __('Disabled (1)', 'Disabled (>1)');

        parent::__construct(
            column: 'user_status',
            statuses: [
                (new Status(self::ENABLED, 'enabled', 'Enabled (1)', 'Enabled (>1)', 'images/published.svg')),
                (new Status(self::DISABLED, 'disabled', 'Disabled (1)', 'Disabled (>1)', 'images/unpublished.svg')),
            ],
            threshold: self::DISABLED,
        );
    }
}
