<?php

/**
 * @package     Dotclear
 *
 * @copyright   Olivier Meunier & Association Dotclear
 * @copyright   AGPL-3.0
 */
declare(strict_types=1);

namespace Dotclear\Plugin\aboutConfig;

use Dotclear\App;
use Dotclear\Helper\Process\TraitProcess;

/**
 * @brief   The module backend process.
 * @ingroup aboutConfig
 */
class Backend
{
    use TraitProcess;

    public static function init(): bool
    {
        // Dead but useful code (for l10n)
        __('about:config');
        __('Manage every blog configuration directive');

        return self::status(My::checkContext(My::BACKEND));
    }

    public static function process(): bool
    {
        if (self::status()) {
            $menu = is_string($menu = App::backend()->menus()::MENU_SYSTEM) ? $menu : '';
            if ($menu !== '') {
                My::addBackendMenuItem($menu);
            }
        }

        return self::status();
    }
}
