<?php

/*
 * vim:set softtabstop=4 shiftwidth=4 expandtab:
 *
 * LICENSE: GNU Affero General Public License, version 3 (AGPL-3.0-or-later)
 * Copyright Ampache.org, 2001-2026
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <https://www.gnu.org/licenses/>.
 *
 */

declare(strict_types=0);

namespace Ampache\Module\Util\Captcha;

use Ampache\Config\AmpConfig;

/**
 * Class easy_captcha_persistent_grant
 * shortcut, allow access for a user if captcha was previously solved
 * (should be identical in each instantiation, cookie is time-bombed)
 */
class easy_captcha_persistent_grant extends easy_captcha
{
    public function __construct(
        $captcha_id = null,
        $ignore_expiration = 0
    ) {
    }

    /**
     * @param int $input
     * @return bool
     */
    public function solved($input = 0)
    {
        if (easy_captcha::CAPTCHA_PERSISTENT && isset($_COOKIE[$this->cookie()])) {
            return in_array($_COOKIE[$this->cookie()], [$this->validity_token(), $this->validity_token(-1)]);
        }

        return false;
    }

    // set captcha persistence cookie
    public function grant()
    {
        if (!headers_sent()) {
            $cookie_options = [
                'expires' => (int)(time() + 175 * easy_captcha::CAPTCHA_TIMEOUT),
                'path' => (string)AmpConfig::get('cookie_path'),
                'domain' => (string)AmpConfig::get('cookie_domain'),
                'secure' => make_bool(AmpConfig::get('cookie_secure')),
                'samesite' => 'Strict'
            ];
            setcookie($this->cookie(), $this->validity_token(), $cookie_options);
        }
    }

    // pseudo password (time-bombed)

    /**
     * @param int $deviation
     * @return string
     */
    public function validity_token($deviation = 0)
    {
        return easy_captcha::hash("PERSISTENCE", $deviation, $length = 100);
    }

    /**
     * @return string
     */
    public function cookie()
    {
        return "captcha_pass";
    }
}
