<?php

declare(strict_types=1);

/**
 * vim:set softtabstop=4 shiftwidth=4 expandtab:
 *
 * LICENSE: GNU Affero General Public License, version 3 (AGPL-3.0-or-later)
 * Copyright Ampache.org, 2001-2026
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <https://www.gnu.org/licenses/>.
 *
 */

namespace Ampache\Module\User;

use Ampache\Module\User\Registration\RegistrationAgreementRenderer;
use Ampache\Module\User\Registration\RegistrationAgreementRendererInterface;

use function DI\autowire;

return [
    PasswordGeneratorInterface::class => autowire(PasswordGenerator::class),
    NewPasswordSenderInterface::class => autowire(NewPasswordSender::class),
    UserStateTogglerInterface::class => autowire(UserStateToggler::class),
    Activity\UserActivityRendererInterface::class => autowire(Activity\UserActivityRenderer::class),
    Activity\UserActivityPosterInterface::class => autowire(Activity\UserActivityPoster::class),
    Activity\TypeHandler\ActivityTypeHandlerMapperInterface::class => autowire(Activity\TypeHandler\ActivityTypeHandlerMapper::class),
    Following\UserFollowTogglerInterface::class => autowire(Following\UserFollowToggler::class),
    Following\UserFollowStateRendererInterface::class => autowire(Following\UserFollowStateRenderer::class),
    Authorization\UserKeyGeneratorInterface::class => autowire(Authorization\UserKeyGenerator::class),
    PrivateMessage\PrivateMessageCreatorInterface::class => autowire(PrivateMessage\PrivateMessageCreator::class),
    Tracking\UserTrackerInterface::class => autowire(Tracking\UserTracker::class),
    RegistrationAgreementRendererInterface::class => autowire(RegistrationAgreementRenderer::class),
];
