<?php

declare(strict_types=0);

/**
 * vim:set softtabstop=4 shiftwidth=4 expandtab:
 *
 * LICENSE: GNU Affero General Public License, version 3 (AGPL-3.0-or-later)
 * Copyright Ampache.org, 2001-2026
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <https://www.gnu.org/licenses/>.
 *
 */

namespace Ampache\Module\Art\Collector;

use Ampache\Repository\Model\Art;

final class DbCollectorModule implements CollectorModuleInterface
{
    /**
     * This function retrieves art that's already in the database
     * @param array{
     *     mb_albumid?: string,
     *     artist?: string,
     *     album?: string,
     *     cover?: ?string,
     *     file?: string,
     *     year_filter?: string,
     *     search_limit?: int,
     * } $data
     * @return array<int, array{
     *     db?: int,
     *     mime?: string,
     *     title?: string,
     * }>
     */
    public function collectArt(
        Art $art,
        int $limit = 5,
        array $data = []
    ): array {
        $results = [];
        if ($art->has_db_info() && $art->id) {
            $results[] = [
                'db' => $art->id,
                'title' => T_('Art'),
                'mime' => $art->raw_mime,
            ];
        }

        return $results;
    }
}
